/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.values;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.values.NumberValueImpl;
import org.eclipse.ocl.pivot.messages.PivotMessages;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.ComparableValue;
import org.eclipse.ocl.pivot.values.IntegerValue;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.ocl.pivot.values.NumberValue;
import org.eclipse.ocl.pivot.values.RealValue;
import org.eclipse.ocl.pivot.values.UnlimitedNaturalValue;
import org.eclipse.ocl.pivot.values.ValuesPackage;

public class RealValueImpl
extends NumberValueImpl
implements RealValue {
    private static final long serialVersionUID = -6016171050097266652L;
    private static final int MINIMUM_SCALE = 32;
    private final @NonNull BigDecimal value;
    private Object integerValue = null;

    @Override
    protected EClass eStaticClass() {
        return ValuesPackage.Literals.REAL_VALUE;
    }

    protected static @NonNull RealValue divideBigDecimal(@NonNull BigDecimal left, @NonNull BigDecimal right) {
        try {
            if (right.signum() == 0) {
                throw new InvalidValueException("divide by zero", new Object[0]);
            }
            int scale = Math.max(left.scale() - right.scale(), 32);
            @NonNull BigDecimal result = left.divide(right, scale, RoundingMode.HALF_EVEN);
            return ValueUtil.realValueOf(result);
        }
        catch (ArithmeticException e) {
            throw new InvalidValueException(e, "divideBigDecimal");
        }
    }

    public static void initStatics() {
    }

    public RealValueImpl(double value) {
        this(BigDecimal.valueOf(value));
    }

    public RealValueImpl(@NonNull BigDecimal value) {
        this.value = value;
        assert (value != null);
    }

    @Override
    public @NonNull RealValue abs() {
        @NonNull BigDecimal result = this.value.abs();
        return ValueUtil.realValueOf(result);
    }

    @Override
    public @NonNull RealValue addInteger(@NonNull IntegerValue rightValue) {
        try {
            @NonNull BigDecimal result = this.value.add(rightValue.bigDecimalValue());
            return ValueUtil.realValueOf(result);
        }
        catch (InvalidValueException e) {
            throw new InvalidValueException(PivotMessages.InvalidReal, e, null, rightValue);
        }
    }

    @Override
    public @NonNull RealValue addReal(@NonNull RealValue rightValue) {
        try {
            @NonNull BigDecimal result = this.value.add(rightValue.bigDecimalValue());
            return ValueUtil.realValueOf(result);
        }
        catch (InvalidValueException e) {
            throw new InvalidValueException(PivotMessages.InvalidReal, e, null, rightValue);
        }
    }

    @Override
    public @NonNull Double asDouble() {
        return this.value.doubleValue();
    }

    @Override
    public Object asEcoreObject(@NonNull IdResolver idResolver, @Nullable Class<?> instanceClass) {
        if (instanceClass == BigDecimal.class) {
            return this.value;
        }
        Object ecoreValue = super.asEcoreObject(idResolver, instanceClass);
        return ecoreValue != null ? ecoreValue : Double.valueOf(this.doubleValue());
    }

    @Override
    public @NonNull Number asNumber() {
        return this.value;
    }

    @Override
    public @NonNull Object asObject() {
        return this.value;
    }

    @Override
    public @NonNull RealValue asRealValue() {
        return this;
    }

    @Override
    public @NonNull Object asUnboxedObject(@NonNull IdResolver idResolver) {
        return this.value;
    }

    @Override
    public @NonNull BigDecimal bigDecimalValue() {
        return this.value;
    }

    @Override
    public @NonNull BigInteger bigIntegerValue() {
        Object intValue = this.getIntegerValue();
        if (intValue instanceof Exception) {
            throw new InvalidValueException((Exception)intValue, "bigIntegerValue");
        }
        return ((IntegerValue)intValue).bigIntegerValue();
    }

    @Override
    public @NonNull RealValue commutatedAdd(@NonNull RealValue left) {
        return left.addReal(this);
    }

    @Override
    public int commutatedCompareTo(@NonNull ComparableValue<?> left) {
        if (left instanceof NumberValue) {
            return ((NumberValue)left).commutatedCompareToReal(this);
        }
        return ValueUtil.throwUnsupportedCompareTo(left, this);
    }

    @Override
    public int commutatedCompareToInteger(@NonNull IntegerValue left) {
        return this.value.compareTo(left.bigDecimalValue());
    }

    @Override
    public int commutatedCompareToReal(@NonNull RealValue left) {
        return this.value.compareTo(left.bigDecimalValue());
    }

    @Override
    public @NonNull RealValue commutatedDivide(@NonNull RealValue left) {
        return left.divideReal(this);
    }

    @Override
    public @NonNull RealValue commutatedMultiply(@NonNull RealValue left) {
        return left.multiplyReal(this);
    }

    @Override
    public @NonNull RealValue commutatedSubtract(@NonNull RealValue left) {
        return left.subtractReal(this);
    }

    @Override
    public int compareTo(@Nullable NumberValue right) {
        if (right != null) {
            return -right.commutatedCompareToReal(this);
        }
        return ValueUtil.throwUnsupportedCompareTo(this, right);
    }

    @Override
    public @NonNull RealValue divideInteger(@NonNull IntegerValue right) {
        return RealValueImpl.divideBigDecimal(this.value, right.bigDecimalValue());
    }

    @Override
    public @NonNull RealValue divideReal(@NonNull RealValue right) {
        return RealValueImpl.divideBigDecimal(this.value, right.bigDecimalValue());
    }

    @Override
    public double doubleValue() {
        return this.value.doubleValue();
    }

    public boolean equals(Object obj) {
        try {
            if (obj instanceof RealValue) {
                BigDecimal bigDecimalValue = ((RealValue)obj).bigDecimalValue();
                return this.value.compareTo(bigDecimalValue) == 0;
            }
            if (obj instanceof IntegerValue) {
                BigDecimal bigDecimalValue = ((IntegerValue)obj).bigDecimalValue();
                return this.value.compareTo(bigDecimalValue) == 0;
            }
        }
        catch (InvalidValueException invalidValueException) {
            // empty catch block
        }
        return this == obj;
    }

    @Override
    public float floatValue() {
        return this.value.floatValue();
    }

    @Override
    public @NonNull IntegerValue floor() {
        @NonNull BigInteger result = this.value.setScale(0, RoundingMode.FLOOR).toBigInteger();
        return ValueUtil.integerValueOf(result);
    }

    protected Object getIntegerValue() {
        if (this.integerValue == null) {
            try {
                @NonNull BigInteger intValue = this.value.toBigIntegerExact();
                this.integerValue = ValueUtil.integerValueOf(intValue);
            }
            catch (ArithmeticException e) {
                this.integerValue = e;
            }
        }
        return this.integerValue;
    }

    public @NonNull Type getType(@NonNull StandardLibrary standardLibrary) {
        return standardLibrary.getRealType();
    }

    @Override
    public @NonNull TypeId getTypeId() {
        return TypeId.REAL;
    }

    public int hashCode() {
        Object intValue = this.getIntegerValue();
        if (intValue instanceof IntegerValue) {
            return intValue.hashCode();
        }
        return this.value.hashCode();
    }

    @Override
    public int intValue() {
        return this.value.intValue();
    }

    @Override
    public @Nullable IntegerValue isIntegerValue() {
        return null;
    }

    @Override
    public @Nullable UnlimitedNaturalValue isUnlimitedNaturalValue() {
        return null;
    }

    @Override
    public long longValue() {
        return this.value.longValue();
    }

    @Override
    public @NonNull RealValue max(@NonNull RealValue rightValue) {
        return rightValue.maxReal(this);
    }

    @Override
    public @NonNull RealValue maxInteger(@NonNull IntegerValue rightValue) {
        try {
            @NonNull BigDecimal result = this.value.max(rightValue.bigDecimalValue());
            return ValueUtil.realValueOf(result);
        }
        catch (InvalidValueException e) {
            throw new InvalidValueException(PivotMessages.InvalidReal, e, null, rightValue);
        }
    }

    @Override
    public @NonNull RealValue maxReal(@NonNull RealValue rightValue) {
        try {
            @NonNull BigDecimal result = this.value.max(rightValue.bigDecimalValue());
            return ValueUtil.realValueOf(result);
        }
        catch (InvalidValueException e) {
            throw new InvalidValueException(PivotMessages.InvalidReal, e, null, rightValue);
        }
    }

    @Override
    public @NonNull RealValue min(@NonNull RealValue rightValue) {
        return rightValue.minReal(this);
    }

    @Override
    public @NonNull RealValue minInteger(@NonNull IntegerValue rightValue) {
        try {
            @NonNull BigDecimal result = this.value.min(rightValue.bigDecimalValue());
            return ValueUtil.realValueOf(result);
        }
        catch (InvalidValueException e) {
            throw new InvalidValueException(PivotMessages.InvalidReal, e, null, rightValue);
        }
    }

    @Override
    public @NonNull RealValue minReal(@NonNull RealValue rightValue) {
        try {
            @NonNull BigDecimal result = this.value.min(rightValue.bigDecimalValue());
            return ValueUtil.realValueOf(result);
        }
        catch (InvalidValueException e) {
            throw new InvalidValueException(PivotMessages.InvalidReal, e, null, rightValue);
        }
    }

    @Override
    public @NonNull RealValue multiplyInteger(@NonNull IntegerValue rightValue) {
        try {
            @NonNull BigDecimal result = this.value.multiply(rightValue.bigDecimalValue());
            return ValueUtil.realValueOf(result);
        }
        catch (InvalidValueException e) {
            throw new InvalidValueException(PivotMessages.InvalidReal, e, null, rightValue);
        }
    }

    @Override
    public @NonNull RealValue multiplyReal(@NonNull RealValue rightValue) {
        try {
            @NonNull BigDecimal result = this.value.multiply(rightValue.bigDecimalValue());
            return ValueUtil.realValueOf(result);
        }
        catch (InvalidValueException e) {
            throw new InvalidValueException(PivotMessages.InvalidReal, e, null, rightValue);
        }
    }

    @Override
    public @NonNull RealValue negate() {
        @NonNull BigDecimal result = this.value.negate();
        return ValueUtil.realValueOf(result);
    }

    @Override
    public @NonNull IntegerValue round() {
        BigDecimal rounded = this.value.signum() >= 0 ? this.value.setScale(0, RoundingMode.HALF_UP) : this.value.negate().setScale(0, RoundingMode.HALF_DOWN).negate();
        @NonNull BigInteger result = rounded.toBigInteger();
        return ValueUtil.integerValueOf(result);
    }

    @Override
    public int signum() {
        return this.value.signum();
    }

    @Override
    public @NonNull RealValue subtractInteger(@NonNull IntegerValue rightValue) {
        try {
            @NonNull BigDecimal result = this.value.subtract(rightValue.bigDecimalValue());
            return ValueUtil.realValueOf(result);
        }
        catch (InvalidValueException e) {
            throw new InvalidValueException(PivotMessages.InvalidReal, e, null, rightValue);
        }
    }

    @Override
    public @NonNull RealValue subtractReal(@NonNull RealValue rightValue) {
        try {
            @NonNull BigDecimal result = this.value.subtract(rightValue.bigDecimalValue());
            return ValueUtil.realValueOf(result);
        }
        catch (InvalidValueException e) {
            throw new InvalidValueException(PivotMessages.InvalidReal, e, null, rightValue);
        }
    }

    public String toString() {
        return this.value.toString();
    }
}

