/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.sync;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.eclipse.oomph.setup.internal.sync.DataProvider;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.userstorage.IBlob;
import org.eclipse.userstorage.IStorage;
import org.eclipse.userstorage.IStorageService;
import org.eclipse.userstorage.util.ConflictException;
import org.eclipse.userstorage.util.FileStorageCache;
import org.eclipse.userstorage.util.NoServiceException;
import org.eclipse.userstorage.util.NotFoundException;

public class RemoteDataProvider
implements DataProvider {
    public static final String APPLICATION_TOKEN = "cNhDr0INs8T109P8h6E1r_GvU3I";
    public static final String KEY = "user_setup";
    private static final byte[] GZIP_MAGIC = new byte[]{31, -117};
    private static final int GZIP_MAGIC_LENGTH = GZIP_MAGIC.length;
    private final IBlob blob;

    public RemoteDataProvider(IStorage storage) {
        this.blob = storage.getBlob(KEY);
    }

    public final DataProvider.Location getLocation() {
        return DataProvider.Location.REMOTE;
    }

    public final URI getURI() {
        IStorageService service = this.getStorage().getService();
        if (service != null) {
            return service.getServiceURI();
        }
        return null;
    }

    public final IStorage getStorage() {
        return this.blob.getStorage();
    }

    public IBlob getBlob() {
        return this.blob;
    }

    public File[] getExtraFiles() {
        return NO_FILES;
    }

    public boolean retrieve(File file) throws IOException, DataProvider.NotFoundException {
        try {
            InputStream contents = this.blob.getContents();
            boolean cached = contents instanceof FileInputStream;
            RemoteDataProvider.uncompressContents(contents, file);
            return !cached;
        }
        catch (NoServiceException noServiceException) {
            throw new DataProvider.NotFoundException(this.getURI());
        }
        catch (NotFoundException notFoundException) {
            throw new DataProvider.NotFoundException(this.getURI());
        }
    }

    public void update(File file, File baseFile) throws IOException, DataProvider.NotCurrentException {
        try {
            InputStream contents = new FileInputStream(file);
            if (!Boolean.getBoolean("org.eclipse.oomph.setup.sync.gzip.skip")) {
                contents = new CompressingInputStream(contents);
            }
            this.blob.setContents(contents);
        }
        catch (ConflictException conflictException) {
            throw new DataProvider.NotCurrentException(this.getURI());
        }
    }

    public boolean delete() throws IOException {
        return this.blob.delete();
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + this.getURI() + "]";
    }

    public static void saveContents(InputStream contents, File file) throws IOException {
        File parentFolder = file.getParentFile();
        if (parentFolder != null) {
            parentFolder.mkdirs();
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            IOUtil.copy((InputStream)contents, (OutputStream)out);
        }
        catch (Throwable throwable) {
            IOUtil.closeSilent(out);
            IOUtil.closeSilent((Closeable)contents);
            throw throwable;
        }
        IOUtil.closeSilent((Closeable)out);
        IOUtil.closeSilent((Closeable)contents);
    }

    public static void uncompressContents(InputStream contents, File file) throws IOException {
        if (!Boolean.getBoolean("org.eclipse.oomph.setup.sync.gunzip.skip")) {
            contents = new BufferedInputStream(contents);
            contents.mark(GZIP_MAGIC_LENGTH);
            byte[] gzipMagic = new byte[GZIP_MAGIC_LENGTH];
            int n = contents.read(gzipMagic);
            contents.reset();
            if (n == GZIP_MAGIC_LENGTH && Arrays.equals(gzipMagic, GZIP_MAGIC)) {
                contents = new GZIPInputStream(contents);
            }
        }
        RemoteDataProvider.saveContents(contents, file);
    }

    private static final class CompressingInputStream
    extends InputStream {
        private InputStream in;
        private TEMPOutputStream temp = new TEMPOutputStream();
        private GZIPOutputStream gzip = new GZIPOutputStream((OutputStream)this.temp, true);

        public CompressingInputStream(InputStream in) throws IOException {
            this.in = in;
        }

        public int read() throws IOException {
            byte[] b = new byte[1];
            int n = this.read(b);
            return n == 1 ? b[0] : n;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.temp.read(b, off, len);
        }

        public void close() throws IOException {
            this.in.close();
            super.close();
        }

        private final class TEMPOutputStream
        extends ByteArrayOutputStream {
            private final byte[] buffer = new byte[8192];

            private TEMPOutputStream() {
            }

            public int read(byte[] b, int off, int len) throws IOException {
                while (this.count < len) {
                    int n = CompressingInputStream.this.in.read(this.buffer);
                    if (n == -1) {
                        CompressingInputStream.this.gzip.close();
                        break;
                    }
                    CompressingInputStream.this.gzip.write(this.buffer, 0, n);
                    CompressingInputStream.this.gzip.flush();
                }
                int result = Math.min(len, this.count);
                System.arraycopy(this.buf, 0, b, off, result);
                this.count -= len;
                if (this.count <= 0) {
                    this.count = 0;
                } else {
                    System.arraycopy(this.buf, len, this.buf, 0, this.count);
                }
                return result == 0 ? -1 : result;
            }
        }
    }

    public static class SyncStorageCache
    extends FileStorageCache.SingleApplication.SingleKey {
        private static final String FILE_NAME_PREFIX = "remote.cache";
        private static final String PROPERTIES_FILE_NAME = "remote.cache.properties";

        public SyncStorageCache(File folder) {
            super(folder, RemoteDataProvider.APPLICATION_TOKEN, RemoteDataProvider.KEY);
            this.setFileNamePrefix(FILE_NAME_PREFIX);
        }

        public File getCacheFile() {
            return new File(this.getFolder(), FILE_NAME_PREFIX);
        }

        public File getPropertiesFile() {
            return new File(this.getFolder(), PROPERTIES_FILE_NAME);
        }
    }
}

