/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.sync;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.fluent.Executor;
import org.eclipse.core.internal.net.ProxyManager;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.oomph.base.util.BaseResourceFactoryImpl;
import org.eclipse.oomph.base.util.BaseUtil;
import org.eclipse.oomph.util.HexUtil;
import org.eclipse.oomph.util.IOExceptionWithCause;
import org.eclipse.oomph.util.IOUtil;

public final class SyncUtil {
    private static final IProxyService PROXY_MANAGER = SyncUtil.getProxyManager();
    private static final String PROP_HTTP_AUTH_NTLM_DOMAIN = "http.auth.ntlm.domain";
    private static final String ENV_USER_DOMAIN = "USERDOMAIN";
    private static final String DOUBLE_BACKSLASH = "\\\\";

    private SyncUtil() {
    }

    public static ResourceSet createResourceSet() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new BaseResourceFactoryImpl());
        return resourceSet;
    }

    public static void inititalizeFile(File file, EClass eClass, ResourceSet resourceSet) {
        if (file.length() == 0L) {
            EObject rootObject = EcoreUtil.create((EClass)eClass);
            Resource resource = resourceSet.createResource(URI.createFileURI((String)file.getAbsolutePath()));
            resource.getContents().add((Object)rootObject);
            BaseUtil.saveEObject((EObject)rootObject);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getDigest(File file) throws IOException {
        String string;
        if (!file.exists()) {
            return null;
        }
        FileInputStream contents = null;
        try {
            contents = new FileInputStream(file);
            string = HexUtil.bytesToHex((byte[])IOUtil.getSHA1((InputStream)contents));
        }
        catch (IOException ex) {
            try {
                throw ex;
                catch (NoSuchAlgorithmException ex2) {
                    throw new IOExceptionWithCause((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                IOUtil.closeSilent(contents);
                throw throwable;
            }
        }
        IOUtil.closeSilent((Closeable)contents);
        return string;
    }

    public static void deleteFile(File file) throws IOException {
        if (file.isFile() && !file.delete()) {
            throw new IOException("Could not delete file " + file);
        }
    }

    public static HttpHost getProxyHost(java.net.URI uri) {
        IProxyData proxy = SyncUtil.getProxyData(uri);
        if (proxy != null) {
            return new HttpHost(proxy.getHost(), proxy.getPort());
        }
        return null;
    }

    public static Executor proxyAuthentication(Executor executor, java.net.URI uri) throws IOException {
        IProxyData proxy = SyncUtil.getProxyData(uri);
        if (proxy != null) {
            HttpHost proxyHost = new HttpHost(proxy.getHost(), proxy.getPort());
            String proxyUserID = proxy.getUserId();
            if (proxyUserID != null) {
                String userID = SyncUtil.getUserName(proxyUserID);
                String password = proxy.getPassword();
                String workstation = SyncUtil.getWorkstation();
                String domain = SyncUtil.getUserDomain(proxyUserID);
                return executor.auth(new AuthScope(proxyHost, AuthScope.ANY_REALM, "ntlm"), (Credentials)new NTCredentials(userID, password, workstation, domain)).auth(new AuthScope(proxyHost, AuthScope.ANY_REALM, AuthScope.ANY_SCHEME), (Credentials)new UsernamePasswordCredentials(userID, password));
            }
        }
        return executor;
    }

    private static String getWorkstation() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    private static String getUserDomain(String userName) {
        int pos;
        String domain = System.getProperty(PROP_HTTP_AUTH_NTLM_DOMAIN);
        if (domain != null) {
            return domain;
        }
        domain = System.getenv(ENV_USER_DOMAIN);
        if (domain != null) {
            return domain;
        }
        if (userName != null && (pos = userName.indexOf(DOUBLE_BACKSLASH)) != -1) {
            return userName.substring(0, pos);
        }
        return null;
    }

    private static String getUserName(String userName) {
        int pos;
        if (userName != null && (pos = userName.indexOf(DOUBLE_BACKSLASH)) != -1) {
            return userName.substring(pos + DOUBLE_BACKSLASH.length());
        }
        return userName;
    }

    private static IProxyData getProxyData(java.net.URI uri) {
        IProxyData[] proxies;
        if (PROXY_MANAGER != null && (proxies = PROXY_MANAGER.select(uri)).length != 0) {
            return proxies[0];
        }
        return null;
    }

    private static IProxyService getProxyManager() {
        try {
            if (CommonPlugin.IS_ECLIPSE_RUNNING) {
                return ProxyManager.getProxyManager();
            }
        }
        catch (Throwable throwable) {}
        return null;
    }
}

