/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.engine.enginecopy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.ui.css.core.dom.CSSStylableElement;
import org.eclipse.e4.ui.css.core.dom.ExtendedCSSRule;
import org.eclipse.e4.ui.css.core.impl.sac.ExtendedSelector;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.ExtendedCSSEngine;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.enginecopy.CSSComputedStyleImpl;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.enginecopy.StyleWrapper;
import org.eclipse.papyrus.infra.gmfdiag.css.lists.ExtendedStyleSheetList;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleRule;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.css.ViewCSS;
import org.w3c.dom.stylesheets.StyleSheet;
import org.w3c.dom.views.DocumentView;

public class ExtendedViewCSSImpl
implements ViewCSS {
    protected ExtendedCSSEngine engine;

    public ExtendedViewCSSImpl(ExtendedCSSEngine extendedCSSEngine) {
        this.engine = extendedCSSEngine;
    }

    @Override
    public CSSStyleDeclaration getComputedStyle(Element elt, String pseudo) {
        StyleWrapper wrapper;
        ExtendedStyleSheetList styleSheetList = this.engine.getAllStylesheets();
        ArrayList<StyleWrapper> declarations = new ArrayList<StyleWrapper>();
        for (StyleSheet styleSheet : styleSheetList) {
            List<StyleWrapper> styleWrappers = this.getStyleWrappers((CSSStyleSheet)styleSheet, elt, pseudo, declarations.size());
            declarations.addAll(styleWrappers);
        }
        String localStyles = ((CSSStylableElement)elt).getCSSStyle();
        if (localStyles != null && (wrapper = this.getStyleWrapper(localStyles)) != null) {
            declarations.add(wrapper);
        }
        return new CSSComputedStyleImpl(declarations);
    }

    private StyleWrapper getStyleWrapper(String localStyles) {
        try {
            CSSStyleDeclaration style = this.engine.parseStyleDeclaration(localStyles);
            StyleWrapper wrapper = new StyleWrapper(style, Integer.MAX_VALUE, 0, ExtendedCSSEngine.CascadeScope.AUTHOR);
            return wrapper;
        }
        catch (IOException ex) {
            this.engine.handleExceptions(ex);
            return null;
        }
    }

    private List<StyleWrapper> getStyleWrappers(CSSStyleSheet styleSheet, Element elt, String pseudoElt, int position) {
        ArrayList<StyleWrapper> styleDeclarations = new ArrayList<StyleWrapper>();
        CSSRuleList ruleList = styleSheet.getCssRules();
        int length = ruleList.getLength();
        int i = 0;
        while (i < length) {
            CSSRule rule = ruleList.item(i);
            if (rule.getType() == 1) {
                CSSStyleRule styleRule = (CSSStyleRule)rule;
                if (rule instanceof ExtendedCSSRule) {
                    ExtendedCSSRule r = (ExtendedCSSRule)rule;
                    SelectorList selectorList = r.getSelectorList();
                    int l = selectorList.getLength();
                    int j = 0;
                    while (j < l) {
                        ExtendedSelector extendedSelector;
                        Selector selector = selectorList.item(j);
                        if (selector instanceof ExtendedSelector && (extendedSelector = (ExtendedSelector)selector).match(elt, pseudoElt)) {
                            CSSStyleDeclaration style = styleRule.getStyle();
                            int specificity = extendedSelector.getSpecificity();
                            StyleWrapper wrapper = new StyleWrapper(style, specificity, position++, this.engine.getCascadeScope(styleSheet));
                            styleDeclarations.add(wrapper);
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        return styleDeclarations;
    }

    @Override
    public DocumentView getDocument() {
        return null;
    }
}

