/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rm.jaxb.control.core.runnable.command;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.ptp.core.jobs.IJobStatus;
import org.eclipse.ptp.core.jobs.IPJobStatus;
import org.eclipse.ptp.core.jobs.JobManager;
import org.eclipse.ptp.core.util.CoreExceptionUtils;
import org.eclipse.ptp.internal.rm.jaxb.control.core.ICommandJob;
import org.eclipse.ptp.internal.rm.jaxb.control.core.ICommandJobStatus;
import org.eclipse.ptp.internal.rm.jaxb.control.core.ICommandJobStatusMap;
import org.eclipse.ptp.internal.rm.jaxb.control.core.ICommandJobStreamMonitor;
import org.eclipse.ptp.internal.rm.jaxb.control.core.ICommandJobStreamsProxy;
import org.eclipse.ptp.internal.rm.jaxb.control.core.JAXBControlCorePlugin;
import org.eclipse.ptp.internal.rm.jaxb.control.core.RemoteServicesDelegate;
import org.eclipse.ptp.internal.rm.jaxb.control.core.messages.Messages;
import org.eclipse.ptp.internal.rm.jaxb.control.core.runnable.JobStatusMap;
import org.eclipse.ptp.rm.jaxb.control.core.ILaunchController;
import org.eclipse.ptp.rm.jaxb.core.IVariableMap;
import org.eclipse.ptp.rm.jaxb.core.data.AttributeType;
import org.eclipse.remote.core.IRemoteProcess;

public class CommandJobStatus
implements ICommandJobStatus {
    private final ILaunchController fControl;
    private final ICommandJob fOpen;
    private final String fLaunchMode;
    private final IVariableMap fVarMap;
    private String fJobId;
    private String fOwner;
    private String fQueue;
    private String fState;
    private String fStateDetail;
    private String fRemoteOutputPath;
    private String fRemoteErrorPath;
    private ICommandJobStreamsProxy fProxy;
    private IRemoteProcess fProcess;
    private PProcesses fPProcesses;
    private boolean fInitialized;
    private boolean fWaitEnabled;
    private boolean fDirty;
    private boolean fFilesChecked;
    private long fLastRequestedUpdate;

    public CommandJobStatus(ICommandJob open, ILaunchController control, IVariableMap map, String mode) {
        this(null, "UNDETERMINED", open, control, map, mode);
    }

    public CommandJobStatus(String jobId, String state, ICommandJob open, ILaunchController control, IVariableMap map, String mode) {
        this.fJobId = jobId;
        this.normalizeState(state);
        this.fOpen = open;
        this.fControl = control;
        this.fVarMap = map;
        this.fLaunchMode = mode;
        this.fWaitEnabled = true;
        this.fLastRequestedUpdate = 0L;
        this.fInitialized = false;
        this.fDirty = false;
        this.fFilesChecked = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel() {
        CommandJobStatus commandJobStatus = this;
        synchronized (commandJobStatus) {
            block9: {
                block8: {
                    block7: {
                        if (this.getStateRank(this.fStateDetail) <= 4) break block7;
                        return false;
                    }
                    this.fWaitEnabled = false;
                    if (this.fOpen == null) break block8;
                    this.fOpen.terminate();
                    this.fOpen.getJobStatus().setState("CANCELED");
                    return true;
                }
                this.notifyAll();
                if (this.fProcess == null || this.fProcess.isCompleted()) break block9;
                this.fProcess.destroy();
                if (this.fProxy != null) {
                    this.fProxy.close();
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelWait() {
        CommandJobStatus commandJobStatus = this;
        synchronized (commandJobStatus) {
            this.fWaitEnabled = false;
            this.notifyAll();
        }
    }

    private boolean canUpdateState(String newState) {
        int currRank;
        int prevRank = this.getStateRank(this.fStateDetail);
        if (prevRank >= (currRank = this.getStateRank(newState))) {
            if (prevRank == 0) {
                return true;
            }
            if (prevRank != 4 || currRank != 3) {
                return false;
            }
        }
        return true;
    }

    private FileReadyChecker checkForReady(String path, int block, IProgressMonitor monitor) {
        FileReadyChecker t = new FileReadyChecker(String.valueOf(Messages.CommandJobStatus_Checking_output_file) + path);
        t.block = block;
        t.path = path;
        t.callerMonitor = monitor;
        t.schedule();
        return t;
    }

    private void checkProcessStateForTermination() {
        if (this.fProcess != null && this.fProcess.isCompleted()) {
            this.setState(this.fProcess.exitValue() == 0 ? "COMPLETED" : "FAILED");
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPJobStatus.class) {
            if (this.fPProcesses != null) {
                return this;
            }
            if (this.fJobId != null && this.fControl != null) {
                String link;
                AttributeType nProcsAttr = this.fVarMap.get("mpiNumberOfProcesses");
                if (nProcsAttr != null && (link = nProcsAttr.getLinkValueTo()) != null) {
                    nProcsAttr = this.fVarMap.get(link);
                }
                if (nProcsAttr != null) {
                    int nProcs = 0;
                    try {
                        nProcs = Integer.parseInt(nProcsAttr.getValue().toString());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (nProcs > 0) {
                        this.fPProcesses = new PProcesses(nProcs);
                        return this;
                    }
                }
            }
        }
        return null;
    }

    public String getControlId() {
        return this.fControl.getControlId();
    }

    public String getErrorPath() {
        return this.fRemoteErrorPath;
    }

    public synchronized String getJobId() {
        return this.fJobId;
    }

    @Override
    public synchronized long getLastUpdateRequest() {
        return this.fLastRequestedUpdate;
    }

    public String getLaunchMode() {
        return this.fLaunchMode;
    }

    public int getNumberOfProcesses() {
        return this.fPProcesses != null ? this.fPProcesses.getNumberOfProcesses() : 0;
    }

    public String getOutputPath() {
        return this.fRemoteOutputPath;
    }

    public String getOwner() {
        return this.fOwner;
    }

    public String getProcessState(int proc) {
        return this.fPProcesses != null ? this.fPProcesses.getProcessState(proc) : "";
    }

    public String getQueueName() {
        return this.fQueue;
    }

    public synchronized String getState() {
        if (this.fStateDetail != "CANCELED") {
            this.checkProcessStateForTermination();
        }
        return this.fState;
    }

    public synchronized String getStateDetail() {
        if (this.fStateDetail != "CANCELED") {
            this.checkProcessStateForTermination();
        }
        return this.fStateDetail;
    }

    private int getStateRank(String state) {
        if ("SUBMITTED".equals(state)) {
            return 1;
        }
        if ("RUNNING".equals(state)) {
            return 4;
        }
        if ("SUSPENDED".equals(state)) {
            return 3;
        }
        if ("COMPLETED".equals(state)) {
            return 5;
        }
        if ("QUEUED_ACTIVE".equals(state)) {
            return 2;
        }
        if ("SYSTEM_ON_HOLD".equals(state)) {
            return 3;
        }
        if ("USER_ON_HOLD".equals(state)) {
            return 3;
        }
        if ("USER_SYSTEM_ON_HOLD".equals(state)) {
            return 3;
        }
        if ("SYSTEM_SUSPENDED".equals(state)) {
            return 3;
        }
        if ("USER_SUSPENDED".equals(state)) {
            return 3;
        }
        if ("USER_SYSTEM_SUSPENDED".equals(state)) {
            return 3;
        }
        if ("FAILED".equals(state)) {
            return 6;
        }
        if ("CANCELED".equals(state)) {
            return 6;
        }
        if ("JOB_OUTERR_READY".equals(state)) {
            return 7;
        }
        return 0;
    }

    public IStreamsProxy getStreamsProxy() {
        return this.fProxy;
    }

    @Override
    public void initialize(String jobId) {
        if (this.fInitialized) {
            return;
        }
        this.fJobId = jobId;
        String path = null;
        this.fRemoteOutputPath = null;
        this.fRemoteErrorPath = null;
        AttributeType a = this.fVarMap.get("stdout_remote_path");
        if (a != null && (path = (String)a.getValue()) != null && !"".equals(path)) {
            this.fRemoteOutputPath = this.fVarMap.getString(jobId, path);
        }
        if ((a = this.fVarMap.get("stderr_remote_path")) != null && (path = (String)a.getValue()) != null && !"".equals(path)) {
            this.fRemoteErrorPath = this.fVarMap.getString(jobId, path);
        }
        this.fInitialized = true;
    }

    public boolean isInteractive() {
        return this.fProcess != null;
    }

    private boolean isReached(String state, String waitUntil) {
        int j;
        int i = this.getStateRank(state);
        return i >= (j = this.getStateRank(waitUntil));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isWaitEnabled() {
        boolean w = true;
        CommandJobStatus commandJobStatus = this;
        synchronized (commandJobStatus) {
            w = this.fWaitEnabled;
        }
        return w;
    }

    @Override
    public void rerun() {
        if (this.getState().equals("RUNNING") && this.isInteractive()) {
            this.fOpen.rerun();
        }
    }

    @Override
    public void maybeWaitForHandlerFiles(int blockForSecs, IProgressMonitor monitor) {
        if (this.fFilesChecked) {
            return;
        }
        FileReadyChecker tout = null;
        FileReadyChecker terr = null;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        if (this.fRemoteOutputPath != null) {
            tout = this.checkForReady(this.fRemoteOutputPath, blockForSecs, (IProgressMonitor)progress.newChild(5));
        }
        if (this.fRemoteErrorPath != null) {
            terr = this.checkForReady(this.fRemoteErrorPath, blockForSecs, (IProgressMonitor)progress.newChild(5));
        }
        if (tout == null && terr == null) {
            this.fFilesChecked = true;
            return;
        }
        if (tout != null) {
            try {
                tout.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (terr != null) {
            try {
                terr.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (tout != null && tout.ready || terr != null && terr.ready) {
            this.setState("JOB_OUTERR_READY");
        }
        this.fFilesChecked = true;
    }

    @Override
    public void setOwner(String owner) {
        this.fOwner = owner;
    }

    @Override
    public void setProcess(IRemoteProcess process) {
        this.fProcess = process;
    }

    public void setProcessOutput(BitSet procs, String output) {
        if (this.fPProcesses != null) {
            this.fPProcesses.setProcessOutput(procs, output);
        }
    }

    public void setProcessState(BitSet procs, String state) {
        if (this.fPProcesses != null) {
            this.fPProcesses.setProcessState(procs, state);
        }
    }

    @Override
    public void setProxy(ICommandJobStreamsProxy proxy) {
        this.fProxy = proxy;
    }

    @Override
    public void setQueueName(String name) {
        this.fQueue = name;
    }

    @Override
    public synchronized void setState(String state) {
        if (!this.canUpdateState(state)) {
            return;
        }
        this.fDirty = false;
        String previousDetail = this.fStateDetail;
        this.normalizeState(state);
        if (previousDetail == null || !previousDetail.equals(this.fStateDetail)) {
            this.fDirty = true;
            JobManager.getInstance().fireJobChanged((IJobStatus)this);
        }
    }

    private void normalizeState(String newState) {
        if ("UNDETERMINED".equals(newState)) {
            this.fState = "UNDETERMINED";
            this.fStateDetail = "UNDETERMINED";
        } else if ("SUBMITTED".equals(newState)) {
            this.fState = "SUBMITTED";
            this.fStateDetail = "SUBMITTED";
        } else if ("RUNNING".equals(newState)) {
            this.fState = "RUNNING";
            this.fStateDetail = "RUNNING";
        } else if ("SUSPENDED".equals(newState)) {
            this.fState = "SUSPENDED";
            this.fStateDetail = "SUSPENDED";
        } else if ("COMPLETED".equals(newState)) {
            this.fState = "COMPLETED";
            this.fStateDetail = "COMPLETED";
        } else if ("QUEUED_ACTIVE".equals(newState)) {
            this.fState = "SUBMITTED";
            this.fStateDetail = "QUEUED_ACTIVE";
        } else if ("SYSTEM_ON_HOLD".equals(newState)) {
            this.fState = "SUBMITTED";
            this.fStateDetail = "SYSTEM_ON_HOLD";
        } else if ("USER_ON_HOLD".equals(newState)) {
            this.fState = "SUBMITTED";
            this.fStateDetail = "USER_ON_HOLD";
        } else if ("USER_SYSTEM_ON_HOLD".equals(newState)) {
            this.fState = "SUBMITTED";
            this.fStateDetail = "USER_SYSTEM_ON_HOLD";
        } else if ("SYSTEM_SUSPENDED".equals(newState)) {
            this.fState = "SUSPENDED";
            this.fStateDetail = "SYSTEM_SUSPENDED";
        } else if ("USER_SUSPENDED".equals(newState)) {
            this.fState = "SUSPENDED";
            this.fStateDetail = "USER_SUSPENDED";
        } else if ("USER_SYSTEM_SUSPENDED".equals(newState)) {
            this.fState = "SUSPENDED";
            this.fStateDetail = "USER_SYSTEM_SUSPENDED";
        } else if ("FAILED".equals(newState)) {
            this.fState = "COMPLETED";
            this.fStateDetail = "FAILED";
        } else if ("CANCELED".equals(newState)) {
            this.fState = "COMPLETED";
            this.fStateDetail = "CANCELED";
        } else if ("JOB_OUTERR_READY".equals(newState)) {
            this.fState = "COMPLETED";
            this.fStateDetail = "JOB_OUTERR_READY";
        }
    }

    @Override
    public synchronized void setUpdateRequestTime(long update) {
        this.fLastRequestedUpdate = update;
    }

    @Override
    public synchronized boolean stateChanged() {
        boolean changed = this.fDirty && !"UNDETERMINED".equals(this.fState);
        this.fDirty = false;
        return changed;
    }

    public String toString() {
        ArrayList<String> s = new ArrayList<String>();
        s.add(this.fJobId);
        s.add(this.fOwner);
        s.add(this.fQueue);
        s.add(this.fState);
        s.add(this.fStateDetail);
        s.add(this.fRemoteOutputPath);
        s.add(this.fRemoteErrorPath);
        return ((Object)s).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForJobId(String uuid, String waitUntil, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        while (!(progress.isCanceled() || !this.isWaitEnabled() || this.fJobId != null && this.isReached(this.fState, waitUntil))) {
            CommandJobStatus commandJobStatus = this;
            synchronized (commandJobStatus) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            progress.setWorkRemaining(10);
            if (this.isInteractive() && this.isWaitEnabled() && this.fProcess.isCompleted() && this.fProcess.exitValue() != 0) {
                throw CoreExceptionUtils.newException((String)(String.valueOf(uuid) + ":" + " " + "FAILED"), null);
            }
            AttributeType a = this.fVarMap.get(uuid);
            if (a == null) continue;
            this.fJobId = a.getName();
            String v = (String)a.getValue();
            if (v != null) {
                this.setState(v);
            }
            if (this.fJobId != null && this.stateChanged()) {
                this.fVarMap.put(this.fJobId, a);
                ICommandJobStatusMap map = JobStatusMap.getInstance(this.fControl);
                if (map != null) {
                    map.addJobStatus(this.fJobId, this);
                }
            }
            if (this.fStateDetail != "FAILED") continue;
            throw CoreExceptionUtils.newException((String)(String.valueOf(uuid) + ":" + " " + "FAILED"), null);
        }
    }

    private class FileReadyChecker
    extends Job {
        private boolean ready;
        private int block;
        private String path;
        private IProgressMonitor callerMonitor;

        public FileReadyChecker(String name) {
            super(name);
        }

        protected IStatus run(IProgressMonitor monitor) {
            this.ready = false;
            long timeout = this.block * 1000;
            RemoteServicesDelegate d = null;
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)120);
            try {
                d = RemoteServicesDelegate.getDelegate(CommandJobStatus.this.fControl.getRemoteServicesId(), CommandJobStatus.this.fControl.getConnectionName(), (IProgressMonitor)progress.newChild(20));
                if (d.getRemoteFileService() == null) {
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
            }
            catch (CoreException ce) {
                IStatus iStatus = CoreExceptionUtils.getErrorStatus((String)ce.getMessage(), (Throwable)ce);
                return iStatus;
            }
            finally {
                if (monitor != null) {
                    monitor.done();
                }
            }
            long start = System.currentTimeMillis();
            long last = 0L;
            long elapsed = 0L;
            double increment = 0.0;
            do {
                try {
                    this.ready = RemoteServicesDelegate.isStable(d.getRemoteFileService(), this.path, 3, (IProgressMonitor)progress.newChild(20));
                }
                catch (Throwable t) {
                    JAXBControlCorePlugin.log(t);
                }
                if (this.ready || (elapsed = System.currentTimeMillis() - start) >= timeout) break;
                increment = (double)(elapsed - last) / (double)timeout * 100.0;
                last = elapsed;
                progress.worked((int)increment);
            } while (!progress.isCanceled() && !this.callerMonitor.isCanceled());
            if (monitor != null) {
                monitor.done();
            }
            return Status.OK_STATUS;
        }
    }

    private class PProcesses {
        private final Map<String, BitSet> fProcState = new HashMap<String, BitSet>();
        private final int fNumProcs;

        public PProcesses(int nprocs) {
            this.fNumProcs = nprocs;
            this.fProcState.put("COMPLETED", new BitSet(nprocs));
            this.fProcState.put("RUNNING", new BitSet(nprocs));
            this.fProcState.put("SUSPENDED", new BitSet(nprocs));
        }

        public int getNumberOfProcesses() {
            return this.fNumProcs;
        }

        public String getProcessState(int proc) {
            for (String state : this.fProcState.keySet()) {
                if (!this.fProcState.get(state).get(proc)) continue;
                return state;
            }
            return "UNDETERMINED";
        }

        public void setProcessOutput(BitSet procs, String output) {
            ICommandJobStreamMonitor monitor = (ICommandJobStreamMonitor)CommandJobStatus.this.getStreamsProxy().getOutputStreamMonitor();
            monitor.append(output);
        }

        public void setProcessState(BitSet procs, String newState) {
            for (String state : this.fProcState.keySet()) {
                if (state.equals(newState)) {
                    this.fProcState.get(state).or(procs);
                    continue;
                }
                this.fProcState.get(state).andNot(procs);
            }
        }
    }
}

