/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.ui.navigator.resources;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.condition.WidgetIsFound;
import org.eclipse.reddeer.core.matcher.WithTextMatcher;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.direct.project.Project;
import org.eclipse.reddeer.eclipse.core.resources.AbstractProject;
import org.eclipse.reddeer.eclipse.core.resources.DefaultProject;
import org.eclipse.reddeer.eclipse.core.resources.DefaultProjectItem;
import org.eclipse.reddeer.eclipse.core.resources.ProjectItem;
import org.eclipse.reddeer.eclipse.exception.EclipseLayerException;
import org.eclipse.reddeer.eclipse.utils.DeleteUtils;
import org.eclipse.reddeer.jface.handler.TreeViewerHandler;
import org.eclipse.reddeer.swt.api.Shell;
import org.eclipse.reddeer.swt.api.TreeItem;
import org.eclipse.reddeer.swt.impl.button.CheckBox;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.menu.ContextMenuItem;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.swt.impl.tree.DefaultTree;
import org.eclipse.reddeer.workbench.core.condition.JobIsRunning;
import org.eclipse.reddeer.workbench.impl.view.WorkbenchView;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.hamcrest.Matcher;

public class AbstractExplorer
extends WorkbenchView {
    protected static final Logger log = Logger.getLogger(AbstractExplorer.class);

    public AbstractExplorer(String viewTitle) {
        super(viewTitle);
    }

    public void selectProjects(String ... projectName) {
        ArrayList<TreeItem> selectTreeItems = new ArrayList<TreeItem>();
        String[] stringArray = projectName;
        int n = projectName.length;
        int n2 = 0;
        while (n2 < n) {
            String pname = stringArray[n2];
            selectTreeItems.add(this.getProject(pname).getTreeItem());
            ++n2;
        }
        if (selectTreeItems.size() > 0) {
            this.getTree().selectItems(selectTreeItems.toArray(new TreeItem[0]));
        }
    }

    public void selectAllProjects() {
        List<DefaultProject> projects = this.getProjects();
        ArrayList<TreeItem> projectsItems = new ArrayList<TreeItem>();
        if (projects.size() > 0) {
            for (DefaultProject project : projects) {
                projectsItems.add(project.getTreeItem());
            }
            this.getTree().selectItems(projectsItems.toArray(new TreeItem[projectsItems.size()]));
        }
    }

    public boolean containsProject(String projectName) {
        boolean result = false;
        try {
            this.getProject(projectName);
            result = true;
        }
        catch (EclipseLayerException eclipseLayerException) {
            result = false;
        }
        return result;
    }

    public List<DefaultProject> getProjects() {
        ArrayList<DefaultProject> projects = new ArrayList<DefaultProject>();
        TreeViewerHandler treeViewerHandler = TreeViewerHandler.getInstance();
        for (TreeItem item : this.getExplorerTreeItems()) {
            String projectName = treeViewerHandler.getNonStyledText(item);
            log.debug("Getting project with name " + projectName);
            if (!Project.isProject((String)projectName)) continue;
            projects.add(new DefaultProject(item));
        }
        return projects;
    }

    public List<ProjectItem> getProjectItems() {
        ArrayList<ProjectItem> items = new ArrayList<ProjectItem>();
        for (TreeItem item : this.getExplorerTreeItems()) {
            items.add(new DefaultProjectItem(item));
        }
        return items;
    }

    public void deleteAllProjects() {
        this.deleteAllProjects(true);
    }

    public void deleteAllProjects(boolean deleteFromFileSystem) {
        this.deleteAllProjects(deleteFromFileSystem, TimePeriod.VERY_LONG);
    }

    public void deleteAllProjects(boolean deleteFromFileSystem, TimePeriod timeout) {
        this.activate();
        if (this.getProjects().size() > 0) {
            this.selectAllProjects();
            new ContextMenuItem(new String[]{"Refresh"}).select();
            new WaitWhile((WaitCondition)new JobIsRunning(), timeout);
            new ContextMenuItem(new String[]{"Delete"}).select();
            DefaultShell s = new DefaultShell("Delete Resources");
            new CheckBox().toggle(deleteFromFileSystem);
            new PushButton("OK").click();
            DeleteUtils.handleDeletion((Shell)s, timeout);
        }
    }

    private DefaultTree getTree() {
        this.activate();
        return new DefaultTree((ReferencedComposite)this.cTabItem);
    }

    public DefaultProject getProject(String projectName) {
        this.activate();
        for (DefaultProject project : this.getProjects()) {
            if (!project.getName().equals(projectName)) continue;
            return project;
        }
        throw new EclipseLayerException("There is no project with name " + projectName);
    }

    public <T extends AbstractProject> T getProject(String projectName, Class<T> projectType) {
        for (TreeItem item : this.getExplorerTreeItems()) {
            try {
                AbstractProject project = (AbstractProject)projectType.getDeclaredConstructor(TreeItem.class).newInstance(item);
                if (!project.getName().equals(projectName)) continue;
                return (T)project;
            }
            catch (EclipseLayerException eclipseLayerException) {
            }
            catch (ReflectiveOperationException reflectiveOperationException) {}
        }
        throw new EclipseLayerException("Required project does not exist. Make sure you are using correct project type and desired project exists.");
    }

    private List<TreeItem> getExplorerTreeItems() {
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        WidgetIsFound widget = new WidgetIsFound(Hyperlink.class, this.cTabItem.getControl(), new Matcher[]{new WithTextMatcher("Create a project...")});
        new WaitUntil((WaitCondition)widget, TimePeriod.SHORT, false);
        if (widget.getResult() != null) {
            return items;
        }
        return this.getTree().getItems();
    }
}

