/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.internal.ccvs.core.CVSMergeSubscriber;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Update;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.actions.WorkspaceTraversalAction;
import org.eclipse.team.internal.ccvs.ui.mappings.ModelMergeOperation;
import org.eclipse.team.internal.ccvs.ui.mappings.ModelMergeParticipant;
import org.eclipse.team.internal.ccvs.ui.operations.UpdateOperation;
import org.eclipse.team.internal.ccvs.ui.subscriber.MergeSynchronizeParticipant;
import org.eclipse.team.internal.ccvs.ui.tags.TagSource;
import org.eclipse.team.internal.ccvs.ui.wizards.MergeWizardPage;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.ui.IWorkbenchPart;

public class MergeWizard
extends Wizard {
    MergeWizardPage page;
    IResource[] resources;
    private final IWorkbenchPart part;
    private final ResourceMapping[] mappings;

    public MergeWizard(IWorkbenchPart part, IResource[] resources, ResourceMapping[] mappings) {
        this.part = part;
        this.resources = resources;
        this.mappings = mappings;
    }

    public void addPages() {
        this.setNeedsProgressMonitor(true);
        TagSource tagSource = TagSource.create(this.resources);
        this.setWindowTitle(CVSUIMessages.MergeWizard_title);
        ImageDescriptor mergeImage = CVSUIPlugin.getPlugin().getImageDescriptor("wizban/mergestream_wizban.png");
        this.page = new MergeWizardPage("mergePage", CVSUIMessages.MergeWizard_0, mergeImage, CVSUIMessages.MergeWizard_1, tagSource);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        CVSTag startTag = this.page.getStartTag();
        CVSTag endTag = this.page.getEndTag();
        if (startTag == null || !this.page.isPreview()) {
            UpdateOperation op = new UpdateOperation(this.getPart(), this.mappings, this.getLocalOptions(startTag, endTag), null);
            try {
                op.run();
            }
            catch (InvocationTargetException e) {
                CVSUIPlugin.openError(this.getShell(), null, null, e);
            }
            catch (InterruptedException interruptedException) {}
        } else if (MergeWizard.isShowModelSync()) {
            ModelMergeParticipant participant = ModelMergeParticipant.getMatchingParticipant(this.mappings, startTag, endTag);
            if (participant == null) {
                CVSMergeSubscriber s = new CVSMergeSubscriber(this.getProjects(this.resources), startTag, endTag, true);
                try {
                    new ModelMergeOperation(this.getPart(), this.mappings, s, this.page.isOnlyPreviewConflicts()).run();
                }
                catch (InvocationTargetException e) {
                    CVSUIPlugin.log(4, "Internal error", e.getTargetException());
                }
                catch (InterruptedException interruptedException) {}
            } else {
                participant.refresh(null, this.mappings);
            }
        } else {
            try {
                this.resources = this.getAllResources(startTag, endTag);
            }
            catch (InvocationTargetException e) {
                CVSUIPlugin.log(4, "An error occurred while determining if extra resources should be included in the merge", e.getTargetException());
            }
            MergeSynchronizeParticipant participant = MergeSynchronizeParticipant.getMatchingParticipant(this.resources, startTag, endTag);
            if (participant == null) {
                CVSMergeSubscriber s = new CVSMergeSubscriber(this.resources, startTag, endTag, false);
                participant = new MergeSynchronizeParticipant(s);
                TeamUI.getSynchronizeManager().addSynchronizeParticipants(new ISynchronizeParticipant[]{participant});
            }
            participant.refresh(this.resources, null, null, null);
        }
        return true;
    }

    private IResource[] getAllResources(CVSTag startTag, CVSTag endTag) throws InvocationTargetException {
        if (!WorkspaceTraversalAction.isLogicalModel(this.mappings)) {
            return this.resources;
        }
        CVSMergeSubscriber s = new CVSMergeSubscriber(WorkspaceTraversalAction.getProjects(this.resources), startTag, endTag, false);
        IResource[] allResources = WorkspaceTraversalAction.getResourcesToCompare(this.mappings, (Subscriber)s);
        s.cancel();
        return allResources;
    }

    public static boolean isShowModelSync() {
        return CVSUIPlugin.getPlugin().getPreferenceStore().getBoolean("enableModelSync");
    }

    private IResource[] getProjects(IResource[] resources) {
        HashSet<IProject> projects = new HashSet<IProject>();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            projects.add(resource.getProject());
            ++i;
        }
        return projects.toArray(new IResource[projects.size()]);
    }

    private Command.LocalOption[] getLocalOptions(CVSTag startTag, CVSTag endTag) {
        ArrayList<Command.LocalOption> options = new ArrayList<Command.LocalOption>();
        if (startTag != null) {
            options.add(Command.makeArgumentOption((Command.LocalOption)Update.JOIN, (String)startTag.getName()));
        }
        options.add(Command.makeArgumentOption((Command.LocalOption)Update.JOIN, (String)endTag.getName()));
        return options.toArray(new Command.LocalOption[options.size()]);
    }

    private IWorkbenchPart getPart() {
        return this.part;
    }
}

