/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml;

import java.io.InputStream;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wb.internal.core.BundleResourceProvider;
import org.eclipse.wb.internal.core.model.description.ToolkitDescription;
import org.eclipse.wb.internal.core.model.description.helpers.DescriptionHelper;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.xml.model.description.ComponentPresentationHelper;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.wb.core.xml";
    private static Activator m_plugin;
    private static final BundleResourceProvider m_resourceProvider;
    private static boolean m_cachesLoaded;

    static {
        m_resourceProvider = BundleResourceProvider.get((String)PLUGIN_ID);
        m_cachesLoaded = false;
    }

    public void stop(BundleContext context) throws Exception {
        m_plugin = null;
        super.stop(context);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        m_plugin = this;
    }

    public static Activator getDefault() {
        return m_plugin;
    }

    public static InputStream getFile(String path) {
        return m_resourceProvider.getFile(path);
    }

    public static Image getImage(String path) {
        return m_resourceProvider.getImage("icons/" + path);
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return m_resourceProvider.getImageDescriptor("icons/" + path);
    }

    public static synchronized void scheduleCachesLoading() {
        if (m_cachesLoaded) {
            return;
        }
        m_cachesLoaded = true;
        if (System.getProperty("FLAG_NO_PALETTE") == null) {
            ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    ToolkitDescription[] toolkits;
                    ToolkitDescription[] toolkitDescriptionArray = toolkits = DescriptionHelper.getToolkits();
                    int n = toolkits.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ToolkitDescription toolkitDescription = toolkitDescriptionArray[n2];
                        String toolkitId = toolkitDescription.getId();
                        ComponentPresentationHelper.scheduleFillingPresentationCache(toolkitId);
                        ++n2;
                    }
                }
            });
        }
    }
}

