/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.command.internal.env.core.data;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.wst.command.internal.env.core.data.ClassEntry;
import org.eclipse.wst.command.internal.env.core.data.DataMappingRegistry;
import org.eclipse.wst.command.internal.env.core.data.DataMappingRegistryImpl;
import org.eclipse.wst.command.internal.env.core.data.RuleEntry;
import org.eclipse.wst.command.internal.env.core.data.Transformer;
import org.eclipse.wst.common.environment.IEnvironment;

public class DataFlowManager {
    private DataMappingRegistryImpl registry_;
    private Hashtable classTable_;
    private int order_;
    private IEnvironment environment_;

    public DataFlowManager(DataMappingRegistryImpl registry, IEnvironment environment) {
        this.registry_ = registry;
        this.classTable_ = new Hashtable();
        this.order_ = 0;
        this.environment_ = environment;
    }

    public DataMappingRegistry getMappingRegistry() {
        return this.registry_;
    }

    public void unprocess(Object object) {
        String objectType = object.getClass().getName();
        ClassEntry classEntry = (ClassEntry)this.classTable_.get(objectType);
        if (classEntry != null) {
            classEntry.removeObject(object);
        }
    }

    public void process(Object object) {
        String objectType = object.getClass().getName();
        ClassEntry classEntry = (ClassEntry)this.classTable_.get(objectType);
        this.environment_.getLog().log(1, "data", 5004, (Object)this, "process", (Object)("Processing: " + objectType));
        if (classEntry == null) {
            classEntry = new ClassEntry();
            this.classTable_.put(objectType, classEntry);
        }
        classEntry.addObject(object, this.order_++);
        Vector ruleEntries = this.registry_.getRuleEntries(objectType);
        if (ruleEntries != null) {
            if (classEntry.setterList_ == null) {
                classEntry.setterList_ = this.getSetterList(object);
            }
            int setterIndex = 0;
            while (setterIndex < classEntry.setterList_.size()) {
                ObjectMethod currentObjectMethod = new ObjectMethod();
                Method setterMethod = (Method)classEntry.setterList_.elementAt(setterIndex);
                RuleEntry currentRuleEntry = null;
                currentObjectMethod.order = -1;
                int index = 0;
                while (index < ruleEntries.size()) {
                    RuleEntry ruleEntry = (RuleEntry)ruleEntries.elementAt(index);
                    if (setterMethod.getName().equals("set" + ruleEntry.targetProperty_)) {
                        ObjectMethod getter = this.getGetterMethod(ruleEntry.sourceType_, ruleEntry.sourceProperty_);
                        if (getter.order == -1) {
                            this.environment_.getLog().log(1, "data", 5005, (Object)this, "process", (Object)("  >>No getter found for property: " + setterMethod.getName()));
                        }
                        if (currentObjectMethod.order < getter.order) {
                            currentObjectMethod = getter;
                            currentRuleEntry = ruleEntry;
                        }
                    }
                    ++index;
                }
                if (currentObjectMethod.order != -1) {
                    this.invokeMethod(currentObjectMethod.object, currentObjectMethod.method, object, setterMethod, currentRuleEntry.transformer_);
                } else {
                    this.environment_.getLog().log(1, "data", 5006, (Object)this, "process", (Object)("  >>No rule found for setter: " + setterMethod.getName()));
                }
                ++setterIndex;
            }
        }
    }

    private Vector getSetterList(Object object) {
        Vector<Method> result = new Vector<Method>();
        Method[] methods = object.getClass().getMethods();
        int index = 0;
        while (index < methods.length) {
            Method method = methods[index];
            boolean isPublic = Modifier.isPublic(method.getModifiers());
            Class<?> returnType = method.getReturnType();
            if (isPublic && returnType == Void.TYPE && method.getParameterTypes().length == 1 && method.getName().startsWith("set")) {
                method.setAccessible(true);
                result.add(method);
            }
            ++index;
        }
        return result;
    }

    private ObjectMethod getGetterMethod(String sourceType, String sourceProperty) {
        Object lastObject;
        ClassEntry classEntry = (ClassEntry)this.classTable_.get(sourceType);
        ObjectMethod getterFound = new ObjectMethod();
        getterFound.order = -1;
        if (classEntry != null && (lastObject = classEntry.getLastObject()) != null) {
            if (classEntry.getterList_ == null) {
                classEntry.getterList_ = this.getGetterList(lastObject);
            }
            int index = 0;
            while (index < classEntry.getterList_.size()) {
                Method getter = (Method)classEntry.getterList_.elementAt(index);
                if (getter.getName().equals("get" + sourceProperty)) {
                    getterFound.order = classEntry.getLastOrder();
                    getterFound.method = getter;
                    getterFound.object = lastObject;
                    break;
                }
                ++index;
            }
        }
        return getterFound;
    }

    private Vector getGetterList(Object object) {
        Vector<Method> result = new Vector<Method>();
        Method[] methods = object.getClass().getMethods();
        int index = 0;
        while (index < methods.length) {
            Method method = methods[index];
            boolean isPublic = Modifier.isPublic(method.getModifiers());
            Class<?> returnType = method.getReturnType();
            if (isPublic && returnType != Void.TYPE && method.getParameterTypes().length == 0 && method.getName().startsWith("get")) {
                method.setAccessible(true);
                result.add(method);
            }
            ++index;
        }
        return result;
    }

    private void invokeMethod(Object sourceObject, Method sourceMethod, Object clientObject, Method clientMethod, Transformer transformer) {
        Object data = null;
        try {
            data = sourceMethod.invoke(sourceObject, new Object[0]);
        }
        catch (InvocationTargetException exc) {
            exc.printStackTrace();
            throw new IllegalArgumentException("Provider \"" + sourceObject.getClass().getName() + "\" threw an exception.");
        }
        catch (IllegalAccessException exc) {
            exc.printStackTrace();
            throw new IllegalArgumentException("Provider \"" + sourceObject.getClass().getName() + "\" threw an exception.");
        }
        this.environment_.getLog().log(1, "data", 5007, (Object)this, "invokeMethod ", (Object)("  Setting prop: " + clientMethod.getName() + " data=" + data + " from: " + sourceObject.getClass().getName()));
        if (transformer != null) {
            data = transformer.transform(data);
        }
        try {
            clientMethod.invoke(clientObject, data);
        }
        catch (InvocationTargetException exc) {
            exc.printStackTrace();
            throw new IllegalArgumentException("Client \"" + clientObject.getClass().getName() + "\" threw an exception.");
        }
        catch (IllegalAccessException exc) {
            exc.printStackTrace();
            throw new IllegalArgumentException("Client \"" + clientObject.getClass().getName() + "\" threw an exception.");
        }
    }

    private class ObjectMethod {
        public Object object;
        public Method method;
        public int order;

        private ObjectMethod() {
        }
    }
}

