/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.shared.ui.core.metamodel.jdt;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.xtend.shared.ui.core.metamodel.jdt.JdtMetaModel;
import org.eclipse.xtend.shared.ui.core.metamodel.jdt.JdtOperationImpl;
import org.eclipse.xtend.shared.ui.core.metamodel.jdt.JdtPropertyImpl;
import org.eclipse.xtend.shared.ui.core.metamodel.jdt.JdtStaticPropertyImpl;
import org.eclipse.xtend.shared.ui.core.metamodel.jdt.JdtTypeStrategy;
import org.eclipse.xtend.shared.ui.internal.XtendLog;
import org.eclipse.xtend.typesystem.AbstractTypeImpl;
import org.eclipse.xtend.typesystem.Feature;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdtTypeImpl
extends AbstractTypeImpl {
    private IType type;
    private Set<Type> superTypes = null;
    private final Feature[] features = null;
    private JdtTypeStrategy strategy = null;
    private JdtMetaModel metamodel = null;

    public JdtTypeImpl(JdtMetaModel meta, IType clazz, String name, JdtTypeStrategy strategy) {
        super(meta.getTypeSystem(), name);
        this.type = clazz;
        this.metamodel = meta;
        this.strategy = strategy;
    }

    public IType getJdtType() {
        if (!this.type.exists()) {
            try {
                this.type = this.metamodel.findType(this.type.getJavaProject(), this.type.getFullyQualifiedName());
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        return this.type;
    }

    public Feature[] getContributedFeatures() {
        if (this.features == null) {
            try {
                IMethod[] ms = this.type.getMethods();
                HashSet<Object> features = new HashSet<Object>();
                int i = 0;
                while (i < ms.length) {
                    IMethod method = ms[i];
                    if (this.strategy.isGetter(method)) {
                        String sig = this.strategy.getPropertiesInnerType(method);
                        Type type = null;
                        type = sig != null ? this.metamodel.getTypeSystem().getListType(this.getTypeForSignature(sig)) : this.getTypeForSignature(method.getReturnType());
                        if (type != null && !type.equals(this.metamodel.getTypeSystem().getVoidType())) {
                            features.add((Object)new JdtPropertyImpl((Type)this, this.strategy.propertyName(method), type));
                        } else if (type == null) {
                            XtendLog.logInfo("Couldn't resolve return type of " + method.toString());
                        }
                    } else if (this.strategy.isOperation(method)) {
                        String[] paramSigns = method.getParameterTypes();
                        Type[] params = new Type[paramSigns.length];
                        boolean unkownType = false;
                        Type rType = this.getTypeForSignature(method.getReturnType());
                        if (rType == null) {
                            unkownType = true;
                        }
                        int j = 0;
                        while (!unkownType && j < paramSigns.length) {
                            params[j] = this.getTypeForSignature(paramSigns[j]);
                            if (params[j] == null) {
                                unkownType = true;
                            }
                            ++j;
                        }
                        if (!unkownType) {
                            features.add((Object)new JdtOperationImpl((Type)this, method.getElementName(), rType, params));
                        }
                    }
                    ++i;
                }
                IField[] iFieldArray = this.type.getFields();
                int n = iFieldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IField field = iFieldArray[n2];
                    if (this.strategy.isConstant(field)) {
                        Type type = this.getTypeForField(field);
                        if (field.isEnumConstant()) {
                            features.add((Object)new JdtStaticPropertyImpl((Type)this, this.strategy.propertyName(field), type, field.getElementName()));
                        } else {
                            features.add((Object)new JdtStaticPropertyImpl((Type)this, this.strategy.propertyName(field), type, field.getConstant()));
                        }
                    }
                    ++n2;
                }
                return features.toArray(new Feature[features.size()]);
            }
            catch (Exception e) {
                XtendLog.logError(e);
                return new Feature[0];
            }
        }
        return this.features;
    }

    private Type getTypeForField(IField field) throws JavaModelException, IllegalArgumentException {
        Type type = null;
        if (field.isEnumConstant()) {
            type = this.metamodel.getTypeSystem().getTypeForName(field.getDeclaringType().getFullyQualifiedName().replaceAll("\\.", "::"));
        } else if (field.getConstant() != null) {
            type = this.metamodel.getTypeSystem().getTypeForName(field.getConstant().getClass().getName().replaceAll("\\.", "::"));
        } else if (Signature.getElementType((String)field.getTypeSignature()).matches("B|C|D|F|I|J|S|Z")) {
            XtendLog.logInfo("constant value for field " + field.getElementName() + " not resolvable");
        } else {
            String typeName = Signature.getElementType((String)field.getTypeSignature());
            type = this.metamodel.getTypeSystem().getTypeForName(typeName.replaceAll("\\.", "::"));
        }
        return type;
    }

    private Type getTypeForSignature(String signature) {
        if ("V".equals(signature)) {
            return this.metamodel.getTypeSystem().getVoidType();
        }
        String name = this.metamodel.getFullyQualifiedName(signature, this.type);
        if (name == null) {
            return null;
        }
        return this.metamodel.getTypeSystem().getTypeForName(name);
    }

    public Set<? extends Type> getSuperTypes() {
        if (this.superTypes == null) {
            this.superTypes = new HashSet<Type>();
            try {
                IType[] jdtSuperTypes = this.strategy.getSuperTypes(this.type);
                int i = 0;
                while (i < jdtSuperTypes.length) {
                    IType type = jdtSuperTypes[i];
                    Type t = this.metamodel.getTypeForClass(type);
                    if (t == null) {
                        XtendLog.logInfo("Couldn't resolve type for " + type);
                    } else {
                        this.superTypes.add(t);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                XtendLog.logError(e);
            }
            if (this.superTypes.isEmpty()) {
                this.superTypes.add(this.getTypeSystem().getObjectType());
            }
        }
        return this.superTypes;
    }

    public final Set<? extends Type> getAllSuperTypes() {
        HashSet<? extends Type> result = new HashSet<Type>(this.getSuperTypes());
        for (Type type : this.getSuperTypes()) {
            if (!(type instanceof JdtTypeImpl)) continue;
            result.addAll(((JdtTypeImpl)type).getAllSuperTypes());
        }
        return result;
    }

    public boolean isInstance(Object o) {
        throw new UnsupportedOperationException();
    }

    protected boolean internalIsAssignableFrom(Type t) {
        if (t instanceof JdtTypeImpl) {
            try {
                return this.strategy.isAssignable(this.getJdtType(), ((JdtTypeImpl)t).getJdtType());
            }
            catch (Exception e) {
                XtendLog.logError(e);
            }
        }
        return false;
    }

    public Object newInstance() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object obj) {
        if (obj instanceof JdtTypeImpl) {
            JdtTypeImpl t = (JdtTypeImpl)((Object)obj);
            return this.type.equals(t.type) && this.strategy.equals(t.strategy);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.type.hashCode();
    }
}

