/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server.symbol;

import com.google.common.annotations.Beta;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.xtext.ide.server.DocumentExtensions;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

@Singleton
@Beta
public class DocumentSymbolMapper {
    @Inject
    private DocumentSymbolNameProvider nameProvider;
    @Inject
    private DocumentSymbolKindProvider kindProvider;
    @Inject
    private DocumentSymbolRangeProvider rangeProvider;
    @Inject
    private DocumentSymbolDetailsProvider detailsProvider;
    @Inject
    private DocumentSymbolDeprecationInfoProvider deprecationInfoProvider;

    public DocumentSymbol toDocumentSymbol(EObject object) {
        DocumentSymbol _documentSymbol = new DocumentSymbol();
        Procedures.Procedure1 _function = it -> {
            it.setName(this.nameProvider.getName(object));
            it.setKind(this.kindProvider.getSymbolKind(object));
            it.setRange(this.rangeProvider.getRange(object));
            it.setSelectionRange(this.rangeProvider.getSelectionRange(object));
            it.setDetail(this.detailsProvider.getDetails(object));
            it.setDeprecated(Boolean.valueOf(this.deprecationInfoProvider.isDeprecated(object)));
            it.setChildren((List)CollectionLiterals.newArrayList());
        };
        return (DocumentSymbol)ObjectExtensions.operator_doubleArrow((Object)_documentSymbol, (Procedures.Procedure1)_function);
    }

    @Singleton
    @Beta
    public static class DocumentSymbolDeprecationInfoProvider {
        public boolean isDeprecated(EObject object) {
            return false;
        }

        public boolean isDeprecated(IEObjectDescription description) {
            return false;
        }
    }

    @Singleton
    @Beta
    public static class DocumentSymbolRangeProvider {
        @Inject
        @Extension
        private DocumentExtensions _documentExtensions;

        public Range getRange(EObject object) {
            Location _newFullLocation = this._documentExtensions.newFullLocation(object);
            Range _range = null;
            if (_newFullLocation != null) {
                _range = _newFullLocation.getRange();
            }
            return _range;
        }

        public Range getSelectionRange(EObject object) {
            Location _newLocation = this._documentExtensions.newLocation(object);
            Range _range = null;
            if (_newLocation != null) {
                _range = _newLocation.getRange();
            }
            return _range;
        }
    }

    @Singleton
    @Beta
    public static class DocumentSymbolKindProvider {
        public SymbolKind getSymbolKind(EObject object) {
            EClass _eClass = null;
            if (object != null) {
                _eClass = object.eClass();
            }
            return this.getSymbolKind(_eClass);
        }

        public SymbolKind getSymbolKind(IEObjectDescription description) {
            EClass _eClass = null;
            if (description != null) {
                _eClass = description.getEClass();
            }
            return this.getSymbolKind(_eClass);
        }

        protected SymbolKind getSymbolKind(EClass clazz) {
            return SymbolKind.Property;
        }
    }

    @Singleton
    @Beta
    public static class DocumentSymbolNameProvider {
        @Inject
        @Extension
        private IQualifiedNameProvider _iQualifiedNameProvider;

        public String getName(EObject object) {
            QualifiedName _fullyQualifiedName = null;
            if (object != null) {
                _fullyQualifiedName = this._iQualifiedNameProvider.getFullyQualifiedName(object);
            }
            return this.getName(_fullyQualifiedName);
        }

        public String getName(IEObjectDescription description) {
            QualifiedName _name = null;
            if (description != null) {
                _name = description.getName();
            }
            return this.getName(_name);
        }

        protected String getName(QualifiedName qualifiedName) {
            String _string = null;
            if (qualifiedName != null) {
                _string = qualifiedName.toString();
            }
            return _string;
        }
    }

    @Singleton
    @Beta
    public static class DocumentSymbolDetailsProvider {
        public String getDetails(EObject object) {
            return "";
        }
    }
}

