/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.structures.common.comparable;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.diffmerge.structures.Structures;

public interface IComparableStructure<E extends Comparable<?>>
extends Comparable<IComparableStructure<?>> {
    public static final Comparator<IComparableStructure<?>> STRUCTURE_COMPARATOR = new Comparator<IComparableStructure<?>>(){

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public int compare(IComparableStructure<?> o1_p, IComparableStructure<?> o2_p) {
            if (o1_p.getClass() != o2_p.getClass()) {
                return o1_p.getClass().getName().compareTo(o2_p.getClass().getName());
            }
            try {
                Iterator<?> it1;
                block8: {
                    it1 = o1_p.getCompareIterator();
                    Iterator<?> it2 = o2_p.getCompareIterator();
                    while (true) {
                        if (!it1.hasNext() || !it2.hasNext()) {
                            if (!it1.hasNext() && !it2.hasNext()) {
                                return 0;
                            }
                            break block8;
                        }
                        Comparable member1 = (Comparable)it1.next();
                        Comparable member2 = (Comparable)it2.next();
                        if (member1 != null && member2 != null) {
                            int result = member1.compareTo(member2);
                            if (result == 0) continue;
                            return result;
                        }
                        if (member1 == null && member2 != null) {
                            return -1;
                        }
                        if (member1 != null) break;
                    }
                    return 1;
                }
                if (!it1.hasNext()) return -1;
                return 1;
            }
            catch (ClassCastException e) {
                return 0;
            }
        }
    };

    public Iterator<E> getCompareIterator();

    public static class ComparableMapEntry<K extends Comparable<?>, V extends Comparable<?>>
    implements IComparableMapEntry<K, V> {
        protected final Map.Entry<K, V> _wrappedEntry;

        public ComparableMapEntry(Map.Entry<K, V> entry_p) {
            this._wrappedEntry = entry_p;
        }

        @Override
        public int compareTo(IComparableStructure<?> o_p) {
            return STRUCTURE_COMPARATOR.compare(this, o_p);
        }

        @Override
        public boolean equals(Object o_p) {
            return this._wrappedEntry.equals(o_p);
        }

        @Override
        public Iterator<Comparable<?>> getCompareIterator() {
            return Arrays.asList(this.getKey(), this.getValue()).iterator();
        }

        @Override
        public K getKey() {
            return (K)((Comparable)this._wrappedEntry.getKey());
        }

        @Override
        public V getValue() {
            return (V)((Comparable)this._wrappedEntry.getValue());
        }

        @Override
        public int hashCode() {
            return this._wrappedEntry.hashCode();
        }

        @Override
        public V setValue(V value_p) {
            return (V)((Comparable)this._wrappedEntry.setValue(value_p));
        }

        public String toString() {
            return Structures.toMapEntryString(this);
        }
    }

    public static interface IComparableList<E extends Comparable<?>>
    extends List<E>,
    IComparableStructure<E> {
    }

    public static interface IComparableMap<K extends Comparable<?>, V extends Comparable<?>>
    extends Map<K, V>,
    IComparableStructure<IComparableMapEntry<K, V>> {
    }

    public static interface IComparableMapEntry<K extends Comparable<?>, V extends Comparable<?>>
    extends Map.Entry<K, V>,
    IComparableStructure<Comparable<?>> {
    }

    public static interface IComparableSet<E extends Comparable<?>>
    extends Set<E>,
    IComparableStructure<E> {
    }
}

