/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.useradmin;

import java.security.Permission;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.equinox.internal.useradmin.Authorization;
import org.eclipse.equinox.internal.useradmin.Group;
import org.eclipse.equinox.internal.useradmin.LogTracker;
import org.eclipse.equinox.internal.useradmin.Role;
import org.eclipse.equinox.internal.useradmin.User;
import org.eclipse.equinox.internal.useradmin.UserAdminEventProducer;
import org.eclipse.equinox.internal.useradmin.UserAdminMsg;
import org.eclipse.equinox.internal.useradmin.UserAdminStore;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.PreferencesService;
import org.osgi.service.useradmin.UserAdminPermission;

public class UserAdmin
implements org.osgi.service.useradmin.UserAdmin {
    protected Vector users;
    protected Vector roles = new Vector();
    protected BundleContext context;
    protected UserAdminEventProducer eventProducer;
    protected boolean alive;
    protected UserAdminStore userAdminStore;
    protected UserAdminPermission adminPermission;
    protected ServiceReference reference;
    protected LogTracker log;

    protected UserAdmin(PreferencesService preferencesService, BundleContext context) throws Exception {
        this.users = new Vector();
        this.context = context;
        this.log = new LogTracker(context, System.out);
        this.alive = true;
        try {
            this.userAdminStore = new UserAdminStore(preferencesService, this, this.log);
            this.userAdminStore.init();
        }
        catch (Exception e) {
            this.log.log(1, UserAdminMsg.Backing_Store_Read_Exception, e);
            throw e;
        }
    }

    protected void setServiceReference(ServiceReference reference) {
        if (this.reference == null) {
            this.reference = reference;
            this.eventProducer = new UserAdminEventProducer(reference, this.context, this.log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.osgi.service.useradmin.Role createRole(String name, int type) {
        this.checkAlive();
        this.checkAdminPermission();
        if (name == null) {
            throw new IllegalArgumentException(UserAdminMsg.CREATE_NULL_ROLE_EXCEPTION);
        }
        if (type != 2 && type != 1) {
            throw new IllegalArgumentException(UserAdminMsg.CREATE_INVALID_TYPE_ROLE_EXCEPTION);
        }
        if (this.getRole(name) != null) {
            return null;
        }
        UserAdmin userAdmin = this;
        synchronized (userAdmin) {
            return this.createRole(name, type, true);
        }
    }

    protected org.osgi.service.useradmin.Role createRole(String name, int type, boolean store) {
        Role newRole = null;
        if (type == 0) {
            newRole = new Role(name, this);
        } else if (type == 1) {
            newRole = new User(name, this);
        } else if (type == 2) {
            newRole = new Group(name, this);
        } else {
            return null;
        }
        if (store) {
            try {
                this.userAdminStore.addRole(newRole);
            }
            catch (BackingStoreException backingStoreException) {
                return null;
            }
            if (this.eventProducer != null) {
                this.eventProducer.generateEvent(1, newRole);
            }
        }
        if (type == 2 || type == 1) {
            this.users.addElement(newRole);
        }
        this.roles.addElement(newRole);
        return newRole;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeRole(String name) {
        this.checkAlive();
        this.checkAdminPermission();
        if (name.equals("user.anyone")) {
            return true;
        }
        UserAdmin userAdmin = this;
        synchronized (userAdmin) {
            block8: {
                Role role = (Role)this.getRole(name);
                if (role == null) break block8;
                try {
                    this.userAdminStore.removeRole(role);
                }
                catch (BackingStoreException backingStoreException) {
                    return false;
                }
                this.roles.removeElement(role);
                this.users.removeElement(role);
                role.destroy();
                this.eventProducer.generateEvent(4, role);
                role = null;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.osgi.service.useradmin.Role getRole(String name) {
        this.checkAlive();
        if (name == null) {
            return null;
        }
        UserAdmin userAdmin = this;
        synchronized (userAdmin) {
            Enumeration e = this.roles.elements();
            while (e.hasMoreElements()) {
                Role role = (Role)e.nextElement();
                if (!role.getName().equals(name)) continue;
                return role;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.osgi.service.useradmin.Role[] getRoles(String filterString) throws InvalidSyntaxException {
        this.checkAlive();
        UserAdmin userAdmin = this;
        synchronized (userAdmin) {
            int size;
            Vector<Role> returnedRoles;
            block8: {
                if (filterString == null) {
                    returnedRoles = this.roles;
                } else {
                    Filter filter = this.context.createFilter(filterString);
                    returnedRoles = new Vector<Role>();
                    int i = 0;
                    while (i < this.roles.size()) {
                        Role role = (Role)this.roles.elementAt(i);
                        if (filter.match(role.getProperties())) {
                            returnedRoles.addElement(role);
                        }
                        ++i;
                    }
                }
                size = returnedRoles.size();
                if (size != 0) break block8;
                return null;
            }
            Object[] roleArray = new Role[size];
            returnedRoles.copyInto(roleArray);
            return roleArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public org.osgi.service.useradmin.User getUser(String key, String value) {
        this.checkAlive();
        if (key == null) {
            return null;
        }
        User foundUser = null;
        UserAdmin userAdmin = this;
        synchronized (userAdmin) {
            Enumeration e = this.users.elements();
            while (true) {
                if (!e.hasMoreElements()) {
                    return foundUser;
                }
                User user = (User)e.nextElement();
                Dictionary props = user.getProperties();
                String keyValue = (String)props.get(key);
                if (keyValue == null || !keyValue.equals(value)) continue;
                if (foundUser != null) {
                    return null;
                }
                foundUser = user;
            }
        }
    }

    public org.osgi.service.useradmin.Authorization getAuthorization(org.osgi.service.useradmin.User user) {
        this.checkAlive();
        return new Authorization((User)user, this);
    }

    protected synchronized void destroy() {
        this.alive = false;
        this.eventProducer.close();
        this.userAdminStore.destroy();
        this.log.close();
    }

    public void checkAdminPermission() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (this.adminPermission == null) {
                this.adminPermission = new UserAdminPermission("admin", null);
            }
            sm.checkPermission((Permission)this.adminPermission);
        }
    }

    public void checkGetCredentialPermission(String credential) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new UserAdminPermission(credential, "getCredential"));
        }
    }

    public void checkChangeCredentialPermission(String credential) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new UserAdminPermission(credential, "changeCredential"));
        }
    }

    public void checkChangePropertyPermission(String property) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new UserAdminPermission(property, "changeProperty"));
        }
    }

    public void checkAlive() {
        if (!this.alive) {
            throw new IllegalStateException(UserAdminMsg.USERADMIN_UNREGISTERED_EXCEPTION);
        }
    }
}

