/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.traceability.engine;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.acceleo.common.preference.AcceleoPreferences;
import org.eclipse.acceleo.internal.traceability.engine.ExpressionTrace;
import org.eclipse.acceleo.model.mtl.Query;

public class QueryTraceCache<C> {
    private final Map<Query, Map<List<Object>, ExpressionTrace<C>>> queryTraceCache = new HashMap<Query, Map<List<Object>, ExpressionTrace<C>>>();

    public ExpressionTrace<C> getCachedTrace(Query query, List<Object> parameters) {
        if (!AcceleoPreferences.isQueryCacheEnabled() || !this.queryTraceCache.containsKey(query)) {
            return null;
        }
        Map<List<Object>, ExpressionTrace<C>> cache = this.queryTraceCache.get(query);
        return cache.get(parameters);
    }

    public void cacheTrace(Query query, List<Object> parameters, ExpressionTrace<C> trace) {
        if (!AcceleoPreferences.isQueryCacheEnabled() || trace.getTraces().isEmpty()) {
            return;
        }
        Map<List<Object>, ExpressionTrace<C>> cache = this.queryTraceCache.get(query);
        if (cache == null) {
            cache = new HashMap<List<Object>, ExpressionTrace<C>>();
            this.queryTraceCache.put(query, cache);
        }
        cache.put(parameters, trace);
    }
}

