/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.pageflow.figure;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.MidpointLocator;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jst.jsf.facesconfig.ui.EditorPlugin;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.editpart.PageflowElementEditPart;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.figure.ConnectionLabel;
import org.eclipse.jst.jsf.facesconfig.ui.preference.GEMPreferences;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;

public class PFLinkFigure
extends PolylineConnection {
    private ConnectionLabel textLabel = null;
    private Color labelBgColor;
    private Color labelFgColor;
    private boolean bLabelVisible = false;
    private int lineWidth = 0;
    private PolygonDecoration arrow = new PolygonDecoration();

    public PFLinkFigure() {
        this.arrow.setTemplate(PolygonDecoration.TRIANGLE_TIP);
        this.arrow.setScale(10.0, (double)(this.getLineWidth() * 2));
        this.setTargetDecoration((RotatableDecoration)this.arrow);
        this.setForegroundColor(this.getForegroundColor());
    }

    public void setLabel(String strLabel) {
        if (strLabel != null) {
            if (this.textLabel == null) {
                this.textLabel = new ConnectionLabel();
                this.textLabel.setFont(this.getLabelFont());
                this.textLabel.setBackgroundColor(this.getLabelBackgroundColor());
                this.textLabel.setForegroundColor(this.getLabelForegroundColor());
                this.setLineWidth(this.getLineWidth());
                this.setLabelVisible(this.getLabelVisible());
                this.setForegroundColor(this.getForegroundColor());
                this.add((IFigure)this.textLabel, new MidpointLocator((Connection)this, 1));
            }
            this.textLabel.setText(strLabel);
        }
    }

    public void clearIcon() {
        this.setImage(null);
    }

    public void clearOutcome() {
        this.setLabel("");
    }

    public void setImage(Image image) {
        if (this.textLabel == null) {
            this.textLabel = new ConnectionLabel();
            this.textLabel.setFont(this.getLabelFont());
            this.textLabel.setBackgroundColor(this.getLabelBackgroundColor());
            this.textLabel.setForegroundColor(this.getLabelForegroundColor());
            this.setLineWidth(this.getLineWidth());
            this.setLabelVisible(this.getLabelVisible());
            this.setForegroundColor(this.getForegroundColor());
            this.add((IFigure)this.textLabel, new MidpointLocator((Connection)this, 0));
        }
        this.textLabel.setIcon(image);
    }

    public void setActionImage() {
        ImageDescriptor imageDescriptor = PageflowElementEditPart.IMG_ACTION;
        Image image = EditorPlugin.getDefault().getImageRegistry().get(imageDescriptor.toString());
        if (image == null) {
            EditorPlugin.getDefault().getImageRegistry().put(imageDescriptor.toString(), imageDescriptor);
            image = EditorPlugin.getDefault().getImageRegistry().get(imageDescriptor.toString());
        }
        this.setImage(image);
    }

    public Image getImage() {
        if (this.textLabel != null) {
            return this.textLabel.getIcon();
        }
        return null;
    }

    public void setToolTipText(String text) {
        Label toolTipLabel = null;
        if (text != null && text.length() > 0) {
            toolTipLabel = new Label(text);
            toolTipLabel.setBorder((Border)new MarginBorder(3));
        }
        super.setToolTip(toolTipLabel);
    }

    public String getToolTipText() {
        if (this.getToolTip() != null) {
            return ((Label)this.getToolTip()).getText();
        }
        return null;
    }

    public void setFont(Font f) {
        if (this.textLabel != null) {
            this.textLabel.setFont(f);
        }
        super.setFont(f);
    }

    private Font getLabelFont() {
        IPreferenceStore store;
        FontData fontData;
        FontRegistry registry = JFaceResources.getFontRegistry();
        if (!registry.get((fontData = PreferenceConverter.getFontData((IPreferenceStore)(store = EditorPlugin.getDefault().getPreferenceStore()), (String)"LineLabelFont")).toString()).equals((Object)registry.defaultFont())) {
            return registry.get(fontData.toString());
        }
        registry.put(fontData.toString(), new FontData[]{fontData});
        return registry.get(fontData.toString());
    }

    public void setLineWidth(int w) {
        if (this.textLabel != null) {
            this.textLabel.setBorderWidth(w);
        }
        this.arrow.setScale(10.0, (double)(this.getLineWidth() * 2));
        super.setLineWidth(w);
    }

    public int getLineWidth() {
        IPreferenceStore store = EditorPlugin.getDefault().getPreferenceStore();
        this.lineWidth = store.getInt("LineWidth");
        return this.lineWidth;
    }

    public void setLabelVisible(boolean flag) {
        if (this.textLabel != null) {
            this.textLabel.setVisible(flag);
        }
    }

    private boolean getLabelVisible() {
        IPreferenceStore store = EditorPlugin.getDefault().getPreferenceStore();
        this.bLabelVisible = store.getBoolean("ShowLineLabels");
        return this.bLabelVisible;
    }

    public void setLabelForegroundColor(Color c) {
        this.labelFgColor = c;
        if (this.textLabel != null) {
            this.textLabel.setForegroundColor(c);
        }
    }

    private Color getLabelForegroundColor() {
        if (this.labelFgColor == null) {
            IPreferenceStore store = EditorPlugin.getDefault().getPreferenceStore();
            this.labelFgColor = GEMPreferences.getColor(store, "LineLabelFontColor");
        }
        return this.labelFgColor;
    }

    public void setLabelBackgroundColor(Color c) {
        this.labelBgColor = c;
        if (this.textLabel != null) {
            this.textLabel.setBackgroundColor(c);
        }
    }

    private Color getLabelBackgroundColor() {
        if (this.labelBgColor == null) {
            IPreferenceStore store = EditorPlugin.getDefault().getPreferenceStore();
            this.labelBgColor = GEMPreferences.getColor(store, "LineLabelColor");
        }
        return this.labelBgColor;
    }

    public Color getForegroundColor() {
        IPreferenceStore store = EditorPlugin.getDefault().getPreferenceStore();
        Color newFgColor = GEMPreferences.getColor(store, "LineColor");
        this.setForegroundColor(newFgColor);
        return newFgColor;
    }

    public void setForegroundColor(Color c) {
        if (this.textLabel != null) {
            this.textLabel.setBorderColor(c);
        }
        super.setForegroundColor(c);
    }
}

