/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.wizards.refactor;

import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jubula.client.core.businessprocess.db.TestCaseBP;
import org.eclipse.jubula.client.core.events.InteractionEventDispatcher;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.NodeMaker;
import org.eclipse.jubula.client.core.persistence.EditSupport;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.ui.rcp.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.rcp.editors.AbstractJBEditor;
import org.eclipse.jubula.client.ui.rcp.editors.JBEditorHelper;
import org.eclipse.jubula.client.ui.rcp.editors.NodeEditorInput;
import org.eclipse.jubula.client.ui.rcp.handlers.delete.DeleteTreeItemHandlerTCEditor;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.wizards.refactor.pages.AdditionalInformationPage;
import org.eclipse.jubula.client.ui.rcp.wizards.refactor.pages.ChooseTestCasePage;
import org.eclipse.jubula.client.ui.rcp.wizards.refactor.pages.MatchComponentNamesPage;

public class ReplaceTCRWizard
extends Wizard {
    private static final String CHOOSE_PAGE_ID = "ReplaceTCRWizard.ChoosePageId";
    private static final String MATCH_COMP_NAMES_PAGE_ID = "ReplaceTCRWizard.MatchCompNamesPageId";
    private static final String ADD_INFORMATION_PAGE_ID = "ReplaceTCRWizard.AdditionalInformationPageId";
    private final AbstractJBEditor m_editor;
    private final List<INodePO> m_listOfExecsToReplace;
    private INodePO m_parentTC;
    private ChooseTestCasePage m_choosePage;
    private MatchComponentNamesPage m_matchCompNamePage;
    private AdditionalInformationPage m_addInfoPage;
    private IExecTestCasePO m_newExec;

    public ReplaceTCRWizard(AbstractJBEditor editor, List<INodePO> listOfExecsToReplace) {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Messages.ReplaceTCRWizardTitle);
        this.m_editor = editor;
        this.m_listOfExecsToReplace = listOfExecsToReplace;
        this.m_parentTC = (INodePO)editor.getEditorHelper().getEditSupport().getWorkVersion();
    }

    public void addPages() {
        super.addPages();
        this.m_choosePage = new ChooseTestCasePage(this.m_parentTC, CHOOSE_PAGE_ID);
        this.m_matchCompNamePage = new MatchComponentNamesPage(MATCH_COMP_NAMES_PAGE_ID, this.m_editor, this.m_listOfExecsToReplace);
        this.m_addInfoPage = new AdditionalInformationPage(ADD_INFORMATION_PAGE_ID);
        this.addPage((IWizardPage)this.m_choosePage);
        this.addPage((IWizardPage)this.m_matchCompNamePage);
        this.addPage((IWizardPage)this.m_addInfoPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page instanceof ChooseTestCasePage) {
            ISpecTestCasePO specTC = this.m_choosePage.getChoosenTestCase();
            this.m_newExec = NodeMaker.createExecTestCasePO((ISpecTestCasePO)specTC);
            this.m_addInfoPage.bindNewExec(this.m_newExec);
            this.m_matchCompNamePage.setSelectedExecNode(this.m_newExec);
        }
        return super.getNextPage(page);
    }

    public boolean performFinish() {
        INodePO placeToInsert = this.m_listOfExecsToReplace.get(0);
        ISpecTestCasePO specTcToInsert = this.m_choosePage.getChoosenTestCase();
        try {
            Integer index = placeToInsert.getParentNode().indexOf(placeToInsert);
            JBEditorHelper eh = this.m_editor.getEditorHelper();
            IExecTestCasePO replacementTCReference = TestCaseBP.addReferencedTestCase((INodePO)placeToInsert.getParentNode(), (IExecTestCasePO)this.m_newExec, (Integer)index);
            InteractionEventDispatcher.getDefault().fireProgammableSelectionEvent((IStructuredSelection)new StructuredSelection((Object)specTcToInsert));
            TestCaseBP.handleFirstReference((EditSupport)this.m_editor.getEditorHelper().getEditSupport(), (ISpecTestCasePO)this.m_choosePage.getChoosenTestCase(), (boolean)false);
            eh.getEditSupport().lockWorkVersion();
            eh.setDirty(true);
            this.m_editor.setSelection((ISelection)new StructuredSelection((Object)replacementTCReference));
        }
        catch (PMException e) {
            NodeEditorInput inp = (NodeEditorInput)this.m_editor.getAdapter(NodeEditorInput.class);
            INodePO inpNode = inp.getNode();
            PMExceptionHandler.handlePMExceptionForMasterSession(e);
            try {
                this.m_editor.reOpenEditor((IPersistentObject)inpNode);
            }
            catch (PMException e1) {
                PMExceptionHandler.handlePMExceptionForEditor(e1, this.m_editor);
            }
        }
        DeleteTreeItemHandlerTCEditor.deleteNodesFromEditor(this.m_listOfExecsToReplace, this.m_editor);
        return true;
    }
}

