/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.wizards.search.refactor;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.wizards.refactor.pages.ChooseTestCasePage;
import org.eclipse.jubula.client.ui.rcp.wizards.search.refactor.ReplaceTestCaseTransaction;
import org.eclipse.jubula.client.ui.rcp.wizards.search.refactor.pages.ComponentNameMappingWizardPage;
import org.eclipse.jubula.client.ui.rcp.wizards.search.refactor.pages.FillParameterValuesWizardPage;
import org.eclipse.jubula.client.ui.rcp.wizards.search.refactor.pages.ParameterNamesMatchingWizardPage;
import org.eclipse.jubula.client.ui.rcp.wizards.search.refactor.pages.ReplaceExecTestCaseData;
import org.eclipse.ui.PlatformUI;

public class SearchReplaceTCRWizard
extends Wizard {
    private static final String CHOOSE_PAGE_ID = "ReplaceTCRWizard.ChoosePageId";
    private static final String COMPONENT_MAPPING_PAGE_ID = "ReplaceTCRWizard.ComponentMappingPageId";
    private static final String PARAMETER_MATCHING_PAGE_ID = "ReplaceTCRWizard.ParameterMatchingPageId";
    private static final String PARAMETER_FILLING_PAGE_ID = "ReplaceTCRWizard.ParameterFillingPageId";
    private final ReplaceExecTestCaseData m_replaceExecTestCaseData;
    private Map<String, String> m_matchedCompNameGuidMap;
    private ChooseTestCasePage m_choosePage;
    private ComponentNameMappingWizardPage m_componentNamesPage;

    public SearchReplaceTCRWizard(Set<IExecTestCasePO> execsToReplace) {
        this.m_replaceExecTestCaseData = new ReplaceExecTestCaseData(execsToReplace);
        this.setWindowTitle(Messages.ReplaceTCRWizardTitle);
    }

    public boolean performFinish() {
        this.m_matchedCompNameGuidMap = this.m_componentNamesPage.getCompMatching();
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, false, (IRunnableWithProgress)new ReplaceTestCaseTransaction(this.m_replaceExecTestCaseData, this.m_matchedCompNameGuidMap));
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
        return true;
    }

    public void addPages() {
        super.addPages();
        HashSet<INodePO> specSet = new HashSet<INodePO>();
        for (IExecTestCasePO exec : this.m_replaceExecTestCaseData.getOldExecTestCases()) {
            if (!ISpecTestCasePO.class.isAssignableFrom(exec.getParentNode().getClass())) continue;
            specSet.add(exec.getParentNode());
        }
        this.m_choosePage = new ChooseTestCasePage(specSet, CHOOSE_PAGE_ID);
        this.m_choosePage.setDescription(Messages.ReplaceTCRWizard_choosePage_multi_description);
        this.m_choosePage.setContextHelpId("org.eclipse.jubula.client.ua.help.searchRefactorReplaceExecutionTestCaseWizardContextId");
        this.m_componentNamesPage = new ComponentNameMappingWizardPage(COMPONENT_MAPPING_PAGE_ID, this.m_replaceExecTestCaseData.getOldExecTestCases());
        this.m_componentNamesPage.setDescription(Messages.ReplaceTCRWizard_matchComponentNames_multi_description);
        this.addPage((IWizardPage)this.m_choosePage);
        this.addPage((IWizardPage)this.m_componentNamesPage);
        this.addPage((IWizardPage)new ParameterNamesMatchingWizardPage(PARAMETER_MATCHING_PAGE_ID, this.m_replaceExecTestCaseData));
        this.addPage((IWizardPage)new FillParameterValuesWizardPage(PARAMETER_FILLING_PAGE_ID, this.m_replaceExecTestCaseData));
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page instanceof ChooseTestCasePage) {
            this.m_replaceExecTestCaseData.setNewSpecTestCase(this.m_choosePage.getChoosenTestCase());
            this.m_componentNamesPage.setNewSpec(this.m_replaceExecTestCaseData.getNewSpecTestCase());
        }
        IWizardPage nextPage = super.getNextPage(page);
        return nextPage;
    }
}

