/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.misc.layouting;

import org.eclipse.jwt.meta.model.core.GraphicalElement;
import org.eclipse.jwt.meta.model.processes.FinalNode;
import org.eclipse.jwt.meta.model.processes.InitialNode;
import org.eclipse.jwt.we.editors.WEEditor;
import org.eclipse.jwt.we.misc.views.LayoutDataManager;
import org.eclipse.zest.layouts.LayoutEntity;
import org.eclipse.zest.layouts.constraints.BasicEntityConstraint;
import org.eclipse.zest.layouts.constraints.LayoutConstraint;

public class GraphicalElementEntity
implements LayoutEntity,
Comparable {
    private WEEditor weeditor;
    private GraphicalElement graphicalElement;
    private Object internalNode;

    public GraphicalElementEntity(WEEditor weeditor) {
        this.weeditor = weeditor;
    }

    public GraphicalElement getGraphicalElement() {
        return this.graphicalElement;
    }

    public void setGraphicalElement(GraphicalElement graphicalElement) {
        this.graphicalElement = graphicalElement;
    }

    public double getHeightInLayout() {
        double height = LayoutDataManager.getHeight(this.weeditor, this.graphicalElement);
        height = height == 10.0 ? 30.0 : height;
        return height;
    }

    public double getWidthInLayout() {
        double width = LayoutDataManager.getWidth(this.weeditor, this.graphicalElement);
        width = width == 10.0 ? 50.0 : width;
        return width;
    }

    public double getXInLayout() {
        return LayoutDataManager.getX(this.weeditor, this.graphicalElement);
    }

    public double getYInLayout() {
        return LayoutDataManager.getY(this.weeditor, this.graphicalElement);
    }

    public void populateLayoutConstraint(LayoutConstraint constraint) {
        ((BasicEntityConstraint)constraint).hasPreferredSize = true;
        ((BasicEntityConstraint)constraint).preferredWidth = this.getWidthInLayout();
        ((BasicEntityConstraint)constraint).preferredHeight = this.getHeightInLayout();
        if (this.graphicalElement instanceof InitialNode) {
            ((BasicEntityConstraint)constraint).hasPreferredLocation = true;
            ((BasicEntityConstraint)constraint).preferredX = 10.0;
            ((BasicEntityConstraint)constraint).preferredY = 10.0;
        }
    }

    public void setLocationInLayout(double x, double y) {
        LayoutDataManager.setX(this.weeditor, this.graphicalElement, (int)Math.round(x));
        LayoutDataManager.setY(this.weeditor, this.graphicalElement, (int)Math.round(y));
    }

    public void setSizeInLayout(double width, double height) {
    }

    public int compareTo(Object o) {
        if (o instanceof InitialNode) {
            return -1;
        }
        if (o instanceof FinalNode) {
            return 1;
        }
        return 0;
    }

    public Object getLayoutInformation() {
        return this.internalNode;
    }

    public void setLayoutInformation(Object internalEntity) {
        this.internalNode = internalEntity;
    }

    public Object getGraphData() {
        return null;
    }

    public void setGraphData(Object o) {
    }
}

