/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.layout;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.util.Proxy;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.draw2d.ui.figures.IBorderItemLocator;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.Bendpoints;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.RoutingStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.business.api.refresh.DiagramCreationUtil;
import org.eclipse.sirius.diagram.ui.business.api.query.ViewQuery;
import org.eclipse.sirius.diagram.ui.business.internal.query.DNodeQuery;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.BorderItemLocatorProvider;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.IStyleConfigurationRegistry;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.StyleConfiguration;
import org.eclipse.sirius.diagram.ui.tools.api.part.DiagramEditPartService;
import org.eclipse.sirius.diagram.ui.tools.internal.layout.LayoutUtil;
import org.eclipse.sirius.tools.internal.SiriusCopierHelper;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public final class LayoutUtils {
    public static final int SCALE = 10;
    public static final Dimension DEFAULT_CONTAINER_DIMENSION = new Dimension(150, 70);
    public static final Dimension NEW_DEFAULT_CONTAINER_DIMENSION = new Dimension(40, 40);
    public static final int COLLAPSED_VERTICAL_REGION_HEIGHT = 28;
    public static final int DEFAULT_WIDTH = 10;
    private static final int TOP_MARGIN = 50;
    private static final int LEFT_MARGIN = 50;
    private static Map<IFigure, List<IFigure>> dummys = new HashMap<IFigure, List<IFigure>>();
    private static Map<IFigure, Integer> dummysStack = new HashMap<IFigure, Integer>();

    private LayoutUtils() {
    }

    public static Rectangle getValidLocation(DDiagramElement borderView, Point proposedLocation, Dimension proposedDimension, DDiagramElement owner, IFigure borderItemContainer, IFigure mainFigure) {
        Dimension defaultDimension;
        if (mainFigure.getBounds().getSize().height == 0 && mainFigure.getBounds().getSize().width == 0 && owner instanceof DNode) {
            defaultDimension = new DNodeQuery((DNode)owner).getDefaultDimension();
            mainFigure.getBounds().height = defaultDimension.height;
            mainFigure.getBounds().width = defaultDimension.width;
        } else if (mainFigure.getBounds().getSize().height == 0 && mainFigure.getBounds().getSize().width == 0 && owner instanceof DDiagramElementContainer) {
            defaultDimension = DEFAULT_CONTAINER_DIMENSION;
            mainFigure.getBounds().height = defaultDimension.height;
            mainFigure.getBounds().width = defaultDimension.width;
        }
        StyleConfiguration styleConfiguration = IStyleConfigurationRegistry.INSTANCE.getStyleConfiguration(owner.getDiagramElementMapping(), owner.getStyle());
        BorderItemLocatorProvider locatorProvider = styleConfiguration.getBorderItemLocatorProvider();
        Figure dummyFigure = new Figure();
        IBorderItemLocator locator = locatorProvider.getBorderItemLocator(mainFigure, owner, borderView);
        Rectangle constraint = new Rectangle(proposedLocation, proposedDimension);
        locator.setConstraint(constraint);
        dummyFigure.setVisible(true);
        borderItemContainer.add((IFigure)dummyFigure);
        Rectangle rect = new Rectangle(constraint);
        rect.translate(mainFigure.getBounds().getLocation().x, mainFigure.getBounds().getLocation().y);
        mainFigure.translateToAbsolute((Translatable)rect);
        dummyFigure.setBounds(rect);
        Rectangle realLocation = locator.getValidLocation(rect, (IFigure)dummyFigure);
        Point parentOrigin = mainFigure.getBounds().getTopLeft();
        Dimension d = realLocation.getTopLeft().getDifference(parentOrigin);
        Point location = new Point(d.width, d.height);
        realLocation.setLocation(location);
        List<IFigure> dummysList = dummys.get(borderItemContainer);
        if (dummysList != null) {
            dummysList.add((IFigure)dummyFigure);
        }
        locator.relocate((IFigure)dummyFigure);
        realLocation.setLocation(dummyFigure.getBounds().getLocation());
        realLocation.setSize(proposedDimension);
        return new Rectangle(realLocation).getTranslated(-parentOrigin.x, -parentOrigin.y);
    }

    public static void prepareFigureForDummyAdds(IFigure figure) {
        if (!dummys.containsKey(figure)) {
            dummys.put(figure, new LinkedList());
        } else {
            Integer currentValue = dummysStack.get(figure);
            if (currentValue == null) {
                currentValue = 0;
            }
            currentValue = currentValue + 1;
            dummysStack.put(figure, currentValue);
        }
    }

    public static void releaseDummys(IFigure figure) {
        if (dummysStack.containsKey(figure)) {
            Integer currentValue = dummysStack.get(figure);
            if ((currentValue = Integer.valueOf(currentValue - 1)) == 0) {
                dummysStack.remove(figure);
            } else {
                dummysStack.put(figure, currentValue);
            }
        } else {
            List<IFigure> dummysChildren = dummys.get(figure);
            if (dummysChildren == null) {
                dummysChildren = Collections.emptyList();
            }
            for (IFigure next : dummysChildren) {
                figure.remove(next);
            }
            dummys.remove(figure);
        }
    }

    public static Dimension getDefaultDimension(CreateViewRequest.ViewDescriptor viewDescriptor) {
        Object element;
        Dimension result = new Dimension(-1, -1);
        IAdaptable adapt = viewDescriptor.getElementAdapter();
        if (adapt instanceof Proxy && (element = ((Proxy)adapt).getRealObject()) instanceof DNode) {
            result = new DNodeQuery((DNode)element).getDefaultDimension();
        }
        return result;
    }

    public static void initializeDiagramLayout(Diagram source, DRepresentation target) {
        DialectManager.INSTANCE.refresh(target, (IProgressMonitor)new NullProgressMonitor());
        final Shell shell = new Shell();
        DiagramEditPart diagramEditPart = LayoutUtils.createDiagramEditPart(target, shell);
        Diagram gmfTarget = diagramEditPart == null ? null : diagramEditPart.getDiagramView();
        if (diagramEditPart != null) {
            diagramEditPart.deactivate();
        }
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                shell.dispose();
            }
        });
        HashMap<EObject, List<View>> realSemanticToView = new HashMap<EObject, List<View>>();
        if (gmfTarget != null) {
            LinkedList<View> sourceCandidates = new LinkedList<View>();
            LayoutUtils.computeSourceCandidates((View)source, sourceCandidates);
            sourceCandidates.addAll((Collection<View>)source.getEdges());
            LayoutUtils.initializeBounds(source, (View)gmfTarget, realSemanticToView, sourceCandidates);
            for (Edge edge : gmfTarget.getEdges()) {
                LayoutUtils.initializeBounds(source, (View)edge, realSemanticToView, sourceCandidates);
            }
            LayoutUtils.optimizeLayout((View)gmfTarget);
            LayoutUtils.moveToUpperLeftCorner((View)gmfTarget);
        }
    }

    private static void moveToUpperLeftCorner(View gmfTarget) {
        Dimension minDistanceToUpperLeftCorner = new Dimension(-1, -1);
        for (View view : gmfTarget.getChildren()) {
            Node node;
            if (!(view instanceof Node) || !((node = (Node)view).getLayoutConstraint() instanceof Location)) continue;
            Location location = (Location)node.getLayoutConstraint();
            minDistanceToUpperLeftCorner.width = minDistanceToUpperLeftCorner.width < 0 || location.getX() < minDistanceToUpperLeftCorner.width ? location.getX() : minDistanceToUpperLeftCorner.width;
            int n = minDistanceToUpperLeftCorner.height = minDistanceToUpperLeftCorner.height < 0 || location.getY() < minDistanceToUpperLeftCorner.height ? location.getY() : minDistanceToUpperLeftCorner.height;
        }
        Dimension delta = new Dimension(0, 0);
        if (minDistanceToUpperLeftCorner.width > 50) {
            delta.width = minDistanceToUpperLeftCorner.width - 50;
        }
        if (minDistanceToUpperLeftCorner.height > 50) {
            delta.height = minDistanceToUpperLeftCorner.height - 50;
        }
        if (delta.height > 0 || delta.width > 0) {
            for (View view : gmfTarget.getChildren()) {
                Node node;
                if (!(view instanceof Node) || !((node = (Node)view).getLayoutConstraint() instanceof Location)) continue;
                Location location = (Location)node.getLayoutConstraint();
                location.setX(location.getX() - delta.width);
                location.setY(location.getY() - delta.height);
            }
        }
    }

    private static void computeSourceCandidates(View source, List<View> candidates) {
        EObject gmfPOVSemanticElement = ViewUtil.resolveSemanticElement((View)source);
        if (gmfPOVSemanticElement instanceof DSemanticDecorator && gmfPOVSemanticElement instanceof DDiagramElement) {
            candidates.add(source);
        }
        for (View child : source.getChildren()) {
            LayoutUtils.computeSourceCandidates(child, candidates);
        }
    }

    private static void initializeBounds(Diagram source, View target, Map<EObject, List<View>> realSemanticToView, List<View> sourceCandidates) {
        View sourceView;
        EObject gmfPOVSemanticElement = ViewUtil.resolveSemanticElement((View)target);
        if (gmfPOVSemanticElement instanceof DDiagramElement && gmfPOVSemanticElement instanceof DSemanticDecorator && (sourceView = LayoutUtils.findSourceView(target, realSemanticToView, sourceCandidates)) != null) {
            LayoutUtils.copyConstraints(sourceView, target);
        }
        for (View child : target.getChildren()) {
            LayoutUtils.initializeBounds(source, child, realSemanticToView, sourceCandidates);
        }
    }

    public static void copyConstraints(View sourceView, View targetView) {
        if (sourceView instanceof Node && targetView instanceof Node) {
            Node nodeSource = (Node)sourceView;
            Node nodeTarget = (Node)targetView;
            LayoutConstraint sourceConstraint = nodeSource.getLayoutConstraint();
            if (sourceConstraint != null) {
                nodeTarget.setLayoutConstraint((LayoutConstraint)SiriusCopierHelper.copyWithNoUidDuplication((EObject)sourceConstraint));
            }
        } else if (sourceView instanceof Edge && targetView instanceof Edge) {
            RoutingStyle rstyle;
            Edge edgeSource = (Edge)sourceView;
            Edge edgeTarget = (Edge)targetView;
            if (edgeSource.getBendpoints() != null) {
                edgeTarget.setBendpoints((Bendpoints)SiriusCopierHelper.copyWithNoUidDuplication((EObject)edgeSource.getBendpoints()));
            }
            if (edgeSource.getSourceAnchor() != null) {
                edgeTarget.setSourceAnchor((Anchor)SiriusCopierHelper.copyWithNoUidDuplication((EObject)edgeSource.getSourceAnchor()));
            }
            if (edgeSource.getTargetAnchor() != null) {
                edgeTarget.setTargetAnchor((Anchor)SiriusCopierHelper.copyWithNoUidDuplication((EObject)edgeSource.getTargetAnchor()));
            }
            if ((rstyle = (RoutingStyle)edgeSource.getStyle(NotationPackage.eINSTANCE.getRoutingStyle())) != null) {
                edgeTarget.getStyles().add((Object)SiriusCopierHelper.copyWithNoUidDuplication((EObject)rstyle));
            }
        }
    }

    private static View findSourceView(View target, Map<EObject, List<View>> realSemanticToView, List<View> sourceCandidates) {
        View result = null;
        EObject gmfPOVSemanticElement = ViewUtil.resolveSemanticElement((View)target);
        if (gmfPOVSemanticElement instanceof DDiagramElement && gmfPOVSemanticElement instanceof DSemanticDecorator) {
            EObject targetRealSemanticElement = ((DSemanticDecorator)gmfPOVSemanticElement).getTarget();
            List<View> views = realSemanticToView.get(targetRealSemanticElement);
            if (views == null) {
                views = new ArrayList<View>(1);
            }
            for (View sourceView : views) {
                if (!LayoutUtils.areSimilars(sourceView, target)) continue;
                result = sourceView;
                break;
            }
            if (result == null) {
                for (View candidate : sourceCandidates) {
                    if (!LayoutUtils.areSimilars(candidate, target)) continue;
                    result = candidate;
                    break;
                }
                if (result != null) {
                    sourceCandidates.remove(result);
                    views.add(result);
                    realSemanticToView.put(targetRealSemanticElement, views);
                }
            }
        }
        return result;
    }

    private static DiagramEditPart createDiagramEditPart(DRepresentation designerDiagram, Shell shell) {
        if (designerDiagram instanceof DSemanticDiagram) {
            Diagram gmfDiag;
            DSemanticDiagram diag = (DSemanticDiagram)designerDiagram;
            DiagramCreationUtil util = new DiagramCreationUtil((DDiagram)diag);
            if (!util.findAssociatedGMFDiagram()) {
                util.createNewGMFDiagram();
                SessionManager.INSTANCE.getSession(diag.getTarget()).getServices().putCustomData("GMF_DIAGRAMS", (EObject)diag, (EObject)util.getAssociatedGMFDiagram());
            }
            if ((gmfDiag = util.getAssociatedGMFDiagram()) != null) {
                DiagramEditPartService tool = new DiagramEditPartService();
                DiagramEditPart diagramEditPart = tool.createDiagramEditPart(gmfDiag, shell, new PreferencesHint("DView"));
                diagramEditPart.refresh();
                LayoutUtil.arrange(diagramEditPart);
                return diagramEditPart;
            }
        }
        return null;
    }

    private static boolean areSimilars(View source, View target) {
        boolean result = false;
        if (source != null && target != null && source.eClass() == target.eClass()) {
            EObject representationSource = ViewUtil.resolveSemanticElement((View)source);
            EObject representationTarget = ViewUtil.resolveSemanticElement((View)target);
            if (representationSource != null && representationTarget != null && representationSource.eClass() == representationTarget.eClass() && representationSource instanceof DSemanticDecorator && representationTarget instanceof DSemanticDecorator) {
                EObject semSource = ((DSemanticDecorator)representationSource).getTarget();
                EObject semTarget = ((DSemanticDecorator)representationTarget).getTarget();
                if (semSource != null && semSource == semTarget) {
                    boolean sourceIsLabel = false;
                    boolean targetIsLabel = false;
                    try {
                        sourceIsLabel = new ViewQuery(source).isForNameEditPart();
                    }
                    catch (NumberFormatException numberFormatException) {}
                    try {
                        targetIsLabel = new ViewQuery(target).isForNameEditPart();
                    }
                    catch (NumberFormatException numberFormatException) {}
                    result = sourceIsLabel == targetIsLabel;
                }
            }
        }
        return result;
    }

    private static void optimizeLayout(View view) {
        for (Object object : view.getChildren()) {
            if (!(object instanceof View)) continue;
            LayoutUtils.optimizeLayout((View)object);
        }
        EObject gmfPOVSemanticElement = ViewUtil.resolveSemanticElement((View)view);
        if (gmfPOVSemanticElement instanceof DNodeContainer) {
            LayoutUtils.optimizeContainerLayout(view);
        }
    }

    private static void optimizeContainerLayout(View view) {
        Bounds containerBounds = view instanceof Node && ((Node)view).getLayoutConstraint() instanceof Bounds ? (Bounds)((Node)view).getLayoutConstraint() : null;
        if (containerBounds != null) {
            View containerView;
            int width;
            View child;
            Dimension minSize = new Dimension(-1, -1);
            View compartment = null;
            for (Object object : view.getChildren()) {
                if (!(object instanceof View)) continue;
                child = (View)object;
                try {
                    int id = Integer.parseInt(child.getType());
                    if (id != 7002 && id != 7001) continue;
                    compartment = child;
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (compartment != null) {
                LayoutUtils.moveToUpperLeftCorner(compartment);
                for (Object object : compartment.getChildren()) {
                    if (!(object instanceof Node) || !((child = (Node)object).getLayoutConstraint() instanceof Bounds)) continue;
                    Bounds bounds = (Bounds)child.getLayoutConstraint();
                    int height = bounds.getY() + bounds.getHeight() + 50;
                    int width2 = bounds.getWidth() + bounds.getX() + 50;
                    minSize.width = minSize.width < 0 || width2 > minSize.width ? width2 : minSize.width;
                    int n = minSize.height = minSize.height < 0 || height > minSize.height ? height : minSize.height;
                }
            }
            Dimension delta = new Dimension(0, 0);
            int height = containerBounds.getHeight();
            if (height != -1 && minSize.height > height) {
                delta.height = minSize.height - height;
                containerBounds.setHeight(minSize.height);
            }
            if ((width = containerBounds.getWidth()) != -1 && minSize.width > width) {
                delta.width = minSize.width - width;
                containerBounds.setWidth(minSize.width);
            }
            if ((delta.width > 0 || delta.height > 0) && (containerView = ViewUtil.getContainerView((View)view)) != null) {
                for (Object object : containerView.getChildren()) {
                    if (!(object instanceof Node)) continue;
                    Node child2 = (Node)object;
                    LayoutUtils.moveChild(containerBounds, delta, child2);
                }
            }
        }
    }

    private static void moveChild(Bounds containerBounds, Dimension delta, Node child) {
        if (child.getLayoutConstraint() instanceof Location) {
            Location location = (Location)child.getLayoutConstraint();
            if (location.getX() > containerBounds.getX() && delta.width > 0) {
                location.setX(location.getX() + delta.width);
            }
            if (location.getY() > containerBounds.getY() && delta.height > 0) {
                location.setY(location.getY() + delta.height);
            }
        }
    }
}

