/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.session.danalysis;

import com.google.common.base.Preconditions;
import java.text.MessageFormat;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.internal.session.danalysis.DAnalysisSessionImpl;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.Messages;

public class AnalysisResourceReloadedCommand
extends RecordingCommand {
    private DAnalysisSessionImpl session;
    private Resource resource;
    private DAnalysis oldAnalysis;

    public AnalysisResourceReloadedCommand(DAnalysisSessionImpl session, TransactionalEditingDomain domain, Resource analysisResource) {
        super(domain, MessageFormat.format(Messages.AnalysisResourceReloadedCommand_label, analysisResource.getURI()));
        this.session = (DAnalysisSessionImpl)Preconditions.checkNotNull((Object)session);
        this.resource = analysisResource;
        EList contents = analysisResource.getContents();
        this.oldAnalysis = contents.isEmpty() ? null : (DAnalysis)contents.get(0);
    }

    public boolean canUndo() {
        return false;
    }

    public boolean canRedo() {
        return false;
    }

    protected void doExecute() {
        this.removeOldAnalysis();
        this.addNewAnalysis();
        this.session = null;
        this.resource = null;
        this.oldAnalysis = null;
    }

    private void removeOldAnalysis() {
        if (this.oldAnalysis != null) {
            this.session.getAnalyses().remove((Object)this.oldAnalysis);
            this.session.removeAdaptersOnAnalysis(this.oldAnalysis);
        }
    }

    private void addNewAnalysis() {
        DAnalysis analysis = (DAnalysis)this.resource.getContents().get(0);
        if (analysis != null) {
            this.session.getAnalyses().add((Object)analysis);
            this.session.addAdaptersOnAnalysis(analysis);
        }
    }
}

