/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.checkers;

import org.eclipse.cdt.codan.core.cxx.model.AbstractIndexAstChecker;
import org.eclipse.cdt.codan.core.model.IProblemWorkingCopy;
import org.eclipse.cdt.codan.internal.checkers.CheckersMessages;
import org.eclipse.cdt.core.dom.ast.ASTNodeProperty;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.core.resources.IResource;

public class SuggestedParenthesisChecker
extends AbstractIndexAstChecker {
    public static final String ER_ID = "org.eclipse.cdt.codan.internal.checkers.SuggestedParenthesisProblem";
    public static final String PARAM_NOT = "paramNot";

    public void processAst(IASTTranslationUnit ast) {
        ast.accept((ASTVisitor)new ExpressionVisitor());
    }

    private int getPrecedence(IASTExpression e) {
        int operator;
        IASTBinaryExpression binExpr;
        if (e instanceof IASTBinaryExpression) {
            binExpr = (IASTBinaryExpression)e;
            operator = binExpr.getOperator();
            if (operator == 12) {
                return 8;
            }
            if (operator == 13) {
                return 9;
            }
            if (operator == 14) {
                return 10;
            }
            if (operator == 15) {
                return 11;
            }
            if (operator == 16) {
                return 12;
            }
        }
        if (e instanceof IASTUnaryExpression) {
            binExpr = (IASTUnaryExpression)e;
            operator = binExpr.getOperator();
            if (operator == 7) {
                return 2;
            }
            if (operator == 6) {
                return 2;
            }
        }
        return -1;
    }

    private boolean isInParentesis(IASTExpression node) {
        IASTUnaryExpression br;
        IASTNode parent = node.getParent();
        return parent instanceof IASTUnaryExpression && (br = (IASTUnaryExpression)parent).getOperator() == 11;
    }

    public boolean isParamNot() {
        return (Boolean)this.getPreference(this.getProblemById(ER_ID, (IResource)this.getFile()), PARAM_NOT);
    }

    public void initPreferences(IProblemWorkingCopy problem) {
        super.initPreferences(problem);
        this.addPreference(problem, PARAM_NOT, CheckersMessages.SuggestedParenthesisChecker_SuggestParanthesesAroundNot, Boolean.FALSE);
    }

    class ExpressionVisitor
    extends ASTVisitor {
        ExpressionVisitor() {
            this.shouldVisitExpressions = true;
        }

        public int visit(IASTExpression expression) {
            int precedence = SuggestedParenthesisChecker.this.getPrecedence(expression);
            IASTNode parent = expression.getParent();
            if (parent instanceof IASTExpression) {
                IASTExpression parentExpr = (IASTExpression)parent;
                if (SuggestedParenthesisChecker.this.isInParentesis(expression)) {
                    return 3;
                }
                if (precedence == 2) {
                    if (SuggestedParenthesisChecker.this.isParamNot() && this.isUsedAsOperand(expression)) {
                        SuggestedParenthesisChecker.this.reportProblem(SuggestedParenthesisChecker.ER_ID, (IASTNode)expression, new Object[]{expression.getRawSignature()});
                        return 1;
                    }
                } else if (precedence >= 0) {
                    int pp = SuggestedParenthesisChecker.this.getPrecedence(parentExpr);
                    if (pp == -1 || pp == precedence) {
                        return 3;
                    }
                    SuggestedParenthesisChecker.this.reportProblem(SuggestedParenthesisChecker.ER_ID, (IASTNode)expression, new Object[]{expression.getRawSignature()});
                }
            }
            return 3;
        }

        private boolean isUsedAsOperand(IASTExpression expression) {
            ASTNodeProperty prop = expression.getPropertyInParent();
            return prop == IASTBinaryExpression.OPERAND_ONE || prop == IASTUnaryExpression.OPERAND;
        }
    }
}

