/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTCompletionContext;
import org.eclipse.cdt.core.dom.ast.IASTCompletionNode;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.qt.core.QtNature;
import org.eclipse.cdt.internal.qt.ui.Activator;
import org.eclipse.cdt.internal.qt.ui.QObjectConnectCompletion;
import org.eclipse.cdt.internal.qt.ui.QObjectDeclarationCompletion;
import org.eclipse.cdt.internal.qt.ui.QPropertyCompletion;
import org.eclipse.cdt.internal.ui.text.contentassist.CContentAssistInvocationContext;
import org.eclipse.cdt.internal.ui.text.contentassist.ParsingBasedProposalComputer;
import org.eclipse.cdt.ui.text.contentassist.ContentAssistInvocationContext;
import org.eclipse.cdt.ui.text.contentassist.ICEditorContentAssistInvocationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

public class QtCompletionProposalComputer
extends ParsingBasedProposalComputer {
    public List<ICompletionProposal> computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        try {
            if (context instanceof CContentAssistInvocationContext) {
                CContentAssistInvocationContext cContext = (CContentAssistInvocationContext)context;
                String prefix = null;
                IASTCompletionNode completionNode = cContext.getCompletionNode();
                if (completionNode != null) {
                    prefix = completionNode.getPrefix();
                }
                if (prefix == null) {
                    prefix = cContext.computeIdentifierPrefix().toString();
                }
                return this.computeCompletionProposals(cContext, completionNode, prefix);
            }
        }
        catch (Exception e) {
            Activator.log(e);
        }
        return Collections.emptyList();
    }

    private boolean isApplicable(ICEditorContentAssistInvocationContext context) {
        ITranslationUnit tu = context.getTranslationUnit();
        if (tu == null) {
            return false;
        }
        ICProject cProject = tu.getCProject();
        if (cProject == null) {
            return false;
        }
        IProject project = cProject.getProject();
        if (project == null) {
            return false;
        }
        return QtNature.hasNature((IProject)project);
    }

    protected List<ICompletionProposal> computeCompletionProposals(CContentAssistInvocationContext context, IASTCompletionNode completionNode, String prefix) throws CoreException {
        if (!this.isApplicable((ICEditorContentAssistInvocationContext)context)) {
            return Collections.emptyList();
        }
        List<ICompletionProposal> proposals = null;
        if (completionNode != null) {
            IASTName[] names;
            IASTName[] iASTNameArray = names = completionNode.getNames();
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                IASTCompletionContext astContext;
                IASTName name = iASTNameArray[n2];
                if (name.getTranslationUnit() != null && (astContext = name.getCompletionContext()) != null && astContext instanceof IASTNode) {
                    IASTNode astNode = (IASTNode)astContext;
                    proposals = QtCompletionProposalComputer.addAll(proposals, QObjectConnectCompletion.getProposals((ICEditorContentAssistInvocationContext)context, name, astContext, astNode));
                    proposals = QtCompletionProposalComputer.addAll(proposals, QObjectDeclarationCompletion.getProposals((ICEditorContentAssistInvocationContext)context, name));
                    proposals = QtCompletionProposalComputer.addAll(proposals, QPropertyCompletion.getProposals((ICEditorContentAssistInvocationContext)context, name, astContext, astNode));
                }
                ++n2;
            }
        }
        return (proposals = QtCompletionProposalComputer.addAll(proposals, QPropertyCompletion.getAttributeProposals((ICEditorContentAssistInvocationContext)context))) == null ? Collections.emptyList() : proposals;
    }

    private static <T> List<T> addAll(List<T> list, Collection<T> toAdd) {
        if (toAdd == null || toAdd.isEmpty()) {
            return list;
        }
        if (list == null) {
            return new ArrayList<T>(toAdd);
        }
        list.addAll(toAdd);
        return list;
    }
}

