/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal;

import java.util.List;
import org.eclipse.cft.server.core.AbstractCloudFoundryUrl;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.CloudServerEvent;
import org.eclipse.cft.server.core.internal.CloudServerListener;
import org.eclipse.cft.server.core.internal.CloudServerUtil;
import org.eclipse.cft.server.core.internal.ServerEventHandler;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.spaces.CloudFoundrySpace;
import org.eclipse.cft.server.ui.internal.CloudFoundryServerUiPlugin;
import org.eclipse.cft.server.ui.internal.CloudServerUIUtil;
import org.eclipse.cft.server.ui.internal.ModuleDeploymentDecoration;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.ui.internal.view.servers.ModuleServer;

public class CloudFoundryDecorator
extends LabelProvider
implements ILightweightLabelDecorator {
    private final CloudServerListener listener = new CloudServerListener(){

        public void serverChanged(CloudServerEvent event) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    LabelProviderChangedEvent labelEvent = new LabelProviderChangedEvent((IBaseLabelProvider)CloudFoundryDecorator.this);
                    CloudFoundryDecorator.this.fireLabelProviderChanged(labelEvent);
                }
            });
        }
    };

    public CloudFoundryDecorator() {
        ServerEventHandler.getDefault().addServerListener(this.listener);
    }

    public void decorate(Object element, final IDecoration decoration) {
        CloudFoundryServer cfServer;
        Server server;
        if (element instanceof ModuleServer) {
            IModule[] modules;
            ModuleServer moduleServer = (ModuleServer)element;
            IServer s = moduleServer.getServer();
            if (s != null && CloudServerUtil.isCloudFoundryServer((IServer)s) && (modules = moduleServer.getModule()) != null && modules.length == 1) {
                ModuleDeploymentDecoration<IDecoration> deploymentDecoration = ModuleDeploymentDecoration.getServersViewDecoration();
                CloudFoundryServer server2 = this.getCloudFoundryServer(moduleServer.getServer());
                if (server2 == null || !server2.isConnected()) {
                    return;
                }
                CloudFoundryApplicationModule module = server2.getExistingCloudModule(modules[0]);
                if (module == null) {
                    return;
                }
                deploymentDecoration.decorateText(decoration, module);
                ImageDescriptor image = deploymentDecoration.getImageDecoration(module);
                if (image != null) {
                    decoration.addOverlay(image, 2);
                }
            }
        } else if (element instanceof Server && CloudServerUtil.isCloudFoundryServer((IServer)(server = (Server)element)) && (cfServer = this.getCloudFoundryServer((IServer)server)) != null && cfServer.getUsername() != null) {
            List<AbstractCloudFoundryUrl> cloudUrls;
            try {
                cloudUrls = CloudServerUIUtil.getAllUrls(cfServer.getBehaviour().getServer().getServerType().getId(), null, false);
            }
            catch (CoreException e1) {
                CloudFoundryServerUiPlugin.logError(e1);
                return;
            }
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    CloudFoundrySpace clSpace;
                    if (cfServer.hasCloudSpace() && (clSpace = cfServer.getCloudFoundrySpace()) != null) {
                        decoration.addSuffix(NLS.bind((String)" - {0} - {1}", (Object)clSpace.getOrgName(), (Object)clSpace.getSpaceName()));
                    }
                    String url = cfServer.getUrl();
                    for (AbstractCloudFoundryUrl cloudUrl : cloudUrls) {
                        if (!cloudUrl.getUrl().equals(url)) continue;
                        decoration.addSuffix(NLS.bind((String)" - {0}", (Object)cloudUrl.getUrl()));
                        break;
                    }
                }
            });
        }
    }

    public void dispose() {
        super.dispose();
        ServerEventHandler.getDefault().removeServerListener(this.listener);
    }

    private CloudFoundryServer getCloudFoundryServer(IServer server) {
        Object obj = server.getAdapter(CloudFoundryServer.class);
        if (obj instanceof CloudFoundryServer) {
            return (CloudFoundryServer)obj;
        }
        return null;
    }
}

