/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal;

import java.util.ArrayList;
import java.util.List;
import org.cloudfoundry.client.lib.domain.CloudEntity;
import org.cloudfoundry.client.lib.domain.CloudOrganization;
import org.cloudfoundry.client.lib.domain.CloudSpace;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.spaces.CloudSpacesDescriptor;
import org.eclipse.cft.server.ui.internal.CloudFoundryImages;
import org.eclipse.cft.server.ui.internal.CloudSpacesDelegate;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.cft.server.ui.internal.UIPart;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;

public class CloudSpacesSelectionPart
extends UIPart {
    private static final String DEFAULT_DESCRIPTION = Messages.CloudSpacesSelectionPart_TEXT_DEFAULT_DESCRIPTION;
    protected TreeViewer orgsSpacesViewer;
    protected final CloudSpacesDelegate cloudSpaceServerDelegate;

    public CloudSpacesSelectionPart(CloudSpacesDelegate cloudSpaceServerDelegate, CloudFoundryServer cloudServer, WizardPage wizardPage) {
        this.cloudSpaceServerDelegate = cloudSpaceServerDelegate;
        String serverTypeId = cloudServer.getServer().getServerType().getId();
        wizardPage.setTitle(Messages.CloudSpacesSelectionPart_TEXT_ORG_AND_SPACE);
        wizardPage.setDescription(DEFAULT_DESCRIPTION);
        ImageDescriptor banner = CloudFoundryImages.getWizardBanner(serverTypeId);
        if (banner != null) {
            wizardPage.setImageDescriptor(banner);
        }
    }

    public CloudSpacesSelectionPart(CloudSpacesDelegate cloudSpaceServerDelegate, CloudFoundryServer cloudServer, IWizardHandle wizardHandle) {
        this.cloudSpaceServerDelegate = cloudSpaceServerDelegate;
        String serverTypeId = cloudServer.getServer().getServerType().getId();
        wizardHandle.setTitle(Messages.CloudSpacesSelectionPart_TEXT_ORG_AND_SPACE);
        wizardHandle.setDescription(DEFAULT_DESCRIPTION);
        ImageDescriptor banner = CloudFoundryImages.getWizardBanner(serverTypeId);
        if (banner != null) {
            wizardHandle.setImageDescriptor(banner);
        }
    }

    @Override
    public Control createPart(Composite parent) {
        Composite tableArea = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(true).applyTo(tableArea);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tableArea);
        Composite orgTableComposite = new Composite(tableArea, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(orgTableComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)orgTableComposite);
        Label orgLabel = new Label(orgTableComposite, 0);
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)orgLabel);
        orgLabel.setText(Messages.CloudSpacesSelectionPart_TEXT_ORG_AND_SPACE_WITH_COLUMN);
        Tree orgTable = new Tree(orgTableComposite, 2052);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)orgTable);
        this.orgsSpacesViewer = new TreeViewer(orgTable);
        this.orgsSpacesViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.orgsSpacesViewer.setLabelProvider((IBaseLabelProvider)new SpacesLabelProvider());
        this.orgsSpacesViewer.setSorter((ViewerSorter)new SpacesSorter());
        this.orgsSpacesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CloudSpacesSelectionPart.this.refresh();
            }
        });
        return tableArea;
    }

    public void setInput() {
        if (this.cloudSpaceServerDelegate != null && this.orgsSpacesViewer != null && !this.orgsSpacesViewer.getTree().isDisposed()) {
            ArrayList orgInput;
            ArrayList arrayList = orgInput = this.cloudSpaceServerDelegate.getCurrentSpacesDescriptor() != null ? this.cloudSpaceServerDelegate.getCurrentSpacesDescriptor().getOrgsAndSpaces().getOrgs() : null;
            if (orgInput == null) {
                orgInput = new ArrayList();
            }
            Object[] organizationInput = orgInput.toArray(new CloudOrganization[orgInput.size()]);
            this.orgsSpacesViewer.setInput((Object)organizationInput);
            this.orgsSpacesViewer.setExpandedElements(organizationInput);
            this.setInitialSelectionInViewer();
        }
    }

    protected void setInitialSelectionInViewer() {
        if (this.cloudSpaceServerDelegate == null) {
            return;
        }
        CloudSpace selectedSpace = this.cloudSpaceServerDelegate.getCurrentCloudSpace();
        if (selectedSpace != null) {
            this.setSelectionInViewer(selectedSpace);
        }
    }

    protected void setSelectionInViewer(CloudSpace selectedSpace) {
        Tree tree = this.orgsSpacesViewer.getTree();
        TreeItem[] orgItems = tree.getItems();
        if (orgItems != null) {
            TreeItem[] children;
            TreeItem orgItem = null;
            TreeItem[] treeItemArray = orgItems;
            int n = orgItems.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                Object treeObj = item.getData();
                if (treeObj instanceof CloudOrganization && ((CloudOrganization)treeObj).getName().equals(selectedSpace.getOrganization().getName())) {
                    orgItem = item;
                    break;
                }
                ++n2;
            }
            if (orgItem != null && (children = orgItem.getItems()) != null) {
                TreeItem[] treeItemArray2 = children;
                int n3 = children.length;
                n = 0;
                while (n < n3) {
                    TreeItem childItem = treeItemArray2[n];
                    Object treeObj = childItem.getData();
                    if (treeObj instanceof CloudSpace && ((CloudSpace)treeObj).getName().equals(selectedSpace.getName())) {
                        tree.select(childItem);
                        break;
                    }
                    ++n;
                }
            }
        }
    }

    protected void setSpaceSelection(CloudSpace selectedCloudSpace) {
        if (this.cloudSpaceServerDelegate != null) {
            this.cloudSpaceServerDelegate.setSelectedSpace(selectedCloudSpace);
            this.notifyStatusChange(selectedCloudSpace, Status.OK_STATUS, 1003);
        }
    }

    protected void refresh() {
        Tree tree;
        TreeItem[] selectedItems;
        if (this.orgsSpacesViewer != null && (selectedItems = (tree = this.orgsSpacesViewer.getTree()).getSelection()) != null && selectedItems.length > 0) {
            Object selectedObj = selectedItems[0].getData();
            CloudSpace selectedSpace = selectedObj instanceof CloudSpace ? (CloudSpace)selectedObj : null;
            this.setSpaceSelection(selectedSpace);
        }
    }

    static class SpacesLabelProvider
    extends LabelProvider {
        public String getText(Object element) {
            if (element instanceof CloudEntity) {
                CloudEntity cloudEntity = (CloudEntity)element;
                return cloudEntity.getName();
            }
            return super.getText(element);
        }
    }

    static class SpacesSorter
    extends ViewerSorter {
        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof CloudEntity && e2 instanceof CloudEntity) {
                String name1 = ((CloudEntity)e1).getName();
                String name2 = ((CloudEntity)e2).getName();
                return name1.compareTo(name2);
            }
            return super.compare(viewer, e1, e2);
        }
    }

    class TableContentProvider
    implements ITreeContentProvider {
        private Object[] elements;

        public void dispose() {
        }

        public Object[] getChildren(Object parentElement) {
            List spaces;
            CloudSpacesDescriptor spaceDescriptor;
            if (parentElement instanceof CloudOrganization && CloudSpacesSelectionPart.this.cloudSpaceServerDelegate != null && (spaceDescriptor = CloudSpacesSelectionPart.this.cloudSpaceServerDelegate.getCurrentSpacesDescriptor()) != null && (spaces = spaceDescriptor.getOrgsAndSpaces().getOrgSpaces(((CloudOrganization)parentElement).getName())) != null) {
                return spaces.toArray(new CloudSpace[spaces.size()]);
            }
            return null;
        }

        public Object[] getElements(Object inputElement) {
            return this.elements;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput instanceof Object[]) {
                this.elements = (Object[])newInput;
            }
        }
    }
}

