/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal;

import org.cloudfoundry.client.lib.domain.CloudApplication;
import org.eclipse.cft.server.core.internal.application.ApplicationRunState;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.ui.internal.CloudFoundryImages;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;

public abstract class ModuleDeploymentDecoration<T> {
    public void decorateText(T decoration, CloudFoundryApplicationModule module) {
        CloudApplication application;
        CloudApplication cloudApplication = application = module != null ? module.getApplication() : null;
        if (application != null && module != null) {
            String deployedAppName = application.getName();
            IModule localModule = module.getLocalModule();
            if (localModule != null && !localModule.getName().equals(deployedAppName)) {
                this.append(decoration, NLS.bind((String)Messages.CloudFoundryDecorator_SUFFIX_DEPLOYED_AS, (Object)deployedAppName));
            } else {
                this.append(decoration, Messages.CloudFoundryDecorator_SUFFIX_DEPLOYED);
            }
            this.decorateRunState(decoration, module);
        } else {
            this.append(decoration, Messages.CloudFoundryDecorator_SUFFIX_NOT_DEPLOYED);
        }
    }

    public ImageDescriptor getImageDecoration(CloudFoundryApplicationModule module) {
        if (module != null && module.getStatus() != null && !module.getStatus().isOK()) {
            if (module.getStatus().getSeverity() == 4) {
                return CloudFoundryImages.OVERLAY_ERROR;
            }
            if (module.getStatus().getSeverity() == 2) {
                return CloudFoundryImages.OVERLAY_WARNING;
            }
        }
        return null;
    }

    protected abstract void append(T var1, String var2);

    protected void decorateRunState(T decoration, CloudFoundryApplicationModule appModule) {
        if (appModule != null) {
            ApplicationRunState runState = appModule.getRunState();
            this.append(decoration, " [" + runState.getLabel() + "]");
        }
    }

    public static ModuleDeploymentDecoration<IDecoration> getServersViewDecoration() {
        return new ServersViewDecoration();
    }

    public static ModuleDeploymentDecoration<StringBuffer> getModuleTextDecoration() {
        return new ModuleTextDecoration();
    }

    private static class ModuleTextDecoration
    extends ModuleDeploymentDecoration<StringBuffer> {
        private ModuleTextDecoration() {
        }

        @Override
        protected void append(StringBuffer decoration, String message) {
            decoration.append(message);
        }
    }

    private static class ServersViewDecoration
    extends ModuleDeploymentDecoration<IDecoration> {
        private ServersViewDecoration() {
        }

        @Override
        protected void append(IDecoration decoration, String message) {
            decoration.addSuffix(message);
        }

        @Override
        protected void decorateRunState(IDecoration decoration, CloudFoundryApplicationModule appModule) {
        }
    }
}

