/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cft.server.core.CFServiceInstance;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.client.CloudFoundryServerBehaviour;
import org.eclipse.cft.server.core.internal.client.DeploymentInfoWorkingCopy;
import org.eclipse.cft.server.core.internal.client.ICloudFoundryOperation;
import org.eclipse.cft.server.ui.internal.actions.EditorAction;
import org.eclipse.cft.server.ui.internal.editor.CloudFoundryApplicationsEditorPage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;

public abstract class ModifyServicesForApplicationAction
extends EditorAction {
    private CloudFoundryApplicationModule appModule;

    public ModifyServicesForApplicationAction(CloudFoundryApplicationModule appModule, CloudFoundryServerBehaviour serverBehaviour, CloudFoundryApplicationsEditorPage editorPage) {
        super(editorPage, EditorAction.RefreshArea.DETAIL);
        this.appModule = appModule;
    }

    public abstract List<String> getServicesToAdd();

    public abstract List<String> getServicesToRemove();

    protected void setApplicationModule(CloudFoundryApplicationModule appModule) {
        this.appModule = appModule;
    }

    @Override
    protected ICloudFoundryOperation getOperation(IProgressMonitor monitor) throws CoreException {
        List existingServices = null;
        ArrayList<String> updatedServices = new ArrayList<String>();
        DeploymentInfoWorkingCopy workingCopy = this.appModule.resolveDeploymentInfoWorkingCopy(monitor);
        existingServices = workingCopy.asServiceBindingList();
        if (existingServices != null) {
            for (String existingService : existingServices) {
                if (existingService == null) continue;
                updatedServices.add(existingService);
            }
        }
        boolean serviceChanges = false;
        List<String> servicesToAdd = this.getServicesToAdd();
        for (String serviceToAdd : servicesToAdd) {
            if (updatedServices.contains(serviceToAdd)) continue;
            updatedServices.add(serviceToAdd);
            serviceChanges = true;
        }
        if (serviceChanges |= updatedServices.removeAll(this.getServicesToRemove())) {
            return new ModifyServicesForApplicationActionOperation(updatedServices, workingCopy);
        }
        return null;
    }

    public static List<String> getServiceNames(IStructuredSelection selection) {
        Object[] objects = selection.toArray();
        ArrayList<String> services = new ArrayList<String>();
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof CFServiceInstance) {
                services.add(((CFServiceInstance)object).getName());
            }
            ++n2;
        }
        return services;
    }

    public static List<CFServiceInstance> getServices(IStructuredSelection selection) {
        Object[] objects = selection.toArray();
        ArrayList<CFServiceInstance> services = new ArrayList<CFServiceInstance>();
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof CFServiceInstance) {
                services.add((CFServiceInstance)object);
            }
            ++n2;
        }
        return services;
    }

    private class ModifyServicesForApplicationActionOperation
    implements ICloudFoundryOperation {
        final DeploymentInfoWorkingCopy workingCopy;
        final List<String> updatedServices;

        public ModifyServicesForApplicationActionOperation(List<String> updatedServices, DeploymentInfoWorkingCopy workingCopy) {
            this.updatedServices = updatedServices;
            this.workingCopy = workingCopy;
        }

        public void run(IProgressMonitor monitor) throws CoreException {
            ArrayList<CFServiceInstance> boundServices = new ArrayList<CFServiceInstance>();
            for (String serName : this.updatedServices) {
                boundServices.add(new CFServiceInstance(serName));
            }
            if (ModifyServicesForApplicationAction.this.appModule.getApplication() != null) {
                ICloudFoundryOperation bindOp = ModifyServicesForApplicationAction.this.getBehaviour().operations().bindServices(ModifyServicesForApplicationAction.this.appModule, this.updatedServices);
                bindOp.run(monitor);
            }
            this.workingCopy.setServices(boundServices);
            this.workingCopy.save();
        }
    }
}

