/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.wizards;

import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.cft.server.ui.internal.wizards.CloudFoundryServiceWizardPageRightPanel;
import org.eclipse.cft.server.ui.internal.wizards.ServiceInstance;

class CFWizServicePageValidation {
    private static Pattern VALID_CHARS = Pattern.compile("[A-Za-z\\$_0-9\\-]+");
    CloudFoundryServiceWizardPageRightPanel wizardPage;

    public CFWizServicePageValidation(CloudFoundryServiceWizardPageRightPanel right) {
        this.wizardPage = right;
    }

    /*
     * WARNING - void declaration
     */
    public void updatePageState() {
        List<List<ServiceInstance>> list;
        boolean descriptionUpdated = false;
        if (!descriptionUpdated) {
            list = this.wizardPage.getServiceInstances();
            if (list == null || list.size() == 0) {
                this.wizardPage.getParent().setDescription(Messages.CloudFoundryServiceWizardPage_TEXT_SELECT_SERVICE_LIST);
                this.wizardPage.getParent().setErrorMessage(null);
                descriptionUpdated = true;
            } else {
                void var3_4;
                Object var3_3 = null;
                HashMap userDefinedNames = new HashMap();
                for (List<ServiceInstance> l : list) {
                    for (ServiceInstance service : l) {
                        if (userDefinedNames.containsKey(service.getUserDefinedName())) {
                            String string = service.getUserDefinedName();
                            break;
                        }
                        userDefinedNames.put(service.getUserDefinedName(), Boolean.TRUE);
                    }
                    if (var3_4 != null) break;
                }
                if (var3_4 != null) {
                    this.wizardPage.getParent().setDescription(null);
                    this.wizardPage.getParent().setErrorMessage(String.valueOf(Messages.CloudFoundryServiceWizardPageRightPanel_ERROR_DUPE_SERVICE_NAMES_FOUND) + (String)var3_4);
                    descriptionUpdated = true;
                }
            }
        }
        if (!descriptionUpdated && (list = this.wizardPage.getServiceInstances()) != null) {
            for (List list2 : list) {
                for (ServiceInstance service : list2) {
                    String userDefinedName = service.getUserDefinedName();
                    if (service != null && userDefinedName != null) {
                        if (userDefinedName.trim().length() == 0) {
                            this.wizardPage.getParent().setDescription(Messages.CloudFoundryServiceWizardPage_TEXT_SET_SERVICE_NAME);
                            this.wizardPage.getParent().setErrorMessage(null);
                            descriptionUpdated = true;
                        }
                        Matcher matcher = VALID_CHARS.matcher(userDefinedName);
                        if (!descriptionUpdated && !matcher.matches()) {
                            this.wizardPage.getParent().setErrorMessage(Messages.CloudFoundryServiceWizardPage_ERROR_INVALID_CHAR);
                            this.wizardPage.getParent().setDescription(null);
                            descriptionUpdated = true;
                        }
                    }
                    if (descriptionUpdated) break;
                }
                if (descriptionUpdated) break;
            }
        }
        if (!descriptionUpdated) {
            List<String> existingServiceNames = this.wizardPage.getExistingServicesNames();
            List<List<ServiceInstance>> list3 = this.wizardPage.getServiceInstances();
            if (list3 != null) {
                String nameMatched = null;
                for (List<ServiceInstance> l : list3) {
                    for (ServiceInstance service : l) {
                        String userDefinedName = service.getUserDefinedName().toLowerCase();
                        if (existingServiceNames.contains(userDefinedName)) {
                            nameMatched = service.getUserDefinedName();
                        }
                        if (nameMatched != null) break;
                    }
                    if (nameMatched != null) break;
                }
                if (nameMatched != null) {
                    this.wizardPage.getParent().setErrorMessage(String.valueOf(Messages.CloudFoundryServiceWizardPageRightPanel_EXISTING_SERVICE_DUPE) + nameMatched);
                    this.wizardPage.getParent().setDescription(null);
                    descriptionUpdated = true;
                }
            }
        }
        if (!descriptionUpdated) {
            this.wizardPage.getParent().setErrorMessage(null);
            this.wizardPage.getParent().setDescription(Messages.CloudFoundryServiceWizardPage_TEXT_FINISH);
            this.wizardPage.getParent().setPageComplete(true);
        } else {
            this.wizardPage.getParent().setPageComplete(false);
        }
    }
}

