/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.wizards;

import org.eclipse.cft.server.core.ApplicationDeploymentInfo;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.ui.internal.CloudFoundryImages;
import org.eclipse.cft.server.ui.internal.EnvironmentVariablesPart;
import org.eclipse.cft.server.ui.internal.IPartChangeListener;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.cft.server.ui.internal.PartChangeEvent;
import org.eclipse.cft.server.ui.internal.wizards.PartsWizardPage;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class CloudFoundryApplicationEnvVarWizardPage
extends PartsWizardPage {
    protected final CloudFoundryServer cloudServer;
    protected final ApplicationDeploymentInfo deploymentInfo;
    protected EnvironmentVariablesPart envVarPart;

    public CloudFoundryApplicationEnvVarWizardPage(CloudFoundryServer cloudServer, ApplicationDeploymentInfo deploymentInfo) {
        super(Messages.CloudFoundryApplicationEnvVarWizardPage_TEXT_ENV_VAR_WIZ, null, null);
        Assert.isNotNull((Object)deploymentInfo);
        this.cloudServer = cloudServer;
        this.deploymentInfo = deploymentInfo;
    }

    public void createControl(Composite parent) {
        this.setTitle(Messages.COMMONTXT_ENV_VAR);
        this.setDescription(Messages.CloudFoundryApplicationEnvVarWizardPage_TEXT_EDIT_ENV_VAR);
        ImageDescriptor banner = CloudFoundryImages.getWizardBanner(this.cloudServer.getServer().getServerType().getId());
        if (banner != null) {
            this.setImageDescriptor(banner);
        }
        Composite mainArea = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).spacing(new Point(-1, 20)).applyTo(mainArea);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)mainArea);
        this.envVarPart = new EnvironmentVariablesPart(this.deploymentInfo);
        this.addPartChangeListner();
        this.envVarPart.createPart(mainArea);
        if (this.deploymentInfo.getEnvVariables() != null) {
            this.envVarPart.setInput(this.deploymentInfo.getEnvVariables());
        }
        this.setControl((Control)mainArea);
    }

    @Override
    public boolean isPageComplete() {
        return true;
    }

    protected void addPartChangeListner() {
        this.envVarPart.addPartChangeListener(new IPartChangeListener(){

            @Override
            public void handleChange(PartChangeEvent event) {
                CloudFoundryApplicationEnvVarWizardPage.this.deploymentInfo.setEnvVariables(CloudFoundryApplicationEnvVarWizardPage.this.envVarPart.getVariables());
            }
        });
    }
}

