/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.wizards;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cft.server.ui.internal.CloudFoundryImages;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.cft.server.ui.internal.wizards.CFWizServicePageValidation;
import org.eclipse.cft.server.ui.internal.wizards.CloudFoundryServiceWizardPage;
import org.eclipse.cft.server.ui.internal.wizards.ServiceInstance;
import org.eclipse.cft.server.ui.internal.wizards.ServiceListRightCompositeLayout;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CloudFoundryServiceWizardPageRightPanel {
    private List<List<ServiceInstance>> serviceInstances = new ArrayList<List<ServiceInstance>>();
    private Group group;
    private Composite layoutList;
    private ScrolledComposite scrollComp;
    private Image removeImage;
    private CFWizServicePageValidation validation;
    private List<String> existingServicesNames = null;
    private Font boldFont;
    CloudFoundryServiceWizardPage parent;

    public CloudFoundryServiceWizardPageRightPanel(CloudFoundryServiceWizardPage parent) {
        this.parent = parent;
        this.validation = new CFWizServicePageValidation(this);
    }

    public Composite createMainWindowComposite(Composite parent) {
        this.removeImage = CloudFoundryImages.REMOVE.createImage();
        this.group = new Group(parent, 4);
        this.group.setText(Messages.CloudFoundryServiceWizardPageRightPanel_SERVICES_TO_CREATE);
        this.group.setLayout((Layout)new FillLayout());
        this.group.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (CloudFoundryServiceWizardPageRightPanel.this.boldFont != null && !CloudFoundryServiceWizardPageRightPanel.this.boldFont.isDisposed()) {
                    CloudFoundryServiceWizardPageRightPanel.this.boldFont.dispose();
                }
                if (CloudFoundryServiceWizardPageRightPanel.this.removeImage != null && !CloudFoundryServiceWizardPageRightPanel.this.removeImage.isDisposed()) {
                    CloudFoundryServiceWizardPageRightPanel.this.removeImage.dispose();
                }
            }
        });
        this.scrollComp = new ScrolledComposite((Composite)this.group, 512);
        this.scrollComp.setAlwaysShowScrollBars(false);
        this.layoutList = this.createLayoutList(this.scrollComp);
        this.scrollComp.setContent((Control)this.layoutList);
        this.scrollComp.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                Control c = CloudFoundryServiceWizardPageRightPanel.this.scrollComp.getContent();
                if (c == null) {
                    return;
                }
                Rectangle r = CloudFoundryServiceWizardPageRightPanel.this.scrollComp.getClientArea();
                r.height = c.computeSize((int)r.width, (int)-1).y;
                c.setBounds(r);
            }
        });
        return this.group;
    }

    public List<List<ServiceInstance>> getServiceInstances() {
        return this.serviceInstances;
    }

    protected CloudFoundryServiceWizardPage getParent() {
        return this.parent;
    }

    private Composite createLayoutList(ScrolledComposite parent) {
        Composite result = null;
        if (this.layoutList != null) {
            Control[] controlArray = this.layoutList.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                c.dispose();
                ++n2;
            }
            result = this.layoutList;
        } else {
            result = new Composite((Composite)parent, 0);
        }
        Display display = result.getDisplay();
        Font font = result.getFont();
        if (this.boldFont == null) {
            FontData[] fontData = font.getFontData();
            fontData[0].setStyle(1);
            fontData[0].setHeight(fontData[0].getHeight());
            this.boldFont = new Font((Device)display, fontData);
        }
        if (result.getLayout() == null) {
            result.setLayout((Layout)new ServiceListRightCompositeLayout(this.serviceInstances));
        }
        ArrayList<Object> tabList = new ArrayList<Object>();
        FocusListener fl = new FocusListener();
        for (List<ServiceInstance> l : this.serviceInstances) {
            ServiceInstance firstInList = l.get(0);
            String serviceName = firstInList.getName();
            Label serviceNameLabel = new Label(result, 0);
            serviceNameLabel.setFont(this.boldFont);
            serviceNameLabel.setText(serviceName);
            for (final ServiceInstance i : l) {
                Label nameLabel = new Label(result, 0);
                nameLabel.setText(Messages.CloudFoundryServiceWizardPageRightPanel_NAME);
                nameLabel.setFont(this.boldFont);
                final Text nameText = new Text(result, 2048);
                nameText.setText(i.getUserDefinedName());
                nameText.setData((Object)i);
                tabList.add(nameText);
                nameText.addFocusListener((org.eclipse.swt.events.FocusListener)fl);
                nameText.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        String text = nameText.getText();
                        if (i != null) {
                            i.setUserDefinedName(text);
                        }
                        CloudFoundryServiceWizardPageRightPanel.this.validation.updatePageState();
                    }
                });
                Button removeButton = new Button(result, 0x800000);
                removeButton.setImage(this.removeImage);
                removeButton.setData((Object)i);
                removeButton.setToolTipText(Messages.CloudFoundryServiceWizardPageRightPanel_REMOVE_TOOLTIP);
                removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        CloudFoundryServiceWizardPageRightPanel.this.removeServiceInstance(i);
                    }
                });
                tabList.add(removeButton);
                removeButton.addFocusListener((org.eclipse.swt.events.FocusListener)fl);
                Label planLabel = new Label(result, 0);
                planLabel.setText(Messages.CloudFoundryServiceWizardPageRightPanel_PLAN);
                final Combo planCombo = new Combo(result, 12);
                planCombo.setItems(i.getPlanDisplayNames());
                planCombo.select(i.getSelectedPlan());
                planCombo.setData((Object)i);
                planCombo.addFocusListener((org.eclipse.swt.events.FocusListener)fl);
                planCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        int selectionIndex = planCombo.getSelectionIndex();
                        if (selectionIndex >= 0) {
                            i.setSelectedPlan(selectionIndex);
                        } else {
                            i.setSelectedPlan(0);
                        }
                    }
                });
                tabList.add(planCombo);
            }
        }
        if (this.serviceInstances.size() == 0) {
            Label noServicesLabel = new Label(result, 64);
            noServicesLabel.setText(Messages.CloudFoundryServiceWizardPageRightPanel_ADD_A_SERVICE);
        }
        result.setTabList(tabList.toArray(new Control[tabList.size()]));
        this.validation.updatePageState();
        return result;
    }

    private void removeServiceInstance(ServiceInstance instance) {
        Iterator<List<ServiceInstance>> listIterator = this.serviceInstances.iterator();
        while (listIterator.hasNext()) {
            List<ServiceInstance> innerList = listIterator.next();
            Iterator<ServiceInstance> innerIterator = innerList.iterator();
            while (innerIterator.hasNext()) {
                ServiceInstance serviceInstance = innerIterator.next();
                if (!serviceInstance.equals(instance)) continue;
                innerIterator.remove();
            }
            if (innerList.size() != 0) continue;
            listIterator.remove();
        }
        this.updateLayoutListComposite();
    }

    private static boolean utilDoesServiceListContainName(List<List<ServiceInstance>> serviceListList, String serviceName) {
        for (List<ServiceInstance> serviceList : serviceListList) {
            for (ServiceInstance instance : serviceList) {
                if (!instance.getUserDefinedName().equalsIgnoreCase(serviceName)) continue;
                return true;
            }
        }
        return false;
    }

    public void setExistingServicesNames(List<String> existingServicesNames) {
        this.existingServicesNames = existingServicesNames;
    }

    public List<String> getExistingServicesNames() {
        return this.existingServicesNames;
    }

    public void addNewServiceInstance(ServiceInstance instance) {
        List<ServiceInstance> serviceListMatch = null;
        for (List<ServiceInstance> serviceList : this.serviceInstances) {
            ServiceInstance prototypicalInstance;
            if (serviceList.size() == 0 || !(prototypicalInstance = serviceList.get(0)).getName().equals(instance.getName())) continue;
            serviceListMatch = serviceList;
            break;
        }
        if (CloudFoundryServiceWizardPageRightPanel.utilDoesServiceListContainName(this.serviceInstances, instance.getUserDefinedName()) || this.existingServicesNames != null && this.existingServicesNames.contains(instance.getUserDefinedName().toLowerCase())) {
            String newName = instance.getUserDefinedName();
            int x = 2;
            while (CloudFoundryServiceWizardPageRightPanel.utilDoesServiceListContainName(this.serviceInstances, String.valueOf(newName) + x) || this.existingServicesNames != null && this.existingServicesNames.contains(String.valueOf(newName.toLowerCase()) + x)) {
                if (++x > 1000) break;
            }
            instance.setUserDefinedName(String.valueOf(newName) + x);
        }
        if (serviceListMatch != null) {
            serviceListMatch.add(instance);
            Collections.sort(serviceListMatch, new Comparator<ServiceInstance>(){

                @Override
                public int compare(ServiceInstance o1, ServiceInstance o2) {
                    String o1Name = o1.getUserDefinedName();
                    String o2Name = o2.getUserDefinedName();
                    if (o1Name == null || o1Name.trim().length() == 0) {
                        o1Name = "zzzzzzzz";
                    }
                    if (o2Name == null || o2Name.trim().length() == 0) {
                        o2Name = "zzzzzzzz";
                    }
                    return o1Name.toLowerCase().compareTo(o2Name.toLowerCase());
                }
            });
        } else {
            ArrayList<ServiceInstance> list = new ArrayList<ServiceInstance>();
            list.add(instance);
            this.serviceInstances.add(list);
            Collections.sort(this.serviceInstances, new Comparator<List<ServiceInstance>>(){

                @Override
                public int compare(List<ServiceInstance> o1, List<ServiceInstance> o2) {
                    if (o1.size() == 0 || o2.size() == 0) {
                        if (o1.size() == o2.size()) {
                            return 0;
                        }
                        if (o2.size() > o1.size()) {
                            return 1;
                        }
                        return -1;
                    }
                    String o1Name = o1.get(0).getName().toLowerCase();
                    String o2Name = o2.get(0).getName().toLowerCase();
                    return o1Name.compareTo(o2Name);
                }
            });
        }
        this.updateLayoutListComposite();
    }

    private void updateLayoutListComposite() {
        this.createLayoutList(this.scrollComp);
        Rectangle r = this.scrollComp.getClientArea();
        r.height = this.layoutList.computeSize((int)r.width, (int)-1).y;
        this.layoutList.setBounds(r);
    }

    class FocusListener
    extends FocusAdapter {
        FocusListener() {
        }

        public void focusGained(FocusEvent e) {
            Control c = (Control)e.getSource();
            ServiceInstance service = (ServiceInstance)c.getData();
            Rectangle bounds = service.getAppxLocation();
            Rectangle area = CloudFoundryServiceWizardPageRightPanel.this.scrollComp.getClientArea();
            Point origin = CloudFoundryServiceWizardPageRightPanel.this.scrollComp.getOrigin();
            if (origin.y > bounds.y) {
                origin.y = Math.max(0, bounds.y);
            }
            if (origin.y + area.height < bounds.y + bounds.height) {
                origin.y = Math.max(0, bounds.y + bounds.height - area.height);
            }
            CloudFoundryServiceWizardPageRightPanel.this.scrollComp.setOrigin(origin);
        }
    }
}

