/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.wizards;

import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.ui.internal.CloudSpacesDelegate;
import org.eclipse.cft.server.ui.internal.CloudSpacesSelectionPart;
import org.eclipse.cft.server.ui.internal.ValidationEventHandler;
import org.eclipse.cft.server.ui.internal.wizards.WizardFragmentStatusHandler;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.eclipse.wst.server.ui.wizard.WizardFragment;

public class CloudFoundrySpacesWizardFragment
extends WizardFragment {
    private final CloudSpacesDelegate spacesDelegate;
    private final CloudFoundryServer cloudServer;
    private CloudSpacesSelectionPart spacesPart;
    private ValidationEventHandler validationEventHandler;
    private WizardFragmentStatusHandler statusHandler;

    public CloudFoundrySpacesWizardFragment(CloudFoundryServer cloudServer, CloudSpacesDelegate spacesDelegate, ValidationEventHandler validationHandler) {
        this.validationEventHandler = validationHandler;
        this.cloudServer = cloudServer;
        this.spacesDelegate = spacesDelegate;
    }

    public Composite createComposite(Composite parent, IWizardHandle wizardHandle) {
        this.statusHandler = new WizardFragmentStatusHandler(wizardHandle);
        this.validationEventHandler.addStatusHandler(this.statusHandler);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.spacesPart = new CloudSpacesSelectionPart(this.spacesDelegate, this.cloudServer, wizardHandle);
        this.spacesPart.addPartChangeListener(this.validationEventHandler);
        this.spacesPart.createPart(composite);
        return composite;
    }

    public boolean isComplete() {
        return this.validationEventHandler.isOK();
    }

    public boolean hasComposite() {
        return true;
    }

    public void enter() {
        if (this.spacesPart != null) {
            this.spacesPart.setInput();
        }
        super.enter();
    }
}

