/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.wizards;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.ui.internal.CFUiUtil;
import org.eclipse.cft.server.ui.internal.ICoreRunnable;
import org.eclipse.cft.server.ui.internal.IEventSource;
import org.eclipse.cft.server.ui.internal.IPartChangeListener;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.cft.server.ui.internal.PartChangeEvent;
import org.eclipse.cft.server.ui.internal.WizardPartChangeEvent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ui.progress.UIJob;

public abstract class PartsWizardPage
extends WizardPage
implements IPartChangeListener {
    protected Map<IEventSource<?>, IStatus> partStatus = new HashMap();

    protected PartsWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    protected IStatus getNextNonOKStatus() {
        IStatus status = null;
        for (Map.Entry<IEventSource<?>, IStatus> entry : this.partStatus.entrySet()) {
            status = entry.getValue();
            if (status != null && !status.isOK()) break;
        }
        return status;
    }

    @Override
    public void handleChange(PartChangeEvent event) {
        IStatus status = event.getStatus();
        if (status == null) {
            status = Status.OK_STATUS;
        }
        if (status.isOK()) {
            this.partStatus.remove(event.getSource());
            Iterator<Map.Entry<IEventSource<?>, IStatus>> iterator = this.partStatus.entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry<IEventSource<?>, IStatus> entry = iterator.next();
                status = entry.getValue();
            }
        } else if (event.getSource() != null) {
            this.partStatus.put(event.getSource(), status);
        }
        boolean updateButtons = !(event instanceof WizardPartChangeEvent) || ((WizardPartChangeEvent)event).updateWizardButtons();
        this.update(updateButtons, status);
    }

    public boolean isPageComplete() {
        IStatus status = this.getNextNonOKStatus();
        return status == null;
    }

    protected void update(boolean updateButtons, IStatus status) {
        if (status == null) {
            status = Status.OK_STATUS;
        }
        if (status.isOK()) {
            this.setErrorMessage(null);
        } else if (status.getSeverity() == 4) {
            this.setErrorMessage(status.getMessage() != null ? status.getMessage() : Messages.PartsWizardPage_ERROR_UNKNOWN);
        } else if (status.getSeverity() == 1) {
            this.setMessage(status.getMessage(), 1);
        } else if (status.getSeverity() == 2) {
            this.setMessage(status.getMessage(), 2);
        }
        if (updateButtons && this.getWizard() != null && this.getWizard().getContainer() != null && this.getWizard().getContainer().getCurrentPage() != null) {
            this.getWizard().getContainer().updateButtons();
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            IStatus status;
            if (this.getPreviousPage() == null) {
                if (!this.getControl().isDisposed()) {
                    this.performWhenPageVisible();
                }
            } else {
                this.performWhenPageVisible();
            }
            if ((status = this.getNextNonOKStatus()) != null) {
                this.update(true, status);
            }
        }
    }

    protected void performWhenPageVisible() {
    }

    protected void runAsync(final ICoreRunnable runnable, String operationLabel) {
        if (runnable == null) {
            return;
        }
        if (operationLabel == null) {
            operationLabel = "";
        }
        Job job = new Job(operationLabel){

            protected IStatus run(IProgressMonitor monitor) {
                CoreException cex = null;
                try {
                    runnable.run(monitor);
                }
                catch (OperationCanceledException operationCanceledException) {
                }
                catch (CoreException ce) {
                    cex = ce;
                }
                if (cex != null) {
                    CloudFoundryPlugin.logError((Throwable)cex);
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(false);
        job.schedule();
    }

    protected void runAsynchWithWizardProgress(final ICoreRunnable runnable, String operationLabel) {
        if (runnable == null) {
            return;
        }
        if (operationLabel == null) {
            operationLabel = "";
        }
        UIJob job = new UIJob(operationLabel){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                CoreException cex = null;
                try {
                    CFUiUtil.runForked(runnable, (IRunnableContext)PartsWizardPage.this.getWizard().getContainer());
                }
                catch (OperationCanceledException operationCanceledException) {
                }
                catch (CoreException ce) {
                    cex = ce;
                }
                if (cex != null) {
                    CloudFoundryPlugin.logError((Throwable)cex);
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }
}

