/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.wizards;

import java.util.List;
import org.eclipse.cft.server.ui.internal.wizards.ServiceInstance;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

class ServiceListRightCompositeLayout
extends Layout {
    final List<List<ServiceInstance>> serviceInstances;

    public ServiceListRightCompositeLayout(List<List<ServiceInstance>> serviceInstances) {
        this.serviceInstances = serviceInstances;
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        int[] result = this.layoutImpl(composite, wHint, flushCache, false);
        return new Point(result[0], result[1]);
    }

    protected void layout(Composite composite, boolean flushCache) {
        this.layoutImpl(composite, -1, flushCache, true);
    }

    private static void centerControl(Control c, int maxControlHeight) {
        Rectangle b = c.getBounds();
        int controlHeight = b.height;
        b.y += maxControlHeight / 2 - controlHeight / 2;
        c.setBounds(b);
    }

    protected int[] layoutImpl(Composite composite, int wHint, boolean flushCache, boolean apply) {
        Control[] children = composite.getChildren();
        if (children.length == 0) {
            return new int[2];
        }
        int width = wHint > 0 ? wHint : composite.getClientArea().width;
        int x = 0;
        int y = 0;
        int c = 0;
        if (this.serviceInstances.size() == 0) {
            Label noServicesLabel = (Label)children[0];
            Point noServicesLabelPoint = noServicesLabel.computeSize(width - 30, -1, flushCache);
            if (apply) {
                noServicesLabel.setBounds(10, 10, noServicesLabelPoint.x, noServicesLabelPoint.y);
                composite.setSize(width, y + noServicesLabelPoint.y + 10);
            }
            return new int[]{width, y + noServicesLabelPoint.y + 10};
        }
        y = 10;
        for (List<ServiceInstance> l : this.serviceInstances) {
            boolean firstInList = true;
            x = 10;
            Label serviceNameLabel = (Label)children[c++];
            Point p = serviceNameLabel.computeSize(-1, -1, flushCache);
            if (apply) {
                serviceNameLabel.setBounds(x, y, p.x, p.y);
            }
            y += p.y;
            for (ServiceInstance i : l) {
                x = 30;
                int lineHeight = -1;
                Label nameLabel = (Label)children[c++];
                Point namePoint = nameLabel.computeSize(-1, -1, flushCache);
                if (apply) {
                    nameLabel.setBounds(x, y, namePoint.x, namePoint.y);
                }
                lineHeight = Math.max(lineHeight, namePoint.y);
                Text nameText = (Text)children[c++];
                Point nameTextPoint = nameText.computeSize(width - (x += namePoint.x + 4) - 80, -1, flushCache);
                if (apply) {
                    nameText.setBounds(x, y, nameTextPoint.x, nameTextPoint.y);
                }
                int nameTextX = x;
                x += nameTextPoint.x + 4;
                lineHeight = Math.max(lineHeight, nameTextPoint.y);
                Button removeButton = (Button)children[c++];
                Point removeButtonPoint = removeButton.computeSize(-1, -1, flushCache);
                if (apply) {
                    removeButton.setBounds(x, y, removeButtonPoint.x, removeButtonPoint.y);
                }
                lineHeight = Math.max(lineHeight, removeButtonPoint.y);
                y += lineHeight;
                if (apply) {
                    ServiceListRightCompositeLayout.centerControl((Control)nameLabel, lineHeight);
                    ServiceListRightCompositeLayout.centerControl((Control)nameText, lineHeight);
                    ServiceListRightCompositeLayout.centerControl((Control)removeButton, lineHeight);
                }
                x = 30;
                lineHeight = -1;
                Label planLabel = (Label)children[c++];
                Point planLabelPoint = planLabel.computeSize(-1, -1, flushCache);
                if (apply) {
                    planLabel.setBounds(x, y, planLabelPoint.x, planLabelPoint.y);
                }
                x += planLabelPoint.x + 4;
                lineHeight = Math.max(lineHeight, planLabelPoint.y);
                x = Math.max(x, nameTextX);
                Combo planCombo = (Combo)children[c++];
                Point planComboPoint = planCombo.computeSize(100, -1, flushCache);
                if (apply) {
                    planCombo.setBounds(x, y, planComboPoint.x, planComboPoint.y);
                }
                lineHeight = Math.max(lineHeight, planComboPoint.y);
                if (apply) {
                    ServiceListRightCompositeLayout.centerControl((Control)planLabel, lineHeight);
                    ServiceListRightCompositeLayout.centerControl((Control)planCombo, lineHeight);
                    Rectangle topLeft = firstInList ? serviceNameLabel.getBounds() : nameLabel.getBounds();
                    Rectangle bottomRight = planCombo.getBounds();
                    Rectangle appxLocation = new Rectangle(topLeft.x, topLeft.y, bottomRight.x + bottomRight.width - topLeft.x, bottomRight.y + bottomRight.height - topLeft.y);
                    i.setAppxLocation(appxLocation);
                }
                y += lineHeight;
                y += 5;
            }
            y += 10;
            firstInList = false;
        }
        if (apply) {
            composite.setSize(width, y);
        }
        return new int[]{width, y};
    }
}

