/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui.checkouts.wizards;

import java.util.Properties;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.explorer.repositories.CDORepository;
import org.eclipse.emf.cdo.explorer.ui.checkouts.CDOCheckoutViewerSorter;
import org.eclipse.emf.cdo.explorer.ui.checkouts.wizards.CheckoutWizardPage;
import org.eclipse.emf.cdo.explorer.ui.repositories.CDORepositoryItemProvider;
import org.eclipse.emf.cdo.internal.explorer.checkouts.CDOCheckoutImpl;
import org.eclipse.emf.cdo.internal.ui.editor.CDOEditor;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.ui.CDOItemProvider;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.ui.views.ContainerItemProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public class CheckoutRootObjectPage
extends CheckoutWizardPage {
    private static final IContainer<Object> LOADING_INPUT = ContainerItemProvider.createSlowInput((String)"Loading...");
    private CDOID rootID;
    private String rootObjectText;
    private TreeViewer treeViewer;
    private CDOView view;
    private CDORepository repository;

    public CheckoutRootObjectPage() {
        super("Root Object", "Select the root object of the new checkout.");
    }

    public final CDOID getRootID() {
        return this.rootID;
    }

    public final void setRootID(CDOID rootID) {
        if (this.rootID != rootID) {
            CheckoutRootObjectPage.log("Setting root id to " + rootID);
            this.rootID = rootID;
            this.rootObjectChanged(rootID);
        }
    }

    public String getRootObjectText() {
        if (this.rootObjectText == null) {
            return this.repository.getLabel();
        }
        return this.rootObjectText;
    }

    public void dispose() {
        this.closeView();
        super.dispose();
    }

    @Override
    protected void createUI(Composite parent) {
        final CDOItemProvider itemProvider = new CDOItemProvider(null){
            private final ComposedAdapterFactory adapterFactory;
            private final ITreeContentProvider contentProvider;
            private final ILabelProvider labelProvider;
            {
                this.adapterFactory = CDOEditor.createAdapterFactory((boolean)true);
                this.contentProvider = new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory);
                this.labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory);
            }

            public void dispose() {
                this.labelProvider.dispose();
                this.contentProvider.dispose();
                this.adapterFactory.dispose();
                super.dispose();
            }

            public boolean hasChildren(Object element) {
                if (CheckoutRootObjectPage.this.view != null) {
                    CDOResource rootResource = CheckoutRootObjectPage.this.view.getRootResource();
                    if (element == CheckoutRootObjectPage.this.repository) {
                        return true;
                    }
                    if (element == rootResource) {
                        return !rootResource.getContents().isEmpty();
                    }
                }
                if (element instanceof EObject) {
                    return this.contentProvider.hasChildren(element);
                }
                return super.hasChildren(element);
            }

            public Object[] getChildren(Object element) {
                if (CheckoutRootObjectPage.this.view != null) {
                    CDOResource rootResource = CheckoutRootObjectPage.this.view.getRootResource();
                    if (element == CheckoutRootObjectPage.this.repository) {
                        return new Object[]{rootResource};
                    }
                    if (element == rootResource) {
                        return rootResource.getContents().toArray();
                    }
                }
                if (element instanceof EObject) {
                    return this.contentProvider.getChildren(element);
                }
                return super.getChildren(element);
            }

            public Object getParent(Object element) {
                CDOResource rootResource;
                if (CheckoutRootObjectPage.this.view != null && element == (rootResource = CheckoutRootObjectPage.this.view.getRootResource())) {
                    return CheckoutRootObjectPage.this.repository;
                }
                if (element instanceof EObject) {
                    return this.contentProvider.getParent(element);
                }
                return super.getParent(element);
            }

            public Image getImage(Object element) {
                if (CheckoutRootObjectPage.this.view != null && element == CheckoutRootObjectPage.this.view.getRootResource()) {
                    return CDORepositoryItemProvider.REPOSITORY_IMAGE;
                }
                if (element instanceof EObject) {
                    return this.labelProvider.getImage(element);
                }
                return super.getImage(element);
            }

            public String getText(Object element) {
                if (CheckoutRootObjectPage.this.view != null && element == CheckoutRootObjectPage.this.view.getRootResource()) {
                    return CheckoutRootObjectPage.this.repository.getLabel();
                }
                if (element instanceof EObject) {
                    return this.labelProvider.getText(element);
                }
                return super.getText(element);
            }

            public void fillContextMenu(IMenuManager manager, ITreeSelection selection) {
            }
        };
        this.treeViewer = new TreeViewer(parent, 2048);
        this.treeViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.treeViewer.setContentProvider((IContentProvider)itemProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)itemProvider);
        this.treeViewer.setComparator((ViewerComparator)new CDOCheckoutViewerSorter());
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)CheckoutRootObjectPage.this.treeViewer.getSelection();
                Object element = selection.getFirstElement();
                if (element instanceof EObject) {
                    EObject eObject = (EObject)element;
                    CDOObject cdoObject = CDOUtil.getCDOObject((EObject)eObject);
                    CheckoutRootObjectPage.this.rootID = cdoObject.cdoID();
                    if (cdoObject != CheckoutRootObjectPage.this.view.getRootResource()) {
                        CheckoutRootObjectPage.this.rootObjectText = this.getText(itemProvider, (EObject)cdoObject);
                    }
                }
                CheckoutRootObjectPage.this.validate();
            }

            private String getText(CDOItemProvider itemProvider2, EObject object) {
                String text = itemProvider2.getText((Object)object);
                int i = 0;
                while (i < "/\\:;,".length()) {
                    text = text.replace("/\\:;,".charAt(i), '.');
                    ++i;
                }
                Object parent = itemProvider2.getParent((Object)object);
                if (parent instanceof EObject) {
                    text = String.valueOf(this.getText(itemProvider2, (EObject)parent)) + "." + text;
                }
                return text;
            }
        });
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CheckoutRootObjectPage.this.showNextPage();
            }
        });
        this.treeViewer.setInput(LOADING_INPUT);
    }

    @Override
    protected boolean doValidate() throws CheckoutWizardPage.ValidationProblem {
        return true;
    }

    @Override
    protected void repositoryChanged(CDORepository repository) {
        this.repository = repository;
        this.closeView();
        super.repositoryChanged(repository);
    }

    @Override
    protected void branchPointChanged(int branchID, long timeStamp) {
        this.closeView();
        super.branchPointChanged(branchID, timeStamp);
    }

    @Override
    protected void pageActivated() {
        if (this.view == null) {
            CDOSession session = this.repository.getSession();
            CDOBranchPoint branchPoint = this.getWizard().getBranchPointPage().getBranchPoint();
            CheckoutRootObjectPage.log("Opening view to " + this.repository);
            this.view = session.openView(branchPoint);
            this.treeViewer.setInput((Object)this.repository);
            this.rootObjectText = null;
            this.getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    CDOResource rootResource = CheckoutRootObjectPage.this.view.getRootResource();
                    CheckoutRootObjectPage.this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)rootResource));
                    CheckoutRootObjectPage.this.treeViewer.expandToLevel((Object)rootResource, 1);
                }
            });
        }
    }

    @Override
    protected void fillProperties(Properties properties) {
        if (this.rootID != null) {
            properties.setProperty("rootID", CDOCheckoutImpl.getCDOIDString((CDOID)this.rootID));
        }
    }

    private void closeView() {
        if (this.view != null) {
            CDOView oldView = this.view;
            this.view = null;
            if (this.treeViewer != null) {
                this.treeViewer.setSelection((ISelection)StructuredSelection.EMPTY);
                this.treeViewer.setInput(LOADING_INPUT);
            }
            CheckoutRootObjectPage.log("Closing view to " + this.repository);
            oldView.close();
        }
    }
}

