/**
 * Copyright (c) 2015 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.internal.logging.aeri.ide;

import org.eclipse.core.runtime.IStatus;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Log Event Group</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.ILogEventGroup#getStatus <em>Status</em>}</li>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.ILogEventGroup#getEvents <em>Events</em>}</li>
 *   <li>{@link org.eclipse.epp.internal.logging.aeri.ide.ILogEventGroup#getTimestamp <em>Timestamp</em>}</li>
 * </ul>
 *
 * @see org.eclipse.epp.internal.logging.aeri.ide.IIdePackage#getLogEventGroup()
 * @model
 * @generated
 */
public interface ILogEventGroup extends EObject {
	/**
	 * Returns the value of the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Status</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Status</em>' attribute.
	 * @see #setStatus(IStatus)
	 * @see org.eclipse.epp.internal.logging.aeri.ide.IIdePackage#getLogEventGroup_Status()
	 * @model dataType="org.eclipse.epp.logging.aeri.core.IStatus"
	 * @generated
	 */
	IStatus getStatus();

	/**
	 * Sets the value of the '{@link org.eclipse.epp.internal.logging.aeri.ide.ILogEventGroup#getStatus <em>Status</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Status</em>' attribute.
	 * @see #getStatus()
	 * @generated
	 */
	void setStatus(IStatus value);

	/**
	 * Returns the value of the '<em><b>Events</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.epp.internal.logging.aeri.ide.ILogEvent}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.epp.internal.logging.aeri.ide.ILogEvent#getGroup <em>Group</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Events</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Events</em>' containment reference list.
	 * @see org.eclipse.epp.internal.logging.aeri.ide.IIdePackage#getLogEventGroup_Events()
	 * @see org.eclipse.epp.internal.logging.aeri.ide.ILogEvent#getGroup
	 * @model opposite="group" containment="true"
	 * @generated
	 */
	EList<ILogEvent> getEvents();

	/**
	 * Returns the value of the '<em><b>Timestamp</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Timestamp</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Timestamp</em>' attribute.
	 * @see #setTimestamp(long)
	 * @see org.eclipse.epp.internal.logging.aeri.ide.IIdePackage#getLogEventGroup_Timestamp()
	 * @model
	 * @generated
	 */
	long getTimestamp();

	/**
	 * Sets the value of the '{@link org.eclipse.epp.internal.logging.aeri.ide.ILogEventGroup#getTimestamp <em>Timestamp</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Timestamp</em>' attribute.
	 * @see #getTimestamp()
	 * @generated
	 */
	void setTimestamp(long value);

} // ILogEventGroup
