/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.platform.ga;

import java.util.ArrayList;
import org.eclipse.graphiti.platform.ga.IVisualState;
import org.eclipse.graphiti.platform.ga.IVisualStateChangeListener;
import org.eclipse.graphiti.platform.ga.VisualStateChangedEvent;

public class VisualState
implements IVisualState {
    private ArrayList<IVisualStateChangeListener> changeListeners = new ArrayList();
    private int actionTargetFeedback = 0;
    private int selectionFeedback = 0;
    private int hoverFeedback = 1;

    @Override
    public void addChangeListener(IVisualStateChangeListener listener) {
        this.changeListeners.add(listener);
    }

    @Override
    public void removeChangeListener(IVisualStateChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    protected void fireVisualStateChanged(VisualStateChangedEvent e) {
        for (IVisualStateChangeListener listener : this.changeListeners) {
            listener.visualStateChanged(e);
        }
    }

    @Override
    public int getActionTargetFeedback() {
        return this.actionTargetFeedback;
    }

    @Override
    public void setActionTargetFeedback(int feedback) {
        int oldActionTargetFeedback = this.actionTargetFeedback;
        this.actionTargetFeedback = feedback;
        if (oldActionTargetFeedback != this.actionTargetFeedback) {
            this.fireVisualStateChanged(new VisualStateChangedEvent(IVisualState.Type.ACTION_TARGET_FEEDBACK, oldActionTargetFeedback, feedback));
        }
    }

    @Override
    public int getSelectionFeedback() {
        return this.selectionFeedback;
    }

    @Override
    public void setSelectionFeedback(int feedback) {
        int oldSelectionFeedback = this.selectionFeedback;
        this.selectionFeedback = feedback;
        if (oldSelectionFeedback != this.selectionFeedback) {
            this.fireVisualStateChanged(new VisualStateChangedEvent(IVisualState.Type.SELECTION, oldSelectionFeedback, feedback));
        }
    }

    @Override
    public void setHoverFeedback(int feedback) {
        int oldHoverFeedback = this.hoverFeedback;
        this.hoverFeedback = feedback;
        if (oldHoverFeedback != this.hoverFeedback) {
            this.fireVisualStateChanged(new VisualStateChangedEvent(IVisualState.Type.HOVER, oldHoverFeedback, feedback));
        }
    }

    @Override
    public int getHoverFeedback() {
        return this.hoverFeedback;
    }
}

