/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.archive;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jubula.client.archive.ImportExportUtil;
import org.eclipse.jubula.client.archive.dto.AutConfigDTO;
import org.eclipse.jubula.client.archive.dto.AutDTO;
import org.eclipse.jubula.client.archive.dto.CapDTO;
import org.eclipse.jubula.client.archive.dto.CategoryDTO;
import org.eclipse.jubula.client.archive.dto.CheckConfigurationDTO;
import org.eclipse.jubula.client.archive.dto.CommentDTO;
import org.eclipse.jubula.client.archive.dto.ComponentNameDTO;
import org.eclipse.jubula.client.archive.dto.ComponentNamesPairDTO;
import org.eclipse.jubula.client.archive.dto.ConditionalStatementDTO;
import org.eclipse.jubula.client.archive.dto.DataRowDTO;
import org.eclipse.jubula.client.archive.dto.DefaultEventHandlerDTO;
import org.eclipse.jubula.client.archive.dto.EventTestCaseDTO;
import org.eclipse.jubula.client.archive.dto.ExecCategoryDTO;
import org.eclipse.jubula.client.archive.dto.IterateDTO;
import org.eclipse.jubula.client.archive.dto.MapEntryDTO;
import org.eclipse.jubula.client.archive.dto.MonitoringValuesDTO;
import org.eclipse.jubula.client.archive.dto.NamedTestDataDTO;
import org.eclipse.jubula.client.archive.dto.NodeDTO;
import org.eclipse.jubula.client.archive.dto.ObjectMappingDTO;
import org.eclipse.jubula.client.archive.dto.ObjectMappingProfileDTO;
import org.eclipse.jubula.client.archive.dto.OmCategoryDTO;
import org.eclipse.jubula.client.archive.dto.OmEntryDTO;
import org.eclipse.jubula.client.archive.dto.ParamDescriptionDTO;
import org.eclipse.jubula.client.archive.dto.ParameterDTO;
import org.eclipse.jubula.client.archive.dto.ProjectDTO;
import org.eclipse.jubula.client.archive.dto.RefTestCaseDTO;
import org.eclipse.jubula.client.archive.dto.RefTestSuiteDTO;
import org.eclipse.jubula.client.archive.dto.ReusedProjectDTO;
import org.eclipse.jubula.client.archive.dto.TDManagerDTO;
import org.eclipse.jubula.client.archive.dto.TechnicalNameDTO;
import org.eclipse.jubula.client.archive.dto.TestCaseDTO;
import org.eclipse.jubula.client.archive.dto.TestDataCategoryDTO;
import org.eclipse.jubula.client.archive.dto.TestJobDTO;
import org.eclipse.jubula.client.archive.dto.TestSuiteDTO;
import org.eclipse.jubula.client.archive.dto.TestresultSummaryDTO;
import org.eclipse.jubula.client.archive.dto.UsedToolkitDTO;
import org.eclipse.jubula.client.archive.dto.ValueSetDTO;
import org.eclipse.jubula.client.archive.dto.WhileDTO;
import org.eclipse.jubula.client.archive.i18n.Messages;
import org.eclipse.jubula.client.core.businessprocess.ProjectNameBP;
import org.eclipse.jubula.client.core.businessprocess.UsedToolkitBP;
import org.eclipse.jubula.client.core.model.IAUTConfigPO;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.ICapParamDescriptionPO;
import org.eclipse.jubula.client.core.model.ICategoryPO;
import org.eclipse.jubula.client.core.model.ICheckConfContPO;
import org.eclipse.jubula.client.core.model.ICheckConfPO;
import org.eclipse.jubula.client.core.model.ICommentPO;
import org.eclipse.jubula.client.core.model.ICompIdentifierPO;
import org.eclipse.jubula.client.core.model.ICompNamesPairPO;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.ICondStructPO;
import org.eclipse.jubula.client.core.model.IConditionalStatementPO;
import org.eclipse.jubula.client.core.model.IDataSetPO;
import org.eclipse.jubula.client.core.model.IDoWhilePO;
import org.eclipse.jubula.client.core.model.IEventExecTestCasePO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.IIteratePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IObjectMappingAssoziationPO;
import org.eclipse.jubula.client.core.model.IObjectMappingCategoryPO;
import org.eclipse.jubula.client.core.model.IObjectMappingPO;
import org.eclipse.jubula.client.core.model.IObjectMappingProfilePO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParamValueSetPO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.IProjectPropertiesPO;
import org.eclipse.jubula.client.core.model.IRefTestSuitePO;
import org.eclipse.jubula.client.core.model.IReusedProjectPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITDManager;
import org.eclipse.jubula.client.core.model.ITcParamDescriptionPO;
import org.eclipse.jubula.client.core.model.ITestDataCategoryPO;
import org.eclipse.jubula.client.core.model.ITestDataCubePO;
import org.eclipse.jubula.client.core.model.ITestJobPO;
import org.eclipse.jubula.client.core.model.ITestResultSummaryPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.model.IUsedToolkitPO;
import org.eclipse.jubula.client.core.model.IValueCommentPO;
import org.eclipse.jubula.client.core.model.IWhileDoPO;
import org.eclipse.jubula.client.core.model.ReentryProperty;
import org.eclipse.jubula.client.core.persistence.CompNamePM;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.PMSaveException;
import org.eclipse.jubula.client.core.persistence.TestResultSummaryPM;
import org.eclipse.jubula.client.core.utils.TrackingUnit;
import org.eclipse.jubula.tools.internal.exception.InvalidDataException;
import org.eclipse.jubula.tools.internal.exception.ProjectDeletedException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.internal.objects.IMonitoringValue;

public class JsonExporter {
    private ProjectDTO m_projectDTO;
    private IProjectPO m_project;
    private IProgressMonitor m_monitor;

    public JsonExporter(IProjectPO project, IProgressMonitor monitor) {
        this.m_monitor = monitor;
        this.m_project = project;
    }

    public ProjectDTO getProjectDTO() throws ProjectDeletedException, PMException, OperationCanceledException {
        this.m_monitor.subTask(Messages.ExportProjectInfo);
        this.m_monitor.worked(1);
        this.m_projectDTO = new ProjectDTO(this.m_project);
        IProjectPropertiesPO projectProperties = this.m_project.getProjectProperties();
        this.fillCheckConfiguration(projectProperties.getCheckConfCont());
        this.fillUsedToolkits();
        this.fillComponentNames();
        this.m_projectDTO.setAutToolKit(this.m_project.getToolkit());
        this.fillTestDataCategories();
        this.fillNamedTestData();
        this.fillAUT();
        this.handleSpecPersistables();
        this.handleExecPersistables();
        this.m_monitor.worked(1);
        this.handleReusedProjects();
        this.setProjectVersions();
        this.m_projectDTO.setReusable(this.m_project.getIsReusable());
        this.m_projectDTO.setProtected(this.m_project.getIsProtected());
        this.m_projectDTO.setTeststyleEnabled(projectProperties.getCheckConfCont().getEnabled());
        this.m_projectDTO.setTestResultDetailsCleanupInterval(this.m_project.getTestResultCleanupInterval());
        this.m_projectDTO.setMarkupLanguage(projectProperties.getMarkupLanguage());
        this.fillTrackingConfig(projectProperties);
        this.m_monitor.worked(1);
        return this.m_projectDTO;
    }

    public void writeTestResultSummariesToFile(FileWriterWithEncoding fWriter) throws IOException, PMException, OperationCanceledException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        fWriter.append((CharSequence)"[");
        float size = TestResultSummaryPM.countOfTestResultSummaries((IProjectPO)this.m_project, null);
        long lastPage = (long)Math.ceil(size / 1000.0f);
        int pos = 0;
        int countOfPage = 1;
        while ((long)countOfPage <= lastPage) {
            ImportExportUtil.checkCancel(this.m_monitor);
            List summaries = TestResultSummaryPM.getTestResultSummaries((IProjectPO)this.m_project, null, (int)countOfPage, (int)1000);
            List<TestresultSummaryDTO> summaryDTOs = this.getTestResultSummaryDTOs(summaries);
            int countOfItemInPage = 0;
            while (countOfItemInPage < summaryDTOs.size()) {
                ++pos;
                TestresultSummaryDTO dto = summaryDTOs.get(countOfItemInPage);
                StringBuffer buffer = new StringBuffer();
                buffer.append(mapper.writeValueAsString((Object)dto));
                if ((long)countOfPage != lastPage || countOfItemInPage != summaryDTOs.size() - 1) {
                    buffer.append(",");
                }
                fWriter.append((CharSequence)buffer);
                this.m_monitor.worked(1);
                ++countOfItemInPage;
            }
            this.m_monitor.subTask(String.valueOf(Messages.ImportJsonImportResult) + pos + "/" + (int)size);
            ++countOfPage;
        }
        fWriter.append((CharSequence)"]");
        fWriter.close();
    }

    private void fillCheckConfiguration(ICheckConfContPO checkConfCont) throws OperationCanceledException {
        ImportExportUtil.checkCancel(this.m_monitor);
        for (String chkId : checkConfCont.getConfMap().keySet()) {
            ICheckConfPO chkConf = (ICheckConfPO)checkConfCont.getConfMap().get(chkId);
            CheckConfigurationDTO chkDTO = new CheckConfigurationDTO(chkConf);
            chkDTO.setCheckId(chkId);
            this.m_projectDTO.addCheckConfiguration(chkDTO);
        }
    }

    private void fillUsedToolkits() throws ProjectDeletedException, PMSaveException {
        UsedToolkitBP toolkitBP = UsedToolkitBP.getInstance();
        try {
            toolkitBP.refreshToolkitInfo(this.m_project);
        }
        catch (PMException e) {
            throw new PMSaveException(String.valueOf(Messages.DataBaseErrorUpdatingToolkits) + String.valueOf(this.m_project.getName()) + Messages.OriginalException + e.toString(), MessageIDs.E_FILE_IO);
        }
        this.fillUsedToolkit(toolkitBP);
    }

    private void fillUsedToolkit(UsedToolkitBP toolkitBP) {
        Set toolkits = toolkitBP.getUsedToolkits();
        for (IUsedToolkitPO usedToolkit : toolkits) {
            UsedToolkitDTO utDTO = new UsedToolkitDTO();
            utDTO.setName(usedToolkit.getToolkitId());
            utDTO.setMajorVersion(usedToolkit.getMajorVersion());
            utDTO.setMinorVersion(usedToolkit.getMinorVersion());
            this.m_projectDTO.addUsedToolkit(utDTO);
        }
    }

    private void fillComponentNames() throws PMException, OperationCanceledException {
        ImportExportUtil.checkCancel(this.m_monitor);
        List allCompNamePOs = CompNamePM.readAllCompNamesRO((Long)this.m_project.getId());
        for (IComponentNamePO compName : allCompNamePOs) {
            ComponentNameDTO compNameDTO = new ComponentNameDTO();
            compNameDTO.setUuid(compName.getGuid());
            compNameDTO.setCompType(compName.getComponentType());
            compNameDTO.setCompName(compName.getName());
            compNameDTO.setCreationContext(compName.getCreationContext().toString());
            compNameDTO.setRefUuid(compName.getReferencedGuid());
            this.m_projectDTO.addComponentName(compNameDTO);
        }
        this.m_monitor.worked(1);
    }

    private void fillTestDataCategories() throws OperationCanceledException {
        ImportExportUtil.checkCancel(this.m_monitor);
        for (ITestDataCategoryPO testDataCategory : this.m_project.getTestDataCubeCont().getCategoryChildren()) {
            TestDataCategoryDTO tdcDTO = new TestDataCategoryDTO();
            this.fillTestDataCategory(tdcDTO, testDataCategory);
            this.m_projectDTO.addTestDataCategorie(tdcDTO);
        }
    }

    private void fillTestDataCategory(TestDataCategoryDTO tdcDTO, ITestDataCategoryPO tdc) {
        tdcDTO.setName(tdc.getName());
        for (ITestDataCategoryPO category : tdc.getCategoryChildren()) {
            TestDataCategoryDTO childTdcDTO = new TestDataCategoryDTO();
            this.fillTestDataCategory(childTdcDTO, category);
            tdcDTO.addTestDataCategorie(childTdcDTO);
        }
        for (ITestDataCubePO testData : tdc.getTestDataChildren()) {
            tdcDTO.addNamedTestData(this.fillNamedTestData((IParameterInterfacePO)testData));
        }
    }

    private void fillNamedTestData() {
        for (IParameterInterfacePO testDataCube : this.m_project.getTestDataCubeCont().getTestDataChildren()) {
            this.m_projectDTO.addNamedTestData(this.fillNamedTestData(testDataCube));
        }
    }

    private NamedTestDataDTO fillNamedTestData(IParameterInterfacePO testData) {
        NamedTestDataDTO ntdDTO = new NamedTestDataDTO();
        ntdDTO.setName(testData.getName());
        for (IParamDescriptionPO paramDesc : testData.getParameterList()) {
            ParamDescriptionDTO pdDTO = new ParamDescriptionDTO();
            this.fillParamDescription(pdDTO, paramDesc);
            ntdDTO.addParameterDescriptions(pdDTO);
        }
        if (testData.getReferencedDataCube() == null) {
            TDManagerDTO tdmDTO = new TDManagerDTO();
            this.fillTDManager(tdmDTO, testData.getDataManager());
            ntdDTO.setTDManager(tdmDTO);
        }
        return ntdDTO;
    }

    private void fillParamDescription(ParamDescriptionDTO pdDTO, IParamDescriptionPO po) {
        ITcParamDescriptionPO tcParamPo;
        IParamValueSetPO valueSet;
        if (po instanceof ICapParamDescriptionPO) {
            pdDTO.setName(po.getUniqueId());
        } else {
            pdDTO.setName(po.getName());
        }
        if (po instanceof ITcParamDescriptionPO && (valueSet = (tcParamPo = (ITcParamDescriptionPO)po).getValueSet()) != null) {
            List values = valueSet.getValues();
            ArrayList<MapEntryDTO> valueDTOs = new ArrayList<MapEntryDTO>();
            for (IValueCommentPO iValueCommentPO : values) {
                valueDTOs.add(new MapEntryDTO(iValueCommentPO.getValue(), iValueCommentPO.getComment()));
            }
            pdDTO.setValueSet(new ValueSetDTO(valueSet.getDefaultValue(), valueDTOs));
        }
        pdDTO.setType(po.getType());
        pdDTO.setUuid(po.getUniqueId());
    }

    private void fillTDManager(TDManagerDTO dto, ITDManager po) {
        dto.setUniqueIds(po.getUniqueIds());
        for (IDataSetPO dataSet : po.getDataSets()) {
            DataRowDTO dsDTO = new DataRowDTO();
            dsDTO.setColumns(dataSet.getColumnStringValues());
            dto.addDataSet(dsDTO);
        }
    }

    private void fillAUT() {
        for (IAUTMainPO aut : this.getSortedAutList(this.m_project)) {
            this.fillAUT(aut);
        }
        this.m_monitor.worked(1);
    }

    private void fillAUT(IAUTMainPO po) {
        AutDTO autDTO = new AutDTO();
        autDTO.setId(ImportExportUtil.i2str(po.getId()));
        autDTO.setName(po.getName());
        autDTO.setToolkit(po.getToolkit());
        autDTO.setUuid(po.getGuid());
        autDTO.setGenerateNames(po.isGenerateNames());
        ObjectMappingDTO omDTO = new ObjectMappingDTO();
        this.fillObjectMapping(omDTO, po.getObjMap());
        autDTO.setObjectMapping(omDTO);
        ArrayList sortedAutConfigs = new ArrayList(po.getAutConfigSet());
        Collections.sort(sortedAutConfigs, new Comparator<IAUTConfigPO>(){

            @Override
            public int compare(IAUTConfigPO autConfig1, IAUTConfigPO autConfig2) {
                return autConfig1.getName().compareTo(autConfig2.getName());
            }
        });
        Map propertyMap = po.getPropertyMap();
        for (String key : po.getPropertyKeys()) {
            autDTO.addToPropertyMap(key, (String)propertyMap.get(key));
        }
        for (IAUTConfigPO conf : sortedAutConfigs) {
            this.fillAUTConfig(autDTO, conf);
        }
        for (String autId : po.getAutIds()) {
            autDTO.addAutId(autId);
        }
        this.m_projectDTO.addAut(autDTO);
    }

    private void fillAUTConfig(AutDTO autDTO, IAUTConfigPO po) {
        AutConfigDTO autConfDTO = new AutConfigDTO();
        autConfDTO.setName(po.getName());
        ArrayList sortedConfigKeys = new ArrayList(po.getAutConfigKeys());
        Collections.sort(sortedConfigKeys);
        for (String key : sortedConfigKeys) {
            MapEntryDTO mapEntryDTO = new MapEntryDTO();
            mapEntryDTO.setKey(key);
            mapEntryDTO.setValue(po.getValue(key, ""));
            autConfDTO.addConfAttrMapEntry(mapEntryDTO);
        }
        autDTO.addConfig(autConfDTO);
    }

    private void fillObjectMapping(ObjectMappingDTO omDTO, IObjectMappingPO po) {
        IObjectMappingProfilePO profilePo = po.getProfile();
        ObjectMappingProfileDTO profileDTO = new ObjectMappingProfileDTO();
        profileDTO.setName(profilePo.getName());
        profileDTO.setContextFactor(profilePo.getContextFactor());
        profileDTO.setNameFactor(profilePo.getNameFactor());
        profileDTO.setPathFactor(profilePo.getPathFactor());
        profileDTO.setThreshold(profilePo.getThreshold());
        omDTO.setProfile(profileDTO);
        OmCategoryDTO mappedDTO = new OmCategoryDTO();
        this.fillObjectMappingCategory(mappedDTO, po.getMappedCategory());
        omDTO.setMapped(mappedDTO);
        OmCategoryDTO unmappedComponentDTO = new OmCategoryDTO();
        this.fillObjectMappingCategory(unmappedComponentDTO, po.getUnmappedLogicalCategory());
        omDTO.setUnmappedComponent(unmappedComponentDTO);
        OmCategoryDTO unmappedTechnicalDTO = new OmCategoryDTO();
        this.fillObjectMappingCategory(unmappedTechnicalDTO, po.getUnmappedTechnicalCategory());
        omDTO.setUnmappedTechnical(unmappedTechnicalDTO);
    }

    private void fillObjectMappingCategory(OmCategoryDTO categoryDTO, IObjectMappingCategoryPO category) {
        categoryDTO.setName(category.getName());
        categoryDTO.setId(category.getId());
        for (IObjectMappingCategoryPO subcategory : category.getUnmodifiableCategoryList()) {
            OmCategoryDTO mappedDTO = new OmCategoryDTO();
            this.fillObjectMappingCategory(mappedDTO, subcategory);
            categoryDTO.addCategories(mappedDTO);
            IAUTMainPO aut = subcategory.getAutMainParent();
            if (aut == null) continue;
            categoryDTO.setAut(ImportExportUtil.i2str(aut.getId()));
        }
        for (IObjectMappingAssoziationPO assoc : category.getUnmodifiableAssociationList()) {
            OmEntryDTO assocDTO = new OmEntryDTO();
            this.fillObjectMappingAssociation(assocDTO, assoc);
            categoryDTO.addAssociation(assocDTO);
        }
    }

    private void fillObjectMappingAssociation(OmEntryDTO assocDTO, IObjectMappingAssoziationPO assoc) {
        ICompIdentifierPO technicalName = assoc.getTechnicalName();
        if (technicalName != null) {
            TechnicalNameDTO technicalNameDTO = new TechnicalNameDTO();
            this.fillTechnicalName(technicalNameDTO, technicalName);
            assocDTO.setTechnicalName(technicalNameDTO);
        }
        assocDTO.setType(assoc.getType());
        for (String logicalName : assoc.getLogicalNames()) {
            assocDTO.addLogicalName(logicalName);
        }
    }

    private void fillTechnicalName(TechnicalNameDTO tnameDTO, ICompIdentifierPO po) {
        tnameDTO.setComponentClassName(po.getComponentClassName());
        tnameDTO.setSupportedClassName(po.getSupportedClassName());
        tnameDTO.setAlternativeDisplayName(po.getAlternativeDisplayName());
        IObjectMappingProfilePO profilePo = po.getProfilePO();
        if (profilePo != null) {
            ObjectMappingProfileDTO profileDto = new ObjectMappingProfileDTO();
            profileDto.setName(profilePo.getName());
            profileDto.setContextFactor(profilePo.getContextFactor());
            profileDto.setNameFactor(profilePo.getNameFactor());
            profileDto.setPathFactor(profilePo.getPathFactor());
            profileDto.setThreshold(profilePo.getThreshold());
            tnameDTO.setObjectMappingProfile(profileDto);
        }
        for (Object n : po.getNeighbours()) {
            tnameDTO.addNeighbour((String)n);
        }
        for (Object h : po.getHierarchyNames()) {
            tnameDTO.addHierarchyName((String)h);
        }
    }

    private void handleSpecPersistables() throws OperationCanceledException {
        for (INodePO tcOrCat : this.m_project.getUnmodSpecList()) {
            ImportExportUtil.checkCancel(this.m_monitor);
            if (tcOrCat instanceof ICategoryPO) {
                CategoryDTO catDTO = new CategoryDTO(tcOrCat);
                this.fillCategory(catDTO, (ICategoryPO)tcOrCat);
                this.m_projectDTO.addCategory(catDTO);
                continue;
            }
            TestCaseDTO tcDTO = new TestCaseDTO(tcOrCat);
            this.fillTestCase(tcDTO, (ISpecTestCasePO)tcOrCat);
            this.m_projectDTO.addCategory(tcDTO);
        }
    }

    private void fillCategory(CategoryDTO categoryDTO, ICategoryPO po) {
        for (INodePO node : po.getUnmodifiableNodeList()) {
            if (node instanceof ICategoryPO) {
                CategoryDTO catDTO = new CategoryDTO(node);
                this.fillCategory(catDTO, (ICategoryPO)node);
                categoryDTO.addNode(catDTO);
                continue;
            }
            if (!(node instanceof ISpecTestCasePO)) continue;
            TestCaseDTO tcDTO = new TestCaseDTO(node);
            this.fillTestCase(tcDTO, (ISpecTestCasePO)node);
            categoryDTO.addNode(tcDTO);
        }
    }

    private void fillTestCase(TestCaseDTO tcDTO, ISpecTestCasePO po) {
        for (Object o : po.getUnmodifiableNodeList()) {
            if (o instanceof ICapPO) {
                ICapPO capPO = (ICapPO)o;
                CapDTO capDTO = new CapDTO((INodePO)capPO);
                this.fillCap(capDTO, capPO);
                tcDTO.addTestStep(capDTO);
                continue;
            }
            if (o instanceof IExecTestCasePO) {
                IExecTestCasePO tcPO = (IExecTestCasePO)o;
                RefTestCaseDTO refTestCaseDTO = new RefTestCaseDTO((INodePO)tcPO);
                this.fillRefTestCase(refTestCaseDTO, tcPO);
                tcDTO.addTestStep(refTestCaseDTO);
                continue;
            }
            if (o instanceof ICommentPO) {
                ICommentPO commentPO = (ICommentPO)o;
                CommentDTO commentDTO = new CommentDTO(commentPO);
                tcDTO.addTestStep(commentDTO);
                continue;
            }
            if (o instanceof IConditionalStatementPO) {
                IConditionalStatementPO conPO = (IConditionalStatementPO)o;
                ConditionalStatementDTO conDTO = new ConditionalStatementDTO((INodePO)conPO);
                this.fillConditionalStatement(conDTO, conPO);
                tcDTO.addTestStep(conDTO);
                continue;
            }
            if (o instanceof IIteratePO) {
                IIteratePO iteratePO = (IIteratePO)o;
                IterateDTO iterateDTO = new IterateDTO((INodePO)iteratePO);
                this.fillIterateStatment(iterateDTO, iteratePO);
                tcDTO.addTestStep(iterateDTO);
                continue;
            }
            if (!(o instanceof IWhileDoPO) && !(o instanceof IDoWhilePO)) continue;
            ICondStructPO condStructPO = (ICondStructPO)o;
            WhileDTO whileDoDTO = new WhileDTO((INodePO)o);
            if (condStructPO instanceof IDoWhilePO) {
                this.fillWhileStatment(whileDoDTO, condStructPO, true);
            } else {
                this.fillWhileStatment(whileDoDTO, condStructPO, false);
            }
            tcDTO.addTestStep(whileDoDTO);
        }
        this.addParamDesc(tcDTO, (IParameterInterfacePO)po);
        tcDTO.setInterfaceLocked(po.isInterfaceLocked());
        tcDTO.setAssocOMCategories(po.getOmCategoryAssoc().stream().map(IPersistentObject::getId).collect(Collectors.toList()));
        this.addTestDataManager(tcDTO, (IParameterInterfacePO)po);
        for (Object o : po.getEventExecTcMap().keySet()) {
            IEventExecTestCasePO evTc = po.getEventExecTC((String)o);
            EventTestCaseDTO etcDTO = new EventTestCaseDTO((INodePO)evTc);
            this.fillEventTestCase(etcDTO, evTc);
            tcDTO.addEventTestcase(etcDTO);
        }
    }

    private void fillIterateStatment(IterateDTO iterateDTO, IIteratePO iteratePO) {
        NodeDTO container = new NodeDTO((INodePO)iteratePO.getDoBranch());
        this.fillContainer(container, (INodePO)iteratePO.getDoBranch());
        iterateDTO.addNode(container);
        this.addParamDesc(iterateDTO, (IParameterInterfacePO)iteratePO);
        this.addTestDataManager(iterateDTO, (IParameterInterfacePO)iteratePO);
    }

    private void addParamDesc(ParameterDTO paramDTO, IParameterInterfacePO paramInterfacePO) {
        for (IParamDescriptionPO paramPO : paramInterfacePO.getParameterList()) {
            ParamDescriptionDTO pdDTO = new ParamDescriptionDTO();
            this.fillParamDescription(pdDTO, paramPO);
            paramDTO.addParameterDescription(pdDTO);
        }
    }

    private void addTestDataManager(ParameterDTO paramDTO, IParameterInterfacePO nodePO) {
        ITDManager dataManager;
        paramDTO.setDatafile(nodePO.getDataFile());
        if (nodePO.getReferencedDataCube() != null) {
            paramDTO.setReferencedTestData(nodePO.getReferencedDataCube().getName());
        }
        if ((dataManager = nodePO.getDataManager()) != null && nodePO.getReferencedDataCube() == null) {
            TDManagerDTO tdmDTO = new TDManagerDTO();
            this.fillTDManager(tdmDTO, dataManager);
            paramDTO.setTDManager(tdmDTO);
        }
    }

    private void fillWhileStatment(WhileDTO whileDTO, ICondStructPO whilePO, boolean isDoFirst) {
        whileDTO.setNegated(whilePO.isNegate());
        NodeDTO container = new NodeDTO((INodePO)whilePO.getDoBranch());
        this.fillContainer(container, (INodePO)whilePO.getDoBranch());
        NodeDTO whileContainer = new NodeDTO((INodePO)whilePO.getCondition());
        this.fillContainer(whileContainer, (INodePO)whilePO.getCondition());
        whileDTO.setDoWhile(isDoFirst);
        whileDTO.addNode(container);
        whileDTO.addNode(whileContainer);
    }

    private void fillConditionalStatement(ConditionalStatementDTO conDTO, IConditionalStatementPO po) {
        conDTO.setNegated(po.isNegate());
        NodeDTO container = new NodeDTO((INodePO)po.getCondition());
        this.fillContainer(container, (INodePO)po.getCondition());
        conDTO.addNode(container);
        container = new NodeDTO((INodePO)po.getThenBranch());
        this.fillContainer(container, (INodePO)po.getThenBranch());
        conDTO.addNode(container);
        container = new NodeDTO((INodePO)po.getElseBranch());
        this.fillContainer(container, (INodePO)po.getElseBranch());
        conDTO.addNode(container);
    }

    private void fillContainer(NodeDTO container, INodePO po) {
        for (INodePO node : po.getUnmodifiableNodeList()) {
            if (node instanceof ICapPO) {
                ICapPO capPO = (ICapPO)node;
                CapDTO capDTO = new CapDTO((INodePO)capPO);
                this.fillCap(capDTO, capPO);
                container.addNode(capDTO);
                continue;
            }
            if (node instanceof IExecTestCasePO) {
                IExecTestCasePO tcPO = (IExecTestCasePO)node;
                RefTestCaseDTO refTestCaseDTO = new RefTestCaseDTO((INodePO)tcPO);
                this.fillRefTestCase(refTestCaseDTO, tcPO);
                container.addNode(refTestCaseDTO);
                continue;
            }
            if (!(node instanceof ICommentPO)) continue;
            ICommentPO commentPO = (ICommentPO)node;
            CommentDTO commentDTO = new CommentDTO(commentPO);
            container.addNode(commentDTO);
        }
    }

    private void fillCap(CapDTO capDTO, ICapPO po) {
        capDTO.setActionName(po.getActionName());
        capDTO.setComponentName(po.getComponentName());
        capDTO.setComponentType(po.getComponentType());
        capDTO.setDatafile(po.getDataFile());
        TDManagerDTO tdmDTO = new TDManagerDTO();
        this.fillTDManager(tdmDTO, po.getDataManager());
        capDTO.setTDManager(tdmDTO);
        for (IParamDescriptionPO desc : po.getParameterList()) {
            ParamDescriptionDTO pdDTO = new ParamDescriptionDTO();
            this.fillParamDescription(pdDTO, desc);
            capDTO.addParameterDescription(pdDTO);
        }
    }

    private void fillRefTestCase(RefTestCaseDTO rtcDTO, IExecTestCasePO po) {
        ITDManager dataManager;
        String execName = po.getRealName();
        if (execName == null) {
            execName = "";
        }
        if (po.getSpecTestCase() != null) {
            String specName = po.getSpecTestCase().getName();
            if (execName.equals(specName)) {
                rtcDTO.setName(null);
            } else {
                rtcDTO.setName(execName);
            }
        } else {
            rtcDTO.setName(execName);
        }
        rtcDTO.setTestcaseUuid(po.getSpecTestCaseGuid());
        if (po.getProjectGuid() != null) {
            rtcDTO.setProjectUuid(po.getProjectGuid());
        }
        rtcDTO.setHasOwnTestdata(!po.getHasReferencedTD());
        rtcDTO.setDatafile(po.getDataFile());
        if (po.getReferencedDataCube() != null) {
            rtcDTO.setReferencedTestData(po.getReferencedDataCube().getName());
        }
        if (!po.getHasReferencedTD() && (dataManager = po.getDataManager()) != null && po.getReferencedDataCube() == null) {
            TDManagerDTO tdmDTO = new TDManagerDTO();
            this.fillTDManager(tdmDTO, dataManager);
            rtcDTO.setTDManager(tdmDTO);
        }
        for (ICompNamesPairPO name : po.getCompNamesPairs()) {
            ComponentNamesPairDTO compNameDTO = new ComponentNamesPairDTO();
            compNameDTO.setOriginalName(name.getFirstName());
            compNameDTO.setNewName(name.getSecondName());
            compNameDTO.setPropagated(name.isPropagated());
            rtcDTO.addOverriddenNames(compNameDTO);
        }
    }

    private void fillEventTestCase(EventTestCaseDTO evDTO, IEventExecTestCasePO po) {
        this.fillRefTestCase(evDTO, (IExecTestCasePO)po);
        evDTO.setEventType(po.getEventType());
        ReentryProperty reentryProp = po.getReentryProp();
        if (reentryProp != null) {
            Integer maxRetries;
            evDTO.setReentryProperty(reentryProp.getName());
            if (reentryProp == ReentryProperty.RETRY && (maxRetries = po.getMaxRetries()) != null) {
                evDTO.setMaxRetries(maxRetries);
            }
        }
    }

    private void handleExecPersistables() throws OperationCanceledException {
        for (INodePO tsOrTjOrCat : this.m_project.getUnmodExecList()) {
            ImportExportUtil.checkCancel(this.m_monitor);
            if (tsOrTjOrCat instanceof ICategoryPO) {
                ExecCategoryDTO eCatDTO = new ExecCategoryDTO(tsOrTjOrCat);
                this.fillCategory(eCatDTO, (ICategoryPO)tsOrTjOrCat);
                this.m_projectDTO.addExecCategorie(eCatDTO);
                continue;
            }
            if (tsOrTjOrCat instanceof ITestSuitePO) {
                TestSuiteDTO tsDTO = new TestSuiteDTO(tsOrTjOrCat);
                this.fillTestsuite(tsDTO, (ITestSuitePO)tsOrTjOrCat);
                this.m_projectDTO.addExecCategorie(tsDTO);
                continue;
            }
            TestJobDTO tjDTO = new TestJobDTO(tsOrTjOrCat);
            this.fillTestJob(tjDTO, (ITestJobPO)tsOrTjOrCat);
            this.m_projectDTO.addExecCategorie(tjDTO);
        }
    }

    private void fillCategory(ExecCategoryDTO execCatDTO, ICategoryPO po) {
        for (INodePO o : po.getUnmodifiableNodeList()) {
            if (o instanceof ICategoryPO) {
                ExecCategoryDTO eCatDTO = new ExecCategoryDTO(o);
                this.fillCategory(eCatDTO, (ICategoryPO)o);
                execCatDTO.addNode(eCatDTO);
                continue;
            }
            if (o instanceof ITestSuitePO) {
                TestSuiteDTO tsDTO = new TestSuiteDTO(o);
                this.fillTestsuite(tsDTO, (ITestSuitePO)o);
                execCatDTO.addNode(tsDTO);
                continue;
            }
            TestJobDTO tjDTO = new TestJobDTO(o);
            this.fillTestJob(tjDTO, (ITestJobPO)o);
            execCatDTO.addNode(tjDTO);
        }
    }

    private void fillTestsuite(TestSuiteDTO tsDTO, ITestSuitePO po) {
        if (po.getAut() != null) {
            tsDTO.setSelectedAut(ImportExportUtil.i2str(po.getAut().getId()));
        } else {
            tsDTO.setSelectedAut(null);
        }
        tsDTO.setStepDelay(po.getStepDelay());
        tsDTO.setRelevant(po.getRelevant());
        for (Object o : po.getUnmodifiableNodeList()) {
            if (o instanceof IExecTestCasePO) {
                IExecTestCasePO tc = (IExecTestCasePO)o;
                RefTestCaseDTO rtcDTO = new RefTestCaseDTO((INodePO)tc);
                this.fillRefTestCase(rtcDTO, tc);
                tsDTO.addUsedTestCase(rtcDTO);
                continue;
            }
            if (o instanceof ICommentPO) {
                ICommentPO commentPO = (ICommentPO)o;
                CommentDTO commentDTO = new CommentDTO(commentPO);
                tsDTO.addUsedTestCase(commentDTO);
                continue;
            }
            if (o instanceof IConditionalStatementPO) {
                IConditionalStatementPO conPO = (IConditionalStatementPO)o;
                ConditionalStatementDTO conDTO = new ConditionalStatementDTO((INodePO)conPO);
                this.fillConditionalStatement(conDTO, conPO);
                tsDTO.addUsedTestCase(conDTO);
                continue;
            }
            if (o instanceof IIteratePO) {
                IIteratePO iteratePO = (IIteratePO)o;
                IterateDTO iterateDTO = new IterateDTO((INodePO)iteratePO);
                this.fillIterateStatment(iterateDTO, iteratePO);
                tsDTO.addUsedTestCase(iterateDTO);
                continue;
            }
            if (!(o instanceof IWhileDoPO) && !(o instanceof IDoWhilePO)) continue;
            ICondStructPO condStructPO = (ICondStructPO)o;
            WhileDTO whileDoDTO = new WhileDTO((INodePO)o);
            if (condStructPO instanceof IDoWhilePO) {
                this.fillWhileStatment(whileDoDTO, condStructPO, true);
            } else {
                this.fillWhileStatment(whileDoDTO, condStructPO, false);
            }
            tsDTO.addUsedTestCase(whileDoDTO);
        }
        for (Object o : po.getDefaultEventHandler().keySet()) {
            String eventType = (String)o;
            Integer evProp = (Integer)po.getDefaultEventHandler().get(eventType);
            try {
                ReentryProperty reentryProperty = ReentryProperty.getProperty((Integer)evProp);
                DefaultEventHandlerDTO ehDTO = new DefaultEventHandlerDTO();
                ehDTO.setEvent(eventType);
                ehDTO.setReentryProperty(reentryProperty.getName());
                if (reentryProperty == ReentryProperty.RETRY) {
                    ehDTO.setMaxRetries(1);
                }
                tsDTO.addEventHandler(ehDTO);
            }
            catch (InvalidDataException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void fillTestJob(TestJobDTO tjDTO, ITestJobPO tj) {
        for (INodePO child : tj.getUnmodifiableNodeList()) {
            if (child instanceof IRefTestSuitePO) {
                IRefTestSuitePO rts = (IRefTestSuitePO)child;
                RefTestSuiteDTO rtsDTO = new RefTestSuiteDTO(rts);
                rtsDTO.setName(rts.getRealName());
                rtsDTO.setUuid(rts.getGuid());
                rtsDTO.setTsUuid(rts.getTestSuiteGuid());
                rtsDTO.setAutId(rts.getTestSuiteAutID());
                tjDTO.addRefTestSuite(rtsDTO);
                continue;
            }
            if (!(child instanceof ICommentPO)) continue;
            tjDTO.addComment(new CommentDTO((ICommentPO)child));
        }
    }

    private void handleReusedProjects() {
        for (IReusedProjectPO reusedProject : this.m_project.getUsedProjects()) {
            ReusedProjectDTO rpDTO = new ReusedProjectDTO();
            this.fillReusedProject(rpDTO, reusedProject);
            this.m_projectDTO.addReusedProject(rpDTO);
        }
        this.m_monitor.worked(1);
    }

    private void fillReusedProject(ReusedProjectDTO rpDTO, IReusedProjectPO po) {
        rpDTO.setProjectName(ProjectNameBP.getInstance().getName(po.getProjectGuid()));
        rpDTO.setProjectUuid(po.getProjectGuid());
        if (po.getMajorNumber() != null) {
            rpDTO.setMajorProjectVersion(po.getMajorNumber());
        }
        if (po.getMinorNumber() != null) {
            rpDTO.setMinorProjectVersion(po.getMinorNumber());
        }
        if (po.getMicroNumber() != null) {
            rpDTO.setMicroProjectVersion(po.getMicroNumber());
        }
        rpDTO.setProjectVersionQualifier(po.getVersionQualifier());
    }

    private List<TestresultSummaryDTO> getTestResultSummaryDTOs(List<ITestResultSummaryPO> poSummaryList) {
        ArrayList<TestresultSummaryDTO> resultDTO = new ArrayList<TestresultSummaryDTO>();
        for (ITestResultSummaryPO poSummary : poSummaryList) {
            if (!poSummary.isTestsuiteRelevant()) continue;
            TestresultSummaryDTO trsDTO = new TestresultSummaryDTO(poSummary);
            Map tmpMap = poSummary.getMonitoringValues();
            for (Map.Entry pairs : tmpMap.entrySet()) {
                IMonitoringValue tmp = (IMonitoringValue)pairs.getValue();
                MonitoringValuesDTO monValDTO = new MonitoringValuesDTO();
                monValDTO.setKey((String)pairs.getKey());
                monValDTO.setCategory(tmp.getCategory());
                monValDTO.setSignificant(tmp.isSignificant());
                monValDTO.setType(tmp.getType());
                monValDTO.setValue(tmp.getValue());
                trsDTO.addMonitoringValue(monValDTO);
            }
            resultDTO.add(trsDTO);
        }
        return resultDTO;
    }

    private void setProjectVersions() {
        this.m_projectDTO.setMetaDataVersion(this.m_project.getClientMetaDataVersion());
        if (this.m_project.getMajorProjectVersion() != null) {
            this.m_projectDTO.setMajorProjectVersion(this.m_project.getMajorProjectVersion());
        }
        if (this.m_project.getMinorProjectVersion() != null) {
            this.m_projectDTO.setMinorProjectVersion(this.m_project.getMinorProjectVersion());
        }
        if (this.m_project.getMicroProjectVersion() != null) {
            this.m_projectDTO.setMicroProjectVersion(this.m_project.getMicroProjectVersion());
        }
        this.m_projectDTO.setProjectVersionQualifier(this.m_project.getProjectVersionQualifier());
    }

    private void fillTrackingConfig(IProjectPropertiesPO projectProperties) {
        Integer trackChangesSpan;
        this.m_projectDTO.setTrackingEnabled(projectProperties.getIsTrackingActivated());
        this.m_projectDTO.setTrackingAttribute(projectProperties.getTrackChangesSignature());
        TrackingUnit trackChangesUnit = projectProperties.getTrackChangesUnit();
        if (trackChangesUnit != null) {
            this.m_projectDTO.setTrackingUnit(trackChangesUnit.toString());
        }
        if ((trackChangesSpan = projectProperties.getTrackChangesSpan()) != null) {
            this.m_projectDTO.setTrackingSpan(trackChangesSpan);
        }
    }

    private List<IAUTMainPO> getSortedAutList(IProjectPO po) {
        ArrayList<IAUTMainPO> sortedAuts = new ArrayList<IAUTMainPO>(po.getAutMainList());
        Collections.sort(sortedAuts, new Comparator<IAUTMainPO>(){

            @Override
            public int compare(IAUTMainPO aut1, IAUTMainPO aut2) {
                return aut1.getGuid().compareTo(aut2.getGuid());
            }
        });
        return sortedAuts;
    }

    public static int getPredictedWork(IProjectPO project, boolean includeTestResultSummaries) {
        int work = 0;
        ++work;
        ++work;
        ++work;
        if (includeTestResultSummaries) {
            try {
                work = (int)((long)work + TestResultSummaryPM.countOfTestResultSummaries((IProjectPO)project, null));
            }
            catch (PMException pMException) {
                // empty catch block
            }
        }
        ++work;
        ++work;
        return ++work;
    }
}

