/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.sync;

import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import java.util.Map;
import org.eclipse.papyrus.infra.sync.SyncBucket;
import org.eclipse.papyrus.infra.sync.SyncItem;
import org.eclipse.papyrus.infra.sync.SyncObject;
import org.eclipse.papyrus.infra.sync.service.ISyncService;
import org.eclipse.papyrus.infra.sync.service.SyncServiceRunnable;

public abstract class SyncRegistry<M, T, X>
extends SyncObject {
    private final Class<M> modelType;
    private final Class<T> backendType;
    private final Map<M, SyncBucket<M, T, X>> buckets;

    public SyncRegistry() {
        TypeToken modelType = new TypeToken<M>(this.getClass()){};
        this.modelType = modelType.getRawType();
        TypeToken backendType = new TypeToken<T>(this.getClass()){};
        this.backendType = backendType.getRawType();
        this.buckets = Maps.newLinkedHashMap();
    }

    public final Class<M> getModelType() {
        return this.modelType;
    }

    public final Class<T> getBackendType() {
        return this.backendType;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    protected abstract M getModelOf(T var1);

    public SyncBucket<M, T, X> getBucket(M model) {
        SyncBucket<M, T, X> result = this.buckets.get(model);
        if (result != null && !result.isActive()) {
            this.buckets.remove(result);
            result = null;
        }
        return result;
    }

    public void register(SyncBucket<M, T, X> bucket) {
        if (!bucket.isActive()) {
            return;
        }
        this.buckets.put(bucket.getModel(), bucket);
    }

    public void unregister(SyncBucket<M, T, X> bucket) {
        if (!bucket.isActive()) {
            return;
        }
        this.buckets.remove(bucket.getModel());
    }

    public boolean isSynchronized(T element) {
        SyncBucket<M, T, X> bucket = this.getBucketFor(element);
        if (bucket == null) {
            return false;
        }
        return bucket.get(element) != null;
    }

    public void synchronize(final T element) {
        final SyncBucket<M, T, X> bucket = this.getBucketFor(element);
        if (bucket == null) {
            return;
        }
        this.run(new SyncServiceRunnable.Safe<SyncItem<M, T>>(){

            @Override
            public SyncItem<M, T> run(ISyncService syncService) {
                return bucket.add(element);
            }
        });
    }

    public void desynchronize(final T element) {
        final SyncBucket<M, T, X> bucket = this.getBucketFor(element);
        if (bucket == null) {
            return;
        }
        this.run(new SyncServiceRunnable.Safe<SyncItem<M, T>>(){

            @Override
            public SyncItem<M, T> run(ISyncService syncService) {
                return bucket.remove(element);
            }
        });
    }

    public boolean synchronizes(T backEnd, M model) {
        SyncBucket<M, T, X> bucket = this.buckets.get(model);
        return bucket != null && bucket.synchronizes(backEnd);
    }

    public SyncBucket<M, T, X> getBucketFor(T element) {
        if (element == null) {
            return null;
        }
        M frontend = this.getModelOf(element);
        if (frontend == null) {
            return null;
        }
        return this.getBucket(frontend);
    }
}

