/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.tools.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class Iterables2 {
    private Iterables2() {
    }

    public static <T> List<T> topoSort(Iterable<T> items, Comparator<? super T> partOrder) {
        LinkedList unsorted = Lists.newLinkedList(items);
        ArrayList result = Lists.newArrayListWithCapacity((int)unsorted.size());
        while (!unsorted.isEmpty()) {
            Object min = unsorted.remove(0);
            ListIterator iter = unsorted.listIterator();
            while (iter.hasNext()) {
                Object next = iter.next();
                if (partOrder.compare(next, min) >= 0) continue;
                iter.set(min);
                min = next;
            }
            result.add(min);
        }
        return result;
    }
}

