/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.emf.dialog;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class NestedEditingDialogContext {
    private static final NestedEditingDialogContext INSTANCE = new NestedEditingDialogContext();
    private final ThreadLocal<Integer> nesting = new ThreadLocal();
    private final ThreadLocal<ResourceSet> resourceSet = new ThreadLocal();

    public static NestedEditingDialogContext getInstance() {
        return INSTANCE;
    }

    public boolean isNested() {
        Integer depth = this.nesting.get();
        return depth != null && depth > 0;
    }

    public void enter() {
        Integer depth = this.nesting.get();
        depth = depth == null || depth < 1 ? Integer.valueOf(1) : Integer.valueOf(depth + 1);
        this.nesting.set(depth);
    }

    public void exit() {
        Integer depth = this.nesting.get();
        if (depth != null) {
            depth = depth <= 1 ? null : Integer.valueOf(depth - 1);
            this.nesting.set(depth);
        }
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet.get();
    }

    public ResourceSet push(Object context) {
        ResourceSet current;
        Resource res;
        ResourceSet previous = this.resourceSet.get();
        if (context instanceof EObject && (res = ((EObject)context).eResource()) != null && (current = res.getResourceSet()) != null) {
            this.resourceSet.set(current);
        }
        return previous;
    }

    public void pop(ResourceSet previous) {
        if (previous == null) {
            this.resourceSet.remove();
        } else {
            this.resourceSet.set(previous);
        }
    }
}

