/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.core.model.index;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.rcptt.core.model.search.SearchPattern;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.core.model.index.QueryResult;
import org.eclipse.rcptt.internal.core.model.index.ReadWriteMonitor;
import org.eclipse.rcptt.util.FileUtil;

public class Index {
    private static final String CURRENT_VERSION = "INDEX_ID_1.0.3";
    public ReadWriteMonitor monitor;
    private File indexFile;
    private Map<String, Entry> docToEnties = new HashMap<String, Entry>();
    private Map<String, String> pathToIDCache = new HashMap<String, String>();
    private Map<String, List<String>> idToPathCache = new HashMap<String, List<String>>();
    private Map<String, String> pathToNameCache = new HashMap<String, String>();
    private int changes = 0;
    private IPath path;

    public Index(IPath fullPath) {
        this.path = fullPath;
        this.monitor = new ReadWriteMonitor();
        this.indexFile = RcpttPlugin.getDefault().getStateLocation().append("index").append(String.valueOf(FileUtil.getID((String)fullPath.toString())) + ".index").toFile();
        this.indexFile.getParentFile().mkdirs();
    }

    public synchronized void load() {
        block7: {
            this.docToEnties.clear();
            if (this.indexFile.exists()) {
                DataInputStream din = null;
                try {
                    try {
                        din = new DataInputStream(new BufferedInputStream(new FileInputStream(this.indexFile)));
                        String id = din.readUTF();
                        if (id.equals(CURRENT_VERSION)) {
                            this.readIndex_1_0(din);
                        }
                    }
                    catch (IOException e) {
                        RcpttPlugin.log(e);
                        FileUtil.safeClose(din);
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    FileUtil.safeClose(din);
                    throw throwable;
                }
                FileUtil.safeClose((Closeable)din);
            }
        }
    }

    private void readIndex_1_0(DataInputStream din) throws IOException {
        int entriesCount = din.readInt();
        int i = 0;
        while (i < entriesCount) {
            Entry entry = new Entry();
            entry.path = din.readUTF();
            entry.timestamp = din.readLong();
            int keysCount = din.readInt();
            int j = 0;
            while (j < keysCount) {
                String key = din.readUTF();
                ArrayList<String> values = new ArrayList<String>();
                int valuesCount = din.readInt();
                int k = 0;
                while (k < valuesCount) {
                    values.add(din.readUTF());
                    ++k;
                }
                entry.keys.put(key, values);
                if ("id".equals(key) && values.size() == 1) {
                    this.pathToIDCache.put(entry.path, (String)values.get(0));
                    this.updateIdToPath(entry.path, (String)values.get(0));
                }
                if ("name".equals(key) && values.size() == 1) {
                    this.pathToNameCache.put(entry.path, (String)values.get(0));
                }
                ++j;
            }
            this.docToEnties.put(entry.path, entry);
            ++i;
        }
    }

    private void writeIndex_1_0(DataOutputStream dout) throws IOException {
        dout.writeUTF(CURRENT_VERSION);
        ArrayList<String> keySet = new ArrayList<String>(this.docToEnties.keySet());
        int entriesCount = this.docToEnties.size();
        dout.writeInt(entriesCount);
        int i = 0;
        while (i < entriesCount) {
            Entry entry = this.docToEnties.get(keySet.get(i));
            dout.writeUTF(entry.path);
            dout.writeLong(entry.timestamp);
            int keysCount = entry.keys.size();
            dout.writeInt(keysCount);
            ArrayList<String> eKeys = new ArrayList<String>(entry.keys.keySet());
            int j = 0;
            while (j < keysCount) {
                String key = (String)eKeys.get(j);
                dout.writeUTF(key);
                List<String> values = entry.keys.get(key);
                int valuesCount = values.size();
                dout.writeInt(valuesCount);
                int k = 0;
                while (k < valuesCount) {
                    dout.writeUTF(values.get(k));
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public synchronized String[] queryDocumentNames() {
        Set<String> names = this.docToEnties.keySet();
        return names.toArray(new String[names.size()]);
    }

    public synchronized void remove(String path) {
        ++this.changes;
        this.docToEnties.remove(path);
        String id = this.pathToIDCache.remove(path);
        this.pathToNameCache.remove(path);
        List<String> list = this.idToPathCache.get(id);
        if (list != null) {
            list.remove(path);
            if (list.isEmpty()) {
                this.idToPathCache.remove(id);
            }
        }
    }

    public synchronized void save() throws IOException {
        if (this.changes == 0 && this.indexFile.exists()) {
            return;
        }
        if (this.docToEnties.isEmpty() && this.indexFile.exists()) {
            this.indexFile.delete();
        }
        DataOutputStream dout = null;
        try {
            dout = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.indexFile)));
            this.writeIndex_1_0(dout);
        }
        catch (Throwable throwable) {
            FileUtil.safeClose(dout);
            throw throwable;
        }
        FileUtil.safeClose((Closeable)dout);
        this.changes = 0;
    }

    public synchronized void dispose() {
        this.docToEnties.clear();
        if (this.indexFile.exists()) {
            this.indexFile.delete();
        }
    }

    public synchronized void addKey(String path, String key, String value) {
        if (this.changes >= 2500) {
            try {
                this.save();
            }
            catch (IOException e) {
                RcpttPlugin.log(e);
            }
        }
        ++this.changes;
        this.getEntry(path).addKey(key, value);
        if ("id".equals(key)) {
            this.pathToIDCache.put(path, value);
            this.updateIdToPath(path, value);
        }
        if ("name".equals(key)) {
            this.pathToNameCache.put(path, value);
        }
    }

    private void updateIdToPath(String path, String id) {
        List<String> list = this.idToPathCache.get(id);
        if (list == null) {
            list = new ArrayList<String>();
            this.idToPathCache.put(id, list);
        }
        if (!list.contains(path)) {
            list.add(path);
        }
    }

    private Entry getEntry(String path) {
        Entry entry = this.docToEnties.get(path);
        if (entry == null) {
            entry = new Entry();
            entry.path = path;
            this.docToEnties.put(path, entry);
        }
        return entry;
    }

    public synchronized void updateModificationstamp(String path, long stamp) {
        ++this.changes;
        this.getEntry((String)path).timestamp = stamp;
    }

    public synchronized long getModificationStamp(String path) {
        return this.getEntry((String)path).timestamp;
    }

    public synchronized List<QueryResult> queryIDs(String id) {
        ArrayList<QueryResult> result = new ArrayList<QueryResult>();
        List<String> list = this.idToPathCache.get(id);
        if (list == null) {
            return result;
        }
        for (String path : list) {
            result.add(new QueryResult(path, "id", id));
        }
        return result;
    }

    public synchronized String queryID(String path) {
        return this.pathToIDCache.get(path);
    }

    public synchronized String queryName(String path) {
        return this.pathToNameCache.get(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<QueryResult> query(String[] keys, SearchPattern.IKeyQuery pattern, IProgressMonitor monitor) {
        ArrayList<QueryResult> results = new ArrayList<QueryResult>();
        for (Map.Entry<String, Entry> entry : this.docToEnties.entrySet()) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            Entry value = entry.getValue();
            String[] stringArray = keys;
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                String k = stringArray[n2];
                List<String> list = value.keys.get(k);
                if (list != null) {
                    for (String val : list) {
                        if (!pattern.accept(k, val)) continue;
                        ArrayList<QueryResult> arrayList = results;
                        synchronized (arrayList) {
                            results.add(new QueryResult(entry.getKey(), k, val));
                        }
                    }
                }
                ++n2;
            }
        }
        return results;
    }

    public IPath getPath() {
        return this.path;
    }

    public synchronized Map<String, List<String>> query(String documentName) {
        Entry entry = this.getEntry(documentName);
        HashMap<String, List<String>> copy = new HashMap<String, List<String>>();
        Set<Map.Entry<String, List<String>>> entrySet = entry.keys.entrySet();
        for (Map.Entry<String, List<String>> entryValue : entrySet) {
            copy.put(entryValue.getKey(), new ArrayList(entryValue.getValue()));
        }
        return copy;
    }

    private static class Entry {
        Map<String, List<String>> keys = new HashMap<String, List<String>>();
        String path;
        long timestamp = -1L;

        private Entry() {
        }

        public void addKey(String key, String value) {
            List<String> list = this.keys.get(key);
            if (list == null) {
                list = new ArrayList<String>();
                this.keys.put(key, list);
            }
            if (!list.contains(value)) {
                list.add(value);
            }
        }
    }
}

