/*******************************************************************************
 * Copyright (c) 2010-2018, Zoltan Ujhelyi, Istvan Rath and Daniel Varro
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-v20.html.
 * 
 * SPDX-License-Identifier: EPL-2.0
 *
 * This file was generated from EMFPatternLanguage.xtext
 *******************************************************************************/
package org.eclipse.viatra.query.patternlanguage.emf.services;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.EnumLiteralDeclaration;
import org.eclipse.xtext.EnumRule;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Group;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.UnorderedGroup;
import org.eclipse.xtext.service.AbstractElementFinder.AbstractEnumRuleElementFinder;
import org.eclipse.xtext.service.AbstractElementFinder.AbstractGrammarElementFinder;
import org.eclipse.xtext.service.GrammarProvider;
import org.eclipse.xtext.xbase.services.XbaseGrammarAccess;
import org.eclipse.xtext.xbase.services.XtypeGrammarAccess;

@Singleton
public class EMFPatternLanguageGrammarAccess extends AbstractGrammarElementFinder {
	
	public class PatternModelElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.viatra.query.patternlanguage.emf.EMFPatternLanguage.PatternModel");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Group cGroup_0 = (Group)cGroup.eContents().get(0);
		private final Keyword cPackageKeyword_0_0 = (Keyword)cGroup_0.eContents().get(0);
		private final Assignment cPackageNameAssignment_0_1 = (Assignment)cGroup_0.eContents().get(1);
		private final RuleCall cPackageNameQualifiedNameParserRuleCall_0_1_0 = (RuleCall)cPackageNameAssignment_0_1.eContents().get(0);
		private final Keyword cSemicolonKeyword_0_2 = (Keyword)cGroup_0.eContents().get(2);
		private final Assignment cImportPackagesAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cImportPackagesVQLImportSectionParserRuleCall_1_0 = (RuleCall)cImportPackagesAssignment_1.eContents().get(0);
		private final Assignment cPatternsAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cPatternsPatternParserRuleCall_2_0 = (RuleCall)cPatternsAssignment_2.eContents().get(0);
		
		//PatternModel:
		//	('package' packageName=QualifiedName ';'?)?
		//	importPackages=VQLImportSection patterns+=Pattern*;
		@Override public ParserRule getRule() { return rule; }
		
		//('package' packageName=QualifiedName ';'?)? importPackages=VQLImportSection patterns+=Pattern*
		public Group getGroup() { return cGroup; }
		
		//('package' packageName=QualifiedName ';'?)?
		public Group getGroup_0() { return cGroup_0; }
		
		//'package'
		public Keyword getPackageKeyword_0_0() { return cPackageKeyword_0_0; }
		
		//packageName=QualifiedName
		public Assignment getPackageNameAssignment_0_1() { return cPackageNameAssignment_0_1; }
		
		//QualifiedName
		public RuleCall getPackageNameQualifiedNameParserRuleCall_0_1_0() { return cPackageNameQualifiedNameParserRuleCall_0_1_0; }
		
		//';'?
		public Keyword getSemicolonKeyword_0_2() { return cSemicolonKeyword_0_2; }
		
		//importPackages=VQLImportSection
		public Assignment getImportPackagesAssignment_1() { return cImportPackagesAssignment_1; }
		
		//VQLImportSection
		public RuleCall getImportPackagesVQLImportSectionParserRuleCall_1_0() { return cImportPackagesVQLImportSectionParserRuleCall_1_0; }
		
		//patterns+=Pattern*
		public Assignment getPatternsAssignment_2() { return cPatternsAssignment_2; }
		
		//Pattern
		public RuleCall getPatternsPatternParserRuleCall_2_0() { return cPatternsPatternParserRuleCall_2_0; }
	}
	public class VQLImportSectionElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.viatra.query.patternlanguage.emf.EMFPatternLanguage.VQLImportSection");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cVQLImportSectionAction_0 = (Action)cGroup.eContents().get(0);
		private final Alternatives cAlternatives_1 = (Alternatives)cGroup.eContents().get(1);
		private final Assignment cPackageImportAssignment_1_0 = (Assignment)cAlternatives_1.eContents().get(0);
		private final RuleCall cPackageImportPackageImportParserRuleCall_1_0_0 = (RuleCall)cPackageImportAssignment_1_0.eContents().get(0);
		private final Assignment cPatternImportAssignment_1_1 = (Assignment)cAlternatives_1.eContents().get(1);
		private final RuleCall cPatternImportPatternImportParserRuleCall_1_1_0 = (RuleCall)cPatternImportAssignment_1_1.eContents().get(0);
		private final Assignment cImportDeclarationsAssignment_1_2 = (Assignment)cAlternatives_1.eContents().get(2);
		private final RuleCall cImportDeclarationsXImportDeclarationParserRuleCall_1_2_0 = (RuleCall)cImportDeclarationsAssignment_1_2.eContents().get(0);
		
		//VQLImportSection:
		//	{VQLImportSection} (packageImport+=PackageImport | patternImport+=PatternImport |
		//	importDeclarations+=XImportDeclaration)*;
		@Override public ParserRule getRule() { return rule; }
		
		//{VQLImportSection} (packageImport+=PackageImport | patternImport+=PatternImport |
		//importDeclarations+=XImportDeclaration)*
		public Group getGroup() { return cGroup; }
		
		//{VQLImportSection}
		public Action getVQLImportSectionAction_0() { return cVQLImportSectionAction_0; }
		
		//(packageImport+=PackageImport | patternImport+=PatternImport | importDeclarations+=XImportDeclaration)*
		public Alternatives getAlternatives_1() { return cAlternatives_1; }
		
		//packageImport+=PackageImport
		public Assignment getPackageImportAssignment_1_0() { return cPackageImportAssignment_1_0; }
		
		//PackageImport
		public RuleCall getPackageImportPackageImportParserRuleCall_1_0_0() { return cPackageImportPackageImportParserRuleCall_1_0_0; }
		
		//patternImport+=PatternImport
		public Assignment getPatternImportAssignment_1_1() { return cPatternImportAssignment_1_1; }
		
		//PatternImport
		public RuleCall getPatternImportPatternImportParserRuleCall_1_1_0() { return cPatternImportPatternImportParserRuleCall_1_1_0; }
		
		//importDeclarations+=XImportDeclaration
		public Assignment getImportDeclarationsAssignment_1_2() { return cImportDeclarationsAssignment_1_2; }
		
		//XImportDeclaration
		public RuleCall getImportDeclarationsXImportDeclarationParserRuleCall_1_2_0() { return cImportDeclarationsXImportDeclarationParserRuleCall_1_2_0; }
	}
	public class PackageImportElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.viatra.query.patternlanguage.emf.EMFPatternLanguage.PackageImport");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cImportKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Keyword cEpackageKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cEPackageAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final CrossReference cEPackageEPackageCrossReference_2_0 = (CrossReference)cEPackageAssignment_2.eContents().get(0);
		private final RuleCall cEPackageEPackageSTRINGTerminalRuleCall_2_0_1 = (RuleCall)cEPackageEPackageCrossReference_2_0.eContents().get(1);
		private final Group cGroup_3 = (Group)cGroup.eContents().get(3);
		private final Keyword cAsKeyword_3_0 = (Keyword)cGroup_3.eContents().get(0);
		private final Assignment cAliasAssignment_3_1 = (Assignment)cGroup_3.eContents().get(1);
		private final RuleCall cAliasIDTerminalRuleCall_3_1_0 = (RuleCall)cAliasAssignment_3_1.eContents().get(0);
		private final Keyword cSemicolonKeyword_4 = (Keyword)cGroup.eContents().get(4);
		
		//PackageImport:
		//	'import' 'epackage'? ePackage=[ecore::EPackage|STRING] ('as' alias=ID)? ';'?;
		@Override public ParserRule getRule() { return rule; }
		
		//'import' 'epackage'? ePackage=[ecore::EPackage|STRING] ('as' alias=ID)? ';'?
		public Group getGroup() { return cGroup; }
		
		//'import'
		public Keyword getImportKeyword_0() { return cImportKeyword_0; }
		
		//'epackage'?
		public Keyword getEpackageKeyword_1() { return cEpackageKeyword_1; }
		
		//ePackage=[ecore::EPackage|STRING]
		public Assignment getEPackageAssignment_2() { return cEPackageAssignment_2; }
		
		//[ecore::EPackage|STRING]
		public CrossReference getEPackageEPackageCrossReference_2_0() { return cEPackageEPackageCrossReference_2_0; }
		
		//STRING
		public RuleCall getEPackageEPackageSTRINGTerminalRuleCall_2_0_1() { return cEPackageEPackageSTRINGTerminalRuleCall_2_0_1; }
		
		//('as' alias=ID)?
		public Group getGroup_3() { return cGroup_3; }
		
		//'as'
		public Keyword getAsKeyword_3_0() { return cAsKeyword_3_0; }
		
		//alias=ID
		public Assignment getAliasAssignment_3_1() { return cAliasAssignment_3_1; }
		
		//ID
		public RuleCall getAliasIDTerminalRuleCall_3_1_0() { return cAliasIDTerminalRuleCall_3_1_0; }
		
		//';'?
		public Keyword getSemicolonKeyword_4() { return cSemicolonKeyword_4; }
	}
	public class PatternImportElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.viatra.query.patternlanguage.emf.EMFPatternLanguage.PatternImport");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cImportKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Keyword cPatternKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cPatternAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final CrossReference cPatternPatternCrossReference_2_0 = (CrossReference)cPatternAssignment_2.eContents().get(0);
		private final RuleCall cPatternPatternQualifiedNameParserRuleCall_2_0_1 = (RuleCall)cPatternPatternCrossReference_2_0.eContents().get(1);
		private final Keyword cSemicolonKeyword_3 = (Keyword)cGroup.eContents().get(3);
		
		//PatternImport:
		//	'import' 'pattern'? pattern=[Pattern|QualifiedName] ';'?;
		@Override public ParserRule getRule() { return rule; }
		
		//'import' 'pattern'? pattern=[Pattern|QualifiedName] ';'?
		public Group getGroup() { return cGroup; }
		
		//'import'
		public Keyword getImportKeyword_0() { return cImportKeyword_0; }
		
		//'pattern'?
		public Keyword getPatternKeyword_1() { return cPatternKeyword_1; }
		
		//pattern=[Pattern|QualifiedName]
		public Assignment getPatternAssignment_2() { return cPatternAssignment_2; }
		
		//[Pattern|QualifiedName]
		public CrossReference getPatternPatternCrossReference_2_0() { return cPatternPatternCrossReference_2_0; }
		
		//QualifiedName
		public RuleCall getPatternPatternQualifiedNameParserRuleCall_2_0_1() { return cPatternPatternQualifiedNameParserRuleCall_2_0_1; }
		
		//';'?
		public Keyword getSemicolonKeyword_3() { return cSemicolonKeyword_3; }
	}
	public class XImportDeclarationElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.viatra.query.patternlanguage.emf.EMFPatternLanguage.XImportDeclaration");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cImportKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Keyword cJavaKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Alternatives cAlternatives_2 = (Alternatives)cGroup.eContents().get(2);
		private final Group cGroup_2_0 = (Group)cAlternatives_2.eContents().get(0);
		private final Assignment cStaticAssignment_2_0_0 = (Assignment)cGroup_2_0.eContents().get(0);
		private final Keyword cStaticStaticKeyword_2_0_0_0 = (Keyword)cStaticAssignment_2_0_0.eContents().get(0);
		private final Assignment cExtensionAssignment_2_0_1 = (Assignment)cGroup_2_0.eContents().get(1);
		private final Keyword cExtensionExtensionKeyword_2_0_1_0 = (Keyword)cExtensionAssignment_2_0_1.eContents().get(0);
		private final Assignment cImportedTypeAssignment_2_0_2 = (Assignment)cGroup_2_0.eContents().get(2);
		private final CrossReference cImportedTypeJvmDeclaredTypeCrossReference_2_0_2_0 = (CrossReference)cImportedTypeAssignment_2_0_2.eContents().get(0);
		private final RuleCall cImportedTypeJvmDeclaredTypeQualifiedNameParserRuleCall_2_0_2_0_1 = (RuleCall)cImportedTypeJvmDeclaredTypeCrossReference_2_0_2_0.eContents().get(1);
		private final Keyword cFullStopKeyword_2_0_3 = (Keyword)cGroup_2_0.eContents().get(3);
		private final Keyword cAsteriskKeyword_2_0_4 = (Keyword)cGroup_2_0.eContents().get(4);
		private final Assignment cImportedTypeAssignment_2_1 = (Assignment)cAlternatives_2.eContents().get(1);
		private final CrossReference cImportedTypeJvmDeclaredTypeCrossReference_2_1_0 = (CrossReference)cImportedTypeAssignment_2_1.eContents().get(0);
		private final RuleCall cImportedTypeJvmDeclaredTypeQualifiedNameParserRuleCall_2_1_0_1 = (RuleCall)cImportedTypeJvmDeclaredTypeCrossReference_2_1_0.eContents().get(1);
		private final Assignment cImportedNamespaceAssignment_2_2 = (Assignment)cAlternatives_2.eContents().get(2);
		private final RuleCall cImportedNamespaceQualifiedNameWithWildcardParserRuleCall_2_2_0 = (RuleCall)cImportedNamespaceAssignment_2_2.eContents().get(0);
		private final Keyword cSemicolonKeyword_3 = (Keyword)cGroup.eContents().get(3);
		
		//@Override
		//XImportDeclaration xtype::XImportDeclaration:
		//	'import' 'java' (static?='static' extension?='extension'? importedType=[types::JvmDeclaredType|QualifiedName] '.'
		//	'*' | importedType=[types::JvmDeclaredType|QualifiedName] | importedNamespace=QualifiedNameWithWildcard) ';'?;
		@Override public ParserRule getRule() { return rule; }
		
		//'import' 'java' (static?='static' extension?='extension'? importedType=[types::JvmDeclaredType|QualifiedName] '.' '*' |
		//importedType=[types::JvmDeclaredType|QualifiedName] | importedNamespace=QualifiedNameWithWildcard) ';'?
		public Group getGroup() { return cGroup; }
		
		//'import'
		public Keyword getImportKeyword_0() { return cImportKeyword_0; }
		
		//'java'
		public Keyword getJavaKeyword_1() { return cJavaKeyword_1; }
		
		//static?='static' extension?='extension'? importedType=[types::JvmDeclaredType|QualifiedName] '.' '*' |
		//importedType=[types::JvmDeclaredType|QualifiedName] | importedNamespace=QualifiedNameWithWildcard
		public Alternatives getAlternatives_2() { return cAlternatives_2; }
		
		//static?='static' extension?='extension'? importedType=[types::JvmDeclaredType|QualifiedName] '.' '*'
		public Group getGroup_2_0() { return cGroup_2_0; }
		
		//static?='static'
		public Assignment getStaticAssignment_2_0_0() { return cStaticAssignment_2_0_0; }
		
		//'static'
		public Keyword getStaticStaticKeyword_2_0_0_0() { return cStaticStaticKeyword_2_0_0_0; }
		
		//extension?='extension'?
		public Assignment getExtensionAssignment_2_0_1() { return cExtensionAssignment_2_0_1; }
		
		//'extension'
		public Keyword getExtensionExtensionKeyword_2_0_1_0() { return cExtensionExtensionKeyword_2_0_1_0; }
		
		//importedType=[types::JvmDeclaredType|QualifiedName]
		public Assignment getImportedTypeAssignment_2_0_2() { return cImportedTypeAssignment_2_0_2; }
		
		//[types::JvmDeclaredType|QualifiedName]
		public CrossReference getImportedTypeJvmDeclaredTypeCrossReference_2_0_2_0() { return cImportedTypeJvmDeclaredTypeCrossReference_2_0_2_0; }
		
		//QualifiedName
		public RuleCall getImportedTypeJvmDeclaredTypeQualifiedNameParserRuleCall_2_0_2_0_1() { return cImportedTypeJvmDeclaredTypeQualifiedNameParserRuleCall_2_0_2_0_1; }
		
		//'.'
		public Keyword getFullStopKeyword_2_0_3() { return cFullStopKeyword_2_0_3; }
		
		//'*'
		public Keyword getAsteriskKeyword_2_0_4() { return cAsteriskKeyword_2_0_4; }
		
		//importedType=[types::JvmDeclaredType|QualifiedName]
		public Assignment getImportedTypeAssignment_2_1() { return cImportedTypeAssignment_2_1; }
		
		//[types::JvmDeclaredType|QualifiedName]
		public CrossReference getImportedTypeJvmDeclaredTypeCrossReference_2_1_0() { return cImportedTypeJvmDeclaredTypeCrossReference_2_1_0; }
		
		//QualifiedName
		public RuleCall getImportedTypeJvmDeclaredTypeQualifiedNameParserRuleCall_2_1_0_1() { return cImportedTypeJvmDeclaredTypeQualifiedNameParserRuleCall_2_1_0_1; }
		
		//importedNamespace=QualifiedNameWithWildcard
		public Assignment getImportedNamespaceAssignment_2_2() { return cImportedNamespaceAssignment_2_2; }
		
		//QualifiedNameWithWildcard
		public RuleCall getImportedNamespaceQualifiedNameWithWildcardParserRuleCall_2_2_0() { return cImportedNamespaceQualifiedNameWithWildcardParserRuleCall_2_2_0; }
		
		//';'?
		public Keyword getSemicolonKeyword_3() { return cSemicolonKeyword_3; }
	}
	public class PatternElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.viatra.query.patternlanguage.emf.EMFPatternLanguage.Pattern");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cAnnotationsAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cAnnotationsAnnotationParserRuleCall_0_0 = (RuleCall)cAnnotationsAssignment_0.eContents().get(0);
		private final Assignment cModifiersAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cModifiersModifiersParserRuleCall_1_0 = (RuleCall)cModifiersAssignment_1.eContents().get(0);
		private final Keyword cPatternKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Assignment cNameAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final RuleCall cNameIDTerminalRuleCall_3_0 = (RuleCall)cNameAssignment_3.eContents().get(0);
		private final Keyword cLeftParenthesisKeyword_4 = (Keyword)cGroup.eContents().get(4);
		private final Group cGroup_5 = (Group)cGroup.eContents().get(5);
		private final Assignment cParametersAssignment_5_0 = (Assignment)cGroup_5.eContents().get(0);
		private final RuleCall cParametersParameterParserRuleCall_5_0_0 = (RuleCall)cParametersAssignment_5_0.eContents().get(0);
		private final Group cGroup_5_1 = (Group)cGroup_5.eContents().get(1);
		private final Keyword cCommaKeyword_5_1_0 = (Keyword)cGroup_5_1.eContents().get(0);
		private final Assignment cParametersAssignment_5_1_1 = (Assignment)cGroup_5_1.eContents().get(1);
		private final RuleCall cParametersParameterParserRuleCall_5_1_1_0 = (RuleCall)cParametersAssignment_5_1_1.eContents().get(0);
		private final Keyword cRightParenthesisKeyword_6 = (Keyword)cGroup.eContents().get(6);
		private final Keyword cEqualsSignKeyword_7 = (Keyword)cGroup.eContents().get(7);
		private final Assignment cBodiesAssignment_8 = (Assignment)cGroup.eContents().get(8);
		private final RuleCall cBodiesPatternBodyParserRuleCall_8_0 = (RuleCall)cBodiesAssignment_8.eContents().get(0);
		private final Group cGroup_9 = (Group)cGroup.eContents().get(9);
		private final Keyword cOrKeyword_9_0 = (Keyword)cGroup_9.eContents().get(0);
		private final Assignment cBodiesAssignment_9_1 = (Assignment)cGroup_9.eContents().get(1);
		private final RuleCall cBodiesPatternBodyParserRuleCall_9_1_0 = (RuleCall)cBodiesAssignment_9_1.eContents().get(0);
		
		//Pattern:
		//	annotations+=Annotation*
		//	modifiers=Modifiers
		//	'pattern'
		//	name=ID
		//	'(' (parameters+=Parameter (',' parameters+=Parameter)*)?
		//	')'
		//	'='?
		//	bodies+=PatternBody ('or' bodies+=PatternBody)*;
		@Override public ParserRule getRule() { return rule; }
		
		//annotations+=Annotation* modifiers=Modifiers 'pattern' name=ID '(' (parameters+=Parameter (',' parameters+=Parameter)*)?
		//')' '='? bodies+=PatternBody ('or' bodies+=PatternBody)*
		public Group getGroup() { return cGroup; }
		
		//annotations+=Annotation*
		public Assignment getAnnotationsAssignment_0() { return cAnnotationsAssignment_0; }
		
		//Annotation
		public RuleCall getAnnotationsAnnotationParserRuleCall_0_0() { return cAnnotationsAnnotationParserRuleCall_0_0; }
		
		//modifiers=Modifiers
		public Assignment getModifiersAssignment_1() { return cModifiersAssignment_1; }
		
		//Modifiers
		public RuleCall getModifiersModifiersParserRuleCall_1_0() { return cModifiersModifiersParserRuleCall_1_0; }
		
		//'pattern'
		public Keyword getPatternKeyword_2() { return cPatternKeyword_2; }
		
		//name=ID
		public Assignment getNameAssignment_3() { return cNameAssignment_3; }
		
		//ID
		public RuleCall getNameIDTerminalRuleCall_3_0() { return cNameIDTerminalRuleCall_3_0; }
		
		//'('
		public Keyword getLeftParenthesisKeyword_4() { return cLeftParenthesisKeyword_4; }
		
		//(parameters+=Parameter (',' parameters+=Parameter)*)?
		public Group getGroup_5() { return cGroup_5; }
		
		//parameters+=Parameter
		public Assignment getParametersAssignment_5_0() { return cParametersAssignment_5_0; }
		
		//Parameter
		public RuleCall getParametersParameterParserRuleCall_5_0_0() { return cParametersParameterParserRuleCall_5_0_0; }
		
		//(',' parameters+=Parameter)*
		public Group getGroup_5_1() { return cGroup_5_1; }
		
		//','
		public Keyword getCommaKeyword_5_1_0() { return cCommaKeyword_5_1_0; }
		
		//parameters+=Parameter
		public Assignment getParametersAssignment_5_1_1() { return cParametersAssignment_5_1_1; }
		
		//Parameter
		public RuleCall getParametersParameterParserRuleCall_5_1_1_0() { return cParametersParameterParserRuleCall_5_1_1_0; }
		
		//')'
		public Keyword getRightParenthesisKeyword_6() { return cRightParenthesisKeyword_6; }
		
		//'='?
		public Keyword getEqualsSignKeyword_7() { return cEqualsSignKeyword_7; }
		
		//bodies+=PatternBody
		public Assignment getBodiesAssignment_8() { return cBodiesAssignment_8; }
		
		//PatternBody
		public RuleCall getBodiesPatternBodyParserRuleCall_8_0() { return cBodiesPatternBodyParserRuleCall_8_0; }
		
		//('or' bodies+=PatternBody)*
		public Group getGroup_9() { return cGroup_9; }
		
		//'or'
		public Keyword getOrKeyword_9_0() { return cOrKeyword_9_0; }
		
		//bodies+=PatternBody
		public Assignment getBodiesAssignment_9_1() { return cBodiesAssignment_9_1; }
		
		//PatternBody
		public RuleCall getBodiesPatternBodyParserRuleCall_9_1_0() { return cBodiesPatternBodyParserRuleCall_9_1_0; }
	}
	public class AnnotationElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.viatra.query.patternlanguage.emf.EMFPatternLanguage.Annotation");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cCommercialAtKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Assignment cNameAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cNameIDTerminalRuleCall_1_0 = (RuleCall)cNameAssignment_1.eContents().get(0);
		private final Group cGroup_2 = (Group)cGroup.eContents().get(2);
		private final Keyword cLeftParenthesisKeyword_2_0 = (Keyword)cGroup_2.eContents().get(0);
		private final Assignment cParametersAssignment_2_1 = (Assignment)cGroup_2.eContents().get(1);
		private final RuleCall cParametersAnnotationParameterParserRuleCall_2_1_0 = (RuleCall)cParametersAssignment_2_1.eContents().get(0);
		private final Group cGroup_2_2 = (Group)cGroup_2.eContents().get(2);
		private final Keyword cCommaKeyword_2_2_0 = (Keyword)cGroup_2_2.eContents().get(0);
		private final Assignment cParametersAssignment_2_2_1 = (Assignment)cGroup_2_2.eContents().get(1);
		private final RuleCall cParametersAnnotationParameterParserRuleCall_2_2_1_0 = (RuleCall)cParametersAssignment_2_2_1.eContents().get(0);
		private final Keyword cRightParenthesisKeyword_2_3 = (Keyword)cGroup_2.eContents().get(3);
		
		//Annotation:
		//	'@'
		//	name=ID ('(' parameters+=AnnotationParameter (',' parameters+=AnnotationParameter)* ')')?;
		@Override public ParserRule getRule() { return rule; }
		
		//'@' name=ID ('(' parameters+=AnnotationParameter (',' parameters+=AnnotationParameter)* ')')?
		public Group getGroup() { return cGroup; }
		
		//'@'
		public Keyword getCommercialAtKeyword_0() { return cCommercialAtKeyword_0; }
		
		//name=ID
		public Assignment getNameAssignment_1() { return cNameAssignment_1; }
		
		//ID
		public RuleCall getNameIDTerminalRuleCall_1_0() { return cNameIDTerminalRuleCall_1_0; }
		
		//('(' parameters+=AnnotationParameter (',' parameters+=AnnotationParameter)* ')')?
		public Group getGroup_2() { return cGroup_2; }
		
		//'('
		public Keyword getLeftParenthesisKeyword_2_0() { return cLeftParenthesisKeyword_2_0; }
		
		//parameters+=AnnotationParameter
		public Assignment getParametersAssignment_2_1() { return cParametersAssignment_2_1; }
		
		//AnnotationParameter
		public RuleCall getParametersAnnotationParameterParserRuleCall_2_1_0() { return cParametersAnnotationParameterParserRuleCall_2_1_0; }
		
		//(',' parameters+=AnnotationParameter)*
		public Group getGroup_2_2() { return cGroup_2_2; }
		
		//','
		public Keyword getCommaKeyword_2_2_0() { return cCommaKeyword_2_2_0; }
		
		//parameters+=AnnotationParameter
		public Assignment getParametersAssignment_2_2_1() { return cParametersAssignment_2_2_1; }
		
		//AnnotationParameter
		public RuleCall getParametersAnnotationParameterParserRuleCall_2_2_1_0() { return cParametersAnnotationParameterParserRuleCall_2_2_1_0; }
		
		//')'
		public Keyword getRightParenthesisKeyword_2_3() { return cRightParenthesisKeyword_2_3; }
	}
	public class AnnotationParameterElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.viatra.query.patternlanguage.emf.EMFPatternLanguage.AnnotationParameter");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cNameAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cNameIDTerminalRuleCall_0_0 = (RuleCall)cNameAssignment_0.eContents().get(0);
		private final Keyword cEqualsSignKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cValueAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cValueAnnotationValueReferenceParserRuleCall_2_0 = (RuleCall)cValueAssignment_2.eContents().get(0);
		
		//AnnotationParameter:
		//	name=ID '=' value=AnnotationValueReference;
		@Override public ParserRule getRule() { return rule; }
		
		//name=ID '=' value=AnnotationValueReference
		public Group getGroup() { return cGroup; }
		
		//name=ID
		public Assignment getNameAssignment_0() { return cNameAssignment_0; }
		
		//ID
		public RuleCall getNameIDTerminalRuleCall_0_0() { return cNameIDTerminalRuleCall_0_0; }
		
		//'='
		public Keyword getEqualsSignKeyword_1() { return cEqualsSignKeyword_1; }
		
		//value=AnnotationValueReference
		public Assignment getValueAssignment_2() { return cValueAssignment_2; }
		
		//AnnotationValueReference
		public RuleCall getValueAnnotationValueReferenceParserRuleCall_2_0() { return cValueAnnotationValueReferenceParserRuleCall_2_0; }
	}
	public class ModifiersElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.viatra.query.patternlanguage.emf.EMFPatternLanguage.Modifiers");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cModifiersAction_0 = (Action)cGroup.eContents().get(0);
		private final UnorderedGroup cUnorderedGroup_1 = (UnorderedGroup)cGroup.eContents().get(1);
		private final Assignment cPrivateAssignment_1_0 = (Assignment)cUnorderedGroup_1.eContents().get(0);
		private final Keyword cPrivatePrivateKeyword_1_0_0 = (Keyword)cPrivateAssignment_1_0.eContents().get(0);
		private final Assignment cExecutionAssignment_1_1 = (Assignment)cUnorderedGroup_1.eContents().get(1);
		private final RuleCall cExecutionExecutionTypeModifierEnumRuleCall_1_1_0 = (RuleCall)cExecutionAssignment_1_1.eContents().get(0);
		
		//Modifiers:
		//	{Modifiers} (private?='private'? & execution=ExecutionTypeModifier?);
		@Override public ParserRule getRule() { return rule; }
		
		//{Modifiers} (private?='private'? & execution=ExecutionTypeModifier?)
		public Group getGroup() { return cGroup; }
		
		//{Modifiers}
		public Action getModifiersAction_0() { return cModifiersAction_0; }
		
		//private?='private'? & execution=ExecutionTypeModifier?
		public UnorderedGroup getUnorderedGroup_1() { return cUnorderedGroup_1; }
		
		////injective?='injective' &
		//private?='private'?
		public Assignment getPrivateAssignment_1_0() { return cPrivateAssignment_1_0; }
		
		//'private'
		public Keyword getPrivatePrivateKeyword_1_0_0() { return cPrivatePrivateKeyword_1_0_0; }
		
		//execution=ExecutionTypeModifier?
		public Assignment getExecutionAssignment_1_1() { return cExecutionAssignment_1_1; }
		
		//ExecutionTypeModifier
		public RuleCall getExecutionExecutionTypeModifierEnumRuleCall_1_1_0() { return cExecutionExecutionTypeModifierEnumRuleCall_1_1_0; }
	}
	public class ParameterElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.viatra.query.patternlanguage.emf.EMFPatternLanguage.Parameter");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cDirectionAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cDirectionParameterDirectionModifierEnumRuleCall_0_0 = (RuleCall)cDirectionAssignment_0.eContents().get(0);
		private final Assignment cNameAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cNameIDTerminalRuleCall_1_0 = (RuleCall)cNameAssignment_1.eContents().get(0);
		private final Alternatives cAlternatives_2 = (Alternatives)cGroup.eContents().get(2);
		private final Group cGroup_2_0 = (Group)cAlternatives_2.eContents().get(0);
		private final Keyword cColonKeyword_2_0_0 = (Keyword)cGroup_2_0.eContents().get(0);
		private final Assignment cTypeAssignment_2_0_1 = (Assignment)cGroup_2_0.eContents().get(1);
		private final RuleCall cTypeTypeParserRuleCall_2_0_1_0 = (RuleCall)cTypeAssignment_2_0_1.eContents().get(0);
		private final Group cGroup_2_1 = (Group)cAlternatives_2.eContents().get(1);
		private final Keyword cColonKeyword_2_1_0 = (Keyword)cGroup_2_1.eContents().get(0);
		private final Assignment cTypeAssignment_2_1_1 = (Assignment)cGroup_2_1.eContents().get(1);
		private final RuleCall cTypeJavaTypeParserRuleCall_2_1_1_0 = (RuleCall)cTypeAssignment_2_1_1.eContents().get(0);
		
		//Parameter:
		//	direction=ParameterDirectionModifier?
		//	name=ID (':' type=Type | ':' type=JavaType)?;
		@Override public ParserRule getRule() { return rule; }
		
		//direction=ParameterDirectionModifier? name=ID (':' type=Type | ':' type=JavaType)?
		public Group getGroup() { return cGroup; }
		
		//direction=ParameterDirectionModifier?
		public Assignment getDirectionAssignment_0() { return cDirectionAssignment_0; }
		
		//ParameterDirectionModifier
		public RuleCall getDirectionParameterDirectionModifierEnumRuleCall_0_0() { return cDirectionParameterDirectionModifierEnumRuleCall_0_0; }
		
		//name=ID
		public Assignment getNameAssignment_1() { return cNameAssignment_1; }
		
		//ID
		public RuleCall getNameIDTerminalRuleCall_1_0() { return cNameIDTerminalRuleCall_1_0; }
		
		//(':' type=Type | ':' type=JavaType)?
		public Alternatives getAlternatives_2() { return cAlternatives_2; }
		
		//':' type=Type
		public Group getGroup_2_0() { return cGroup_2_0; }
		
		//':'
		public Keyword getColonKeyword_2_0_0() { return cColonKeyword_2_0_0; }
		
		//type=Type
		public Assignment getTypeAssignment_2_0_1() { return cTypeAssignment_2_0_1; }
		
		//Type
		public RuleCall getTypeTypeParserRuleCall_2_0_1_0() { return cTypeTypeParserRuleCall_2_0_1_0; }
		
		//':' type=JavaType
		public Group getGroup_2_1() { return cGroup_2_1; }
		
		//':'
		public Keyword getColonKeyword_2_1_0() { return cColonKeyword_2_1_0; }
		
		//type=JavaType
		public Assignment getTypeAssignment_2_1_1() { return cTypeAssignment_2_1_1; }
		
		//JavaType
		public RuleCall getTypeJavaTypeParserRuleCall_2_1_1_0() { return cTypeJavaTypeParserRuleCall_2_1_1_0; }
	}
	public class VariableReferenceElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.viatra.query.patternlanguage.emf.EMFPatternLanguage.VariableReference");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final Group cGroup_0 = (Group)cAlternatives.eContents().get(0);
		private final Assignment cAggregatorAssignment_0_0 = (Assignment)cGroup_0.eContents().get(0);
		private final Keyword cAggregatorNumberSignKeyword_0_0_0 = (Keyword)cAggregatorAssignment_0_0.eContents().get(0);
		private final Assignment cVarAssignment_0_1 = (Assignment)cGroup_0.eContents().get(1);
		private final RuleCall cVarIDTerminalRuleCall_0_1_0 = (RuleCall)cVarAssignment_0_1.eContents().get(0);
		private final Assignment cAggregatorAssignment_1 = (Assignment)cAlternatives.eContents().get(1);
		private final Keyword cAggregatorNumberSignKeyword_1_0 = (Keyword)cAggregatorAssignment_1.eContents().get(0);
		
		//VariableReference:
		//	aggregator?='#'? var=ID | aggregator?='#';
		@Override public ParserRule getRule() { return rule; }
		
		//aggregator?='#'? var=ID | aggregator?='#'
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//aggregator?='#'? var=ID
		public Group getGroup_0() { return cGroup_0; }
		
		//aggregator?='#'?
		public Assignment getAggregatorAssignment_0_0() { return cAggregatorAssignment_0_0; }
		
		//'#'
		public Keyword getAggregatorNumberSignKeyword_0_0_0() { return cAggregatorNumberSignKeyword_0_0_0; }
		
		//var=ID
		public Assignment getVarAssignment_0_1() { return cVarAssignment_0_1; }
		
		//ID
		public RuleCall getVarIDTerminalRuleCall_0_1_0() { return cVarIDTerminalRuleCall_0_1_0; }
		
		//aggregator?='#'
		public Assignment getAggregatorAssignment_1() { return cAggregatorAssignment_1; }
		
		//'#'
		public Keyword getAggregatorNumberSignKeyword_1_0() { return cAggregatorNumberSignKeyword_1_0; }
	}
	public class TypeElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.viatra.query.patternlanguage.emf.EMFPatternLanguage.Type");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Group cGroup_0 = (Group)cGroup.eContents().get(0);
		private final Assignment cMetamodelAssignment_0_0 = (Assignment)cGroup_0.eContents().get(0);
		private final CrossReference cMetamodelPackageImportCrossReference_0_0_0 = (CrossReference)cMetamodelAssignment_0_0.eContents().get(0);
		private final RuleCall cMetamodelPackageImportIDTerminalRuleCall_0_0_0_1 = (RuleCall)cMetamodelPackageImportCrossReference_0_0_0.eContents().get(1);
		private final Keyword cColonColonKeyword_0_1 = (Keyword)cGroup_0.eContents().get(1);
		private final Assignment cClassnameAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final CrossReference cClassnameEClassifierCrossReference_1_0 = (CrossReference)cClassnameAssignment_1.eContents().get(0);
		private final RuleCall cClassnameEClassifierIDTerminalRuleCall_1_0_1 = (RuleCall)cClassnameEClassifierCrossReference_1_0.eContents().get(1);
		
		//Type ClassType:
		//	(metamodel=[PackageImport] '::')? classname=[ecore::EClassifier];
		@Override public ParserRule getRule() { return rule; }
		
		//(metamodel=[PackageImport] '::')? classname=[ecore::EClassifier]
		public Group getGroup() { return cGroup; }
		
		//(metamodel=[PackageImport] '::')?
		public Group getGroup_0() { return cGroup_0; }
		
		//metamodel=[PackageImport]
		public Assignment getMetamodelAssignment_0_0() { return cMetamodelAssignment_0_0; }
		
		//[PackageImport]
		public CrossReference getMetamodelPackageImportCrossReference_0_0_0() { return cMetamodelPackageImportCrossReference_0_0_0; }
		
		//ID
		public RuleCall getMetamodelPackageImportIDTerminalRuleCall_0_0_0_1() { return cMetamodelPackageImportIDTerminalRuleCall_0_0_0_1; }
		
		//'::'
		public Keyword getColonColonKeyword_0_1() { return cColonColonKeyword_0_1; }
		
		//classname=[ecore::EClassifier]
		public Assignment getClassnameAssignment_1() { return cClassnameAssignment_1; }
		
		//[ecore::EClassifier]
		public CrossReference getClassnameEClassifierCrossReference_1_0() { return cClassnameEClassifierCrossReference_1_0; }
		
		//ID
		public RuleCall getClassnameEClassifierIDTerminalRuleCall_1_0_1() { return cClassnameEClassifierIDTerminalRuleCall_1_0_1; }
	}
	public class RefTypeElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.viatra.query.patternlanguage.emf.EMFPatternLanguage.RefType");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cReferenceTypeAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cRefnameAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final CrossReference cRefnameEStructuralFeatureCrossReference_1_0 = (CrossReference)cRefnameAssignment_1.eContents().get(0);
		private final RuleCall cRefnameEStructuralFeatureIDTerminalRuleCall_1_0_1 = (RuleCall)cRefnameEStructuralFeatureCrossReference_1_0.eContents().get(1);
		
		//RefType ReferenceType:
		//	{ReferenceType} refname=[ecore::EStructuralFeature];
		@Override public ParserRule getRule() { return rule; }
		
		//{ReferenceType} refname=[ecore::EStructuralFeature]
		public Group getGroup() { return cGroup; }
		
		//{ReferenceType}
		public Action getReferenceTypeAction_0() { return cReferenceTypeAction_0; }
		
		//refname=[ecore::EStructuralFeature]
		public Assignment getRefnameAssignment_1() { return cRefnameAssignment_1; }
		
		//[ecore::EStructuralFeature]
		public CrossReference getRefnameEStructuralFeatureCrossReference_1_0() { return cRefnameEStructuralFeatureCrossReference_1_0; }
		
		//ID
		public RuleCall getRefnameEStructuralFeatureIDTerminalRuleCall_1_0_1() { return cRefnameEStructuralFeatureIDTerminalRuleCall_1_0_1; }
	}
	public class JavaTypeElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.viatra.query.patternlanguage.emf.EMFPatternLanguage.JavaType");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cJavaTypeAction_0 = (Action)cGroup.eContents().get(0);
		private final Keyword cJavaKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cClassRefAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final CrossReference cClassRefJvmDeclaredTypeCrossReference_2_0 = (CrossReference)cClassRefAssignment_2.eContents().get(0);
		private final RuleCall cClassRefJvmDeclaredTypeQualifiedNameParserRuleCall_2_0_1 = (RuleCall)cClassRefJvmDeclaredTypeCrossReference_2_0.eContents().get(1);
		
		//JavaType EntityType:
		//	{JavaType} 'java' classRef=[types::JvmDeclaredType|QualifiedName];
		@Override public ParserRule getRule() { return rule; }
		
		//{JavaType} 'java' classRef=[types::JvmDeclaredType|QualifiedName]
		public Group getGroup() { return cGroup; }
		
		//{JavaType}
		public Action getJavaTypeAction_0() { return cJavaTypeAction_0; }
		
		//'java'
		public Keyword getJavaKeyword_1() { return cJavaKeyword_1; }
		
		//classRef=[types::JvmDeclaredType|QualifiedName]
		public Assignment getClassRefAssignment_2() { return cClassRefAssignment_2; }
		
		//[types::JvmDeclaredType|QualifiedName]
		public CrossReference getClassRefJvmDeclaredTypeCrossReference_2_0() { return cClassRefJvmDeclaredTypeCrossReference_2_0; }
		
		//QualifiedName
		public RuleCall getClassRefJvmDeclaredTypeQualifiedNameParserRuleCall_2_0_1() { return cClassRefJvmDeclaredTypeQualifiedNameParserRuleCall_2_0_1; }
	}
	public class PatternBodyElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.viatra.query.patternlanguage.emf.EMFPatternLanguage.PatternBody");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cPatternBodyAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cNameAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cNameIDTerminalRuleCall_1_0 = (RuleCall)cNameAssignment_1.eContents().get(0);
		private final Keyword cLeftCurlyBracketKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Group cGroup_3 = (Group)cGroup.eContents().get(3);
		private final Assignment cConstraintsAssignment_3_0 = (Assignment)cGroup_3.eContents().get(0);
		private final RuleCall cConstraintsConstraintParserRuleCall_3_0_0 = (RuleCall)cConstraintsAssignment_3_0.eContents().get(0);
		private final Keyword cSemicolonKeyword_3_1 = (Keyword)cGroup_3.eContents().get(1);
		private final Keyword cRightCurlyBracketKeyword_4 = (Keyword)cGroup.eContents().get(4);
		
		//PatternBody:
		//	{PatternBody} name=ID?
		//	'{' (constraints+=Constraint ';')*
		//	'}';
		@Override public ParserRule getRule() { return rule; }
		
		//{PatternBody} name=ID? '{' (constraints+=Constraint ';')* '}'
		public Group getGroup() { return cGroup; }
		
		//{PatternBody}
		public Action getPatternBodyAction_0() { return cPatternBodyAction_0; }
		
		//name=ID?
		public Assignment getNameAssignment_1() { return cNameAssignment_1; }
		
		//ID
		public RuleCall getNameIDTerminalRuleCall_1_0() { return cNameIDTerminalRuleCall_1_0; }
		
		//'{'
		public Keyword getLeftCurlyBracketKeyword_2() { return cLeftCurlyBracketKeyword_2; }
		
		//(constraints+=Constraint ';')*
		public Group getGroup_3() { return cGroup_3; }
		
		//constraints+=Constraint
		public Assignment getConstraintsAssignment_3_0() { return cConstraintsAssignment_3_0; }
		
		//Constraint
		public RuleCall getConstraintsConstraintParserRuleCall_3_0_0() { return cConstraintsConstraintParserRuleCall_3_0_0; }
		
		//';'
		public Keyword getSemicolonKeyword_3_1() { return cSemicolonKeyword_3_1; }
		
		//'}'
		public Keyword getRightCurlyBracketKeyword_4() { return cRightCurlyBracketKeyword_4; }
	}
	public class ConstraintElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.viatra.query.patternlanguage.emf.EMFPatternLanguage.Constraint");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cCheckConstraintParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cTypeCheckConstraintParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		private final RuleCall cCompareConstraintParserRuleCall_2 = (RuleCall)cAlternatives.eContents().get(2);
		private final RuleCall cPatternCompositionConstraintParserRuleCall_3 = (RuleCall)cAlternatives.eContents().get(3);
		private final RuleCall cPathExpressionConstraintParserRuleCall_4 = (RuleCall)cAlternatives.eContents().get(4);
		private final RuleCall cEClassifierConstraintParserRuleCall_5 = (RuleCall)cAlternatives.eContents().get(5);
		
		//Constraint:
		//	CheckConstraint | TypeCheckConstraint | CompareConstraint | PatternCompositionConstraint | PathExpressionConstraint
		//	| EClassifierConstraint;
		@Override public ParserRule getRule() { return rule; }
		
		//CheckConstraint | TypeCheckConstraint | CompareConstraint | PatternCompositionConstraint | PathExpressionConstraint |
		//EClassifierConstraint
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//CheckConstraint
		public RuleCall getCheckConstraintParserRuleCall_0() { return cCheckConstraintParserRuleCall_0; }
		
		//TypeCheckConstraint
		public RuleCall getTypeCheckConstraintParserRuleCall_1() { return cTypeCheckConstraintParserRuleCall_1; }
		
		//CompareConstraint
		public RuleCall getCompareConstraintParserRuleCall_2() { return cCompareConstraintParserRuleCall_2; }
		
		//PatternCompositionConstraint
		public RuleCall getPatternCompositionConstraintParserRuleCall_3() { return cPatternCompositionConstraintParserRuleCall_3; }
		
		//PathExpressionConstraint
		public RuleCall getPathExpressionConstraintParserRuleCall_4() { return cPathExpressionConstraintParserRuleCall_4; }
		
		//EClassifierConstraint
		public RuleCall getEClassifierConstraintParserRuleCall_5() { return cEClassifierConstraintParserRuleCall_5; }
	}
	public class TypeCheckConstraintElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.viatra.query.patternlanguage.emf.EMFPatternLanguage.TypeCheckConstraint");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cTypeAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cTypeJavaTypeParserRuleCall_0_0 = (RuleCall)cTypeAssignment_0.eContents().get(0);
		private final Keyword cLeftParenthesisKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cVarAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cVarVariableReferenceParserRuleCall_2_0 = (RuleCall)cVarAssignment_2.eContents().get(0);
		private final Keyword cRightParenthesisKeyword_3 = (Keyword)cGroup.eContents().get(3);
		
		//TypeCheckConstraint:
		//	type=JavaType '(' var=VariableReference ')';
		@Override public ParserRule getRule() { return rule; }
		
		//type=JavaType '(' var=VariableReference ')'
		public Group getGroup() { return cGroup; }
		
		//type=JavaType
		public Assignment getTypeAssignment_0() { return cTypeAssignment_0; }
		
		//JavaType
		public RuleCall getTypeJavaTypeParserRuleCall_0_0() { return cTypeJavaTypeParserRuleCall_0_0; }
		
		//'('
		public Keyword getLeftParenthesisKeyword_1() { return cLeftParenthesisKeyword_1; }
		
		//var=VariableReference
		public Assignment getVarAssignment_2() { return cVarAssignment_2; }
		
		//VariableReference
		public RuleCall getVarVariableReferenceParserRuleCall_2_0() { return cVarVariableReferenceParserRuleCall_2_0; }
		
		//')'
		public Keyword getRightParenthesisKeyword_3() { return cRightParenthesisKeyword_3; }
	}
	public class PatternCompositionConstraintElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.viatra.query.patternlanguage.emf.EMFPatternLanguage.PatternCompositionConstraint");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final Group cGroup_0 = (Group)cAlternatives.eContents().get(0);
		private final Assignment cNegativeAssignment_0_0 = (Assignment)cGroup_0.eContents().get(0);
		private final Keyword cNegativeNegKeyword_0_0_0 = (Keyword)cNegativeAssignment_0_0.eContents().get(0);
		private final Assignment cCallAssignment_0_1 = (Assignment)cGroup_0.eContents().get(1);
		private final RuleCall cCallPatternCallParserRuleCall_0_1_0 = (RuleCall)cCallAssignment_0_1.eContents().get(0);
		private final Group cGroup_1 = (Group)cAlternatives.eContents().get(1);
		private final Assignment cNegativeAssignment_1_0 = (Assignment)cGroup_1.eContents().get(0);
		private final Keyword cNegativeNegKeyword_1_0_0 = (Keyword)cNegativeAssignment_1_0.eContents().get(0);
		private final Alternatives cAlternatives_1_1 = (Alternatives)cGroup_1.eContents().get(1);
		private final Assignment cCallAssignment_1_1_0 = (Assignment)cAlternatives_1_1.eContents().get(0);
		private final RuleCall cCallEClassifierConstraintParserRuleCall_1_1_0_0 = (RuleCall)cCallAssignment_1_1_0.eContents().get(0);
		private final Assignment cCallAssignment_1_1_1 = (Assignment)cAlternatives_1_1.eContents().get(1);
		private final RuleCall cCallPathExpressionConstraintParserRuleCall_1_1_1_0 = (RuleCall)cCallAssignment_1_1_1.eContents().get(0);
		
		//PatternCompositionConstraint:
		//	negative?='neg'? call=PatternCall
		//	| negative?='neg' (call=EClassifierConstraint | call=PathExpressionConstraint);
		@Override public ParserRule getRule() { return rule; }
		
		//negative?='neg'? call=PatternCall | negative?='neg' (call=EClassifierConstraint | call=PathExpressionConstraint)
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//negative?='neg'? call=PatternCall
		public Group getGroup_0() { return cGroup_0; }
		
		//negative?='neg'?
		public Assignment getNegativeAssignment_0_0() { return cNegativeAssignment_0_0; }
		
		//'neg'
		public Keyword getNegativeNegKeyword_0_0_0() { return cNegativeNegKeyword_0_0_0; }
		
		//call=PatternCall
		public Assignment getCallAssignment_0_1() { return cCallAssignment_0_1; }
		
		//PatternCall
		public RuleCall getCallPatternCallParserRuleCall_0_1_0() { return cCallPatternCallParserRuleCall_0_1_0; }
		
		//negative?='neg' (call=EClassifierConstraint | call=PathExpressionConstraint)
		public Group getGroup_1() { return cGroup_1; }
		
		//negative?='neg'
		public Assignment getNegativeAssignment_1_0() { return cNegativeAssignment_1_0; }
		
		//'neg'
		public Keyword getNegativeNegKeyword_1_0_0() { return cNegativeNegKeyword_1_0_0; }
		
		//call=EClassifierConstraint | call=PathExpressionConstraint
		public Alternatives getAlternatives_1_1() { return cAlternatives_1_1; }
		
		//call=EClassifierConstraint
		public Assignment getCallAssignment_1_1_0() { return cCallAssignment_1_1_0; }
		
		//EClassifierConstraint
		public RuleCall getCallEClassifierConstraintParserRuleCall_1_1_0_0() { return cCallEClassifierConstraintParserRuleCall_1_1_0_0; }
		
		//call=PathExpressionConstraint
		public Assignment getCallAssignment_1_1_1() { return cCallAssignment_1_1_1; }
		
		//PathExpressionConstraint
		public RuleCall getCallPathExpressionConstraintParserRuleCall_1_1_1_0() { return cCallPathExpressionConstraintParserRuleCall_1_1_1_0; }
	}
	public class PatternCallElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.viatra.query.patternlanguage.emf.EMFPatternLanguage.PatternCall");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cFindKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Assignment cPatternRefAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final CrossReference cPatternRefPatternCrossReference_1_0 = (CrossReference)cPatternRefAssignment_1.eContents().get(0);
		private final RuleCall cPatternRefPatternQualifiedNameParserRuleCall_1_0_1 = (RuleCall)cPatternRefPatternCrossReference_1_0.eContents().get(1);
		private final Assignment cTransitiveAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cTransitiveClosureTypeEnumRuleCall_2_0 = (RuleCall)cTransitiveAssignment_2.eContents().get(0);
		private final Keyword cLeftParenthesisKeyword_3 = (Keyword)cGroup.eContents().get(3);
		private final Group cGroup_4 = (Group)cGroup.eContents().get(4);
		private final Assignment cParametersAssignment_4_0 = (Assignment)cGroup_4.eContents().get(0);
		private final RuleCall cParametersValueReferenceParserRuleCall_4_0_0 = (RuleCall)cParametersAssignment_4_0.eContents().get(0);
		private final Group cGroup_4_1 = (Group)cGroup_4.eContents().get(1);
		private final Keyword cCommaKeyword_4_1_0 = (Keyword)cGroup_4_1.eContents().get(0);
		private final Assignment cParametersAssignment_4_1_1 = (Assignment)cGroup_4_1.eContents().get(1);
		private final RuleCall cParametersValueReferenceParserRuleCall_4_1_1_0 = (RuleCall)cParametersAssignment_4_1_1.eContents().get(0);
		private final Keyword cRightParenthesisKeyword_5 = (Keyword)cGroup.eContents().get(5);
		
		//PatternCall:
		//	'find' patternRef=[Pattern|QualifiedName] transitive=ClosureType? '(' (parameters+=ValueReference (','
		//	parameters+=ValueReference)*)? ')';
		@Override public ParserRule getRule() { return rule; }
		
		//'find' patternRef=[Pattern|QualifiedName] transitive=ClosureType? '(' (parameters+=ValueReference (','
		//parameters+=ValueReference)*)? ')'
		public Group getGroup() { return cGroup; }
		
		//'find'
		public Keyword getFindKeyword_0() { return cFindKeyword_0; }
		
		//patternRef=[Pattern|QualifiedName]
		public Assignment getPatternRefAssignment_1() { return cPatternRefAssignment_1; }
		
		//[Pattern|QualifiedName]
		public CrossReference getPatternRefPatternCrossReference_1_0() { return cPatternRefPatternCrossReference_1_0; }
		
		//QualifiedName
		public RuleCall getPatternRefPatternQualifiedNameParserRuleCall_1_0_1() { return cPatternRefPatternQualifiedNameParserRuleCall_1_0_1; }
		
		//transitive=ClosureType?
		public Assignment getTransitiveAssignment_2() { return cTransitiveAssignment_2; }
		
		//ClosureType
		public RuleCall getTransitiveClosureTypeEnumRuleCall_2_0() { return cTransitiveClosureTypeEnumRuleCall_2_0; }
		
		//'('
		public Keyword getLeftParenthesisKeyword_3() { return cLeftParenthesisKeyword_3; }
		
		//(parameters+=ValueReference (',' parameters+=ValueReference)*)?
		public Group getGroup_4() { return cGroup_4; }
		
		//parameters+=ValueReference
		public Assignment getParametersAssignment_4_0() { return cParametersAssignment_4_0; }
		
		//ValueReference
		public RuleCall getParametersValueReferenceParserRuleCall_4_0_0() { return cParametersValueReferenceParserRuleCall_4_0_0; }
		
		//(',' parameters+=ValueReference)*
		public Group getGroup_4_1() { return cGroup_4_1; }
		
		//','
		public Keyword getCommaKeyword_4_1_0() { return cCommaKeyword_4_1_0; }
		
		//parameters+=ValueReference
		public Assignment getParametersAssignment_4_1_1() { return cParametersAssignment_4_1_1; }
		
		//ValueReference
		public RuleCall getParametersValueReferenceParserRuleCall_4_1_1_0() { return cParametersValueReferenceParserRuleCall_4_1_1_0; }
		
		//')'
		public Keyword getRightParenthesisKeyword_5() { return cRightParenthesisKeyword_5; }
	}
	public class CompareConstraintElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.viatra.query.patternlanguage.emf.EMFPatternLanguage.CompareConstraint");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cLeftOperandAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cLeftOperandValueReferenceParserRuleCall_0_0 = (RuleCall)cLeftOperandAssignment_0.eContents().get(0);
		private final Assignment cFeatureAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cFeatureCompareFeatureEnumRuleCall_1_0 = (RuleCall)cFeatureAssignment_1.eContents().get(0);
		private final Assignment cRightOperandAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cRightOperandValueReferenceParserRuleCall_2_0 = (RuleCall)cRightOperandAssignment_2.eContents().get(0);
		
		//CompareConstraint:
		//	leftOperand=ValueReference feature=CompareFeature rightOperand=ValueReference;
		@Override public ParserRule getRule() { return rule; }
		
		//leftOperand=ValueReference feature=CompareFeature rightOperand=ValueReference
		public Group getGroup() { return cGroup; }
		
		//leftOperand=ValueReference
		public Assignment getLeftOperandAssignment_0() { return cLeftOperandAssignment_0; }
		
		//ValueReference
		public RuleCall getLeftOperandValueReferenceParserRuleCall_0_0() { return cLeftOperandValueReferenceParserRuleCall_0_0; }
		
		//feature=CompareFeature
		public Assignment getFeatureAssignment_1() { return cFeatureAssignment_1; }
		
		//CompareFeature
		public RuleCall getFeatureCompareFeatureEnumRuleCall_1_0() { return cFeatureCompareFeatureEnumRuleCall_1_0; }
		
		//rightOperand=ValueReference
		public Assignment getRightOperandAssignment_2() { return cRightOperandAssignment_2; }
		
		//ValueReference
		public RuleCall getRightOperandValueReferenceParserRuleCall_2_0() { return cRightOperandValueReferenceParserRuleCall_2_0; }
	}
	public class CheckConstraintElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.viatra.query.patternlanguage.emf.EMFPatternLanguage.CheckConstraint");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cCheckKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Keyword cLeftParenthesisKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cExpressionAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cExpressionXExpressionParserRuleCall_2_0 = (RuleCall)cExpressionAssignment_2.eContents().get(0);
		private final Keyword cRightParenthesisKeyword_3 = (Keyword)cGroup.eContents().get(3);
		
		//CheckConstraint:
		//	'check' '(' expression=XExpression ')';
		@Override public ParserRule getRule() { return rule; }
		
		//'check' '(' expression=XExpression ')'
		public Group getGroup() { return cGroup; }
		
		//'check'
		public Keyword getCheckKeyword_0() { return cCheckKeyword_0; }
		
		//'('
		public Keyword getLeftParenthesisKeyword_1() { return cLeftParenthesisKeyword_1; }
		
		//expression=XExpression
		public Assignment getExpressionAssignment_2() { return cExpressionAssignment_2; }
		
		//XExpression
		public RuleCall getExpressionXExpressionParserRuleCall_2_0() { return cExpressionXExpressionParserRuleCall_2_0; }
		
		//')'
		public Keyword getRightParenthesisKeyword_3() { return cRightParenthesisKeyword_3; }
	}
	public class PathExpressionConstraintElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.viatra.query.patternlanguage.emf.EMFPatternLanguage.PathExpressionConstraint");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cSourceTypeAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cSourceTypeTypeParserRuleCall_0_0 = (RuleCall)cSourceTypeAssignment_0.eContents().get(0);
		private final Group cGroup_1 = (Group)cGroup.eContents().get(1);
		private final Keyword cFullStopKeyword_1_0 = (Keyword)cGroup_1.eContents().get(0);
		private final Assignment cEdgeTypesAssignment_1_1 = (Assignment)cGroup_1.eContents().get(1);
		private final RuleCall cEdgeTypesRefTypeParserRuleCall_1_1_0 = (RuleCall)cEdgeTypesAssignment_1_1.eContents().get(0);
		private final Assignment cTransitiveAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cTransitiveClosureTypeEnumRuleCall_2_0 = (RuleCall)cTransitiveAssignment_2.eContents().get(0);
		private final Keyword cLeftParenthesisKeyword_3 = (Keyword)cGroup.eContents().get(3);
		private final Assignment cSrcAssignment_4 = (Assignment)cGroup.eContents().get(4);
		private final RuleCall cSrcVariableReferenceParserRuleCall_4_0 = (RuleCall)cSrcAssignment_4.eContents().get(0);
		private final Keyword cCommaKeyword_5 = (Keyword)cGroup.eContents().get(5);
		private final Assignment cDstAssignment_6 = (Assignment)cGroup.eContents().get(6);
		private final RuleCall cDstValueReferenceParserRuleCall_6_0 = (RuleCall)cDstAssignment_6.eContents().get(0);
		private final Keyword cRightParenthesisKeyword_7 = (Keyword)cGroup.eContents().get(7);
		
		//PathExpressionConstraint:
		//	sourceType=Type ('.' edgeTypes+=RefType?)* transitive=ClosureType? '(' src=VariableReference ',' dst=ValueReference
		//	')';
		@Override public ParserRule getRule() { return rule; }
		
		//sourceType=Type ('.' edgeTypes+=RefType?)* transitive=ClosureType? '(' src=VariableReference ',' dst=ValueReference ')'
		public Group getGroup() { return cGroup; }
		
		//sourceType=Type
		public Assignment getSourceTypeAssignment_0() { return cSourceTypeAssignment_0; }
		
		//Type
		public RuleCall getSourceTypeTypeParserRuleCall_0_0() { return cSourceTypeTypeParserRuleCall_0_0; }
		
		//('.' edgeTypes+=RefType?)*
		public Group getGroup_1() { return cGroup_1; }
		
		//'.'
		public Keyword getFullStopKeyword_1_0() { return cFullStopKeyword_1_0; }
		
		//edgeTypes+=RefType?
		public Assignment getEdgeTypesAssignment_1_1() { return cEdgeTypesAssignment_1_1; }
		
		//RefType
		public RuleCall getEdgeTypesRefTypeParserRuleCall_1_1_0() { return cEdgeTypesRefTypeParserRuleCall_1_1_0; }
		
		//transitive=ClosureType?
		public Assignment getTransitiveAssignment_2() { return cTransitiveAssignment_2; }
		
		//ClosureType
		public RuleCall getTransitiveClosureTypeEnumRuleCall_2_0() { return cTransitiveClosureTypeEnumRuleCall_2_0; }
		
		//'('
		public Keyword getLeftParenthesisKeyword_3() { return cLeftParenthesisKeyword_3; }
		
		//src=VariableReference
		public Assignment getSrcAssignment_4() { return cSrcAssignment_4; }
		
		//VariableReference
		public RuleCall getSrcVariableReferenceParserRuleCall_4_0() { return cSrcVariableReferenceParserRuleCall_4_0; }
		
		//','
		public Keyword getCommaKeyword_5() { return cCommaKeyword_5; }
		
		//dst=ValueReference
		public Assignment getDstAssignment_6() { return cDstAssignment_6; }
		
		//ValueReference
		public RuleCall getDstValueReferenceParserRuleCall_6_0() { return cDstValueReferenceParserRuleCall_6_0; }
		
		//')'
		public Keyword getRightParenthesisKeyword_7() { return cRightParenthesisKeyword_7; }
	}
	public class ValueReferenceElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.viatra.query.patternlanguage.emf.EMFPatternLanguage.ValueReference");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cLiteralValueReferenceParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cVariableReferenceParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		private final RuleCall cComputationValueParserRuleCall_2 = (RuleCall)cAlternatives.eContents().get(2);
		
		//ValueReference:
		//	LiteralValueReference | VariableReference | ComputationValue;
		@Override public ParserRule getRule() { return rule; }
		
		//LiteralValueReference | VariableReference | ComputationValue
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//LiteralValueReference
		public RuleCall getLiteralValueReferenceParserRuleCall_0() { return cLiteralValueReferenceParserRuleCall_0; }
		
		//VariableReference
		public RuleCall getVariableReferenceParserRuleCall_1() { return cVariableReferenceParserRuleCall_1; }
		
		//ComputationValue
		public RuleCall getComputationValueParserRuleCall_2() { return cComputationValueParserRuleCall_2; }
	}
	public class AnnotationValueReferenceElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.viatra.query.patternlanguage.emf.EMFPatternLanguage.AnnotationValueReference");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cValueReferenceParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cListValueParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		
		//AnnotationValueReference ValueReference:
		//	ValueReference | ListValue;
		@Override public ParserRule getRule() { return rule; }
		
		//ValueReference | ListValue
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//ValueReference
		public RuleCall getValueReferenceParserRuleCall_0() { return cValueReferenceParserRuleCall_0; }
		
		//ListValue
		public RuleCall getListValueParserRuleCall_1() { return cListValueParserRuleCall_1; }
	}
	public class LiteralValueReferenceElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.viatra.query.patternlanguage.emf.EMFPatternLanguage.LiteralValueReference");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cNumberValueParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cStringValueParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		private final RuleCall cBoolValueParserRuleCall_2 = (RuleCall)cAlternatives.eContents().get(2);
		private final RuleCall cEnumValueParserRuleCall_3 = (RuleCall)cAlternatives.eContents().get(3);
		
		//LiteralValueReference ValueReference:
		//	NumberValue | StringValue | BoolValue | EnumValue;
		@Override public ParserRule getRule() { return rule; }
		
		//NumberValue | StringValue | BoolValue | EnumValue
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//NumberValue
		public RuleCall getNumberValueParserRuleCall_0() { return cNumberValueParserRuleCall_0; }
		
		//StringValue
		public RuleCall getStringValueParserRuleCall_1() { return cStringValueParserRuleCall_1; }
		
		//BoolValue
		public RuleCall getBoolValueParserRuleCall_2() { return cBoolValueParserRuleCall_2; }
		
		//EnumValue
		public RuleCall getEnumValueParserRuleCall_3() { return cEnumValueParserRuleCall_3; }
	}
	public class StringValueElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.viatra.query.patternlanguage.emf.EMFPatternLanguage.StringValue");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cStringValueAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cValueAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cValueSTRINGTerminalRuleCall_1_0 = (RuleCall)cValueAssignment_1.eContents().get(0);
		
		//StringValue LiteralValueReference:
		//	{StringValue} value=STRING;
		@Override public ParserRule getRule() { return rule; }
		
		//{StringValue} value=STRING
		public Group getGroup() { return cGroup; }
		
		//{StringValue}
		public Action getStringValueAction_0() { return cStringValueAction_0; }
		
		//value=STRING
		public Assignment getValueAssignment_1() { return cValueAssignment_1; }
		
		//STRING
		public RuleCall getValueSTRINGTerminalRuleCall_1_0() { return cValueSTRINGTerminalRuleCall_1_0; }
	}
	public class NumberValueElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.viatra.query.patternlanguage.emf.EMFPatternLanguage.NumberValue");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cNumberValueAction_0 = (Action)cGroup.eContents().get(0);
		private final Alternatives cAlternatives_1 = (Alternatives)cGroup.eContents().get(1);
		private final Keyword cPlusSignKeyword_1_0 = (Keyword)cAlternatives_1.eContents().get(0);
		private final Assignment cNegativeAssignment_1_1 = (Assignment)cAlternatives_1.eContents().get(1);
		private final Keyword cNegativeHyphenMinusKeyword_1_1_0 = (Keyword)cNegativeAssignment_1_1.eContents().get(0);
		private final Assignment cValueAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cValueXNumberLiteralParserRuleCall_2_0 = (RuleCall)cValueAssignment_2.eContents().get(0);
		
		//NumberValue LiteralValueReference:
		//	{NumberValue} ('+' | negative?='-')? value=XNumberLiteral;
		@Override public ParserRule getRule() { return rule; }
		
		//{NumberValue} ('+' | negative?='-')? value=XNumberLiteral
		public Group getGroup() { return cGroup; }
		
		//{NumberValue}
		public Action getNumberValueAction_0() { return cNumberValueAction_0; }
		
		//('+' | negative?='-')?
		public Alternatives getAlternatives_1() { return cAlternatives_1; }
		
		//'+'
		public Keyword getPlusSignKeyword_1_0() { return cPlusSignKeyword_1_0; }
		
		//negative?='-'
		public Assignment getNegativeAssignment_1_1() { return cNegativeAssignment_1_1; }
		
		//'-'
		public Keyword getNegativeHyphenMinusKeyword_1_1_0() { return cNegativeHyphenMinusKeyword_1_1_0; }
		
		//value=XNumberLiteral
		public Assignment getValueAssignment_2() { return cValueAssignment_2; }
		
		//XNumberLiteral
		public RuleCall getValueXNumberLiteralParserRuleCall_2_0() { return cValueXNumberLiteralParserRuleCall_2_0; }
	}
	public class XNumberLiteralElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.viatra.query.patternlanguage.emf.EMFPatternLanguage.XNumberLiteral");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cXNumberLiteralAction_0 = (Action)cGroup.eContents().get(0);
		private final Assignment cValueAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cValueNumberParserRuleCall_1_0 = (RuleCall)cValueAssignment_1.eContents().get(0);
		
		//@Override
		//XNumberLiteral xbase::XNumberLiteral:
		//	{xbase::XNumberLiteral} value=Number;
		@Override public ParserRule getRule() { return rule; }
		
		//{xbase::XNumberLiteral} value=Number
		public Group getGroup() { return cGroup; }
		
		//{xbase::XNumberLiteral}
		public Action getXNumberLiteralAction_0() { return cXNumberLiteralAction_0; }
		
		//value=Number
		public Assignment getValueAssignment_1() { return cValueAssignment_1; }
		
		//Number
		public RuleCall getValueNumberParserRuleCall_1_0() { return cValueNumberParserRuleCall_1_0; }
	}
	public class BoolValueElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.viatra.query.patternlanguage.emf.EMFPatternLanguage.BoolValue");
		private final Assignment cValueAssignment = (Assignment)rule.eContents().get(1);
		private final RuleCall cValueXBooleanLiteralParserRuleCall_0 = (RuleCall)cValueAssignment.eContents().get(0);
		
		//BoolValue:
		//	value=XBooleanLiteral;
		@Override public ParserRule getRule() { return rule; }
		
		//value=XBooleanLiteral
		public Assignment getValueAssignment() { return cValueAssignment; }
		
		//XBooleanLiteral
		public RuleCall getValueXBooleanLiteralParserRuleCall_0() { return cValueXBooleanLiteralParserRuleCall_0; }
	}
	public class XBooleanLiteralElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.viatra.query.patternlanguage.emf.EMFPatternLanguage.XBooleanLiteral");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Action cXBooleanLiteralAction_0 = (Action)cGroup.eContents().get(0);
		private final Alternatives cAlternatives_1 = (Alternatives)cGroup.eContents().get(1);
		private final Keyword cFalseKeyword_1_0 = (Keyword)cAlternatives_1.eContents().get(0);
		private final Keyword cFALSEKeyword_1_1 = (Keyword)cAlternatives_1.eContents().get(1);
		private final Assignment cIsTrueAssignment_1_2 = (Assignment)cAlternatives_1.eContents().get(2);
		private final Keyword cIsTrueTrueKeyword_1_2_0 = (Keyword)cIsTrueAssignment_1_2.eContents().get(0);
		private final Assignment cIsTrueAssignment_1_3 = (Assignment)cAlternatives_1.eContents().get(3);
		private final Keyword cIsTrueTRUEKeyword_1_3_0 = (Keyword)cIsTrueAssignment_1_3.eContents().get(0);
		
		//@Override
		//XBooleanLiteral xbase::XBooleanLiteral:
		//	{xbase::XBooleanLiteral} ('false' | 'FALSE' | isTrue?='true' | isTrue?="TRUE");
		@Override public ParserRule getRule() { return rule; }
		
		//{xbase::XBooleanLiteral} ('false' | 'FALSE' | isTrue?='true' | isTrue?="TRUE")
		public Group getGroup() { return cGroup; }
		
		//{xbase::XBooleanLiteral}
		public Action getXBooleanLiteralAction_0() { return cXBooleanLiteralAction_0; }
		
		//'false' | 'FALSE' | isTrue?='true' | isTrue?="TRUE"
		public Alternatives getAlternatives_1() { return cAlternatives_1; }
		
		//'false'
		public Keyword getFalseKeyword_1_0() { return cFalseKeyword_1_0; }
		
		//'FALSE'
		public Keyword getFALSEKeyword_1_1() { return cFALSEKeyword_1_1; }
		
		//isTrue?='true'
		public Assignment getIsTrueAssignment_1_2() { return cIsTrueAssignment_1_2; }
		
		//'true'
		public Keyword getIsTrueTrueKeyword_1_2_0() { return cIsTrueTrueKeyword_1_2_0; }
		
		//isTrue?="TRUE"
		public Assignment getIsTrueAssignment_1_3() { return cIsTrueAssignment_1_3; }
		
		//"TRUE"
		public Keyword getIsTrueTRUEKeyword_1_3_0() { return cIsTrueTRUEKeyword_1_3_0; }
	}
	public class ListValueElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.viatra.query.patternlanguage.emf.EMFPatternLanguage.ListValue");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cLeftCurlyBracketKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Assignment cValuesAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cValuesValueReferenceParserRuleCall_1_0 = (RuleCall)cValuesAssignment_1.eContents().get(0);
		private final Group cGroup_2 = (Group)cGroup.eContents().get(2);
		private final Keyword cCommaKeyword_2_0 = (Keyword)cGroup_2.eContents().get(0);
		private final Assignment cValuesAssignment_2_1 = (Assignment)cGroup_2.eContents().get(1);
		private final RuleCall cValuesValueReferenceParserRuleCall_2_1_0 = (RuleCall)cValuesAssignment_2_1.eContents().get(0);
		private final Keyword cRightCurlyBracketKeyword_3 = (Keyword)cGroup.eContents().get(3);
		
		//ListValue:
		//	'{' values+=ValueReference (',' values+=ValueReference)* '}';
		@Override public ParserRule getRule() { return rule; }
		
		//'{' values+=ValueReference (',' values+=ValueReference)* '}'
		public Group getGroup() { return cGroup; }
		
		//'{'
		public Keyword getLeftCurlyBracketKeyword_0() { return cLeftCurlyBracketKeyword_0; }
		
		//values+=ValueReference
		public Assignment getValuesAssignment_1() { return cValuesAssignment_1; }
		
		//ValueReference
		public RuleCall getValuesValueReferenceParserRuleCall_1_0() { return cValuesValueReferenceParserRuleCall_1_0; }
		
		//(',' values+=ValueReference)*
		public Group getGroup_2() { return cGroup_2; }
		
		//','
		public Keyword getCommaKeyword_2_0() { return cCommaKeyword_2_0; }
		
		//values+=ValueReference
		public Assignment getValuesAssignment_2_1() { return cValuesAssignment_2_1; }
		
		//ValueReference
		public RuleCall getValuesValueReferenceParserRuleCall_2_1_0() { return cValuesValueReferenceParserRuleCall_2_1_0; }
		
		//'}'
		public Keyword getRightCurlyBracketKeyword_3() { return cRightCurlyBracketKeyword_3; }
	}
	public class ComputationValueElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.viatra.query.patternlanguage.emf.EMFPatternLanguage.ComputationValue");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final RuleCall cAggregatedValueParserRuleCall_0 = (RuleCall)cAlternatives.eContents().get(0);
		private final RuleCall cFunctionEvaluationValueParserRuleCall_1 = (RuleCall)cAlternatives.eContents().get(1);
		
		//ComputationValue:
		//	AggregatedValue | FunctionEvaluationValue;
		@Override public ParserRule getRule() { return rule; }
		
		//AggregatedValue | FunctionEvaluationValue
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//AggregatedValue
		public RuleCall getAggregatedValueParserRuleCall_0() { return cAggregatedValueParserRuleCall_0; }
		
		//FunctionEvaluationValue
		public RuleCall getFunctionEvaluationValueParserRuleCall_1() { return cFunctionEvaluationValueParserRuleCall_1; }
	}
	public class FunctionEvaluationValueElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.viatra.query.patternlanguage.emf.EMFPatternLanguage.FunctionEvaluationValue");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cEvalKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Keyword cLeftParenthesisKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cExpressionAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cExpressionXExpressionParserRuleCall_2_0 = (RuleCall)cExpressionAssignment_2.eContents().get(0);
		private final Keyword cRightParenthesisKeyword_3 = (Keyword)cGroup.eContents().get(3);
		
		//FunctionEvaluationValue:
		//	'eval' '(' expression=XExpression ')';
		@Override public ParserRule getRule() { return rule; }
		
		//'eval' '(' expression=XExpression ')'
		public Group getGroup() { return cGroup; }
		
		//'eval'
		public Keyword getEvalKeyword_0() { return cEvalKeyword_0; }
		
		//'('
		public Keyword getLeftParenthesisKeyword_1() { return cLeftParenthesisKeyword_1; }
		
		//expression=XExpression
		public Assignment getExpressionAssignment_2() { return cExpressionAssignment_2; }
		
		//XExpression
		public RuleCall getExpressionXExpressionParserRuleCall_2_0() { return cExpressionXExpressionParserRuleCall_2_0; }
		
		//')'
		public Keyword getRightParenthesisKeyword_3() { return cRightParenthesisKeyword_3; }
	}
	public class AggregatedValueElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.viatra.query.patternlanguage.emf.EMFPatternLanguage.AggregatedValue");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cAggregatorAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final CrossReference cAggregatorJvmDeclaredTypeCrossReference_0_0 = (CrossReference)cAggregatorAssignment_0.eContents().get(0);
		private final RuleCall cAggregatorJvmDeclaredTypeValidIDParserRuleCall_0_0_1 = (RuleCall)cAggregatorJvmDeclaredTypeCrossReference_0_0.eContents().get(1);
		private final Alternatives cAlternatives_1 = (Alternatives)cGroup.eContents().get(1);
		private final Assignment cCallAssignment_1_0 = (Assignment)cAlternatives_1.eContents().get(0);
		private final RuleCall cCallPatternCallParserRuleCall_1_0_0 = (RuleCall)cCallAssignment_1_0.eContents().get(0);
		private final Assignment cCallAssignment_1_1 = (Assignment)cAlternatives_1.eContents().get(1);
		private final RuleCall cCallEClassifierConstraintParserRuleCall_1_1_0 = (RuleCall)cCallAssignment_1_1.eContents().get(0);
		private final Assignment cCallAssignment_1_2 = (Assignment)cAlternatives_1.eContents().get(2);
		private final RuleCall cCallPathExpressionConstraintParserRuleCall_1_2_0 = (RuleCall)cCallAssignment_1_2.eContents().get(0);
		
		//AggregatedValue:
		//	aggregator=[types::JvmDeclaredType|ValidID] (call=PatternCall | call=EClassifierConstraint |
		//	call=PathExpressionConstraint);
		@Override public ParserRule getRule() { return rule; }
		
		//// TODO aggregator should be QualifiedName
		//aggregator=[types::JvmDeclaredType|ValidID] (call=PatternCall | call=EClassifierConstraint |
		//call=PathExpressionConstraint)
		public Group getGroup() { return cGroup; }
		
		//// TODO aggregator should be QualifiedName
		//aggregator=[types::JvmDeclaredType|ValidID]
		public Assignment getAggregatorAssignment_0() { return cAggregatorAssignment_0; }
		
		//[types::JvmDeclaredType|ValidID]
		public CrossReference getAggregatorJvmDeclaredTypeCrossReference_0_0() { return cAggregatorJvmDeclaredTypeCrossReference_0_0; }
		
		//ValidID
		public RuleCall getAggregatorJvmDeclaredTypeValidIDParserRuleCall_0_0_1() { return cAggregatorJvmDeclaredTypeValidIDParserRuleCall_0_0_1; }
		
		//call=PatternCall | call=EClassifierConstraint | call=PathExpressionConstraint
		public Alternatives getAlternatives_1() { return cAlternatives_1; }
		
		//call=PatternCall
		public Assignment getCallAssignment_1_0() { return cCallAssignment_1_0; }
		
		//PatternCall
		public RuleCall getCallPatternCallParserRuleCall_1_0_0() { return cCallPatternCallParserRuleCall_1_0_0; }
		
		//call=EClassifierConstraint
		public Assignment getCallAssignment_1_1() { return cCallAssignment_1_1; }
		
		//EClassifierConstraint
		public RuleCall getCallEClassifierConstraintParserRuleCall_1_1_0() { return cCallEClassifierConstraintParserRuleCall_1_1_0; }
		
		//call=PathExpressionConstraint
		public Assignment getCallAssignment_1_2() { return cCallAssignment_1_2; }
		
		//PathExpressionConstraint
		public RuleCall getCallPathExpressionConstraintParserRuleCall_1_2_0() { return cCallPathExpressionConstraintParserRuleCall_1_2_0; }
	}
	public class EClassifierConstraintElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.viatra.query.patternlanguage.emf.EMFPatternLanguage.EClassifierConstraint");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cTypeAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cTypeTypeParserRuleCall_0_0 = (RuleCall)cTypeAssignment_0.eContents().get(0);
		private final Keyword cLeftParenthesisKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cVarAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cVarVariableReferenceParserRuleCall_2_0 = (RuleCall)cVarAssignment_2.eContents().get(0);
		private final Keyword cRightParenthesisKeyword_3 = (Keyword)cGroup.eContents().get(3);
		
		//EClassifierConstraint:
		//	type=Type '(' var=VariableReference ')';
		@Override public ParserRule getRule() { return rule; }
		
		//type=Type '(' var=VariableReference ')'
		public Group getGroup() { return cGroup; }
		
		//type=Type
		public Assignment getTypeAssignment_0() { return cTypeAssignment_0; }
		
		//Type
		public RuleCall getTypeTypeParserRuleCall_0_0() { return cTypeTypeParserRuleCall_0_0; }
		
		//'('
		public Keyword getLeftParenthesisKeyword_1() { return cLeftParenthesisKeyword_1; }
		
		//var=VariableReference
		public Assignment getVarAssignment_2() { return cVarAssignment_2; }
		
		//VariableReference
		public RuleCall getVarVariableReferenceParserRuleCall_2_0() { return cVarVariableReferenceParserRuleCall_2_0; }
		
		//')'
		public Keyword getRightParenthesisKeyword_3() { return cRightParenthesisKeyword_3; }
	}
	public class EnumValueElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.viatra.query.patternlanguage.emf.EMFPatternLanguage.EnumValue");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cEnumerationAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final CrossReference cEnumerationEEnumCrossReference_0_0 = (CrossReference)cEnumerationAssignment_0.eContents().get(0);
		private final RuleCall cEnumerationEEnumIDTerminalRuleCall_0_0_1 = (RuleCall)cEnumerationEEnumCrossReference_0_0.eContents().get(1);
		private final Keyword cColonColonKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cLiteralAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final CrossReference cLiteralEEnumLiteralCrossReference_2_0 = (CrossReference)cLiteralAssignment_2.eContents().get(0);
		private final RuleCall cLiteralEEnumLiteralIDTerminalRuleCall_2_0_1 = (RuleCall)cLiteralEEnumLiteralCrossReference_2_0.eContents().get(1);
		
		//EnumValue:
		//	enumeration=[ecore::EEnum]? '::' literal=[ecore::EEnumLiteral];
		@Override public ParserRule getRule() { return rule; }
		
		//enumeration=[ecore::EEnum]? '::' literal=[ecore::EEnumLiteral]
		public Group getGroup() { return cGroup; }
		
		//enumeration=[ecore::EEnum]?
		public Assignment getEnumerationAssignment_0() { return cEnumerationAssignment_0; }
		
		//[ecore::EEnum]
		public CrossReference getEnumerationEEnumCrossReference_0_0() { return cEnumerationEEnumCrossReference_0_0; }
		
		//ID
		public RuleCall getEnumerationEEnumIDTerminalRuleCall_0_0_1() { return cEnumerationEEnumIDTerminalRuleCall_0_0_1; }
		
		//'::'
		public Keyword getColonColonKeyword_1() { return cColonColonKeyword_1; }
		
		//literal=[ecore::EEnumLiteral]
		public Assignment getLiteralAssignment_2() { return cLiteralAssignment_2; }
		
		//[ecore::EEnumLiteral]
		public CrossReference getLiteralEEnumLiteralCrossReference_2_0() { return cLiteralEEnumLiteralCrossReference_2_0; }
		
		//ID
		public RuleCall getLiteralEEnumLiteralIDTerminalRuleCall_2_0_1() { return cLiteralEEnumLiteralIDTerminalRuleCall_2_0_1; }
	}
	
	public class ExecutionTypeModifierElements extends AbstractEnumRuleElementFinder {
		private final EnumRule rule = (EnumRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.viatra.query.patternlanguage.emf.EMFPatternLanguage.ExecutionTypeModifier");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final EnumLiteralDeclaration cSearchEnumLiteralDeclaration_0 = (EnumLiteralDeclaration)cAlternatives.eContents().get(0);
		private final Keyword cSearchSearchKeyword_0_0 = (Keyword)cSearchEnumLiteralDeclaration_0.eContents().get(0);
		private final EnumLiteralDeclaration cIncrementalEnumLiteralDeclaration_1 = (EnumLiteralDeclaration)cAlternatives.eContents().get(1);
		private final Keyword cIncrementalIncrementalKeyword_1_0 = (Keyword)cIncrementalEnumLiteralDeclaration_1.eContents().get(0);
		
		//enum ExecutionTypeModifier returns ExecutionType:
		//	search | incremental;
		public EnumRule getRule() { return rule; }
		
		//search | incremental
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//search
		public EnumLiteralDeclaration getSearchEnumLiteralDeclaration_0() { return cSearchEnumLiteralDeclaration_0; }
		
		//"search"
		public Keyword getSearchSearchKeyword_0_0() { return cSearchSearchKeyword_0_0; }
		
		//incremental
		public EnumLiteralDeclaration getIncrementalEnumLiteralDeclaration_1() { return cIncrementalEnumLiteralDeclaration_1; }
		
		//"incremental"
		public Keyword getIncrementalIncrementalKeyword_1_0() { return cIncrementalIncrementalKeyword_1_0; }
	}
	public class ParameterDirectionModifierElements extends AbstractEnumRuleElementFinder {
		private final EnumRule rule = (EnumRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.viatra.query.patternlanguage.emf.EMFPatternLanguage.ParameterDirectionModifier");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final EnumLiteralDeclaration cInEnumLiteralDeclaration_0 = (EnumLiteralDeclaration)cAlternatives.eContents().get(0);
		private final Keyword cInInKeyword_0_0 = (Keyword)cInEnumLiteralDeclaration_0.eContents().get(0);
		private final EnumLiteralDeclaration cOutEnumLiteralDeclaration_1 = (EnumLiteralDeclaration)cAlternatives.eContents().get(1);
		private final Keyword cOutOutKeyword_1_0 = (Keyword)cOutEnumLiteralDeclaration_1.eContents().get(0);
		
		//enum ParameterDirectionModifier returns ParameterDirection:
		//	in | out;
		public EnumRule getRule() { return rule; }
		
		//in | out
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//in
		public EnumLiteralDeclaration getInEnumLiteralDeclaration_0() { return cInEnumLiteralDeclaration_0; }
		
		//"in"
		public Keyword getInInKeyword_0_0() { return cInInKeyword_0_0; }
		
		//out
		public EnumLiteralDeclaration getOutEnumLiteralDeclaration_1() { return cOutEnumLiteralDeclaration_1; }
		
		//"out"
		public Keyword getOutOutKeyword_1_0() { return cOutOutKeyword_1_0; }
	}
	public class CompareFeatureElements extends AbstractEnumRuleElementFinder {
		private final EnumRule rule = (EnumRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.viatra.query.patternlanguage.emf.EMFPatternLanguage.CompareFeature");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final EnumLiteralDeclaration cEqualityEnumLiteralDeclaration_0 = (EnumLiteralDeclaration)cAlternatives.eContents().get(0);
		private final Keyword cEqualityEqualsSignEqualsSignKeyword_0_0 = (Keyword)cEqualityEnumLiteralDeclaration_0.eContents().get(0);
		private final EnumLiteralDeclaration cInequalityEnumLiteralDeclaration_1 = (EnumLiteralDeclaration)cAlternatives.eContents().get(1);
		private final Keyword cInequalityExclamationMarkEqualsSignKeyword_1_0 = (Keyword)cInequalityEnumLiteralDeclaration_1.eContents().get(0);
		
		//enum CompareFeature:
		//	equality='==' | inequality='!=';
		public EnumRule getRule() { return rule; }
		
		//equality='==' | inequality='!='
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//equality='=='
		public EnumLiteralDeclaration getEqualityEnumLiteralDeclaration_0() { return cEqualityEnumLiteralDeclaration_0; }
		
		//'=='
		public Keyword getEqualityEqualsSignEqualsSignKeyword_0_0() { return cEqualityEqualsSignEqualsSignKeyword_0_0; }
		
		//inequality='!='
		public EnumLiteralDeclaration getInequalityEnumLiteralDeclaration_1() { return cInequalityEnumLiteralDeclaration_1; }
		
		//'!='
		public Keyword getInequalityExclamationMarkEqualsSignKeyword_1_0() { return cInequalityExclamationMarkEqualsSignKeyword_1_0; }
	}
	public class ClosureTypeElements extends AbstractEnumRuleElementFinder {
		private final EnumRule rule = (EnumRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.viatra.query.patternlanguage.emf.EMFPatternLanguage.ClosureType");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final EnumLiteralDeclaration cReflexive_transitiveEnumLiteralDeclaration_0 = (EnumLiteralDeclaration)cAlternatives.eContents().get(0);
		private final Keyword cReflexive_transitiveAsteriskKeyword_0_0 = (Keyword)cReflexive_transitiveEnumLiteralDeclaration_0.eContents().get(0);
		private final EnumLiteralDeclaration cTransitiveEnumLiteralDeclaration_1 = (EnumLiteralDeclaration)cAlternatives.eContents().get(1);
		private final Keyword cTransitivePlusSignKeyword_1_0 = (Keyword)cTransitiveEnumLiteralDeclaration_1.eContents().get(0);
		
		//enum ClosureType:
		//	reflexive_transitive='*' | transitive='+';
		public EnumRule getRule() { return rule; }
		
		//reflexive_transitive='*' | transitive='+'
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//reflexive_transitive='*'
		public EnumLiteralDeclaration getReflexive_transitiveEnumLiteralDeclaration_0() { return cReflexive_transitiveEnumLiteralDeclaration_0; }
		
		//'*'
		public Keyword getReflexive_transitiveAsteriskKeyword_0_0() { return cReflexive_transitiveAsteriskKeyword_0_0; }
		
		//transitive='+'
		public EnumLiteralDeclaration getTransitiveEnumLiteralDeclaration_1() { return cTransitiveEnumLiteralDeclaration_1; }
		
		//'+'
		public Keyword getTransitivePlusSignKeyword_1_0() { return cTransitivePlusSignKeyword_1_0; }
	}
	
	private final PatternModelElements pPatternModel;
	private final VQLImportSectionElements pVQLImportSection;
	private final PackageImportElements pPackageImport;
	private final PatternImportElements pPatternImport;
	private final XImportDeclarationElements pXImportDeclaration;
	private final PatternElements pPattern;
	private final AnnotationElements pAnnotation;
	private final AnnotationParameterElements pAnnotationParameter;
	private final ModifiersElements pModifiers;
	private final ExecutionTypeModifierElements eExecutionTypeModifier;
	private final ParameterDirectionModifierElements eParameterDirectionModifier;
	private final ParameterElements pParameter;
	private final VariableReferenceElements pVariableReference;
	private final TypeElements pType;
	private final RefTypeElements pRefType;
	private final JavaTypeElements pJavaType;
	private final PatternBodyElements pPatternBody;
	private final ConstraintElements pConstraint;
	private final TypeCheckConstraintElements pTypeCheckConstraint;
	private final PatternCompositionConstraintElements pPatternCompositionConstraint;
	private final PatternCallElements pPatternCall;
	private final CompareConstraintElements pCompareConstraint;
	private final CompareFeatureElements eCompareFeature;
	private final CheckConstraintElements pCheckConstraint;
	private final PathExpressionConstraintElements pPathExpressionConstraint;
	private final ValueReferenceElements pValueReference;
	private final AnnotationValueReferenceElements pAnnotationValueReference;
	private final LiteralValueReferenceElements pLiteralValueReference;
	private final StringValueElements pStringValue;
	private final NumberValueElements pNumberValue;
	private final XNumberLiteralElements pXNumberLiteral;
	private final BoolValueElements pBoolValue;
	private final XBooleanLiteralElements pXBooleanLiteral;
	private final ListValueElements pListValue;
	private final ComputationValueElements pComputationValue;
	private final FunctionEvaluationValueElements pFunctionEvaluationValue;
	private final AggregatedValueElements pAggregatedValue;
	private final EClassifierConstraintElements pEClassifierConstraint;
	private final EnumValueElements pEnumValue;
	private final ClosureTypeElements eClosureType;
	
	private final Grammar grammar;
	
	private final XbaseGrammarAccess gaXbase;
	
	private final XtypeGrammarAccess gaXtype;

	@Inject
	public EMFPatternLanguageGrammarAccess(GrammarProvider grammarProvider,
			XbaseGrammarAccess gaXbase,
			XtypeGrammarAccess gaXtype) {
		this.grammar = internalFindGrammar(grammarProvider);
		this.gaXbase = gaXbase;
		this.gaXtype = gaXtype;
		this.pPatternModel = new PatternModelElements();
		this.pVQLImportSection = new VQLImportSectionElements();
		this.pPackageImport = new PackageImportElements();
		this.pPatternImport = new PatternImportElements();
		this.pXImportDeclaration = new XImportDeclarationElements();
		this.pPattern = new PatternElements();
		this.pAnnotation = new AnnotationElements();
		this.pAnnotationParameter = new AnnotationParameterElements();
		this.pModifiers = new ModifiersElements();
		this.eExecutionTypeModifier = new ExecutionTypeModifierElements();
		this.eParameterDirectionModifier = new ParameterDirectionModifierElements();
		this.pParameter = new ParameterElements();
		this.pVariableReference = new VariableReferenceElements();
		this.pType = new TypeElements();
		this.pRefType = new RefTypeElements();
		this.pJavaType = new JavaTypeElements();
		this.pPatternBody = new PatternBodyElements();
		this.pConstraint = new ConstraintElements();
		this.pTypeCheckConstraint = new TypeCheckConstraintElements();
		this.pPatternCompositionConstraint = new PatternCompositionConstraintElements();
		this.pPatternCall = new PatternCallElements();
		this.pCompareConstraint = new CompareConstraintElements();
		this.eCompareFeature = new CompareFeatureElements();
		this.pCheckConstraint = new CheckConstraintElements();
		this.pPathExpressionConstraint = new PathExpressionConstraintElements();
		this.pValueReference = new ValueReferenceElements();
		this.pAnnotationValueReference = new AnnotationValueReferenceElements();
		this.pLiteralValueReference = new LiteralValueReferenceElements();
		this.pStringValue = new StringValueElements();
		this.pNumberValue = new NumberValueElements();
		this.pXNumberLiteral = new XNumberLiteralElements();
		this.pBoolValue = new BoolValueElements();
		this.pXBooleanLiteral = new XBooleanLiteralElements();
		this.pListValue = new ListValueElements();
		this.pComputationValue = new ComputationValueElements();
		this.pFunctionEvaluationValue = new FunctionEvaluationValueElements();
		this.pAggregatedValue = new AggregatedValueElements();
		this.pEClassifierConstraint = new EClassifierConstraintElements();
		this.pEnumValue = new EnumValueElements();
		this.eClosureType = new ClosureTypeElements();
	}
	
	protected Grammar internalFindGrammar(GrammarProvider grammarProvider) {
		Grammar grammar = grammarProvider.getGrammar(this);
		while (grammar != null) {
			if ("org.eclipse.viatra.query.patternlanguage.emf.EMFPatternLanguage".equals(grammar.getName())) {
				return grammar;
			}
			List<Grammar> grammars = grammar.getUsedGrammars();
			if (!grammars.isEmpty()) {
				grammar = grammars.iterator().next();
			} else {
				return null;
			}
		}
		return grammar;
	}
	
	@Override
	public Grammar getGrammar() {
		return grammar;
	}
	
	
	public XbaseGrammarAccess getXbaseGrammarAccess() {
		return gaXbase;
	}
	
	public XtypeGrammarAccess getXtypeGrammarAccess() {
		return gaXtype;
	}

	
	//PatternModel:
	//	('package' packageName=QualifiedName ';'?)?
	//	importPackages=VQLImportSection patterns+=Pattern*;
	public PatternModelElements getPatternModelAccess() {
		return pPatternModel;
	}
	
	public ParserRule getPatternModelRule() {
		return getPatternModelAccess().getRule();
	}
	
	//VQLImportSection:
	//	{VQLImportSection} (packageImport+=PackageImport | patternImport+=PatternImport |
	//	importDeclarations+=XImportDeclaration)*;
	public VQLImportSectionElements getVQLImportSectionAccess() {
		return pVQLImportSection;
	}
	
	public ParserRule getVQLImportSectionRule() {
		return getVQLImportSectionAccess().getRule();
	}
	
	//PackageImport:
	//	'import' 'epackage'? ePackage=[ecore::EPackage|STRING] ('as' alias=ID)? ';'?;
	public PackageImportElements getPackageImportAccess() {
		return pPackageImport;
	}
	
	public ParserRule getPackageImportRule() {
		return getPackageImportAccess().getRule();
	}
	
	//PatternImport:
	//	'import' 'pattern'? pattern=[Pattern|QualifiedName] ';'?;
	public PatternImportElements getPatternImportAccess() {
		return pPatternImport;
	}
	
	public ParserRule getPatternImportRule() {
		return getPatternImportAccess().getRule();
	}
	
	//@Override
	//XImportDeclaration xtype::XImportDeclaration:
	//	'import' 'java' (static?='static' extension?='extension'? importedType=[types::JvmDeclaredType|QualifiedName] '.'
	//	'*' | importedType=[types::JvmDeclaredType|QualifiedName] | importedNamespace=QualifiedNameWithWildcard) ';'?;
	public XImportDeclarationElements getXImportDeclarationAccess() {
		return pXImportDeclaration;
	}
	
	public ParserRule getXImportDeclarationRule() {
		return getXImportDeclarationAccess().getRule();
	}
	
	//Pattern:
	//	annotations+=Annotation*
	//	modifiers=Modifiers
	//	'pattern'
	//	name=ID
	//	'(' (parameters+=Parameter (',' parameters+=Parameter)*)?
	//	')'
	//	'='?
	//	bodies+=PatternBody ('or' bodies+=PatternBody)*;
	public PatternElements getPatternAccess() {
		return pPattern;
	}
	
	public ParserRule getPatternRule() {
		return getPatternAccess().getRule();
	}
	
	//Annotation:
	//	'@'
	//	name=ID ('(' parameters+=AnnotationParameter (',' parameters+=AnnotationParameter)* ')')?;
	public AnnotationElements getAnnotationAccess() {
		return pAnnotation;
	}
	
	public ParserRule getAnnotationRule() {
		return getAnnotationAccess().getRule();
	}
	
	//AnnotationParameter:
	//	name=ID '=' value=AnnotationValueReference;
	public AnnotationParameterElements getAnnotationParameterAccess() {
		return pAnnotationParameter;
	}
	
	public ParserRule getAnnotationParameterRule() {
		return getAnnotationParameterAccess().getRule();
	}
	
	//Modifiers:
	//	{Modifiers} (private?='private'? & execution=ExecutionTypeModifier?);
	public ModifiersElements getModifiersAccess() {
		return pModifiers;
	}
	
	public ParserRule getModifiersRule() {
		return getModifiersAccess().getRule();
	}
	
	//enum ExecutionTypeModifier returns ExecutionType:
	//	search | incremental;
	public ExecutionTypeModifierElements getExecutionTypeModifierAccess() {
		return eExecutionTypeModifier;
	}
	
	public EnumRule getExecutionTypeModifierRule() {
		return getExecutionTypeModifierAccess().getRule();
	}
	
	//enum ParameterDirectionModifier returns ParameterDirection:
	//	in | out;
	public ParameterDirectionModifierElements getParameterDirectionModifierAccess() {
		return eParameterDirectionModifier;
	}
	
	public EnumRule getParameterDirectionModifierRule() {
		return getParameterDirectionModifierAccess().getRule();
	}
	
	//Parameter:
	//	direction=ParameterDirectionModifier?
	//	name=ID (':' type=Type | ':' type=JavaType)?;
	public ParameterElements getParameterAccess() {
		return pParameter;
	}
	
	public ParserRule getParameterRule() {
		return getParameterAccess().getRule();
	}
	
	//VariableReference:
	//	aggregator?='#'? var=ID | aggregator?='#';
	public VariableReferenceElements getVariableReferenceAccess() {
		return pVariableReference;
	}
	
	public ParserRule getVariableReferenceRule() {
		return getVariableReferenceAccess().getRule();
	}
	
	//Type ClassType:
	//	(metamodel=[PackageImport] '::')? classname=[ecore::EClassifier];
	public TypeElements getTypeAccess() {
		return pType;
	}
	
	public ParserRule getTypeRule() {
		return getTypeAccess().getRule();
	}
	
	//RefType ReferenceType:
	//	{ReferenceType} refname=[ecore::EStructuralFeature];
	public RefTypeElements getRefTypeAccess() {
		return pRefType;
	}
	
	public ParserRule getRefTypeRule() {
		return getRefTypeAccess().getRule();
	}
	
	//JavaType EntityType:
	//	{JavaType} 'java' classRef=[types::JvmDeclaredType|QualifiedName];
	public JavaTypeElements getJavaTypeAccess() {
		return pJavaType;
	}
	
	public ParserRule getJavaTypeRule() {
		return getJavaTypeAccess().getRule();
	}
	
	//PatternBody:
	//	{PatternBody} name=ID?
	//	'{' (constraints+=Constraint ';')*
	//	'}';
	public PatternBodyElements getPatternBodyAccess() {
		return pPatternBody;
	}
	
	public ParserRule getPatternBodyRule() {
		return getPatternBodyAccess().getRule();
	}
	
	//Constraint:
	//	CheckConstraint | TypeCheckConstraint | CompareConstraint | PatternCompositionConstraint | PathExpressionConstraint
	//	| EClassifierConstraint;
	public ConstraintElements getConstraintAccess() {
		return pConstraint;
	}
	
	public ParserRule getConstraintRule() {
		return getConstraintAccess().getRule();
	}
	
	//TypeCheckConstraint:
	//	type=JavaType '(' var=VariableReference ')';
	public TypeCheckConstraintElements getTypeCheckConstraintAccess() {
		return pTypeCheckConstraint;
	}
	
	public ParserRule getTypeCheckConstraintRule() {
		return getTypeCheckConstraintAccess().getRule();
	}
	
	//PatternCompositionConstraint:
	//	negative?='neg'? call=PatternCall
	//	| negative?='neg' (call=EClassifierConstraint | call=PathExpressionConstraint);
	public PatternCompositionConstraintElements getPatternCompositionConstraintAccess() {
		return pPatternCompositionConstraint;
	}
	
	public ParserRule getPatternCompositionConstraintRule() {
		return getPatternCompositionConstraintAccess().getRule();
	}
	
	//PatternCall:
	//	'find' patternRef=[Pattern|QualifiedName] transitive=ClosureType? '(' (parameters+=ValueReference (','
	//	parameters+=ValueReference)*)? ')';
	public PatternCallElements getPatternCallAccess() {
		return pPatternCall;
	}
	
	public ParserRule getPatternCallRule() {
		return getPatternCallAccess().getRule();
	}
	
	//CompareConstraint:
	//	leftOperand=ValueReference feature=CompareFeature rightOperand=ValueReference;
	public CompareConstraintElements getCompareConstraintAccess() {
		return pCompareConstraint;
	}
	
	public ParserRule getCompareConstraintRule() {
		return getCompareConstraintAccess().getRule();
	}
	
	//enum CompareFeature:
	//	equality='==' | inequality='!=';
	public CompareFeatureElements getCompareFeatureAccess() {
		return eCompareFeature;
	}
	
	public EnumRule getCompareFeatureRule() {
		return getCompareFeatureAccess().getRule();
	}
	
	//CheckConstraint:
	//	'check' '(' expression=XExpression ')';
	public CheckConstraintElements getCheckConstraintAccess() {
		return pCheckConstraint;
	}
	
	public ParserRule getCheckConstraintRule() {
		return getCheckConstraintAccess().getRule();
	}
	
	//PathExpressionConstraint:
	//	sourceType=Type ('.' edgeTypes+=RefType?)* transitive=ClosureType? '(' src=VariableReference ',' dst=ValueReference
	//	')';
	public PathExpressionConstraintElements getPathExpressionConstraintAccess() {
		return pPathExpressionConstraint;
	}
	
	public ParserRule getPathExpressionConstraintRule() {
		return getPathExpressionConstraintAccess().getRule();
	}
	
	//ValueReference:
	//	LiteralValueReference | VariableReference | ComputationValue;
	public ValueReferenceElements getValueReferenceAccess() {
		return pValueReference;
	}
	
	public ParserRule getValueReferenceRule() {
		return getValueReferenceAccess().getRule();
	}
	
	//AnnotationValueReference ValueReference:
	//	ValueReference | ListValue;
	public AnnotationValueReferenceElements getAnnotationValueReferenceAccess() {
		return pAnnotationValueReference;
	}
	
	public ParserRule getAnnotationValueReferenceRule() {
		return getAnnotationValueReferenceAccess().getRule();
	}
	
	//LiteralValueReference ValueReference:
	//	NumberValue | StringValue | BoolValue | EnumValue;
	public LiteralValueReferenceElements getLiteralValueReferenceAccess() {
		return pLiteralValueReference;
	}
	
	public ParserRule getLiteralValueReferenceRule() {
		return getLiteralValueReferenceAccess().getRule();
	}
	
	//StringValue LiteralValueReference:
	//	{StringValue} value=STRING;
	public StringValueElements getStringValueAccess() {
		return pStringValue;
	}
	
	public ParserRule getStringValueRule() {
		return getStringValueAccess().getRule();
	}
	
	//NumberValue LiteralValueReference:
	//	{NumberValue} ('+' | negative?='-')? value=XNumberLiteral;
	public NumberValueElements getNumberValueAccess() {
		return pNumberValue;
	}
	
	public ParserRule getNumberValueRule() {
		return getNumberValueAccess().getRule();
	}
	
	//@Override
	//XNumberLiteral xbase::XNumberLiteral:
	//	{xbase::XNumberLiteral} value=Number;
	public XNumberLiteralElements getXNumberLiteralAccess() {
		return pXNumberLiteral;
	}
	
	public ParserRule getXNumberLiteralRule() {
		return getXNumberLiteralAccess().getRule();
	}
	
	//BoolValue:
	//	value=XBooleanLiteral;
	public BoolValueElements getBoolValueAccess() {
		return pBoolValue;
	}
	
	public ParserRule getBoolValueRule() {
		return getBoolValueAccess().getRule();
	}
	
	//@Override
	//XBooleanLiteral xbase::XBooleanLiteral:
	//	{xbase::XBooleanLiteral} ('false' | 'FALSE' | isTrue?='true' | isTrue?="TRUE");
	public XBooleanLiteralElements getXBooleanLiteralAccess() {
		return pXBooleanLiteral;
	}
	
	public ParserRule getXBooleanLiteralRule() {
		return getXBooleanLiteralAccess().getRule();
	}
	
	//ListValue:
	//	'{' values+=ValueReference (',' values+=ValueReference)* '}';
	public ListValueElements getListValueAccess() {
		return pListValue;
	}
	
	public ParserRule getListValueRule() {
		return getListValueAccess().getRule();
	}
	
	//ComputationValue:
	//	AggregatedValue | FunctionEvaluationValue;
	public ComputationValueElements getComputationValueAccess() {
		return pComputationValue;
	}
	
	public ParserRule getComputationValueRule() {
		return getComputationValueAccess().getRule();
	}
	
	//FunctionEvaluationValue:
	//	'eval' '(' expression=XExpression ')';
	public FunctionEvaluationValueElements getFunctionEvaluationValueAccess() {
		return pFunctionEvaluationValue;
	}
	
	public ParserRule getFunctionEvaluationValueRule() {
		return getFunctionEvaluationValueAccess().getRule();
	}
	
	//AggregatedValue:
	//	aggregator=[types::JvmDeclaredType|ValidID] (call=PatternCall | call=EClassifierConstraint |
	//	call=PathExpressionConstraint);
	public AggregatedValueElements getAggregatedValueAccess() {
		return pAggregatedValue;
	}
	
	public ParserRule getAggregatedValueRule() {
		return getAggregatedValueAccess().getRule();
	}
	
	//EClassifierConstraint:
	//	type=Type '(' var=VariableReference ')';
	public EClassifierConstraintElements getEClassifierConstraintAccess() {
		return pEClassifierConstraint;
	}
	
	public ParserRule getEClassifierConstraintRule() {
		return getEClassifierConstraintAccess().getRule();
	}
	
	//EnumValue:
	//	enumeration=[ecore::EEnum]? '::' literal=[ecore::EEnumLiteral];
	public EnumValueElements getEnumValueAccess() {
		return pEnumValue;
	}
	
	public ParserRule getEnumValueRule() {
		return getEnumValueAccess().getRule();
	}
	
	//enum ClosureType:
	//	reflexive_transitive='*' | transitive='+';
	public ClosureTypeElements getClosureTypeAccess() {
		return eClosureType;
	}
	
	public EnumRule getClosureTypeRule() {
		return getClosureTypeAccess().getRule();
	}
	
	//XExpression:
	//	XAssignment;
	public XbaseGrammarAccess.XExpressionElements getXExpressionAccess() {
		return gaXbase.getXExpressionAccess();
	}
	
	public ParserRule getXExpressionRule() {
		return getXExpressionAccess().getRule();
	}
	
	//XAssignment XExpression:
	//	{XAssignment} feature=[types::JvmIdentifiableElement|FeatureCallID] OpSingleAssign value=XAssignment | XOrExpression
	//	(=> ({XBinaryOperation.leftOperand=current} feature=[types::JvmIdentifiableElement|OpMultiAssign])
	//	rightOperand=XAssignment)?;
	public XbaseGrammarAccess.XAssignmentElements getXAssignmentAccess() {
		return gaXbase.getXAssignmentAccess();
	}
	
	public ParserRule getXAssignmentRule() {
		return getXAssignmentAccess().getRule();
	}
	
	//OpSingleAssign:
	//	'=';
	public XbaseGrammarAccess.OpSingleAssignElements getOpSingleAssignAccess() {
		return gaXbase.getOpSingleAssignAccess();
	}
	
	public ParserRule getOpSingleAssignRule() {
		return getOpSingleAssignAccess().getRule();
	}
	
	//OpMultiAssign:
	//	'+=' | '-=' | '*=' | '/=' | '%=' |
	//	'<' '<' '=' |
	//	'>' '>'? '>=';
	public XbaseGrammarAccess.OpMultiAssignElements getOpMultiAssignAccess() {
		return gaXbase.getOpMultiAssignAccess();
	}
	
	public ParserRule getOpMultiAssignRule() {
		return getOpMultiAssignAccess().getRule();
	}
	
	//XOrExpression XExpression:
	//	XAndExpression (=> ({XBinaryOperation.leftOperand=current} feature=[types::JvmIdentifiableElement|OpOr])
	//	rightOperand=XAndExpression)*;
	public XbaseGrammarAccess.XOrExpressionElements getXOrExpressionAccess() {
		return gaXbase.getXOrExpressionAccess();
	}
	
	public ParserRule getXOrExpressionRule() {
		return getXOrExpressionAccess().getRule();
	}
	
	//OpOr:
	//	'||';
	public XbaseGrammarAccess.OpOrElements getOpOrAccess() {
		return gaXbase.getOpOrAccess();
	}
	
	public ParserRule getOpOrRule() {
		return getOpOrAccess().getRule();
	}
	
	//XAndExpression XExpression:
	//	XEqualityExpression (=> ({XBinaryOperation.leftOperand=current} feature=[types::JvmIdentifiableElement|OpAnd])
	//	rightOperand=XEqualityExpression)*;
	public XbaseGrammarAccess.XAndExpressionElements getXAndExpressionAccess() {
		return gaXbase.getXAndExpressionAccess();
	}
	
	public ParserRule getXAndExpressionRule() {
		return getXAndExpressionAccess().getRule();
	}
	
	//OpAnd:
	//	'&&';
	public XbaseGrammarAccess.OpAndElements getOpAndAccess() {
		return gaXbase.getOpAndAccess();
	}
	
	public ParserRule getOpAndRule() {
		return getOpAndAccess().getRule();
	}
	
	//XEqualityExpression XExpression:
	//	XRelationalExpression (=> ({XBinaryOperation.leftOperand=current} feature=[types::JvmIdentifiableElement|OpEquality])
	//	rightOperand=XRelationalExpression)*;
	public XbaseGrammarAccess.XEqualityExpressionElements getXEqualityExpressionAccess() {
		return gaXbase.getXEqualityExpressionAccess();
	}
	
	public ParserRule getXEqualityExpressionRule() {
		return getXEqualityExpressionAccess().getRule();
	}
	
	//OpEquality:
	//	'==' | '!=' | '===' | '!==';
	public XbaseGrammarAccess.OpEqualityElements getOpEqualityAccess() {
		return gaXbase.getOpEqualityAccess();
	}
	
	public ParserRule getOpEqualityRule() {
		return getOpEqualityAccess().getRule();
	}
	
	//XRelationalExpression XExpression:
	//	XOtherOperatorExpression (=> ({XInstanceOfExpression.expression=current} 'instanceof') type=JvmTypeReference |
	//	=> ({XBinaryOperation.leftOperand=current} feature=[types::JvmIdentifiableElement|OpCompare])
	//	rightOperand=XOtherOperatorExpression)*;
	public XbaseGrammarAccess.XRelationalExpressionElements getXRelationalExpressionAccess() {
		return gaXbase.getXRelationalExpressionAccess();
	}
	
	public ParserRule getXRelationalExpressionRule() {
		return getXRelationalExpressionAccess().getRule();
	}
	
	//OpCompare:
	//	'>=' | '<' '=' | '>' | '<';
	public XbaseGrammarAccess.OpCompareElements getOpCompareAccess() {
		return gaXbase.getOpCompareAccess();
	}
	
	public ParserRule getOpCompareRule() {
		return getOpCompareAccess().getRule();
	}
	
	//XOtherOperatorExpression XExpression:
	//	XAdditiveExpression (=> ({XBinaryOperation.leftOperand=current} feature=[types::JvmIdentifiableElement|OpOther])
	//	rightOperand=XAdditiveExpression)*;
	public XbaseGrammarAccess.XOtherOperatorExpressionElements getXOtherOperatorExpressionAccess() {
		return gaXbase.getXOtherOperatorExpressionAccess();
	}
	
	public ParserRule getXOtherOperatorExpressionRule() {
		return getXOtherOperatorExpressionAccess().getRule();
	}
	
	//OpOther:
	//	'->'
	//	| '..<'
	//	| '>' '..'
	//	| '..'
	//	| '=>'
	//	| '>' (=> ('>' '>') | '>') | '<' (=> ('<' '<') | '<' | '=>') | '<>'
	//	| '?:';
	public XbaseGrammarAccess.OpOtherElements getOpOtherAccess() {
		return gaXbase.getOpOtherAccess();
	}
	
	public ParserRule getOpOtherRule() {
		return getOpOtherAccess().getRule();
	}
	
	//XAdditiveExpression XExpression:
	//	XMultiplicativeExpression (=> ({XBinaryOperation.leftOperand=current} feature=[types::JvmIdentifiableElement|OpAdd])
	//	rightOperand=XMultiplicativeExpression)*;
	public XbaseGrammarAccess.XAdditiveExpressionElements getXAdditiveExpressionAccess() {
		return gaXbase.getXAdditiveExpressionAccess();
	}
	
	public ParserRule getXAdditiveExpressionRule() {
		return getXAdditiveExpressionAccess().getRule();
	}
	
	//OpAdd:
	//	'+' | '-';
	public XbaseGrammarAccess.OpAddElements getOpAddAccess() {
		return gaXbase.getOpAddAccess();
	}
	
	public ParserRule getOpAddRule() {
		return getOpAddAccess().getRule();
	}
	
	//XMultiplicativeExpression XExpression:
	//	XUnaryOperation (=> ({XBinaryOperation.leftOperand=current} feature=[types::JvmIdentifiableElement|OpMulti])
	//	rightOperand=XUnaryOperation)*;
	public XbaseGrammarAccess.XMultiplicativeExpressionElements getXMultiplicativeExpressionAccess() {
		return gaXbase.getXMultiplicativeExpressionAccess();
	}
	
	public ParserRule getXMultiplicativeExpressionRule() {
		return getXMultiplicativeExpressionAccess().getRule();
	}
	
	//OpMulti:
	//	'*' | '**' | '/' | '%';
	public XbaseGrammarAccess.OpMultiElements getOpMultiAccess() {
		return gaXbase.getOpMultiAccess();
	}
	
	public ParserRule getOpMultiRule() {
		return getOpMultiAccess().getRule();
	}
	
	//XUnaryOperation XExpression:
	//	{XUnaryOperation} feature=[types::JvmIdentifiableElement|OpUnary] operand=XUnaryOperation
	//	| XCastedExpression;
	public XbaseGrammarAccess.XUnaryOperationElements getXUnaryOperationAccess() {
		return gaXbase.getXUnaryOperationAccess();
	}
	
	public ParserRule getXUnaryOperationRule() {
		return getXUnaryOperationAccess().getRule();
	}
	
	//OpUnary:
	//	"!" | "-" | "+";
	public XbaseGrammarAccess.OpUnaryElements getOpUnaryAccess() {
		return gaXbase.getOpUnaryAccess();
	}
	
	public ParserRule getOpUnaryRule() {
		return getOpUnaryAccess().getRule();
	}
	
	//XCastedExpression XExpression:
	//	XPostfixOperation (=> ({XCastedExpression.target=current} 'as') type=JvmTypeReference)*;
	public XbaseGrammarAccess.XCastedExpressionElements getXCastedExpressionAccess() {
		return gaXbase.getXCastedExpressionAccess();
	}
	
	public ParserRule getXCastedExpressionRule() {
		return getXCastedExpressionAccess().getRule();
	}
	
	//XPostfixOperation XExpression:
	//	XMemberFeatureCall => ({XPostfixOperation.operand=current} feature=[types::JvmIdentifiableElement|OpPostfix])?;
	public XbaseGrammarAccess.XPostfixOperationElements getXPostfixOperationAccess() {
		return gaXbase.getXPostfixOperationAccess();
	}
	
	public ParserRule getXPostfixOperationRule() {
		return getXPostfixOperationAccess().getRule();
	}
	
	//OpPostfix:
	//	"++" | "--";
	public XbaseGrammarAccess.OpPostfixElements getOpPostfixAccess() {
		return gaXbase.getOpPostfixAccess();
	}
	
	public ParserRule getOpPostfixRule() {
		return getOpPostfixAccess().getRule();
	}
	
	//XMemberFeatureCall XExpression:
	//	XPrimaryExpression (=> ({XAssignment.assignable=current} ('.' | explicitStatic?="::")
	//	feature=[types::JvmIdentifiableElement|FeatureCallID] OpSingleAssign) value=XAssignment
	//	| => ({XMemberFeatureCall.memberCallTarget=current} ("." | nullSafe?="?." | explicitStatic?="::")) ('<'
	//	typeArguments+=JvmArgumentTypeReference (',' typeArguments+=JvmArgumentTypeReference)* '>')?
	//	feature=[types::JvmIdentifiableElement|IdOrSuper] (=> explicitOperationCall?='(' (memberCallArguments+=XShortClosure
	//	| memberCallArguments+=XExpression (',' memberCallArguments+=XExpression)*)?
	//	')')?
	//	memberCallArguments+=XClosure?)*;
	public XbaseGrammarAccess.XMemberFeatureCallElements getXMemberFeatureCallAccess() {
		return gaXbase.getXMemberFeatureCallAccess();
	}
	
	public ParserRule getXMemberFeatureCallRule() {
		return getXMemberFeatureCallAccess().getRule();
	}
	
	//XPrimaryExpression XExpression:
	//	XConstructorCall | XBlockExpression | XSwitchExpression | XSynchronizedExpression | XFeatureCall | XLiteral |
	//	XIfExpression | XForLoopExpression | XBasicForLoopExpression | XWhileExpression | XDoWhileExpression |
	//	XThrowExpression | XReturnExpression | XTryCatchFinallyExpression | XParenthesizedExpression;
	public XbaseGrammarAccess.XPrimaryExpressionElements getXPrimaryExpressionAccess() {
		return gaXbase.getXPrimaryExpressionAccess();
	}
	
	public ParserRule getXPrimaryExpressionRule() {
		return getXPrimaryExpressionAccess().getRule();
	}
	
	//XLiteral XExpression:
	//	XCollectionLiteral | XClosure | super::XBooleanLiteral | super::XNumberLiteral | XNullLiteral | XStringLiteral |
	//	XTypeLiteral;
	public XbaseGrammarAccess.XLiteralElements getXLiteralAccess() {
		return gaXbase.getXLiteralAccess();
	}
	
	public ParserRule getXLiteralRule() {
		return getXLiteralAccess().getRule();
	}
	
	//XCollectionLiteral:
	//	XSetLiteral | XListLiteral;
	public XbaseGrammarAccess.XCollectionLiteralElements getXCollectionLiteralAccess() {
		return gaXbase.getXCollectionLiteralAccess();
	}
	
	public ParserRule getXCollectionLiteralRule() {
		return getXCollectionLiteralAccess().getRule();
	}
	
	//XSetLiteral:
	//	{XSetLiteral} '#' '{' (elements+=XExpression (',' elements+=XExpression)*)? '}';
	public XbaseGrammarAccess.XSetLiteralElements getXSetLiteralAccess() {
		return gaXbase.getXSetLiteralAccess();
	}
	
	public ParserRule getXSetLiteralRule() {
		return getXSetLiteralAccess().getRule();
	}
	
	//XListLiteral:
	//	{XListLiteral} '#' '[' (elements+=XExpression (',' elements+=XExpression)*)? ']';
	public XbaseGrammarAccess.XListLiteralElements getXListLiteralAccess() {
		return gaXbase.getXListLiteralAccess();
	}
	
	public ParserRule getXListLiteralRule() {
		return getXListLiteralAccess().getRule();
	}
	
	//XClosure XExpression:
	//	=> ({XClosure}
	//	'[')
	//	=> ((declaredFormalParameters+=JvmFormalParameter (',' declaredFormalParameters+=JvmFormalParameter)*)?
	//	explicitSyntax?='|')?
	//	expression=XExpressionInClosure
	//	']';
	public XbaseGrammarAccess.XClosureElements getXClosureAccess() {
		return gaXbase.getXClosureAccess();
	}
	
	public ParserRule getXClosureRule() {
		return getXClosureAccess().getRule();
	}
	
	//XExpressionInClosure XExpression:
	//	{XBlockExpression} (expressions+=XExpressionOrVarDeclaration ';'?)*;
	public XbaseGrammarAccess.XExpressionInClosureElements getXExpressionInClosureAccess() {
		return gaXbase.getXExpressionInClosureAccess();
	}
	
	public ParserRule getXExpressionInClosureRule() {
		return getXExpressionInClosureAccess().getRule();
	}
	
	//XShortClosure XExpression:
	//	=> ({XClosure} (declaredFormalParameters+=JvmFormalParameter (',' declaredFormalParameters+=JvmFormalParameter)*)?
	//	explicitSyntax?='|') expression=XExpression;
	public XbaseGrammarAccess.XShortClosureElements getXShortClosureAccess() {
		return gaXbase.getXShortClosureAccess();
	}
	
	public ParserRule getXShortClosureRule() {
		return getXShortClosureAccess().getRule();
	}
	
	//XParenthesizedExpression XExpression:
	//	'(' XExpression ')';
	public XbaseGrammarAccess.XParenthesizedExpressionElements getXParenthesizedExpressionAccess() {
		return gaXbase.getXParenthesizedExpressionAccess();
	}
	
	public ParserRule getXParenthesizedExpressionRule() {
		return getXParenthesizedExpressionAccess().getRule();
	}
	
	//XIfExpression XExpression:
	//	{XIfExpression}
	//	'if' '(' if=XExpression ')'
	//	then=XExpression (=> 'else' else=XExpression)?;
	public XbaseGrammarAccess.XIfExpressionElements getXIfExpressionAccess() {
		return gaXbase.getXIfExpressionAccess();
	}
	
	public ParserRule getXIfExpressionRule() {
		return getXIfExpressionAccess().getRule();
	}
	
	//XSwitchExpression XExpression:
	//	{XSwitchExpression}
	//	'switch' (=> ('(' declaredParam=JvmFormalParameter ':') switch=XExpression ')'
	//	| => (declaredParam=JvmFormalParameter ':')? switch=XExpression) '{'
	//	cases+=XCasePart* ('default' ':' default=XExpression)?
	//	'}';
	public XbaseGrammarAccess.XSwitchExpressionElements getXSwitchExpressionAccess() {
		return gaXbase.getXSwitchExpressionAccess();
	}
	
	public ParserRule getXSwitchExpressionRule() {
		return getXSwitchExpressionAccess().getRule();
	}
	
	//XCasePart:
	//	{XCasePart} typeGuard=JvmTypeReference? ('case' case=XExpression)? (':' then=XExpression | fallThrough?=',');
	public XbaseGrammarAccess.XCasePartElements getXCasePartAccess() {
		return gaXbase.getXCasePartAccess();
	}
	
	public ParserRule getXCasePartRule() {
		return getXCasePartAccess().getRule();
	}
	
	//XForLoopExpression XExpression:
	//	=> ({XForLoopExpression}
	//	'for' '(' declaredParam=JvmFormalParameter ':') forExpression=XExpression ')'
	//	eachExpression=XExpression;
	public XbaseGrammarAccess.XForLoopExpressionElements getXForLoopExpressionAccess() {
		return gaXbase.getXForLoopExpressionAccess();
	}
	
	public ParserRule getXForLoopExpressionRule() {
		return getXForLoopExpressionAccess().getRule();
	}
	
	//XBasicForLoopExpression XExpression:
	//	{XBasicForLoopExpression}
	//	'for' '(' (initExpressions+=XExpressionOrVarDeclaration (',' initExpressions+=XExpressionOrVarDeclaration)*)? ';'
	//	expression=XExpression? ';' (updateExpressions+=XExpression (',' updateExpressions+=XExpression)*)? ')'
	//	eachExpression=XExpression;
	public XbaseGrammarAccess.XBasicForLoopExpressionElements getXBasicForLoopExpressionAccess() {
		return gaXbase.getXBasicForLoopExpressionAccess();
	}
	
	public ParserRule getXBasicForLoopExpressionRule() {
		return getXBasicForLoopExpressionAccess().getRule();
	}
	
	//XWhileExpression XExpression:
	//	{XWhileExpression}
	//	'while' '(' predicate=XExpression ')'
	//	body=XExpression;
	public XbaseGrammarAccess.XWhileExpressionElements getXWhileExpressionAccess() {
		return gaXbase.getXWhileExpressionAccess();
	}
	
	public ParserRule getXWhileExpressionRule() {
		return getXWhileExpressionAccess().getRule();
	}
	
	//XDoWhileExpression XExpression:
	//	{XDoWhileExpression}
	//	'do'
	//	body=XExpression
	//	'while' '(' predicate=XExpression ')';
	public XbaseGrammarAccess.XDoWhileExpressionElements getXDoWhileExpressionAccess() {
		return gaXbase.getXDoWhileExpressionAccess();
	}
	
	public ParserRule getXDoWhileExpressionRule() {
		return getXDoWhileExpressionAccess().getRule();
	}
	
	//XBlockExpression XExpression:
	//	{XBlockExpression}
	//	'{' (expressions+=XExpressionOrVarDeclaration ';'?)*
	//	'}';
	public XbaseGrammarAccess.XBlockExpressionElements getXBlockExpressionAccess() {
		return gaXbase.getXBlockExpressionAccess();
	}
	
	public ParserRule getXBlockExpressionRule() {
		return getXBlockExpressionAccess().getRule();
	}
	
	//XExpressionOrVarDeclaration XExpression:
	//	XVariableDeclaration | XExpression;
	public XbaseGrammarAccess.XExpressionOrVarDeclarationElements getXExpressionOrVarDeclarationAccess() {
		return gaXbase.getXExpressionOrVarDeclarationAccess();
	}
	
	public ParserRule getXExpressionOrVarDeclarationRule() {
		return getXExpressionOrVarDeclarationAccess().getRule();
	}
	
	//XVariableDeclaration XExpression:
	//	{XVariableDeclaration} (writeable?='var' | 'val') (=> (type=JvmTypeReference name=ValidID) | name=ValidID) ('='
	//	right=XExpression)?;
	public XbaseGrammarAccess.XVariableDeclarationElements getXVariableDeclarationAccess() {
		return gaXbase.getXVariableDeclarationAccess();
	}
	
	public ParserRule getXVariableDeclarationRule() {
		return getXVariableDeclarationAccess().getRule();
	}
	
	//JvmFormalParameter types::JvmFormalParameter:
	//	parameterType=JvmTypeReference? name=ValidID;
	public XbaseGrammarAccess.JvmFormalParameterElements getJvmFormalParameterAccess() {
		return gaXbase.getJvmFormalParameterAccess();
	}
	
	public ParserRule getJvmFormalParameterRule() {
		return getJvmFormalParameterAccess().getRule();
	}
	
	//FullJvmFormalParameter types::JvmFormalParameter:
	//	parameterType=JvmTypeReference name=ValidID;
	public XbaseGrammarAccess.FullJvmFormalParameterElements getFullJvmFormalParameterAccess() {
		return gaXbase.getFullJvmFormalParameterAccess();
	}
	
	public ParserRule getFullJvmFormalParameterRule() {
		return getFullJvmFormalParameterAccess().getRule();
	}
	
	//XFeatureCall XExpression:
	//	{XFeatureCall} ('<' typeArguments+=JvmArgumentTypeReference (',' typeArguments+=JvmArgumentTypeReference)* '>')?
	//	feature=[types::JvmIdentifiableElement|IdOrSuper] (=> explicitOperationCall?='(' (featureCallArguments+=XShortClosure
	//	| featureCallArguments+=XExpression (',' featureCallArguments+=XExpression)*)?
	//	')')?
	//	featureCallArguments+=XClosure?;
	public XbaseGrammarAccess.XFeatureCallElements getXFeatureCallAccess() {
		return gaXbase.getXFeatureCallAccess();
	}
	
	public ParserRule getXFeatureCallRule() {
		return getXFeatureCallAccess().getRule();
	}
	
	//FeatureCallID:
	//	ValidID | 'extends' | 'static' | 'import' | 'extension';
	public XbaseGrammarAccess.FeatureCallIDElements getFeatureCallIDAccess() {
		return gaXbase.getFeatureCallIDAccess();
	}
	
	public ParserRule getFeatureCallIDRule() {
		return getFeatureCallIDAccess().getRule();
	}
	
	//IdOrSuper:
	//	FeatureCallID | 'super';
	public XbaseGrammarAccess.IdOrSuperElements getIdOrSuperAccess() {
		return gaXbase.getIdOrSuperAccess();
	}
	
	public ParserRule getIdOrSuperRule() {
		return getIdOrSuperAccess().getRule();
	}
	
	//XConstructorCall XExpression:
	//	{XConstructorCall}
	//	'new' constructor=[types::JvmConstructor|QualifiedName] (=> '<' typeArguments+=JvmArgumentTypeReference (','
	//	typeArguments+=JvmArgumentTypeReference)* '>')? (=> explicitConstructorCall?='(' (arguments+=XShortClosure
	//	| arguments+=XExpression (',' arguments+=XExpression)*)?
	//	')')?
	//	arguments+=XClosure?;
	public XbaseGrammarAccess.XConstructorCallElements getXConstructorCallAccess() {
		return gaXbase.getXConstructorCallAccess();
	}
	
	public ParserRule getXConstructorCallRule() {
		return getXConstructorCallAccess().getRule();
	}
	
	//XNullLiteral XExpression:
	//	{XNullLiteral} 'null';
	public XbaseGrammarAccess.XNullLiteralElements getXNullLiteralAccess() {
		return gaXbase.getXNullLiteralAccess();
	}
	
	public ParserRule getXNullLiteralRule() {
		return getXNullLiteralAccess().getRule();
	}
	
	//XStringLiteral XExpression:
	//	{XStringLiteral} value=STRING;
	public XbaseGrammarAccess.XStringLiteralElements getXStringLiteralAccess() {
		return gaXbase.getXStringLiteralAccess();
	}
	
	public ParserRule getXStringLiteralRule() {
		return getXStringLiteralAccess().getRule();
	}
	
	//XTypeLiteral XExpression:
	//	{XTypeLiteral} 'typeof' '(' type=[types::JvmType|QualifiedName] arrayDimensions+=ArrayBrackets* ')';
	public XbaseGrammarAccess.XTypeLiteralElements getXTypeLiteralAccess() {
		return gaXbase.getXTypeLiteralAccess();
	}
	
	public ParserRule getXTypeLiteralRule() {
		return getXTypeLiteralAccess().getRule();
	}
	
	//XThrowExpression XExpression:
	//	{XThrowExpression} 'throw' expression=XExpression;
	public XbaseGrammarAccess.XThrowExpressionElements getXThrowExpressionAccess() {
		return gaXbase.getXThrowExpressionAccess();
	}
	
	public ParserRule getXThrowExpressionRule() {
		return getXThrowExpressionAccess().getRule();
	}
	
	//XReturnExpression XExpression:
	//	{XReturnExpression} 'return' -> expression=XExpression?;
	public XbaseGrammarAccess.XReturnExpressionElements getXReturnExpressionAccess() {
		return gaXbase.getXReturnExpressionAccess();
	}
	
	public ParserRule getXReturnExpressionRule() {
		return getXReturnExpressionAccess().getRule();
	}
	
	//XTryCatchFinallyExpression XExpression:
	//	{XTryCatchFinallyExpression}
	//	'try'
	//	expression=XExpression (catchClauses+=XCatchClause+ (=> 'finally' finallyExpression=XExpression)?
	//	| 'finally' finallyExpression=XExpression);
	public XbaseGrammarAccess.XTryCatchFinallyExpressionElements getXTryCatchFinallyExpressionAccess() {
		return gaXbase.getXTryCatchFinallyExpressionAccess();
	}
	
	public ParserRule getXTryCatchFinallyExpressionRule() {
		return getXTryCatchFinallyExpressionAccess().getRule();
	}
	
	//XSynchronizedExpression XExpression:
	//	=> ({XSynchronizedExpression}
	//	'synchronized' '(') param=XExpression ')' expression=XExpression;
	public XbaseGrammarAccess.XSynchronizedExpressionElements getXSynchronizedExpressionAccess() {
		return gaXbase.getXSynchronizedExpressionAccess();
	}
	
	public ParserRule getXSynchronizedExpressionRule() {
		return getXSynchronizedExpressionAccess().getRule();
	}
	
	//XCatchClause:
	//	=> 'catch' '(' declaredParam=FullJvmFormalParameter ')' expression=XExpression;
	public XbaseGrammarAccess.XCatchClauseElements getXCatchClauseAccess() {
		return gaXbase.getXCatchClauseAccess();
	}
	
	public ParserRule getXCatchClauseRule() {
		return getXCatchClauseAccess().getRule();
	}
	
	//@Override
	//QualifiedName:
	//	ValidID (=> '.' ValidID)*;
	public XbaseGrammarAccess.QualifiedNameElements getQualifiedNameAccess() {
		return gaXbase.getQualifiedNameAccess();
	}
	
	public ParserRule getQualifiedNameRule() {
		return getQualifiedNameAccess().getRule();
	}
	
	//Number hidden():
	//	HEX | (INT | DECIMAL) ('.' (INT | DECIMAL))?;
	public XbaseGrammarAccess.NumberElements getNumberAccess() {
		return gaXbase.getNumberAccess();
	}
	
	public ParserRule getNumberRule() {
		return getNumberAccess().getRule();
	}
	
	///**
	// * Dummy rule, for "better" downwards compatibility, since GrammarAccess generates non-static inner classes,
	// * which makes downstream grammars break on classloading, when a rule is removed.
	// */ StaticQualifier:
	//	(ValidID '::')+;
	public XbaseGrammarAccess.StaticQualifierElements getStaticQualifierAccess() {
		return gaXbase.getStaticQualifierAccess();
	}
	
	public ParserRule getStaticQualifierRule() {
		return getStaticQualifierAccess().getRule();
	}
	
	//terminal HEX:
	//	('0x' | '0X') ('0'..'9' | 'a'..'f' | 'A'..'F' | '_')+ ('#' (('b' | 'B') ('i' | 'I') | ('l' | 'L')))?;
	public TerminalRule getHEXRule() {
		return gaXbase.getHEXRule();
	}
	
	//terminal INT returns ecore::EInt:
	//	'0'..'9' ('0'..'9' | '_')*;
	public TerminalRule getINTRule() {
		return gaXbase.getINTRule();
	}
	
	//terminal DECIMAL:
	//	INT (('e' | 'E') ('+' | '-')? INT)? (('b' | 'B') ('i' | 'I' | 'd' | 'D') | ('l' | 'L' | 'd' | 'D' | 'f' | 'F'))?;
	public TerminalRule getDECIMALRule() {
		return gaXbase.getDECIMALRule();
	}
	
	//JvmTypeReference:
	//	JvmParameterizedTypeReference => ({JvmGenericArrayTypeReference.componentType=current} ArrayBrackets)*
	//	| XFunctionTypeRef;
	public XtypeGrammarAccess.JvmTypeReferenceElements getJvmTypeReferenceAccess() {
		return gaXtype.getJvmTypeReferenceAccess();
	}
	
	public ParserRule getJvmTypeReferenceRule() {
		return getJvmTypeReferenceAccess().getRule();
	}
	
	//ArrayBrackets:
	//	'[' ']';
	public XtypeGrammarAccess.ArrayBracketsElements getArrayBracketsAccess() {
		return gaXtype.getArrayBracketsAccess();
	}
	
	public ParserRule getArrayBracketsRule() {
		return getArrayBracketsAccess().getRule();
	}
	
	//XFunctionTypeRef:
	//	('(' (paramTypes+=JvmTypeReference (',' paramTypes+=JvmTypeReference)*)? ')')? '=>' returnType=JvmTypeReference;
	public XtypeGrammarAccess.XFunctionTypeRefElements getXFunctionTypeRefAccess() {
		return gaXtype.getXFunctionTypeRefAccess();
	}
	
	public ParserRule getXFunctionTypeRefRule() {
		return getXFunctionTypeRefAccess().getRule();
	}
	
	//JvmParameterizedTypeReference:
	//	type=[JvmType|super::QualifiedName] (=> '<' arguments+=JvmArgumentTypeReference (','
	//	arguments+=JvmArgumentTypeReference)* '>' (=> ({JvmInnerTypeReference.outer=current} '.') type=[JvmType|ValidID] (=>
	//	'<' arguments+=JvmArgumentTypeReference (',' arguments+=JvmArgumentTypeReference)* '>')?)*)?;
	public XtypeGrammarAccess.JvmParameterizedTypeReferenceElements getJvmParameterizedTypeReferenceAccess() {
		return gaXtype.getJvmParameterizedTypeReferenceAccess();
	}
	
	public ParserRule getJvmParameterizedTypeReferenceRule() {
		return getJvmParameterizedTypeReferenceAccess().getRule();
	}
	
	//JvmArgumentTypeReference JvmTypeReference:
	//	JvmTypeReference | JvmWildcardTypeReference;
	public XtypeGrammarAccess.JvmArgumentTypeReferenceElements getJvmArgumentTypeReferenceAccess() {
		return gaXtype.getJvmArgumentTypeReferenceAccess();
	}
	
	public ParserRule getJvmArgumentTypeReferenceRule() {
		return getJvmArgumentTypeReferenceAccess().getRule();
	}
	
	//JvmWildcardTypeReference:
	//	{JvmWildcardTypeReference} '?' (constraints+=JvmUpperBound constraints+=JvmUpperBoundAnded*
	//	| constraints+=JvmLowerBound constraints+=JvmLowerBoundAnded*)?;
	public XtypeGrammarAccess.JvmWildcardTypeReferenceElements getJvmWildcardTypeReferenceAccess() {
		return gaXtype.getJvmWildcardTypeReferenceAccess();
	}
	
	public ParserRule getJvmWildcardTypeReferenceRule() {
		return getJvmWildcardTypeReferenceAccess().getRule();
	}
	
	//JvmUpperBound:
	//	'extends' typeReference=JvmTypeReference;
	public XtypeGrammarAccess.JvmUpperBoundElements getJvmUpperBoundAccess() {
		return gaXtype.getJvmUpperBoundAccess();
	}
	
	public ParserRule getJvmUpperBoundRule() {
		return getJvmUpperBoundAccess().getRule();
	}
	
	//JvmUpperBoundAnded JvmUpperBound:
	//	'&' typeReference=JvmTypeReference;
	public XtypeGrammarAccess.JvmUpperBoundAndedElements getJvmUpperBoundAndedAccess() {
		return gaXtype.getJvmUpperBoundAndedAccess();
	}
	
	public ParserRule getJvmUpperBoundAndedRule() {
		return getJvmUpperBoundAndedAccess().getRule();
	}
	
	//JvmLowerBound:
	//	'super' typeReference=JvmTypeReference;
	public XtypeGrammarAccess.JvmLowerBoundElements getJvmLowerBoundAccess() {
		return gaXtype.getJvmLowerBoundAccess();
	}
	
	public ParserRule getJvmLowerBoundRule() {
		return getJvmLowerBoundAccess().getRule();
	}
	
	//JvmLowerBoundAnded JvmLowerBound:
	//	'&' typeReference=JvmTypeReference;
	public XtypeGrammarAccess.JvmLowerBoundAndedElements getJvmLowerBoundAndedAccess() {
		return gaXtype.getJvmLowerBoundAndedAccess();
	}
	
	public ParserRule getJvmLowerBoundAndedRule() {
		return getJvmLowerBoundAndedAccess().getRule();
	}
	
	//JvmTypeParameter:
	//	name=ValidID (constraints+=JvmUpperBound constraints+=JvmUpperBoundAnded*)?;
	public XtypeGrammarAccess.JvmTypeParameterElements getJvmTypeParameterAccess() {
		return gaXtype.getJvmTypeParameterAccess();
	}
	
	public ParserRule getJvmTypeParameterRule() {
		return getJvmTypeParameterAccess().getRule();
	}
	
	//QualifiedNameWithWildcard:
	//	super::QualifiedName '.' '*';
	public XtypeGrammarAccess.QualifiedNameWithWildcardElements getQualifiedNameWithWildcardAccess() {
		return gaXtype.getQualifiedNameWithWildcardAccess();
	}
	
	public ParserRule getQualifiedNameWithWildcardRule() {
		return getQualifiedNameWithWildcardAccess().getRule();
	}
	
	//ValidID:
	//	ID;
	public XtypeGrammarAccess.ValidIDElements getValidIDAccess() {
		return gaXtype.getValidIDAccess();
	}
	
	public ParserRule getValidIDRule() {
		return getValidIDAccess().getRule();
	}
	
	//XImportSection:
	//	importDeclarations+=super::XImportDeclaration+;
	public XtypeGrammarAccess.XImportSectionElements getXImportSectionAccess() {
		return gaXtype.getXImportSectionAccess();
	}
	
	public ParserRule getXImportSectionRule() {
		return getXImportSectionAccess().getRule();
	}
	
	//QualifiedNameInStaticImport:
	//	(ValidID '.')+;
	public XtypeGrammarAccess.QualifiedNameInStaticImportElements getQualifiedNameInStaticImportAccess() {
		return gaXtype.getQualifiedNameInStaticImportAccess();
	}
	
	public ParserRule getQualifiedNameInStaticImportRule() {
		return getQualifiedNameInStaticImportAccess().getRule();
	}
	
	//terminal ID:
	//	'^'? ('a'..'z' | 'A'..'Z' | '$' | '_') ('a'..'z' | 'A'..'Z' | '$' | '_' | '0'..'9')*;
	public TerminalRule getIDRule() {
		return gaXtype.getIDRule();
	}
	
	//terminal STRING:
	//	'"' ('\\' . | !('\\' | '"'))* '"'? |
	//	"'" ('\\' . | !('\\' | "'"))* "'"?;
	public TerminalRule getSTRINGRule() {
		return gaXtype.getSTRINGRule();
	}
	
	//terminal ML_COMMENT:
	//	'/*'->'*/';
	public TerminalRule getML_COMMENTRule() {
		return gaXtype.getML_COMMENTRule();
	}
	
	//terminal SL_COMMENT:
	//	'//' !('\n' | '\r')* ('\r'? '\n')?;
	public TerminalRule getSL_COMMENTRule() {
		return gaXtype.getSL_COMMENTRule();
	}
	
	//terminal WS:
	//	' ' | '\t' | '\r' | '\n'+;
	public TerminalRule getWSRule() {
		return gaXtype.getWSRule();
	}
	
	//terminal ANY_OTHER:
	//	.;
	public TerminalRule getANY_OTHERRule() {
		return gaXtype.getANY_OTHERRule();
	}
}
