/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.build.BuildRequest;
import org.eclipse.xtext.build.IncrementalBuilder;
import org.eclipse.xtext.build.IndexState;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.resource.IExternalContentSupport;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.resource.impl.ChunkedResourceDescriptions;
import org.eclipse.xtext.resource.impl.ProjectDescription;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.IFileSystemScanner;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.ISourceFolder;
import org.eclipse.xtext.workspace.ProjectConfigAdapter;
import org.eclipse.xtext.xbase.lib.Procedures;

public class ProjectManager {
    @Inject
    protected IncrementalBuilder incrementalBuilder;
    @Inject
    protected Provider<XtextResourceSet> resourceSetProvider;
    @Inject
    protected IResourceServiceProvider.Registry languagesRegistry;
    @Inject
    protected IFileSystemScanner fileSystemScanner;
    @Inject
    protected IExternalContentSupport externalContentSupport;
    private IndexState indexState = new IndexState();
    private URI baseDir;
    private Procedures.Procedure2<? super URI, ? super Iterable<Issue>> issueAcceptor;
    private Provider<Map<String, ResourceDescriptionsData>> indexProvider;
    private IExternalContentSupport.IExternalContentProvider openedDocumentsContentProvider;
    private XtextResourceSet resourceSet;
    private ProjectDescription projectDescription;
    private IProjectConfig projectConfig;

    public void initialize(ProjectDescription description, IProjectConfig projectConfig, Procedures.Procedure2<? super URI, ? super Iterable<Issue>> acceptor, IExternalContentSupport.IExternalContentProvider openedDocumentsContentProvider, Provider<Map<String, ResourceDescriptionsData>> indexProvider, CancelIndicator cancelIndicator) {
        this.projectDescription = description;
        this.projectConfig = projectConfig;
        this.baseDir = projectConfig.getPath();
        this.issueAcceptor = acceptor;
        this.openedDocumentsContentProvider = openedDocumentsContentProvider;
        this.indexProvider = indexProvider;
    }

    public IncrementalBuilder.Result doInitialBuild(CancelIndicator cancelIndicator) {
        ArrayList<URI> allUris = new ArrayList<URI>();
        for (ISourceFolder srcFolder : this.projectConfig.getSourceFolders()) {
            allUris.addAll(srcFolder.getAllResources(this.fileSystemScanner));
        }
        return this.doBuild(allUris, Collections.emptyList(), Collections.emptyList(), cancelIndicator);
    }

    public IncrementalBuilder.Result doBuild(List<URI> dirtyFiles, List<URI> deletedFiles, List<IResourceDescription.Delta> externalDeltas, CancelIndicator cancelIndicator) {
        BuildRequest request = this.newBuildRequest(dirtyFiles, deletedFiles, externalDeltas, cancelIndicator);
        IncrementalBuilder.Result result = this.incrementalBuilder.build(request, arg_0 -> ((IResourceServiceProvider.Registry)this.languagesRegistry).getResourceServiceProvider(arg_0));
        this.indexState = result.getIndexState();
        this.resourceSet = request.getResourceSet();
        ((Map)this.indexProvider.get()).put(this.projectDescription.getName(), this.indexState.getResourceDescriptions());
        return result;
    }

    protected BuildRequest newBuildRequest(List<URI> changedFiles, List<URI> deletedFiles, List<IResourceDescription.Delta> externalDeltas, CancelIndicator cancelIndicator) {
        BuildRequest result = new BuildRequest();
        result.setBaseDir(this.baseDir);
        result.setState(new IndexState(this.indexState.getResourceDescriptions().copy(), this.indexState.getFileMappings().copy()));
        result.setResourceSet(this.createFreshResourceSet(result.getState().getResourceDescriptions()));
        result.setDirtyFiles(changedFiles);
        result.setDeletedFiles(deletedFiles);
        result.setExternalDeltas(externalDeltas);
        result.setAfterValidate((uri, issues) -> {
            this.issueAcceptor.apply((Object)uri, (Object)issues);
            return true;
        });
        result.setCancelIndicator(cancelIndicator);
        result.setIndexOnly(this.projectConfig.isIndexOnly());
        return result;
    }

    public XtextResourceSet createNewResourceSet(ResourceDescriptionsData newIndex) {
        XtextResourceSet result = (XtextResourceSet)this.resourceSetProvider.get();
        this.projectDescription.attachToEmfObject((Notifier)result);
        ProjectConfigAdapter.install((ResourceSet)result, (IProjectConfig)this.projectConfig);
        ChunkedResourceDescriptions index = new ChunkedResourceDescriptions((Map)this.indexProvider.get(), (ResourceSet)result);
        index.setContainer(this.projectDescription.getName(), newIndex);
        this.externalContentSupport.configureResourceSet((ResourceSet)result, this.openedDocumentsContentProvider);
        return result;
    }

    protected XtextResourceSet createFreshResourceSet(ResourceDescriptionsData newIndex) {
        if (this.resourceSet == null) {
            this.resourceSet = this.createNewResourceSet(newIndex);
        } else {
            ChunkedResourceDescriptions resDescs = ChunkedResourceDescriptions.findInEmfObject((Notifier)this.resourceSet);
            for (Map.Entry entry : ((Map)this.indexProvider.get()).entrySet()) {
                resDescs.setContainer((String)entry.getKey(), (ResourceDescriptionsData)entry.getValue());
            }
            resDescs.setContainer(this.projectDescription.getName(), newIndex);
        }
        return this.resourceSet;
    }

    public Resource getResource(URI uri) {
        Resource resource = this.resourceSet.getResource(uri, true);
        resource.getContents();
        return resource;
    }

    public void reportProjectIssue(String message, String code, Severity severity) {
        Issue.IssueImpl result = new Issue.IssueImpl();
        result.setMessage(message);
        result.setCode(code);
        result.setSeverity(severity);
        result.setUriToProblem(this.baseDir);
        this.issueAcceptor.apply((Object)this.baseDir, (Object)ImmutableList.of((Object)result));
    }

    public IndexState getIndexState() {
        return this.indexState;
    }

    protected void setIndexState(IndexState indexState) {
        this.indexState = indexState;
    }

    public URI getBaseDir() {
        return this.baseDir;
    }

    protected Procedures.Procedure2<? super URI, ? super Iterable<Issue>> getIssueAcceptor() {
        return this.issueAcceptor;
    }

    protected Provider<Map<String, ResourceDescriptionsData>> getIndexProvider() {
        return this.indexProvider;
    }

    protected IExternalContentSupport.IExternalContentProvider getOpenedDocumentsContentProvider() {
        return this.openedDocumentsContentProvider;
    }

    public XtextResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public ProjectDescription getProjectDescription() {
        return this.projectDescription;
    }

    public IProjectConfig getProjectConfig() {
        return this.projectConfig;
    }

    public void aboutToRemoveFromWorkspace() {
        for (ISourceFolder srcFolder : this.projectConfig.getSourceFolders()) {
            for (URI resourceURI : srcFolder.getAllResources(this.fileSystemScanner)) {
                this.issueAcceptor.apply((Object)resourceURI, Collections.emptyList());
            }
        }
    }
}

