/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.common.extension.model;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.bpel.common.BPELResourceSet;
import org.eclipse.bpel.fnmeta.FunctionLibrary;
import org.eclipse.bpel.fnmeta.FunctionRegistry;
import org.eclipse.bpel.fnmeta.IFunctionRegistryLoader;
import org.eclipse.bpel.fnmeta.model.Function;
import org.eclipse.bpel.fnmeta.model.Registry;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.osgi.framework.BundleContext;

public class Activator
extends Plugin
implements IFunctionRegistryLoader {
    public static final String PLUGIN_ID = "org.eclipse.bpel.common.model";
    public static Activator INSTANCE;
    static String FUNCTION_REGISTRY;
    static String AT_REGISTRY_NAME_SPACE;
    static String AT_URI;

    static {
        FUNCTION_REGISTRY = "functionRegistry";
        AT_REGISTRY_NAME_SPACE = "namespace";
        AT_URI = "uri";
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        INSTANCE = this;
        FunctionLibrary.INSTANCE.registerLoader(this);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        FunctionLibrary.INSTANCE.unregisterLoader(this);
        INSTANCE = null;
    }

    public static void log(String message, Throwable e, int severity) {
        IStatus status = null;
        if (e instanceof CoreException) {
            status = ((CoreException)e).getStatus();
        } else {
            String m;
            String string = m = e != null ? e.getMessage() : null;
            if (message == null) {
                if (m == null) {
                    m = "<no message>";
                }
            } else {
                m = m == null ? message : String.valueOf(message) + "[" + m + "]";
            }
            status = new Status(severity, PLUGIN_ID, 0, m, e);
        }
        if (Platform.isRunning()) {
            INSTANCE.getLog().log(status);
        } else {
            String msg = MessageFormat.format("{1,choice,0#msg|1#Info|2#Warning|4#Error}@{0}: {3}", status.getPlugin(), status.getSeverity(), status.getCode(), status.getMessage());
            System.err.println(msg);
            if (status.getException() != null) {
                status.getException().printStackTrace(System.err);
            }
        }
    }

    public IConfigurationElement[] getConfigurationElements(String extensionPointId) {
        String id = this.getBundle().getSymbolicName();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(id, extensionPointId);
        if (extensionPoint == null) {
            return new IConfigurationElement[0];
        }
        return extensionPoint.getConfigurationElements();
    }

    @Override
    public void load(FunctionRegistry registry) {
        IConfigurationElement[] iConfigurationElementArray = this.getConfigurationElements(FUNCTION_REGISTRY);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            String location;
            URI uri;
            BPELResourceSet rs;
            Resource resource;
            IConfigurationElement elm = iConfigurationElementArray[n2];
            String ns = registry.getLanguageNS();
            if (ns != null && ns.equals(elm.getAttribute(AT_REGISTRY_NAME_SPACE)) && (resource = (rs = new BPELResourceSet()).getResource(uri = URI.createURI((String)(location = elm.getAttribute(AT_URI))), true, "fnmeta")).getContents().size() > 0) {
                Registry r = (Registry)resource.getContents().get(0);
                registry.add((List<Function>)r.getFunctions());
            }
            ++n2;
        }
    }
}

