/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.projectconfig.impl;

import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.oomph.projectconfig.ExclusionPredicate;
import org.eclipse.oomph.projectconfig.InclusionPredicate;
import org.eclipse.oomph.projectconfig.PreferenceFilter;
import org.eclipse.oomph.projectconfig.PreferenceProfile;
import org.eclipse.oomph.projectconfig.Project;
import org.eclipse.oomph.projectconfig.ProjectConfigFactory;
import org.eclipse.oomph.projectconfig.ProjectConfigPackage;
import org.eclipse.oomph.projectconfig.WorkspaceConfiguration;
import org.eclipse.oomph.projectconfig.impl.ExclusionPredicateImpl;
import org.eclipse.oomph.projectconfig.impl.InclusionPredicateImpl;
import org.eclipse.oomph.projectconfig.impl.PreferenceFilterImpl;
import org.eclipse.oomph.projectconfig.impl.PreferenceProfileImpl;
import org.eclipse.oomph.projectconfig.impl.ProjectImpl;
import org.eclipse.oomph.projectconfig.impl.WorkspaceConfigurationImpl;

public class ProjectConfigFactoryImpl
extends EFactoryImpl
implements ProjectConfigFactory {
    public static ProjectConfigFactory init() {
        try {
            ProjectConfigFactory theProjectConfigFactory = (ProjectConfigFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/Oomph/projectconfig/1.0");
            if (theProjectConfigFactory != null) {
                return theProjectConfigFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new ProjectConfigFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createWorkspaceConfiguration();
            }
            case 1: {
                return this.createProject();
            }
            case 2: {
                return this.createPreferenceProfile();
            }
            case 3: {
                return this.createPreferenceFilter();
            }
            case 4: {
                return this.createInclusionPredicate();
            }
            case 5: {
                return this.createExclusionPredicate();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 6: {
                return this.createPatternFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 6: {
                return this.convertPatternToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public WorkspaceConfiguration createWorkspaceConfiguration() {
        WorkspaceConfigurationImpl workspaceConfiguration = new WorkspaceConfigurationImpl();
        return workspaceConfiguration;
    }

    public Project createProject() {
        ProjectImpl project = new ProjectImpl();
        return project;
    }

    public PreferenceProfile createPreferenceProfile() {
        PreferenceProfileImpl preferenceProfile = new PreferenceProfileImpl();
        return preferenceProfile;
    }

    public PreferenceFilter createPreferenceFilter() {
        PreferenceFilterImpl preferenceFilter = new PreferenceFilterImpl();
        return preferenceFilter;
    }

    public InclusionPredicate createInclusionPredicate() {
        InclusionPredicateImpl inclusionPredicate = new InclusionPredicateImpl();
        return inclusionPredicate;
    }

    public ExclusionPredicate createExclusionPredicate() {
        ExclusionPredicateImpl exclusionPredicate = new ExclusionPredicateImpl();
        return exclusionPredicate;
    }

    public Pattern createPatternFromString(EDataType eDataType, String initialValue) {
        return initialValue == null ? null : Pattern.compile(initialValue);
    }

    public String convertPatternToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public ProjectConfigPackage getProjectConfigPackage() {
        return (ProjectConfigPackage)this.getEPackage();
    }

    @Deprecated
    public static ProjectConfigPackage getPackage() {
        return ProjectConfigPackage.eINSTANCE;
    }
}

