/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.views.config.utils;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.core.language.ILanguageService;
import org.eclipse.papyrus.infra.core.resource.IModel;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.nattable.tester.ITableTester;
import org.eclipse.papyrus.infra.nattable.views.config.messages.Messages;

public class TableViewCreationTester
implements ITableTester {
    public IStatus isAllowed(Object context) {
        if (context instanceof EObject) {
            EObject current = (EObject)context;
            try {
                ModelSet modelSet = ServiceUtilsForEObject.getInstance().getModelSet((Object)current);
                IModel model = modelSet.getModelFor((Object)current);
                if (model != null && ILanguageService.getLanguageModels((ModelSet)modelSet).contains(model)) {
                    return new Status(0, "org.eclipse.papyrus.infra.nattable.views.config", Messages.TableViewCreationTester_TheTableViewCanBeCreated);
                }
            }
            catch (ServiceException e) {
                return new Status(4, "org.eclipse.papyrus.infra.nattable.views.config", Messages.TableViewCreationTester_ServicesUnavailable);
            }
        }
        return new Status(4, "org.eclipse.papyrus.infra.nattable.views.config", Messages.TableViewCreationTester_TheTableViewCantBeCreated);
    }
}

