/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.phpIni;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.filesystem.local.LocalFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathContainer;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.php.internal.core.includepath.IncludePath;
import org.eclipse.php.internal.core.util.PHPSearchEngine;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.phpIni.INIFileModifier;

public class PHPINIUtil {
    private static final String PHP_INI_FILE = "php.ini";
    private static final String INCLUDE_PATH = "include_path";
    private static final String ZEND_EXTENSION = "zend_extension";
    private static final String ZEND_EXTENSION_TS = "zend_extension_ts";
    private static final String MEMORY_LIMIT = "memory_limit";
    private static final String DATE_TIMEZONE = "date.timezone";

    private static void modifyIncludePath(File phpIniFile, String[] includePath) {
        try {
            INIFileModifier m = new INIFileModifier(phpIniFile);
            m.removeAllEntries(INCLUDE_PATH);
            StringBuilder valueBuf = new StringBuilder(".");
            String[] stringArray = includePath;
            int n = includePath.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                valueBuf.append(File.pathSeparatorChar).append(path);
                ++n2;
            }
            m.addEntry(INCLUDE_PATH, valueBuf.toString());
            m.close();
        }
        catch (IOException e) {
            PHPDebugPlugin.log(e);
        }
    }

    private static void modifyDebuggerExtensionPath(File phpIniFile, String extensionPath) {
        try {
            INIFileModifier m = new INIFileModifier(phpIniFile);
            if ("win32".equals(Platform.getOS())) {
                if (m.removeAllEntries(ZEND_EXTENSION_TS, ".*\\.\\\\ZendDebugger\\.dll.*")) {
                    m.addEntry(ZEND_EXTENSION_TS, extensionPath);
                }
            } else if (m.removeAllEntries(ZEND_EXTENSION, ".*\\./ZendDebugger\\.so.*")) {
                m.addEntry(ZEND_EXTENSION, extensionPath);
            }
            m.close();
        }
        catch (IOException e) {
            PHPDebugPlugin.log(e);
        }
    }

    private static void modifyExtensionDir(File phpIniFile, String extensionPath) {
        try {
            INIFileModifier m = new INIFileModifier(phpIniFile);
            m.addEntry("extension_dir", extensionPath, true);
            m.close();
        }
        catch (IOException e) {
            PHPDebugPlugin.log(e);
        }
    }

    public static File createPHPIniByProject(File phpIniFile, IProject project) {
        File tempIniFile = PHPINIUtil.createTemporaryPHPINIFile(phpIniFile);
        if (project != null) {
            IncludePath[] path = PHPSearchEngine.buildIncludePath((IProject)project);
            ArrayList<String> includePath = new ArrayList<String>(path.length);
            IncludePath[] includePathArray = path;
            int n = path.length;
            int n2 = 0;
            while (n2 < n) {
                IContainer container;
                IPath location;
                IncludePath pathObject = includePathArray[n2];
                if (pathObject.isBuildpath()) {
                    int n3;
                    IBuildpathEntry entry = (IBuildpathEntry)pathObject.getEntry();
                    if (entry.getEntryKind() == 4) {
                        IPath entryPath = DLTKCore.getResolvedVariablePath((IPath)entry.getPath());
                        includePath.add(entryPath.toFile().getAbsolutePath());
                    } else if (entry.getEntryKind() == 2 || entry.getEntryKind() == 3 || entry.getEntryKind() == 1) {
                        if (entry.getEntryKind() == 2) {
                            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                            IResource resource = root.findMember(entry.getPath());
                            IModelElement scriptProject = DLTKCore.create((IResource)resource);
                            if (scriptProject instanceof IScriptProject) {
                                try {
                                    IProjectFragment[] projectFragments;
                                    IProjectFragment[] iProjectFragmentArray = projectFragments = ((IScriptProject)scriptProject).getProjectFragments();
                                    int n4 = projectFragments.length;
                                    n3 = 0;
                                    while (n3 < n4) {
                                        IProjectFragment projectFragment = iProjectFragmentArray[n3];
                                        if (projectFragment.getResource() instanceof IFolder || projectFragment.getResource() instanceof IProject) {
                                            PHPINIUtil.addIncludePath(includePath, projectFragment.getPath());
                                        }
                                        ++n3;
                                    }
                                }
                                catch (ModelException projectFragments) {}
                            }
                        } else {
                            PHPINIUtil.addIncludePath(includePath, entry.getPath());
                        }
                    } else if (entry.getEntryKind() == 5) {
                        try {
                            IBuildpathEntry[] buildpathEntries;
                            IScriptProject scriptProject = DLTKCore.create((IProject)project);
                            IBuildpathContainer buildpathContainer = DLTKCore.getBuildpathContainer((IPath)entry.getPath(), (IScriptProject)scriptProject);
                            if (buildpathContainer != null && (buildpathEntries = buildpathContainer.getBuildpathEntries()) != null) {
                                IBuildpathEntry[] iBuildpathEntryArray = buildpathEntries;
                                n3 = buildpathEntries.length;
                                int n5 = 0;
                                while (n5 < n3) {
                                    IBuildpathEntry iBuildpathEntry = iBuildpathEntryArray[n5];
                                    IPath localPath = EnvironmentPathUtils.getLocalPath((IPath)iBuildpathEntry.getPath());
                                    includePath.add(localPath.toOSString());
                                    ++n5;
                                }
                            }
                        }
                        catch (ModelException e) {
                            Logger.logException(e);
                        }
                    }
                } else if (pathObject.getEntry() instanceof IContainer && (location = (container = (IContainer)pathObject.getEntry()).getLocation()) != null) {
                    includePath.add(location.toOSString());
                }
                ++n2;
            }
            PHPINIUtil.modifyIncludePath(tempIniFile, includePath.toArray(new String[includePath.size()]));
        }
        return tempIniFile;
    }

    private static void addIncludePath(List<String> includePath, IPath path) {
        IPath entryPath = EnvironmentPathUtils.getLocalPath((IPath)path);
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(entryPath);
        if (resource != null) {
            IPath location = resource.getLocation();
            if (location != null) {
                includePath.add(location.toOSString());
            }
        } else {
            includePath.add(entryPath.toOSString());
        }
    }

    public static File prepareBeforeLaunch(File phpIniFile, String phpExePath, IProject project) {
        File tempIniFile = PHPINIUtil.createTemporaryPHPINIFile(phpIniFile);
        tempIniFile = PHPINIUtil.createPHPIniByProject(phpIniFile, project);
        if (phpIniFile != null) {
            File debuggerFile = new File(phpIniFile.getParentFile(), "win32".equals(Platform.getOS()) ? "ZendDebugger.dll" : "ZendDebugger.so");
            if (debuggerFile.exists()) {
                PHPINIUtil.modifyDebuggerExtensionPath(tempIniFile, debuggerFile.getAbsolutePath());
            }
            PHPINIUtil.modifyExtensionDir(tempIniFile, new File(debuggerFile.getParentFile(), "ext").getAbsolutePath());
        }
        if (PHPDebugPlugin.DEBUG) {
            System.out.println("\nPHP.ini contents:\n---------------------");
            try {
                String line;
                BufferedReader r = new BufferedReader(new FileReader(tempIniFile));
                while ((line = r.readLine()) != null) {
                    System.out.println(line);
                }
                r.close();
                System.out.println();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return tempIniFile;
    }

    public static File createTemporaryPHPINIFile() {
        return PHPINIUtil.createTemporaryPHPINIFile(null);
    }

    public static File createTemporaryPHPINIFile(File originalPHPIniFile) {
        File phpIniFile = null;
        try {
            File tempDir = new File(System.getProperty("java.io.tmpdir"), "php-ini");
            if (!tempDir.exists()) {
                tempDir.mkdir();
                tempDir.deleteOnExit();
            }
            tempDir = File.createTempFile("session", null, tempDir);
            tempDir.delete();
            tempDir.mkdir();
            tempDir.deleteOnExit();
            phpIniFile = new File(tempDir, PHP_INI_FILE);
            phpIniFile.createNewFile();
            phpIniFile.deleteOnExit();
            if (originalPHPIniFile != null && originalPHPIniFile.exists()) {
                new LocalFile(originalPHPIniFile).copy((IFileStore)new LocalFile(phpIniFile), 2, (IProgressMonitor)new NullProgressMonitor());
            }
            PHPINIUtil.appendDefaultPHPIniContent(phpIniFile);
        }
        catch (Exception e) {
            PHPDebugPlugin.log(e);
        }
        return phpIniFile;
    }

    private static void appendDefaultPHPIniContent(File phpIniFile) throws IOException {
        try {
            INIFileModifier m = new INIFileModifier(phpIniFile);
            if (!m.hasEntry(MEMORY_LIMIT)) {
                m.addEntry(MEMORY_LIMIT, "256M");
            }
            if (!m.hasEntry(DATE_TIMEZONE)) {
                m.addEntry(DATE_TIMEZONE, Calendar.getInstance().getTimeZone().getID());
            }
            m.close();
        }
        catch (IOException e) {
            PHPDebugPlugin.log(e);
        }
    }

    public static File findPHPIni(String phpExe) {
        File phpExeFile = new File(phpExe);
        File phpIniFile = new File(phpExeFile.getParentFile(), PHP_INI_FILE);
        if (!phpIniFile.exists() || !phpIniFile.canRead()) {
            try {
                String l;
                Process p = Runtime.getRuntime().exec(new String[]{phpExeFile.getAbsolutePath(), "-i"});
                BufferedReader r = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while ((l = r.readLine()) != null) {
                    int i = l.indexOf(" => ");
                    if (i <= 0) continue;
                    String key = l.substring(0, i);
                    String value = l.substring(i + 4);
                    if (!"Loaded Configuration File".equals(key)) continue;
                    phpIniFile = new File(value);
                    break;
                }
                r.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (phpIniFile.exists() && phpIniFile.canRead()) {
            return phpIniFile;
        }
        return null;
    }
}

