/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.sync.cdt.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsEditableProvider;
import org.eclipse.cdt.core.settings.model.CIncludePathEntry;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.managedbuilder.language.settings.providers.GCCBuildCommandParser;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ptp.rdt.sync.core.SyncConfig;
import org.eclipse.ptp.rdt.sync.core.SyncConfigManager;
import org.eclipse.ptp.rdt.sync.core.exceptions.MissingConnectionException;
import org.eclipse.remote.core.IRemoteConnection;

public class SyncGCCBuildCommandParser
extends GCCBuildCommandParser
implements ILanguageSettingsEditableProvider {
    protected void setSettingEntries(List<? extends ICLanguageSettingEntry> entries) {
        if (entries == null) {
            super.setSettingEntries(entries);
            return;
        }
        SyncConfig config = SyncConfigManager.getActive((IProject)this.currentProject);
        if (config.getSyncProviderId() == null) {
            super.setSettingEntries(entries);
            return;
        }
        IRemoteConnection conn = null;
        try {
            conn = config.getRemoteConnection();
        }
        catch (MissingConnectionException e1) {
            super.setSettingEntries(entries);
            return;
        }
        ArrayList<ICLanguageSettingEntry> newEntries = new ArrayList<ICLanguageSettingEntry>();
        for (ICLanguageSettingEntry iCLanguageSettingEntry : entries) {
            ICLanguageSettingEntry newEntry;
            if (!(iCLanguageSettingEntry instanceof CIncludePathEntry) || (iCLanguageSettingEntry.getFlags() & 8) == 1) {
                newEntry = iCLanguageSettingEntry;
            } else {
                String remotePath = ((CIncludePathEntry)iCLanguageSettingEntry).getValue();
                String workspacePath = this.getWorkspacePath(remotePath, config.getLocation(this.currentProject));
                if (workspacePath == null) {
                    if (remotePath.startsWith("C:")) {
                        remotePath = remotePath.substring(2);
                    }
                    newEntry = new CIncludePathEntry("//" + conn.getName() + remotePath, iCLanguageSettingEntry.getFlags());
                } else {
                    newEntry = new CIncludePathEntry(workspacePath, iCLanguageSettingEntry.getFlags());
                }
            }
            newEntries.add(newEntry);
        }
        super.setSettingEntries(newEntries);
    }

    public String parseResourceName(String line) {
        String compilerPath = super.parseResourceName(line);
        if (compilerPath == null) {
            return compilerPath;
        }
        SyncConfig config = SyncConfigManager.getActive((IProject)this.currentProject);
        if (config.getSyncProviderId() == null) {
            return compilerPath;
        }
        String workspacePath = this.getWorkspacePath(compilerPath, config.getLocation(this.currentProject));
        if (workspacePath == null) {
            return compilerPath;
        }
        return workspacePath;
    }

    private String getWorkspacePath(String remotePathString, String remoteRootString) {
        Path remoteRoot = new Path(remoteRootString);
        Path remotePath = new Path(remotePathString);
        if (!remoteRoot.isPrefixOf((IPath)remotePath)) {
            return null;
        }
        IPath localRoot = this.currentProject.getLocation();
        return remotePath.toOSString().replaceFirst(remoteRoot.toOSString(), localRoot.toOSString());
    }
}

