/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.sync.git.core;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.ptp.internal.rdt.sync.git.core.Activator;
import org.eclipse.ptp.internal.rdt.sync.git.core.CommandRunner;
import org.eclipse.ptp.internal.rdt.sync.git.core.GitRepo;
import org.eclipse.ptp.internal.rdt.sync.git.core.JGitRepo;
import org.eclipse.ptp.internal.rdt.sync.git.core.messages.Messages;
import org.eclipse.ptp.rdt.sync.core.AbstractSyncFileFilter;
import org.eclipse.ptp.rdt.sync.core.RecursiveSubMonitor;
import org.eclipse.ptp.rdt.sync.core.RemoteLocation;
import org.eclipse.ptp.rdt.sync.core.SyncConfig;
import org.eclipse.ptp.rdt.sync.core.SyncConfigManager;
import org.eclipse.ptp.rdt.sync.core.SyncFlag;
import org.eclipse.ptp.rdt.sync.core.exceptions.MissingConnectionException;
import org.eclipse.ptp.rdt.sync.core.exceptions.RemoteSyncException;
import org.eclipse.ptp.rdt.sync.core.exceptions.RemoteSyncMergeConflictException;
import org.eclipse.ptp.rdt.sync.core.services.AbstractSynchronizeService;
import org.eclipse.ptp.rdt.sync.core.services.ISynchronizeServiceDescriptor;

public class GitSyncService
extends AbstractSynchronizeService {
    public static final String gitDir = ".ptp-sync";
    public static final String emptyDirectoryFileName = ".ptp-sync-folder";
    public static final String commitMessage = Messages.GitSyncService_0;
    public static final String remotePushBranch = "ptp-push";
    private static final Map<IPath, JGitRepo> localDirectoryToJGitRepoMap = Collections.synchronizedMap(new HashMap());
    private static final Map<RemoteLocation, GitRepo> remoteLocationToGitRepoMap = Collections.synchronizedMap(new HashMap());
    private static final ReentrantLock syncLock = new ReentrantLock();
    private static final ConcurrentMap<ProjectAndRemoteLocationPair, SyncInt> syncLRPending = new ConcurrentHashMap<ProjectAndRemoteLocationPair, SyncInt>();
    private static final ConcurrentMap<ProjectAndRemoteLocationPair, SyncInt> syncRLPending = new ConcurrentHashMap<ProjectAndRemoteLocationPair, SyncInt>();
    private static final Set<LocalAndRemoteLocationPair> cleanFileFilterMap = new HashSet<LocalAndRemoteLocationPair>();
    private static final Set<LocalAndRemoteLocationPair> localChangesPushed = new HashSet<LocalAndRemoteLocationPair>();
    private static boolean consCalled = false;

    static JGitRepo getLocalJGitRepo(IProject project, IProgressMonitor monitor) throws RemoteSyncException {
        JGitRepo repo;
        block8: {
            IPath localDir = project.getLocation();
            if (localDir == null) {
                throw new RemoteSyncException(String.valueOf(Messages.GitSyncService_17) + project.getName());
            }
            repo = localDirectoryToJGitRepoMap.get(localDir);
            try {
                if (repo != null) break block8;
                try {
                    repo = new JGitRepo(localDir, monitor);
                    localDirectoryToJGitRepoMap.put(localDir, repo);
                    GitSyncService.setRepoFilesAsDerived(project);
                }
                catch (GitAPIException e) {
                    throw new RemoteSyncException((Throwable)e);
                }
                catch (IOException e) {
                    throw new RemoteSyncException((Throwable)e);
                }
            }
            finally {
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
        return repo;
    }

    static GitRepo getGitRepo(RemoteLocation rl, IProgressMonitor monitor) throws RemoteSyncException {
        GitRepo repo;
        block8: {
            if (rl == null) {
                throw new NullPointerException();
            }
            repo = remoteLocationToGitRepoMap.get(rl);
            try {
                if (repo != null) break block8;
                RecursiveSubMonitor subMon = RecursiveSubMonitor.convert((IProgressMonitor)monitor, (int)100);
                subMon.subTask(Messages.GitSyncService_1);
                try {
                    subMon.subTask(Messages.GitSyncService_2);
                    repo = new GitRepo(rl, (IProgressMonitor)subMon.newChild(90));
                    remoteLocationToGitRepoMap.put(rl, repo);
                }
                catch (MissingConnectionException e) {
                    if (monitor != null) {
                        monitor.done();
                    }
                    return null;
                }
            }
            finally {
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
        return repo;
    }

    public GitSyncService(ISynchronizeServiceDescriptor descriptor) {
        super(descriptor);
        assert (!consCalled) : Messages.GitSyncService_3;
        consCalled = true;
    }

    public void checkout(IProject project, IPath[] paths) throws RemoteSyncException {
        JGitRepo repo = GitSyncService.getLocalJGitRepo(project, null);
        if (repo != null) {
            try {
                repo.checkout(paths);
                GitSyncService.doRefresh(project);
            }
            catch (GitAPIException e) {
                throw new RemoteSyncException((Throwable)e);
            }
        }
    }

    public void checkoutRemoteCopy(IProject project, IPath[] paths) throws RemoteSyncException {
        JGitRepo repo = GitSyncService.getLocalJGitRepo(project, null);
        if (repo != null) {
            try {
                repo.checkoutRemoteCopy(paths);
                GitSyncService.doRefresh(project);
            }
            catch (GitAPIException e) {
                throw new RemoteSyncException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close(IProject project) throws RemoteSyncException {
        JGitRepo repo = GitSyncService.getLocalJGitRepo(project, null);
        if (repo != null) {
            repo.close();
        }
        Map<IPath, JGitRepo> map = localDirectoryToJGitRepoMap;
        synchronized (map) {
            Iterator<Map.Entry<IPath, JGitRepo>> it = localDirectoryToJGitRepoMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<IPath, JGitRepo> entry = it.next();
                if (entry.getValue() != repo) continue;
                it.remove();
            }
        }
        SyncConfig[] syncConfigArray = SyncConfigManager.getConfigs((IProject)project);
        int n = syncConfigArray.length;
        int n2 = 0;
        while (n2 < n) {
            SyncConfig config = syncConfigArray[n2];
            remoteLocationToGitRepoMap.remove(config.getRemoteLocation());
            ++n2;
        }
    }

    public Set<IPath> getMergeConflictFiles(IProject project) throws RemoteSyncException {
        JGitRepo repo = GitSyncService.getLocalJGitRepo(project, null);
        if (repo == null) {
            return new HashSet<IPath>();
        }
        try {
            return repo.getMergeConflictFiles();
        }
        catch (GitAPIException e) {
            throw new RemoteSyncException((Throwable)e);
        }
        catch (IOException e) {
            throw new RemoteSyncException((Throwable)e);
        }
    }

    public String[] getMergeConflictParts(IProject project, IFile file) throws RemoteSyncException {
        JGitRepo repo = GitSyncService.getLocalJGitRepo(project, null);
        if (repo == null) {
            return null;
        }
        try {
            return repo.getMergeConflictParts(file.getProjectRelativePath());
        }
        catch (GitAPIException e) {
            throw new RemoteSyncException((Throwable)e);
        }
        catch (IOException e) {
            throw new RemoteSyncException((Throwable)e);
        }
    }

    public void setMergeAsResolved(IProject project, IPath[] paths) throws RemoteSyncException {
        JGitRepo repo = GitSyncService.getLocalJGitRepo(project, null);
        if (repo != null) {
            try {
                repo.setMergeAsResolved(paths);
            }
            catch (GitAPIException e) {
                throw new RemoteSyncException((Throwable)e);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public void synchronize(IProject project, RemoteLocation rl, IResourceDelta delta, IProgressMonitor monitor, Set<SyncFlag> syncFlags) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 13[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void doSync(IProject project, RemoteLocation remoteLoc, Set<SyncFlag> syncFlags, IProgressMonitor monitor) throws RemoteSyncException {
        block20: {
            boolean syncLR = syncFlags.contains(SyncFlag.SYNC_LR);
            boolean syncRL = syncFlags.contains(SyncFlag.SYNC_RL);
            RecursiveSubMonitor subMon = RecursiveSubMonitor.convert((IProgressMonitor)monitor, (int)100);
            try {
                subMon.subTask(Messages.GitSyncService_6);
                JGitRepo localRepo = GitSyncService.getLocalJGitRepo(project, (IProgressMonitor)subMon.newChild(5));
                if (localRepo.inUnresolvedMergeState()) {
                    throw new RemoteSyncMergeConflictException(Messages.GitSyncService_8);
                }
                LocalAndRemoteLocationPair lrpair = new LocalAndRemoteLocationPair(localRepo.getDirectory(), remoteLoc);
                subMon.subTask(Messages.GitSyncService_12);
                if (localRepo.commit((IProgressMonitor)subMon.newChild(5))) {
                    Iterator<LocalAndRemoteLocationPair> it = localChangesPushed.iterator();
                    while (it.hasNext()) {
                        LocalAndRemoteLocationPair lrp = it.next();
                        if (!lrp.getLocal().equals((Object)localRepo.getDirectory())) continue;
                        it.remove();
                    }
                }
                if (!(syncLR && !localChangesPushed.contains(lrpair) || syncRL)) {
                    return;
                }
                subMon.subTask(Messages.GitSyncService_7);
                GitRepo remoteRepo = GitSyncService.getGitRepo(remoteLoc, (IProgressMonitor)subMon.newChild(10));
                if (remoteRepo == null) {
                    return;
                }
                try {
                    boolean success;
                    if (!cleanFileFilterMap.contains(lrpair)) {
                        subMon.subTask(Messages.GitSyncService_11);
                        remoteRepo.uploadFilter(localRepo, (IProgressMonitor)subMon.newChild(10));
                        cleanFileFilterMap.add(lrpair);
                    }
                    if (syncRL) {
                        subMon.subTask(Messages.GitSyncService_24);
                        this.doSyncRL(localRepo, remoteRepo, (IProgressMonitor)subMon.newChild(30));
                    }
                    if (!syncLR || localChangesPushed.contains(lrpair)) break block20;
                    subMon.subTask(Messages.GitSyncService_25);
                    CommandRunner.CommandResults results = this.doSyncLR(localRepo, remoteRepo, (IProgressMonitor)subMon.newChild(30));
                    boolean bl = success = results.getExitCode() == 0;
                    if (!success && !syncRL) {
                        subMon.subTask(Messages.GitSyncService_26);
                        this.doSyncRL(localRepo, remoteRepo, (IProgressMonitor)subMon.newChild(30));
                        subMon.subTask(Messages.GitSyncService_27);
                        results = this.doSyncLR(localRepo, remoteRepo, (IProgressMonitor)subMon.newChild(10));
                        boolean bl2 = success = results.getExitCode() == 0;
                    }
                    if (success) {
                        localChangesPushed.add(lrpair);
                        break block20;
                    }
                    throw new RemoteSyncException(String.valueOf(Messages.GitSyncService_23) + results.getStderr());
                }
                catch (JGitInternalException e) {
                    throw new RemoteSyncException((Throwable)e);
                }
                catch (IOException e) {
                    throw new RemoteSyncException((Throwable)e);
                }
                catch (GitAPIException e) {
                    throw new RemoteSyncException((Throwable)e);
                }
                catch (MissingConnectionException missingConnectionException) {
                }
            }
            finally {
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
    }

    private CommandRunner.CommandResults doSyncLR(JGitRepo localRepo, GitRepo remoteRepo, IProgressMonitor monitor) throws RemoteSyncException, MissingConnectionException {
        RecursiveSubMonitor subMon = RecursiveSubMonitor.convert((IProgressMonitor)monitor, (int)30);
        try {
            if (localRepo.getGit().branchList().call().size() > 0) {
                subMon.subTask(Messages.GitSyncService_18);
                localRepo.push(remoteRepo, (IProgressMonitor)subMon.newChild(20));
                subMon.subTask(Messages.GitSyncService_28);
                CommandRunner.CommandResults commandResults = remoteRepo.merge((IProgressMonitor)subMon.newChild(10));
                return commandResults;
            }
            CommandRunner.CommandResults commandResults = new CommandRunner.CommandResults();
            return commandResults;
        }
        catch (TransportException e) {
            throw new RemoteSyncException((Throwable)e);
        }
        catch (GitAPIException e) {
            throw new RemoteSyncException((Throwable)e);
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void doSyncRL(JGitRepo localRepo, GitRepo remoteRepo, IProgressMonitor monitor) throws RemoteSyncException, MissingConnectionException {
        RecursiveSubMonitor subMon = RecursiveSubMonitor.convert((IProgressMonitor)monitor, (int)90);
        subMon.subTask(Messages.GitSyncService_13);
        remoteRepo.commitRemoteFiles((IProgressMonitor)subMon.newChild(40));
        subMon.subTask(Messages.GitSyncService_14);
        try {
            localRepo.fetch(remoteRepo, (IProgressMonitor)subMon.newChild(40));
        }
        catch (TransportException e) {
            if (e.getMessage().startsWith("Remote does not have ")) {
                if (monitor != null) {
                    monitor.done();
                }
                return;
            }
            throw new RemoteSyncException((Throwable)e);
        }
        subMon.subTask(Messages.GitSyncService_15);
        try {
            MergeResult mergeResult = localRepo.merge((IProgressMonitor)subMon.newChild(10));
            if (mergeResult.getFailingPaths() != null) {
                String message = Messages.GitSyncService_16;
                for (String s : mergeResult.getFailingPaths().keySet()) {
                    message = String.valueOf(message) + System.getProperty("line.separator") + s;
                }
                throw new RemoteSyncException(message);
            }
            if (localRepo.inUnresolvedMergeState()) {
                throw new RemoteSyncMergeConflictException(Messages.GitSyncService_8);
            }
        }
        catch (GitAPIException e) {
            throw new RemoteSyncException((Throwable)e);
        }
        catch (IOException e) {
            throw new RemoteSyncException((Throwable)e);
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public AbstractSyncFileFilter getSyncFileFilter(IProject project) throws RemoteSyncException {
        return GitSyncService.getLocalJGitRepo(project, null).getFilter();
    }

    /*
     * Unable to fully structure code
     */
    public void setSyncFileFilter(IProject project, AbstractSyncFileFilter filter) throws RemoteSyncException {
        it = GitSyncService.cleanFileFilterMap.iterator();
        localDir = project.getLocation();
        if (localDir != null) ** GOTO lbl8
        throw new RemoteSyncException(String.valueOf(Messages.GitSyncService_17) + project.getName());
lbl-1000:
        // 1 sources

        {
            lp = it.next();
            if (!lp.getLocal().equals((Object)localDir)) continue;
            it.remove();
lbl8:
            // 3 sources

            ** while (it.hasNext())
        }
lbl9:
        // 1 sources

        localRepo = GitSyncService.getLocalJGitRepo(project, null);
        localRepo.setFilter(filter);
    }

    private static Thread doRefresh(final IProject project) {
        Thread refreshWorkspaceThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    project.refreshLocal(2, null);
                }
                catch (CoreException e) {
                    Activator.log(Messages.JGitRepo_16, e);
                }
            }
        }, "Refresh workspace thread");
        refreshWorkspaceThread.start();
        return refreshWorkspaceThread;
    }

    private static void setRepoFilesAsDerived(final IProject project) {
        final Thread refreshThread = GitSyncService.doRefresh(project);
        Thread setDerivedThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    refreshThread.join();
                    project.getFolder(GitSyncService.gitDir).setDerived(true, null);
                }
                catch (InterruptedException e) {
                    Activator.log(e);
                }
                catch (CoreException e) {
                    Activator.log(e);
                }
            }
        }, "Set repository as derived thread");
        setDerivedThread.start();
    }

    private static class LocalAndRemoteLocationPair {
        IPath localDir;
        RemoteLocation remoteLoc;

        public LocalAndRemoteLocationPair(IPath ld, RemoteLocation rl) {
            this.localDir = ld;
            this.remoteLoc = rl;
        }

        public IPath getLocal() {
            return this.localDir;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.localDir == null ? 0 : this.localDir.hashCode());
            result = 31 * result + (this.remoteLoc == null ? 0 : this.remoteLoc.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LocalAndRemoteLocationPair other = (LocalAndRemoteLocationPair)obj;
            if (this.localDir == null ? other.localDir != null : !this.localDir.equals((Object)other.localDir)) {
                return false;
            }
            return !(this.remoteLoc == null ? other.remoteLoc != null : !this.remoteLoc.equals((Object)other.remoteLoc));
        }
    }

    private static class ProjectAndRemoteLocationPair {
        IProject project;
        RemoteLocation remoteLoc;

        public ProjectAndRemoteLocationPair(IProject p, RemoteLocation rl) {
            this.project = p;
            this.remoteLoc = rl;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.project == null ? 0 : this.project.hashCode());
            result = 31 * result + (this.remoteLoc == null ? 0 : this.remoteLoc.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProjectAndRemoteLocationPair other = (ProjectAndRemoteLocationPair)obj;
            if (this.project == null ? other.project != null : !this.project.equals((Object)other.project)) {
                return false;
            }
            return !(this.remoteLoc == null ? other.remoteLoc != null : !this.remoteLoc.equals((Object)other.remoteLoc));
        }
    }

    private static class SyncInt {
        private int value;

        public SyncInt(int initialValue) {
            this.value = initialValue;
        }

        public synchronized int get() {
            return this.value;
        }

        public synchronized int incrementAndGet() {
            return ++this.value;
        }

        public synchronized int decrementAndGet() {
            --this.value;
            this.notifyAll();
            return this.value;
        }

        public synchronized void waitForZero() throws InterruptedException {
            while (this.value != 0) {
                this.wait();
            }
        }
    }
}

