/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.description.resource;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.wb.internal.core.model.description.resource.IDescriptionVersionsProvider;
import org.eclipse.wb.internal.core.utils.check.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FromListDescriptionVersionsProvider
implements IDescriptionVersionsProvider {
    private final List<String> m_versions = Lists.newArrayList();

    public FromListDescriptionVersionsProvider(List<String> allVersions, String currentVersion) {
        int currentVersionIndex = allVersions.indexOf(currentVersion);
        Assert.isTrue((currentVersionIndex != -1 ? 1 : 0) != 0, (String)"Version %s is not present in %s", (Object[])new Object[]{currentVersion, allVersions});
        for (String version : allVersions) {
            this.m_versions.add(0, version);
            if (version.equals(currentVersion)) break;
        }
    }

    @Override
    public List<String> getVersions(Class<?> componentClass) throws Exception {
        if (this.validate(componentClass)) {
            return this.m_versions;
        }
        return ImmutableList.of();
    }

    protected abstract boolean validate(Class<?> var1) throws Exception;
}

