/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.MigLayout.model.ui;

import java.text.MessageFormat;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.wb.core.controls.CSpinner;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;
import org.eclipse.wb.internal.swing.MigLayout.model.MigDimensionInfo;
import org.eclipse.wb.internal.swing.MigLayout.model.ModelMessages;

public final class DimensionResizeComposite
extends Composite {
    private final int m_defaultWeight;
    private final String m_propertyName;
    private final Listener m_listener;
    private MigDimensionInfo m_dimension;
    private final Button m_defaultWeightButton;
    private final Button m_customWeightButton;
    private final CSpinner m_weightSpinner;
    private final Button m_defaultPriorityButton;
    private final Button m_customPriorityButton;
    private final CSpinner m_prioritySpinner;
    private boolean m_updatingDimension;

    public DimensionResizeComposite(Composite parent, int style, String defaultWeightLabel, String customWeightLabel, final int defaultWeight, final int customWeight, String propertyName, Listener listener) {
        super(parent, style);
        this.m_defaultWeight = defaultWeight;
        this.m_propertyName = StringUtils.capitalize((String)propertyName);
        this.m_listener = listener;
        GridLayoutFactory.create((Composite)this).noMargins().columns(2).spacingH(15);
        Composite weightComposite = new Composite((Composite)this, 0);
        GridDataFactory.create((Control)weightComposite).grabH().fill();
        GridLayoutFactory.create((Composite)weightComposite).noMargins().columns(2);
        this.m_defaultWeightButton = new Button(weightComposite, 16);
        GridDataFactory.create((Control)this.m_defaultWeightButton).spanH(2);
        this.m_defaultWeightButton.setText(defaultWeightLabel);
        this.m_defaultWeightButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DimensionResizeComposite.this.m_weightSpinner.setEnabled(false);
                DimensionResizeComposite.this.m_weightSpinner.setSelection(defaultWeight);
                DimensionResizeComposite.this.toDimension();
            }
        });
        this.m_customWeightButton = new Button(weightComposite, 16);
        this.m_customWeightButton.setText(customWeightLabel);
        this.m_customWeightButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DimensionResizeComposite.this.m_weightSpinner.setEnabled(true);
                DimensionResizeComposite.this.m_weightSpinner.setSelection(customWeight);
                DimensionResizeComposite.this.toDimension();
            }
        });
        this.m_weightSpinner = new CSpinner(weightComposite, 2048);
        GridDataFactory.create((Control)this.m_weightSpinner).hintHC(10).grabH().fill();
        this.m_weightSpinner.setRange(0, Integer.MAX_VALUE);
        this.m_weightSpinner.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DimensionResizeComposite.this.toDimension();
            }
        });
        Composite priorityComposite = new Composite((Composite)this, 0);
        GridDataFactory.create((Control)priorityComposite).grabH().fill();
        GridLayoutFactory.create((Composite)priorityComposite).noMargins().columns(2);
        this.m_defaultPriorityButton = new Button(priorityComposite, 16);
        GridDataFactory.create((Control)this.m_defaultPriorityButton).spanH(2);
        this.m_defaultPriorityButton.setText(ModelMessages.DimensionResizeComposite_defaultPriority);
        this.m_defaultPriorityButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DimensionResizeComposite.this.m_prioritySpinner.setEnabled(false);
                DimensionResizeComposite.this.m_prioritySpinner.setSelection(100);
                DimensionResizeComposite.this.toDimension();
            }
        });
        this.m_customPriorityButton = new Button(priorityComposite, 16);
        this.m_customPriorityButton.setText(ModelMessages.DimensionResizeComposite_customPriority);
        this.m_customPriorityButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DimensionResizeComposite.this.m_prioritySpinner.setEnabled(true);
                DimensionResizeComposite.this.m_prioritySpinner.setSelection(100);
                DimensionResizeComposite.this.toDimension();
            }
        });
        this.m_prioritySpinner = new CSpinner(priorityComposite, 2048);
        GridDataFactory.create((Control)this.m_prioritySpinner).hintHC(10).grabH().fill();
        this.m_prioritySpinner.setRange(0, Integer.MAX_VALUE);
        this.m_prioritySpinner.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DimensionResizeComposite.this.toDimension();
            }
        });
    }

    public void fromDimension(MigDimensionInfo dimension) {
        if (!this.m_updatingDimension) {
            this.m_dimension = dimension;
            try {
                String methodName = MessageFormat.format("get{0}", this.m_propertyName);
                Float weight = (Float)ReflectionUtils.invokeMethod2((Object)this.m_dimension, (String)methodName);
                if (weight == null || weight.intValue() == this.m_defaultWeight) {
                    this.m_defaultWeightButton.setSelection(true);
                    this.m_customWeightButton.setSelection(false);
                    this.m_weightSpinner.setEnabled(false);
                    this.m_weightSpinner.setSelection(0);
                } else {
                    this.m_defaultWeightButton.setSelection(false);
                    this.m_customWeightButton.setSelection(true);
                    this.m_weightSpinner.setEnabled(true);
                    this.m_weightSpinner.setSelection(weight.intValue());
                }
                methodName = MessageFormat.format("get{0}Priority", this.m_propertyName);
                int priority = (Integer)ReflectionUtils.invokeMethod2((Object)this.m_dimension, (String)methodName);
                if (priority == 100) {
                    this.m_defaultPriorityButton.setSelection(true);
                    this.m_customPriorityButton.setSelection(false);
                    this.m_prioritySpinner.setEnabled(false);
                } else {
                    this.m_defaultPriorityButton.setSelection(false);
                    this.m_customPriorityButton.setSelection(true);
                    this.m_prioritySpinner.setEnabled(true);
                }
                this.m_prioritySpinner.setSelection(priority);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void toDimension() {
        this.m_updatingDimension = true;
        try {
            try {
                Float weight = this.m_defaultWeightButton.getSelection() ? null : new Float(this.m_weightSpinner.getSelection());
                String methodName = MessageFormat.format("set{0}", this.m_propertyName);
                ReflectionUtils.invokeMethod2((Object)this.m_dimension, (String)methodName, Float.class, (Object)weight);
                int priority = this.m_defaultPriorityButton.getSelection() ? 100 : this.m_prioritySpinner.getSelection();
                methodName = MessageFormat.format("set{0}Priority", this.m_propertyName);
                ReflectionUtils.invokeMethod2((Object)this.m_dimension, (String)methodName, Integer.TYPE, (Object)priority);
                this.notifyModified();
            }
            catch (Throwable throwable) {
                this.m_updatingDimension = false;
            }
        }
        finally {
            this.m_updatingDimension = false;
        }
    }

    private void notifyModified() {
        Event event = new Event();
        this.m_listener.handleEvent(event);
    }
}

